/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverDependencies;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverLibraryMavenArtifact;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.RunnableContextDelegate;
import org.jkiss.dbeaver.runtime.WebUtils;
import org.jkiss.dbeaver.ui.UIConfirmation;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.StandardErrorDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDependenciesTree;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDownloadPage;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDownloadWizard;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

class DriverDownloadAutoPage
extends DriverDownloadPage {
    public static final String NETWORK_TEST_URL = "https://repo1.maven.org";
    private DriverDependenciesTree depsTree;

    DriverDownloadAutoPage() {
        super(UIConnectionMessages.dialog_driver_download_auto_page_auto_download, UIConnectionMessages.dialog_driver_download_auto_page_download_driver_files, null);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        DriverDownloadWizard wizard = this.getWizard();
        DBPDriver driver = wizard.getDriver();
        Composite container = UIUtils.createPlaceholder((Composite)parent, (int)1);
        this.setMessage(NLS.bind((String)UIConnectionMessages.dialog_driver_download_auto_page_download_specific_driver_files, (Object)driver.getName()));
        this.initializeDialogUnits((Control)container);
        this.setDescriptionLabel(container);
        this.setExpander(container);
        this.setControl((Control)parent);
    }

    private ExpandableComposite setExpander(final @NotNull Composite parent) {
        ExpandableComposite expander = new ExpandableComposite(parent, 0, 34);
        Composite details = this.setDetails((Composite)expander);
        expander.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                parent.getShell().pack(true);
                UIUtils.resizeShell((Shell)parent.getShell());
            }
        });
        expander.setText(UIConnectionMessages.dialog_driver_download_auto_page_show_details);
        expander.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).indent(0, 10).create());
        expander.setClient((Control)details);
        return expander;
    }

    private void setDescriptionLabel(@NotNull Composite parent) {
        DBPDriver driver = this.getWizard().getDriver();
        String driverDescription = Objects.requireNonNullElse(driver.getDescription(), driver.getFullName());
        UIUtils.createInfoLabel((Composite)parent, (String)NLS.bind((String)UIConnectionMessages.dialog_driver_download_auto_page_driver_description, (Object)driverDescription));
    }

    @Override
    boolean performFinish() {
        try {
            this.getContainer().run(true, true, monitor -> this.downloadLibraryFiles((DBRProgressMonitor)new DefaultProgressMonitor(monitor)));
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(UIConnectionMessages.dialog_driver_download_auto_page_driver_download_error, UIConnectionMessages.dialog_driver_download_auto_page_driver_download_error_msg, e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    @Override
    void resolveLibraries() {
        block3: {
            try {
                if (!this.depsTree.loadLibDependencies()) {
                    this.setErrorMessage(UIConnectionMessages.dialog_driver_download_auto_page_cannot_resolve_libraries_text);
                }
            }
            catch (DBException e) {
                if (this.depsTree.handleDownloadError(e) || !(this.getContainer() instanceof WizardDialog)) break block3;
                ((WizardDialog)this.getContainer()).close();
            }
        }
        this.depsTree.resizeTree();
    }

    public boolean isPageComplete() {
        return true;
    }

    public void setMessage(String newMessage, int newType) {
        super.setMessage(newMessage, newType);
    }

    protected IDialogSettings getDialogSettings() {
        return super.getDialogSettings();
    }

    private Composite setDetails(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        final DriverDownloadWizard wizard = this.getWizard();
        DBPDriver driver = wizard.getDriver();
        int verticalIndentFirstRow = 10;
        if (!wizard.isForceDownload()) {
            Composite infoGroup = UIUtils.createPlaceholder((Composite)composite, (int)2, (int)5);
            infoGroup.setLayoutData((Object)new GridData(768));
            Label infoText = new Label(infoGroup, 0);
            infoText.setText(NLS.bind((String)UIConnectionMessages.dialog_driver_download_auto_page_driver_file_missing_text, (Object)driver.getFullName()));
            GridData infoGridData = new GridData(768);
            infoGridData.verticalIndent = verticalIndentFirstRow;
            infoText.setLayoutData((Object)infoGridData);
            final Button forceCheckbox = UIUtils.createCheckbox((Composite)infoGroup, (String)UIConnectionMessages.dialog_driver_download_auto_page_force_download, (boolean)wizard.isForceDownload());
            forceCheckbox.setToolTipText(UIConnectionMessages.dialog_driver_download_auto_page_force_download_tooltip);
            GridData forceCheckboxGridData = new GridData(130);
            forceCheckboxGridData.verticalIndent = verticalIndentFirstRow;
            forceCheckbox.setLayoutData((Object)forceCheckboxGridData);
            forceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    wizard.setForceDownload(forceCheckbox.getSelection());
                }
            });
        }
        Group filesGroup = UIUtils.createControlGroup((Composite)composite, (String)UIConnectionMessages.dialog_driver_download_auto_page_required_files, (int)1, (int)1808, (int)-1);
        filesGroup.setLayoutData((Object)new GridData(1808));
        this.depsTree = new DriverDependenciesTree((Composite)filesGroup, (DBRRunnableContext)new RunnableContextDelegate((IRunnableContext)this.getContainer()), this.getWizard().getDependencies(), driver, driver.getDriverLibraries(), true){

            @Override
            protected void setLibraryVersion(DriverLibraryMavenArtifact library, String version) {
                String curVersion = library.getVersion();
                if (CommonUtils.equalObjects((Object)curVersion, (Object)version)) {
                    return;
                }
                library.setPreferredVersion(version);
                library.setForcedVersion(true);
                DriverDownloadAutoPage.this.resolveLibraries();
            }
        };
        GridData treeGridData = new GridData(4, 4, true, true);
        treeGridData.widthHint = 600;
        this.depsTree.getTree().setLayoutData((Object)treeGridData);
        Composite infoPanel = UIUtils.createComposite((Composite)filesGroup, (int)2);
        infoPanel.setLayoutData((Object)new GridData(768));
        Label label = new Label(infoPanel, 0);
        label.setText(UIConnectionMessages.dialog_driver_download_auto_page_change_driver_version_text);
        label.setLayoutData((Object)new GridData(768));
        Button rtdButton = UIUtils.createDialogButton((Composite)infoPanel, (String)UIMessages.button_reset_to_defaults, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> {
            for (DBPDriverLibrary dBPDriverLibrary : this.depsTree.getLibraries()) {
                if (!(dBPDriverLibrary instanceof DriverLibraryMavenArtifact)) continue;
                DriverLibraryMavenArtifact mavenArtifact = (DriverLibraryMavenArtifact)dBPDriverLibrary;
                mavenArtifact.setForcedVersion(false);
                mavenArtifact.resetVersion();
            }
            this.resolveLibraries();
        }));
        rtdButton.setLayoutData((Object)new GridData(128));
        if (!wizard.isForceDownload()) {
            Label infoText = new Label(composite, 0);
            infoText.setText(UIConnectionMessages.dialog_driver_download_auto_page_obtain_driver_files_text);
            infoText.setLayoutData((Object)new GridData(768));
        }
        this.createLinksPanel(composite);
        return composite;
    }

    private void downloadLibraryFiles(final DBRProgressMonitor monitor) throws InterruptedException {
        if (!this.acceptDriverLicenses()) {
            return;
        }
        boolean processUnsecure = false;
        List nodes = this.getWizard().getDependencies().getLibraryList();
        int i = 0;
        int filesSize = nodes.size();
        while (i < filesSize) {
            final DBPDriverLibrary lib = ((DBPDriverDependencies.DependencyNode)nodes.get((int)i)).library;
            if (!processUnsecure && !lib.isSecureDownload(monitor)) {
                boolean process = (Boolean)new UIConfirmation(){

                    protected Boolean runTask() {
                        MessageBox messageBox = new MessageBox(DriverDownloadAutoPage.this.getShell(), 200);
                        messageBox.setText(UIConnectionMessages.dialog_driver_download_auto_page_driver_security_warning);
                        messageBox.setMessage(NLS.bind((String)UIConnectionMessages.dialog_driver_download_auto_page_driver_security_warning_msg, (Object)lib.getDisplayName(), (Object)lib.getExternalURL(monitor)));
                        int response = messageBox.open();
                        if (response == 64) {
                            return true;
                        }
                        return false;
                    }
                }.execute();
                if (!process) break;
                processUnsecure = true;
            }
            int result = 0;
            try {
                lib.downloadLibraryFile(monitor, this.getWizard().isForceDownload(), NLS.bind((String)UIConnectionMessages.dialog_driver_download_auto_page_download_rate, (Object)(i + 1), (Object)filesSize));
            }
            catch (IOException e) {
                result = lib.getType() == DBPDriverLibrary.FileType.license ? 0 : (Integer)new UITask<Integer>(){

                    protected Integer runTask() {
                        String message = RuntimeUtils.isWindows() && CommonUtils.hasCause((Throwable)e, SSLHandshakeException.class) ? (DBWorkbench.getPlatform().getApplication().hasProductFeature("connection/simpleTruststore") ? UIConnectionMessages.dialog_driver_download_auto_page_download_failed_cert_msg : UIConnectionMessages.dialog_driver_download_auto_page_download_failed_cert_msg_advanced) : UIConnectionMessages.dialog_driver_download_auto_page_download_failed_msg;
                        DownloadErrorDialog dialog = new DownloadErrorDialog(UIUtils.getActiveWorkbenchShell(), lib.getDisplayName(), message, e);
                        return dialog.open();
                    }
                }.execute();
            }
            switch (result) {
                case 1: 
                case 7: {
                    return;
                }
                case 8: {
                    break;
                }
                case 0: 
                case 9: {
                    ++i;
                }
            }
        }
        ((DriverDescriptor)this.getWizard().getDriver()).setModified(true);
    }

    private boolean acceptDriverLicenses() {
        DBPDriver driver = this.getWizard().getDriver();
        if (!driver.isLicenseRequired()) {
            return true;
        }
        String license = driver.getLicense();
        if (CommonUtils.isEmpty((String)license)) {
            return true;
        }
        return DBWorkbench.getPlatformUI().acceptLicense("You have to accept driver '" + driver.getFullName() + "' license to continue", license);
    }

    private boolean isNetworkAccessible() {
        try {
            WebUtils.openConnection((String)NETWORK_TEST_URL, (String)GeneralUtils.getProductTitle());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static class DownloadErrorDialog
    extends StandardErrorDialog {
        DownloadErrorDialog(Shell parentShell, String dialogTitle, String message, Throwable error) {
            super(parentShell, dialogTitle, message, GeneralUtils.makeExceptionStatus((Throwable)error), 7);
        }

        protected void createButtonsForButtonBar(@NotNull Composite parent) {
            this.createButton(parent, 7, IDialogConstants.ABORT_LABEL, true);
            this.createButton(parent, 8, IDialogConstants.RETRY_LABEL, false);
            this.createButton(parent, 9, IDialogConstants.IGNORE_LABEL, false);
            this.createDetailsButton(parent);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 13) {
                super.buttonPressed(buttonId);
            } else {
                this.setReturnCode(buttonId);
                this.close();
            }
        }
    }
}

