/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.stat.BinStatUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002=>B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J,\u0010\r\u001a\u00020\u00072\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000f0\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\\\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\u000f0\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fJ;\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\u000f0\u00112\u0006\u0010\u0017\u001a\u00020\u00192\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u0000\u00a2\u0006\u0002\b\u001aJ \u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u001eJ\u001e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eJB\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0 0\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000f2\u0006\u0010!\u001a\u00020\u0012H\u0002JA\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0 0\u000f2\b\u0010!\u001a\u0004\u0018\u00010\u00122\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010&J(\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\u000f2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\u000fH\u0002JO\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\u000f2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000f0\u000f2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010,J)\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0 2\u000e\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000fH\u0000\u00a2\u0006\u0002\b/J3\u00100\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010 2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u00103J.\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000f0\u000f2\u0018\u00105\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0 0\u000fH\u0002J\"\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\u000f2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fH\u0002JA\u00108\u001a\u00020\u0007\"\u000e\b\u0000\u00109*\b\u0012\u0004\u0012\u00020\u00130\u000f2\u000e\u00107\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000f2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u0002H90;H\u0000\u00a2\u0006\u0002\b<R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/ContourStatUtil;", "", "()V", "xLoc", "", "yLoc", "checkEdge", "", "edge", "Lorg/jetbrains/letsPlot/core/plot/base/stat/ContourStatUtil$Edge;", "colCount", "", "rowCount", "checkEdges", "paths", "", "computeContours", "", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "xRange", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "yRange", "data", "levels", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "computeContours$plot_base", "computeLevels", "zRange", "binOptions", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil$BinOptions;", "computeSegments", "Lkotlin/Pair;", "level", "computeSegmentsForGridCell", "value5", "col", "row", "(Ljava/lang/Double;[DII)Ljava/util/List;", "confirmPaths", "convertPaths", "xStep", "yStep", "origin", "(Ljava/util/List;DDLorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Ljava/lang/Double;)Ljava/util/List;", "estimateRegularGridShape", "xs", "estimateRegularGridShape$plot_base", "intersectionSegment", "vectors", "Lorg/jetbrains/letsPlot/core/plot/base/stat/ContourStatUtil$TripleVector;", "(Ljava/util/List;Ljava/lang/Double;)Lkotlin/Pair;", "joinSegments", "segments", "pathSeparator", "path", "removePathByEndpoints", "T", "pathByEndPoint", "", "removePathByEndpoints$plot_base", "Edge", "TripleVector", "plot-base"})
public final class ContourStatUtil {
    @NotNull
    public static final ContourStatUtil INSTANCE = new ContourStatUtil();
    @NotNull
    private static final double[] xLoc;
    @NotNull
    private static final double[] yLoc;

    private ContourStatUtil() {
    }

    @NotNull
    public final Pair<Integer, Integer> estimateRegularGridShape$plot_base(@NotNull List<Double> xs) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        int colCount = 0;
        Double x0 = null;
        for (Double x2 : xs) {
            if (x0 == null) {
                x0 = x2;
            } else if (Intrinsics.areEqual((Double)x2, (Double)x0)) break;
            ++colCount;
        }
        if (colCount <= 1) {
            throw new IllegalArgumentException("Data grid must be at least 2 columns wide (was " + colCount + ')');
        }
        int rowCount = xs.size() / colCount;
        if (rowCount <= 1) {
            throw new IllegalArgumentException("Data grid must be at least 2 rows tall (was " + rowCount + ')');
        }
        return new Pair((Object)colCount, (Object)rowCount);
    }

    @Nullable
    public final List<Double> computeLevels(@NotNull DataFrame data2, @NotNull BinStatUtil.BinOptions binOptions) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)binOptions, (String)"binOptions");
        if (!(data2.has(TransformVar.INSTANCE.getX()) && data2.has(TransformVar.INSTANCE.getY()) && data2.has(TransformVar.INSTANCE.getZ()))) {
            return null;
        }
        DoubleSpan zRange = data2.range(TransformVar.INSTANCE.getZ());
        return this.computeLevels(zRange, binOptions);
    }

    @Nullable
    public final List<Double> computeLevels(@Nullable DoubleSpan zRange, @NotNull BinStatUtil.BinOptions binOptions) {
        Intrinsics.checkNotNullParameter((Object)binOptions, (String)"binOptions");
        if (zRange == null || SeriesUtil.INSTANCE.isBeyondPrecision(zRange)) {
            return null;
        }
        BinStatUtil.CountAndWidth b2 = BinStatUtil.binCountAndWidth$default(BinStatUtil.INSTANCE, zRange.getLength(), binOptions, null, 4, null);
        ArrayList<Double> levels = new ArrayList<Double>();
        int n = b2.getCount();
        for (int i = 0; i < n; ++i) {
            double level = (double)i * b2.getWidth() + zRange.getLowerEnd();
            levels.add(level += b2.getWidth() / (double)2);
        }
        return levels;
    }

    @NotNull
    public final Map<Double, List<List<DoubleVector>>> computeContours$plot_base(@NotNull DataFrame data2, @NotNull List<Double> levels) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter(levels, (String)"levels");
        List<Double> xVector = data2.getNumeric(TransformVar.INSTANCE.getX());
        List<Double> zVector = data2.getNumeric(TransformVar.INSTANCE.getZ());
        Pair<Integer, Integer> shape = this.estimateRegularGridShape$plot_base(xVector);
        int colCount = ((Number)shape.getFirst()).intValue();
        int rowCount = ((Number)shape.getSecond()).intValue();
        DoubleSpan doubleSpan = data2.range(TransformVar.INSTANCE.getX());
        Intrinsics.checkNotNull((Object)doubleSpan);
        DoubleSpan xRange = doubleSpan;
        DoubleSpan doubleSpan2 = data2.range(TransformVar.INSTANCE.getY());
        Intrinsics.checkNotNull((Object)doubleSpan2);
        DoubleSpan yRange = doubleSpan2;
        return this.computeContours(xRange, yRange, colCount, rowCount, zVector, levels);
    }

    @NotNull
    public final Map<Double, List<List<DoubleVector>>> computeContours(@NotNull DoubleSpan xRange, @NotNull DoubleSpan yRange, int colCount, int rowCount, @NotNull List<Double> data2, @NotNull List<Double> levels) {
        Intrinsics.checkNotNullParameter((Object)xRange, (String)"xRange");
        Intrinsics.checkNotNullParameter((Object)yRange, (String)"yRange");
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        Intrinsics.checkNotNullParameter(levels, (String)"levels");
        double xStep = xRange.getLength() / (double)(colCount - 1);
        double yStep = yRange.getLength() / (double)(rowCount - 1);
        DoubleVector origin = new DoubleVector(xRange.getLowerEnd(), yRange.getLowerEnd());
        HashMap pathListByLevel = new HashMap();
        Iterator<Double> iterator2 = levels.iterator();
        while (iterator2.hasNext()) {
            double level = ((Number)iterator2.next()).doubleValue();
            List<Pair<Edge, Edge>> levelSegments = this.computeSegments(colCount, rowCount, data2, level);
            List<List<Edge>> paths = this.joinSegments(levelSegments);
            List<List<DoubleVector>> pathsReal = this.convertPaths(paths, xStep, yStep, origin, level);
            pathsReal = this.confirmPaths(pathsReal);
            Double d = level;
            ((Map)pathListByLevel).put(d, pathsReal);
        }
        return pathListByLevel;
    }

    private final List<List<Edge>> joinSegments(List<Pair<Edge, Edge>> segments) {
        ArrayList<List> pathList = new ArrayList<List>();
        HashMap pathByEndPoint = new HashMap();
        for (Pair<Edge, Edge> segment2 : segments) {
            Edge p0 = (Edge)segment2.getFirst();
            Edge p1 = (Edge)segment2.getSecond();
            if (pathByEndPoint.containsKey(p0) || pathByEndPoint.containsKey(p1)) {
                List path0 = (List)pathByEndPoint.get(p0);
                List path1 = (List)pathByEndPoint.get(p1);
                if (path0 != null) {
                    pathByEndPoint.remove(path0.get(0));
                    pathByEndPoint.remove(path0.get(path0.size() - 1));
                }
                if (path1 != null) {
                    pathByEndPoint.remove(path1.get(0));
                    pathByEndPoint.remove(path1.get(path1.size() - 1));
                }
                List longPath = null;
                if (path0 == path1) {
                    List list2 = path0;
                    Intrinsics.checkNotNull((Object)list2);
                    list2.add(segment2.getSecond());
                    pathList.add(path0);
                    continue;
                }
                if (path0 != null && path1 != null) {
                    longPath = path0;
                    longPath.addAll(path1);
                } else if (path0 == null) {
                    List list3 = path1;
                    Intrinsics.checkNotNull((Object)list3);
                    longPath = list3;
                    longPath.add(0, segment2.getFirst());
                } else {
                    longPath = path0;
                    longPath.add(segment2.getSecond());
                }
                ((Map)pathByEndPoint).put(longPath.get(0), longPath);
                ((Map)pathByEndPoint).put(longPath.get(longPath.size() - 1), longPath);
                continue;
            }
            ArrayList<Object> path2 = new ArrayList<Object>();
            path2.add(segment2.getFirst());
            path2.add(segment2.getSecond());
            ((Map)pathByEndPoint).put(segment2.getFirst(), path2);
            ((Map)pathByEndPoint).put(segment2.getSecond(), path2);
        }
        HashSet pathSet = new HashSet(pathByEndPoint.values());
        for (List path3 : pathSet) {
            pathList.add(path3);
        }
        return pathList;
    }

    private final List<List<DoubleVector>> convertPaths(List<? extends List<Edge>> paths, double xStep, double yStep, DoubleVector origin, Double level) {
        ArrayList result2 = new ArrayList();
        for (List<Edge> list2 : paths) {
            ArrayList<DoubleVector> temp = new ArrayList<DoubleVector>();
            DoubleVector lastPoint = null;
            for (Edge edge : list2) {
                Double d = level;
                Intrinsics.checkNotNull((Object)d);
                DoubleVector intersect = edge.intersect(d);
                intersect = new DoubleVector(xStep * intersect.getX(), yStep * intersect.getY()).add(origin);
                if (Intrinsics.areEqual((Object)intersect, lastPoint)) continue;
                temp.add(intersect);
                lastPoint = intersect;
            }
            if (Intrinsics.areEqual((Object)list2.get(0), (Object)list2.get(list2.size() - 1)) && !Intrinsics.areEqual(temp.get(0), temp.get(temp.size() - 1))) {
                temp.set(temp.size() - 1, (DoubleVector)temp.get(0));
            }
            if (temp.size() <= 1) continue;
            result2.add(temp);
        }
        return result2;
    }

    private final List<List<DoubleVector>> confirmPaths(List<? extends List<DoubleVector>> paths) {
        ArrayList<List> newPaths = new ArrayList<List>();
        HashMap pathByEndPoint = new HashMap();
        for (List<DoubleVector> list2 : paths) {
            DoubleVector doubleVector;
            DoubleVector p0 = list2.get(0);
            if (Intrinsics.areEqual((Object)p0, (Object)(doubleVector = list2.get(list2.size() - 1)))) {
                newPaths.add(list2);
                continue;
            }
            if (pathByEndPoint.containsKey(p0) || pathByEndPoint.containsKey(doubleVector)) {
                List path0 = (List)pathByEndPoint.get(p0);
                List path1 = (List)pathByEndPoint.get(doubleVector);
                this.removePathByEndpoints$plot_base(path0, pathByEndPoint);
                this.removePathByEndpoints$plot_base(path1, pathByEndPoint);
                ArrayList longPath = new ArrayList();
                if (path0 == path1) {
                    List list3 = path0;
                    Intrinsics.checkNotNull((Object)list3);
                    longPath.addAll(list3);
                    longPath.addAll(list2.subList(1, list2.size()));
                    newPaths.add(longPath);
                    continue;
                }
                if (path0 != null && path1 != null) {
                    longPath.addAll(path0);
                    longPath.addAll(list2.subList(1, list2.size() - 1));
                    longPath.addAll(path1);
                } else if (path0 == null) {
                    List list4 = path1;
                    Intrinsics.checkNotNull((Object)list4);
                    longPath.addAll(list4);
                    longPath.addAll(0, list2.subList(0, list2.size() - 1));
                } else {
                    longPath.addAll(path0);
                    longPath.addAll(list2.subList(1, list2.size()));
                }
                Map map2 = pathByEndPoint;
                Object e = longPath.get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                map2.put(e, longPath);
                map2 = pathByEndPoint;
                Object e2 = longPath.get(longPath.size() - 1);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                map2.put(e2, longPath);
                continue;
            }
            ((Map)pathByEndPoint).put(list2.get(0), list2);
            ((Map)pathByEndPoint).put(list2.get(list2.size() - 1), list2);
        }
        HashSet pathSet = new HashSet(pathByEndPoint.values());
        for (List path3 : pathSet) {
            newPaths.add(path3);
        }
        ArrayList arrayList = new ArrayList();
        for (List list5 : newPaths) {
            Intrinsics.checkNotNull((Object)list5);
            arrayList.addAll(this.pathSeparator(list5));
        }
        return arrayList;
    }

    public final <T extends List<? extends DoubleVector>> void removePathByEndpoints$plot_base(@Nullable List<DoubleVector> path2, @NotNull Map<DoubleVector, T> pathByEndPoint) {
        Intrinsics.checkNotNullParameter(pathByEndPoint, (String)"pathByEndPoint");
        if (path2 != null) {
            pathByEndPoint.remove(path2.get(0));
            pathByEndPoint.remove(path2.get(path2.size() - 1));
        }
    }

    private final List<List<DoubleVector>> pathSeparator(List<DoubleVector> path2) {
        ArrayList<List<DoubleVector>> result2 = new ArrayList<List<DoubleVector>>();
        int startIndex = 0;
        int n = path2.size() - 1;
        for (int nextIndex = 1; nextIndex < n; ++nextIndex) {
            if (!Intrinsics.areEqual((Object)path2.get(startIndex), (Object)path2.get(nextIndex))) continue;
            result2.add(path2.subList(startIndex, nextIndex + 1));
            startIndex = nextIndex;
        }
        if (startIndex == 0) {
            return CollectionsKt.listOf(path2);
        }
        result2.add(path2.subList(startIndex, path2.size()));
        return result2;
    }

    private final List<Pair<Edge, Edge>> computeSegments(int colCount, int rowCount, List<Double> data2, double level) {
        ArrayList segments = new ArrayList();
        int n = rowCount - 1;
        for (int row = 0; row < n; ++row) {
            int n2 = colCount - 1;
            for (int col = 0; col < n2; ++col) {
                int i0 = row * colCount + col;
                int i1 = row * colCount + col + 1;
                int i2 = (row + 1) * colCount + col + 1;
                int i3 = (row + 1) * colCount + col;
                double[] v = new double[5];
                Double d = data2.get(i0);
                Intrinsics.checkNotNull((Object)d);
                v[0] = ((Number)d).doubleValue();
                Double d2 = data2.get(i1);
                Intrinsics.checkNotNull((Object)d2);
                v[1] = ((Number)d2).doubleValue();
                Double d3 = data2.get(i2);
                Intrinsics.checkNotNull((Object)d3);
                v[2] = ((Number)d3).doubleValue();
                Double d4 = data2.get(i3);
                Intrinsics.checkNotNull((Object)d4);
                v[3] = ((Number)d4).doubleValue();
                double min = v[0];
                double max = v[0];
                for (int i = 1; i < 4; ++i) {
                    min = Math.min(min, v[i]);
                    max = Math.max(max, v[i]);
                }
                if (min == max) continue;
                v[4] = (v[0] + v[1] + v[2] + v[3] - min - max) / (double)2;
                if (!(level > min) || !(level <= max)) continue;
                List<Pair<Edge, Edge>> cellSegments = this.computeSegmentsForGridCell(level, v, col, row);
                segments.addAll(cellSegments);
            }
        }
        return segments;
    }

    private final List<Pair<Edge, Edge>> computeSegmentsForGridCell(Double level, double[] value5, int col, int row) {
        int i;
        ArrayList<Pair<Edge, Edge>> result2 = new ArrayList<Pair<Edge, Edge>>();
        ArrayList<TripleVector> points2 = new ArrayList<TripleVector>();
        List tempVector = null;
        for (i = 0; i < 5; ++i) {
            points2.add(new TripleVector((double)col + xLoc[i], (double)row + yLoc[i], value5[i]));
        }
        for (i = 0; i < 4; ++i) {
            int i1 = (i + 1) % 4;
            tempVector = new ArrayList();
            Object e = points2.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            tempVector.add(e);
            Object e2 = points2.get(i1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
            tempVector.add(e2);
            Object e3 = points2.get(4);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"get(...)");
            tempVector.add(e3);
            Pair<Edge, Edge> temp = this.intersectionSegment(tempVector, level);
            if (temp == null) continue;
            result2.add(temp);
        }
        return result2;
    }

    private final Pair<Edge, Edge> intersectionSegment(List<TripleVector> vectors, Double level) {
        Double d = level;
        Intrinsics.checkNotNull((Object)d);
        int type = vectors.get(0).getType(d) * 100 + vectors.get(1).getType(level) * 10 + vectors.get(2).getType(level);
        Edge start2 = null;
        Edge end = null;
        switch (type) {
            case 100: {
                start2 = new Edge(vectors.get(2), vectors.get(0));
                end = new Edge(vectors.get(0), vectors.get(1));
                break;
            }
            case 10: {
                start2 = new Edge(vectors.get(0), vectors.get(1));
                end = new Edge(vectors.get(1), vectors.get(2));
                break;
            }
            case 1: {
                start2 = new Edge(vectors.get(1), vectors.get(2));
                end = new Edge(vectors.get(2), vectors.get(0));
                break;
            }
            case 110: {
                start2 = new Edge(vectors.get(0), vectors.get(2));
                end = new Edge(vectors.get(2), vectors.get(1));
                break;
            }
            case 101: {
                start2 = new Edge(vectors.get(2), vectors.get(1));
                end = new Edge(vectors.get(1), vectors.get(0));
                break;
            }
            case 11: {
                start2 = new Edge(vectors.get(1), vectors.get(0));
                end = new Edge(vectors.get(0), vectors.get(2));
                break;
            }
            default: {
                return null;
            }
        }
        return new Pair((Object)start2, (Object)end);
    }

    private final void checkEdges(List<? extends List<Edge>> paths, int colCount, int rowCount) {
        for (List<Edge> list2 : paths) {
            if (Intrinsics.areEqual((Object)list2.get(0), (Object)list2.get(list2.size() - 1))) continue;
            this.checkEdge(list2.get(0), colCount, rowCount);
            this.checkEdge(list2.get(list2.size() - 1), colCount, rowCount);
        }
    }

    private final void checkEdge(Edge edge, int colCount, int rowCount) {
        TripleVector a2 = edge.getMyA();
        TripleVector b2 = edge.getMyB();
        if (a2.getMyX() == 0 && b2.getMyX() == 0) {
            return;
        }
        if (a2.getMyY() == 0 && b2.getMyY() == 0) {
            return;
        }
        if (a2.getMyX() == colCount - 1 && b2.getMyX() == colCount - 1) {
            return;
        }
        if (a2.getMyY() == rowCount - 1 && b2.getMyY() == rowCount - 1) {
            return;
        }
        throw new IllegalArgumentException("Check Edge Failed");
    }

    static {
        double[] dArray = new double[]{0.0, 1.0, 1.0, 0.0, 0.5};
        xLoc = dArray;
        dArray = new double[]{0.0, 0.0, 1.0, 1.0, 0.5};
        yLoc = dArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/ContourStatUtil$Edge;", "", "myA", "Lorg/jetbrains/letsPlot/core/plot/base/stat/ContourStatUtil$TripleVector;", "myB", "(Lorg/jetbrains/letsPlot/core/plot/base/stat/ContourStatUtil$TripleVector;Lorg/jetbrains/letsPlot/core/plot/base/stat/ContourStatUtil$TripleVector;)V", "getMyA", "()Lorg/jetbrains/letsPlot/core/plot/base/stat/ContourStatUtil$TripleVector;", "getMyB", "equals", "", "other", "hashCode", "", "intersect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "level", "", "plot-base"})
    private static final class Edge {
        @NotNull
        private final TripleVector myA;
        @NotNull
        private final TripleVector myB;

        public Edge(@NotNull TripleVector myA, @NotNull TripleVector myB) {
            Intrinsics.checkNotNullParameter((Object)myA, (String)"myA");
            Intrinsics.checkNotNullParameter((Object)myB, (String)"myB");
            this.myA = myA;
            this.myB = myB;
        }

        @NotNull
        public final TripleVector getMyA() {
            return this.myA;
        }

        @NotNull
        public final TripleVector getMyB() {
            return this.myB;
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof Edge)) {
                return false;
            }
            Edge obj = (Edge)other;
            return Intrinsics.areEqual((Object)this.myA, (Object)obj.myA) && Intrinsics.areEqual((Object)this.myB, (Object)obj.myB) || Intrinsics.areEqual((Object)this.myA, (Object)obj.myB) && Intrinsics.areEqual((Object)this.myB, (Object)obj.myA);
        }

        public int hashCode() {
            return this.myA.getCoord().hashCode() + this.myB.getCoord().hashCode();
        }

        @NotNull
        public final DoubleVector intersect(double level) {
            double z0 = this.myA.getZ();
            double z1 = this.myB.getZ();
            if (level == z0) {
                return this.myA.getCoord();
            }
            if (level == z1) {
                return this.myB.getCoord();
            }
            double ratio = (z1 - z0) / (level - z0);
            double x0 = this.myA.getX();
            double y0 = this.myA.getY();
            double x1 = this.myB.getX();
            double y1 = this.myB.getY();
            double x2 = x0 + (x1 - x0) / ratio;
            double y2 = y0 + (y1 - y0) / ratio;
            return new DoubleVector(x2, y2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0003J\b\u0010\u001b\u001a\u00020\fH\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/ContourStatUtil$TripleVector;", "", "x", "", "y", "z", "(DDD)V", "coord", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getCoord", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "myIsCenter", "", "myX", "getMyX", "()I", "myY", "getMyY", "getX", "()D", "getY", "getZ", "equals", "", "other", "getType", "level", "hashCode", "plot-base"})
    private static final class TripleVector {
        private final double z;
        private final int myX;
        private final int myY;
        private final int myIsCenter;

        public TripleVector(double x2, double y2, double z) {
            this.z = z;
            this.myX = (int)x2;
            this.myY = (int)y2;
            this.myIsCenter = x2 % 1.0 == 0.0 ? 0 : 1;
        }

        public final double getZ() {
            return this.z;
        }

        public final int getMyX() {
            return this.myX;
        }

        public final int getMyY() {
            return this.myY;
        }

        @NotNull
        public final DoubleVector getCoord() {
            return new DoubleVector(this.getX(), this.getY());
        }

        public final double getX() {
            return (double)this.myX + 0.5 * (double)this.myIsCenter;
        }

        public final double getY() {
            return (double)this.myY + 0.5 * (double)this.myIsCenter;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            TripleVector that = (TripleVector)other;
            return this.myX == that.myX && this.myY == that.myY && this.myIsCenter == that.myIsCenter;
        }

        public int hashCode() {
            Integer[] integerArray = new Integer[]{this.myX, this.myY, this.myIsCenter};
            return integerArray.hashCode();
        }

        public final int getType(double level) {
            return this.z >= level ? 1 : 0;
        }
    }
}

