/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.CopyrightUpdaters;
import com.maddyhome.idea.copyright.psi.UpdateCopyright;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightsProvider;
import org.jetbrains.annotations.Nullable;

public final class UpdateCopyrightFactory {
    private static final Logger LOG = Logger.getInstance((String)UpdateCopyrightFactory.class.getName());

    private UpdateCopyrightFactory() {
    }

    @Nullable
    public static UpdateCopyright createUpdateCopyright(Project project, Module module, PsiFile file, CopyrightProfile options) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return UpdateCopyrightFactory.createUpdateCopyright(project, module, virtualFile, virtualFile.getFileType(), options);
    }

    @Nullable
    private static UpdateCopyright createUpdateCopyright(Project project, Module module, VirtualFile file, FileType type, CopyrightProfile options) {
        LOG.debug("file=" + String.valueOf(file));
        LOG.debug("type=" + type.getName());
        UpdateCopyrightsProvider provider = CopyrightUpdaters.INSTANCE.forFileType(type);
        return provider != null ? provider.createInstance(project, module, file, type, options) : null;
    }
}

