/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.template.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.jinja.template.formatter.BlockTreeProcessor;
import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockIndex
extends BlockTreeProcessor {
    private final Map<TextRange, Block> myRangeToBlockMap = new HashMap<TextRange, Block>();
    private final Map<Block, Block> myBlockToParentMap = new HashMap<Block, Block>();
    private final Map<Block, Block> myReplacementMap = new HashMap<Block, Block>();

    public void doBuild(Block blockTree) {
        this.processSubtree(blockTree);
    }

    @Nullable
    public Block getBlockForPsi(PsiElement psiElement) {
        return this.getBlock(psiElement.getTextRange());
    }

    @Nullable
    public Block getParent(PsiElement psiElement) {
        Block block = this.getBlockForPsi(psiElement);
        if (block == null) {
            return null;
        }
        return this.getParent(block);
    }

    @Nullable
    public Block getParent(@NotNull Block block) {
        if (block == null) {
            BlockIndex.$$$reportNull$$$0(0);
        }
        return this.get(this.myBlockToParentMap.get(this.get(block)));
    }

    @Nullable
    public Block getBlock(TextRange textRange) {
        return this.get(this.myRangeToBlockMap.get(textRange));
    }

    @Override
    protected void processBlock(Block block, Block parent) {
        if (block instanceof ASTBlock) {
            ASTBlock astBlock = (ASTBlock)block;
            PsiElement element = astBlock.getNode().getPsi();
            if (element instanceof DjangoTagElementImpl || element instanceof OuterLanguageElement || element instanceof HtmlTag) {
                this.updateRangeToBlockMapping(element.getTextRange(), block);
            }
        } else if (block instanceof SyntheticBlock) {
            this.updateRangeToBlockMapping(block.getTextRange(), block);
        }
        if (parent != null) {
            this.updateParent(block, parent);
        }
    }

    protected void updateRangeToBlockMapping(@NotNull TextRange textRange, @NotNull Block block) {
        if (textRange == null) {
            BlockIndex.$$$reportNull$$$0(1);
        }
        if (block == null) {
            BlockIndex.$$$reportNull$$$0(2);
        }
        this.myRangeToBlockMap.put(textRange, block);
    }

    public void updateParent(List<Block> blocks, Block parentBlock) {
        for (Block b : blocks) {
            this.updateParent(b, parentBlock);
        }
    }

    public void updateParent(Block b, Block parentBlock) {
        this.myBlockToParentMap.put(b, parentBlock);
    }

    public void replace(@NotNull Block b, @NotNull Block replacement) {
        if (b == null) {
            BlockIndex.$$$reportNull$$$0(3);
        }
        if (replacement == null) {
            BlockIndex.$$$reportNull$$$0(4);
        }
        this.myReplacementMap.put(b, replacement);
    }

    @Nullable
    public Block get(@Nullable Block b) {
        if (b == null) {
            return null;
        }
        Block r = this.myReplacementMap.get(b);
        return r == null ? b : r;
    }

    @NotNull
    public Set<Block> get(@NotNull Set<Block> set) {
        if (set == null) {
            BlockIndex.$$$reportNull$$$0(5);
        }
        HashSet<Block> res = new HashSet<Block>();
        for (Block b : set) {
            Block r = this.get(b);
            if (r == null) continue;
            res.add(r);
        }
        HashSet<Block> hashSet = res;
        if (hashSet == null) {
            BlockIndex.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    public boolean equalBlocks(Block b1, Block b2) {
        if (b1 == null && b2 == null) {
            return false;
        }
        return this.get(b1) == this.get(b2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jinja/template/formatter/BlockIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jinja/template/formatter/BlockIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateRangeToBlockMapping";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

