/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.console.WebConsoleViewSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.IconUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a(\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0000\u001a$\u0010\u0013\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a,\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\u001a\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0002\u001a\u0016\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u001c\u0010 \u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u000e\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#\u001a\u000e\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&\u001a\u0010\u0010'\u001a\u0004\u0018\u00010\u00032\u0006\u0010(\u001a\u00020)\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"invalidChar", "Lkotlin/text/Regex;", "getSelectorName", "", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "convertIDEStylesToCss", "defaultSelector", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "fontMetrics", "Ljava/awt/FontMetrics;", "settings", "Lcom/intellij/javascript/debugger/console/WebConsoleViewSettings;", "addSettings", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "setDisplay", "selector", "value", "", "addEditorStyles", "getLineHeight", "", "addConsoleViewContentTypes", "textAttributesToCss", "selectorName", "attr", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "textAttributesToInlineCss", "attributesToCss", "colorToCss", "c", "Ljava/awt/Color;", "fontTypeToCss", "fontType", "", "effectTypeToTextDecorationLine", "effectType", "Lcom/intellij/openapi/editor/markup/EffectType;", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nStylesConversion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StylesConversion.kt\ncom/intellij/javascript/debugger/console/StylesConversionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1869#2,2:160\n1617#2,9:163\n1869#2:172\n1870#2:174\n1626#2:175\n1#3:162\n1#3:173\n*S KotlinDebug\n*F\n+ 1 StylesConversion.kt\ncom/intellij/javascript/debugger/console/StylesConversionKt\n*L\n109#1:160,2\n134#1:163,9\n134#1:172\n134#1:174\n134#1:175\n134#1:173\n*E\n"})
public final class StylesConversionKt {
    @NotNull
    private static final Regex invalidChar = new Regex("[~!@$%^&*()+=,./';:\"?><\\[\\]{}|`#\\\\]");

    @NotNull
    public static final String getSelectorName(@NotNull ConsoleViewContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        String string = contentType.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        CharSequence charSequence = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = charSequence.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        charSequence = string2;
        Regex regex = invalidChar;
        String string3 = "_";
        return "_" + regex.replace(charSequence, string3);
    }

    @NotNull
    public static final String convertIDEStylesToCss(@NotNull String defaultSelector, @NotNull EditorColorsScheme scheme, @NotNull FontMetrics fontMetrics, @NotNull WebConsoleViewSettings settings) {
        Intrinsics.checkNotNullParameter((Object)defaultSelector, (String)"defaultSelector");
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        StringBuilder sb = new StringBuilder();
        StylesConversionKt.addConsoleViewContentTypes(sb);
        StylesConversionKt.addEditorStyles(defaultSelector, scheme, sb, fontMetrics);
        StylesConversionKt.addSettings(settings, sb);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final void addSettings(@NotNull WebConsoleViewSettings settings, @NotNull StringBuilder sb) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        StylesConversionKt.setDisplay(sb, "level-error", settings.getShowErrors());
        StylesConversionKt.setDisplay(sb, "level-warning", settings.getShowWarnings());
        StylesConversionKt.setDisplay(sb, "level-info", settings.getShowInfo());
        StylesConversionKt.setDisplay(sb, "level-log", settings.getShowLog());
        StylesConversionKt.setDisplay(sb, "level-debug", settings.getShowDebug());
        StylesConversionKt.setDisplay(sb, "source-network", settings.getShowNetwork());
    }

    private static final void setDisplay(StringBuilder sb, String selector, boolean value) {
        sb.append("." + selector + " { ");
        sb.append("display: " + (value ? "block" : "none") + ";");
        sb.append("} ");
    }

    private static final void addEditorStyles(String defaultSelector, EditorColorsScheme scheme, StringBuilder sb, FontMetrics fontMetrics) {
        Object object;
        Object selection_background;
        block7: {
            block6: {
                block5: {
                    Object object2;
                    block4: {
                        sb.append(StringsKt.trimIndent((String)("\n    @font-face {\n      font-family: '" + scheme.getConsoleFontName() + "';\n      src:\n        url('fonts/" + scheme.getConsoleFontName() + ".ttf') format(\"truetype\"),\n        url('fonts/" + scheme.getFont(EditorFontType.CONSOLE_PLAIN).getPSName() + ".ttf') format(\"truetype\");\n    }\n  ")));
                        String string = scheme.getConsoleFontName();
                        int n = fontMetrics.getFont().getSize();
                        float f = StylesConversionKt.getLineHeight(fontMetrics, scheme);
                        float f2 = StylesConversionKt.getLineHeight(fontMetrics, scheme);
                        Color color = scheme.getDefaultBackground();
                        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
                        sb.append(StringsKt.trimIndent((String)("\n    ." + defaultSelector + " {\n      font-family:  " + string + ";\n      font-size:    " + n + "px;\n      line-height:  " + f + "px;\n      min-height:   " + f2 + "px;\n    }\n    body {  \n      background-color: " + StylesConversionKt.colorToCss(color) + ";\n    }\n  ")));
                        Icon icon = AllIcons.Debugger.PromptInput;
                        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PromptInput");
                        Icon promptIcon = icon;
                        Icon scaledIcon = IconUtil.scaleByFont((Icon)promptIcon, null, (float)fontMetrics.getAscent());
                        sb.append(StringsKt.trimIndent((String)("\n    .icon {\n      background-size: " + scaledIcon.getIconWidth() + "px " + scaledIcon.getIconHeight() + "px;\n      width: " + scaledIcon.getIconWidth() + "px;\n      height: " + scaledIcon.getIconHeight() + "px;\n    }\n  ")));
                        object2 = scheme.getColor(EditorColors.SELECTION_BACKGROUND_COLOR);
                        if (object2 == null) break block4;
                        Color it = object2;
                        boolean bl = false;
                        String string2 = "background-color: " + StylesConversionKt.colorToCss(it) + " !important;";
                        object2 = string2;
                        if (string2 != null) break block5;
                    }
                    object2 = selection_background = "";
                }
                if ((object = scheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR)) == null) break block6;
                Color it = object;
                boolean bl = false;
                String string = "color: " + StylesConversionKt.colorToCss(it) + " !important;";
                object = string;
                if (string != null) break block7;
            }
            object = "";
        }
        Object selection_foreground = object;
        sb.append(StringsKt.trimIndent((String)("\n    .selected, .selected * {\n        " + (String)selection_background + "\n        " + (String)selection_foreground + "\n    }\n  ")));
    }

    private static final float getLineHeight(FontMetrics fontMetrics, EditorColorsScheme scheme) {
        return (float)fontMetrics.getHeight() * scheme.getConsoleLineSpacing();
    }

    private static final void addConsoleViewContentTypes(StringBuilder sb) {
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
        String string = StylesConversionKt.getSelectorName(consoleViewContentType);
        TextAttributes textAttributes = ConsoleViewContentType.NORMAL_OUTPUT.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"getAttributes(...)");
        sb.append(StylesConversionKt.textAttributesToCss(string, textAttributes));
        ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.LOG_ERROR_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"LOG_ERROR_OUTPUT");
        String string2 = StylesConversionKt.getSelectorName(consoleViewContentType2);
        TextAttributes textAttributes2 = ConsoleViewContentType.LOG_ERROR_OUTPUT.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes2, (String)"getAttributes(...)");
        sb.append(StylesConversionKt.textAttributesToCss(string2, textAttributes2));
        ConsoleViewContentType consoleViewContentType3 = ConsoleViewContentType.LOG_WARNING_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType3, (String)"LOG_WARNING_OUTPUT");
        String string3 = StylesConversionKt.getSelectorName(consoleViewContentType3);
        TextAttributes textAttributes3 = ConsoleViewContentType.LOG_WARNING_OUTPUT.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes3, (String)"getAttributes(...)");
        sb.append(StylesConversionKt.textAttributesToCss(string3, textAttributes3));
        ConsoleViewContentType consoleViewContentType4 = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType4, (String)"LOG_DEBUG_OUTPUT");
        String string4 = StylesConversionKt.getSelectorName(consoleViewContentType4);
        TextAttributes textAttributes4 = ConsoleViewContentType.LOG_DEBUG_OUTPUT.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes4, (String)"getAttributes(...)");
        sb.append(StylesConversionKt.textAttributesToCss(string4, textAttributes4));
        ConsoleViewContentType consoleViewContentType5 = ConsoleViewContentType.LOG_INFO_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType5, (String)"LOG_INFO_OUTPUT");
        String string5 = StylesConversionKt.getSelectorName(consoleViewContentType5);
        TextAttributes textAttributes5 = ConsoleViewContentType.LOG_INFO_OUTPUT.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes5, (String)"getAttributes(...)");
        sb.append(StylesConversionKt.textAttributesToCss(string5, textAttributes5));
        ConsoleViewContentType consoleViewContentType6 = ConsoleViewContentType.USER_INPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType6, (String)"USER_INPUT");
        String string6 = StylesConversionKt.getSelectorName(consoleViewContentType6);
        TextAttributes textAttributes6 = ConsoleViewContentType.USER_INPUT.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes6, (String)"getAttributes(...)");
        sb.append(StylesConversionKt.textAttributesToCss(string6, textAttributes6));
        ConsoleViewContentType consoleViewContentType7 = ConsoleViewContentType.SYSTEM_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType7, (String)"SYSTEM_OUTPUT");
        String string7 = StylesConversionKt.getSelectorName(consoleViewContentType7);
        TextAttributes textAttributes7 = ConsoleViewContentType.SYSTEM_OUTPUT.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes7, (String)"getAttributes(...)");
        sb.append(StylesConversionKt.textAttributesToCss(string7, textAttributes7));
        Collection collection = ConsoleViewContentType.getRegisteredTypes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredTypes(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsoleViewContentType it = (ConsoleViewContentType)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string8 = StylesConversionKt.getSelectorName(it);
            TextAttributes textAttributes8 = it.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes8, (String)"getAttributes(...)");
            sb.append(StylesConversionKt.textAttributesToCss(string8, textAttributes8));
        }
    }

    @NotNull
    public static final String textAttributesToCss(@NotNull String selectorName, @NotNull TextAttributes attr) {
        Intrinsics.checkNotNullParameter((Object)selectorName, (String)"selectorName");
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        StringBuilder sb = new StringBuilder();
        sb.append("." + selectorName + " { ");
        StylesConversionKt.attributesToCss(sb, attr);
        sb.append(" } ");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String textAttributesToInlineCss(@NotNull TextAttributes attr) {
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        StringBuilder sb = new StringBuilder();
        StylesConversionKt.attributesToCss(sb, attr);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final void attributesToCss(StringBuilder sb, TextAttributes attr) {
        void $this$mapNotNullTo$iv$iv;
        Color it;
        Color color = attr.getForegroundColor();
        if (color != null) {
            it = color;
            boolean bl = false;
            sb.append(" color: " + StylesConversionKt.colorToCss(it) + ";");
        }
        Color color2 = attr.getBackgroundColor();
        if (color2 != null) {
            it = color2;
            boolean bl = false;
            sb.append(" background-color: " + StylesConversionKt.colorToCss(it) + ";");
        }
        int it2 = attr.getFontType();
        boolean $i$a$-let-StylesConversionKt$attributesToCss$42 = false;
        sb.append(" " + StylesConversionKt.fontTypeToCss(it2) + ";");
        Iterable $this$mapNotNull$iv = attr.getFlyweight().getAllEffects().keySet();
        boolean $i$f$mapNotNull = false;
        Iterable $i$a$-let-StylesConversionKt$attributesToCss$42 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            EffectType it3 = (EffectType)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it3);
            if (StylesConversionKt.effectTypeToTextDecorationLine(it3) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        String it22 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        boolean bl = false;
        if (((CharSequence)it22).length() > 0) {
            sb.append(" text-decoration-line: " + it22 + ";");
        }
    }

    @NotNull
    public static final String colorToCss(@NotNull Color c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return "rgba(" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + ", " + c.getAlpha() + ")";
    }

    @NotNull
    public static final String fontTypeToCss(int fontType) {
        return switch (fontType) {
            case 0 -> "font-weight: normal";
            case 1 -> "font-weight: bold";
            case 2 -> "font-style: italic";
            case 3 -> "font-weight: bold; font-style: italic";
            default -> "font-weight: normal";
        };
    }

    @Nullable
    public static final String effectTypeToTextDecorationLine(@NotNull EffectType effectType) {
        Intrinsics.checkNotNullParameter((Object)effectType, (String)"effectType");
        return switch (WhenMappings.$EnumSwitchMapping$0[effectType.ordinal()]) {
            case 1 -> "underline";
            case 2 -> "line-through";
            default -> null;
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectType.values().length];
            try {
                nArray[EffectType.LINE_UNDERSCORE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.STRIKEOUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

