/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl.engineV2;

import com.google.common.net.InetAddresses;
import com.intellij.httpClient.execution.impl.engineV2.UrlComparisonResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u00a8\u0006\b"}, d2={"compareWithSubdomain", "Lcom/intellij/httpClient/execution/impl/engineV2/UrlComparisonResult;", "domain", "", "subDomain", "isIpAwareLocalhost", "", "host", "intellij.httpClient.executor"})
public final class UrlUtilsKt {
    @NotNull
    public static final UrlComparisonResult compareWithSubdomain(@NotNull String domain, @NotNull String subDomain) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)subDomain, (String)"subDomain");
        if (Intrinsics.areEqual((Object)domain, (Object)subDomain)) {
            return UrlComparisonResult.EQUAL;
        }
        if (UrlUtilsKt.isIpAwareLocalhost(domain) && UrlUtilsKt.isIpAwareLocalhost(subDomain)) {
            return UrlComparisonResult.EQUAL;
        }
        if (InetAddresses.isInetAddress((String)domain) || InetAddresses.isInetAddress((String)subDomain)) {
            return UrlComparisonResult.NOT_EQUAL;
        }
        if (StringsKt.endsWith$default((String)subDomain, (String)("." + domain), (boolean)false, (int)2, null)) {
            return UrlComparisonResult.SUBDOMAIN;
        }
        return UrlComparisonResult.NOT_EQUAL;
    }

    private static final boolean isIpAwareLocalhost(String host) {
        return Intrinsics.areEqual((Object)host, (Object)"127.0.0.1") || Intrinsics.areEqual((Object)host, (Object)"localhost");
    }
}

