/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.console;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.common.CommonClientResponse;
import com.intellij.httpClient.execution.common.CommonClientResponseBody;
import com.intellij.httpClient.execution.common.StructuredPresentableClientResponse;
import com.intellij.httpClient.execution.common.StructuredPresentationHeader;
import com.intellij.httpClient.http.request.HttpClientCoroutinesService;
import com.intellij.httpClient.http.request.HttpClientCoroutinesServiceKt;
import com.intellij.httpClient.http.request.cookies.CookieStorageInvalidFileException;
import com.intellij.httpClient.http.request.cookies.HttpRequestCookiesStorage;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.HttpRequestResponseFileResult;
import com.intellij.httpClient.http.request.run.console.HttpClientMessagePrinter;
import com.intellij.httpClient.http.request.run.console.HttpResponseCustomPresentation;
import com.intellij.httpClient.http.request.run.console.HttpResponsePresentation;
import com.intellij.httpClient.http.request.run.console.HttpSucceedResponsePresentation;
import com.intellij.httpClient.http.request.run.console.single.HttpResponseFoldingModelFactory;
import com.intellij.httpClient.http.request.run.console.single.HttpResponseFoldingModelFactoryKt;
import com.intellij.httpClient.http.request.run.console.single.PlainFoldingModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.util.coroutines.flow.FlowKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u0000 82\u00020\u0001:\u000289B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016JT\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001c0\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u000e\u0010!\u001a\n\u0018\u00010\"j\u0004\u0018\u0001`#H\u0016J\"\u0010$\u001a\u00020\u00142\n\u0010%\u001a\u00060&j\u0002`'2\u0006\u0010\u0017\u001a\u00020\u0018H\u0084@\u00a2\u0006\u0002\u0010(J.\u0010)\u001a\u00020*2\u0006\u0010\r\u001a\u00020+2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110-H\u0084@\u00a2\u0006\u0002\u0010.J\u0018\u0010/\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J$\u00100\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u00101\u001a\u0004\u0018\u00010 2\b\b\u0002\u00102\u001a\u00020\bH\u0004J\u0018\u00103\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\u001a\u00107\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpSucceedResponsePresentation;", "Lcom/intellij/httpClient/http/request/run/console/HttpResponsePresentation;", "response", "Lcom/intellij/httpClient/execution/common/CommonClientResponse;", "request", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "withCookieJar", "", "<init>", "(Lcom/intellij/httpClient/execution/common/CommonClientResponse;Lcom/intellij/psi/SmartPsiElementPointer;Z)V", "getResponse", "()Lcom/intellij/httpClient/execution/common/CommonClientResponse;", "body", "Lcom/intellij/httpClient/execution/common/CommonClientResponseBody;", "canBeReformatted", "getExecutionTime", "", "isEmpty", "print", "", "project", "Lcom/intellij/openapi/project/Project;", "printer", "Lcom/intellij/httpClient/http/request/run/console/HttpClientMessagePrinter;", "pathToResponse", "Lcom/intellij/httpClient/http/request/run/HttpRequestResponseFileResult;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "isValid", "Ljava/util/function/Predicate;", "responseFoldingModelProvider", "Lcom/intellij/httpClient/http/request/run/console/single/HttpResponseFoldingModelFactory;", "onFinishPrinting", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "handleResponsePrintingException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/Exception;Lcom/intellij/httpClient/http/request/run/console/HttpClientMessagePrinter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awaitForContent", "Lcom/intellij/httpClient/execution/common/CommonClientResponseBody$Binary$Content;", "Lcom/intellij/httpClient/execution/common/CommonClientResponseBody$Binary;", "timeProperty", "Lkotlin/reflect/KMutableProperty0;", "(Lcom/intellij/httpClient/execution/common/CommonClientResponseBody$Binary;Lcom/intellij/httpClient/http/request/run/console/HttpClientMessagePrinter;Lkotlin/reflect/KMutableProperty0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "printCookieStorage", "printHeader", "foldingModelFactory", "addLineBreak", "addCustomPresentations", "order", "Lcom/intellij/httpClient/http/request/run/console/HttpResponseCustomPresentation$Order;", "printStatus", "printResponseFilePath", "Companion", "DownloadingProgressBar", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpSucceedResponsePresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpSucceedResponsePresentation.kt\ncom/intellij/httpClient/http/request/run/console/HttpSucceedResponsePresentation\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,338:1\n1321#2,2:339\n*S KotlinDebug\n*F\n+ 1 HttpSucceedResponsePresentation.kt\ncom/intellij/httpClient/http/request/run/console/HttpSucceedResponsePresentation\n*L\n228#1:339,2\n*E\n"})
public class HttpSucceedResponsePresentation
extends HttpResponsePresentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonClientResponse response;
    @NotNull
    private final SmartPsiElementPointer<HttpRequest> request;
    private final boolean withCookieJar;
    @NotNull
    private final CommonClientResponseBody body;
    @NotNull
    private static final ExtensionPointName<HttpResponseCustomPresentation> CUSTOM_PRESENTATIONS_EP_NAME = new ExtensionPointName("com.intellij.httpClient.responseCustomPresentation");

    public HttpSucceedResponsePresentation(@NotNull CommonClientResponse response2, @NotNull SmartPsiElementPointer<HttpRequest> request, boolean withCookieJar) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        this.response = response2;
        this.request = request;
        this.withCookieJar = withCookieJar;
        this.body = this.response.getBody();
    }

    @NotNull
    protected final CommonClientResponse getResponse() {
        return this.response;
    }

    @Override
    public boolean canBeReformatted() {
        return false;
    }

    @Override
    public long getExecutionTime() {
        Long l = this.response.getExecutionTime();
        return l != null ? l : 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.body instanceof CommonClientResponseBody.Empty;
    }

    @Override
    public void print(@NotNull Project project, @NotNull HttpClientMessagePrinter printer2, @Nullable HttpRequestResponseFileResult pathToResponse, @NotNull FileType fileType, @NotNull Predicate<? super FileType> isValid, @Nullable HttpResponseFoldingModelFactory responseFoldingModelProvider, @Nullable Runnable onFinishPrinting) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)printer2, (String)"printer");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter(isValid, (String)"isValid");
        boolean needsEnterAfterHeader = this.printHeader(printer2, responseFoldingModelProvider, true);
        HttpClientCoroutinesService httpClientCoroutinesService = HttpClientCoroutinesService.Companion.getInstance(project);
        CoroutineDispatcher coroutineDispatcher = HttpClientCoroutinesServiceKt.getHttpClientTasks(Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        BuildersKt.launch$default((CoroutineScope)httpClientCoroutinesService.scope(coroutineDispatcher.plus(ModalityKt.asContextElement((ModalityState)modalityState)).plus((CoroutineContext)new CoroutineName("Printing response"))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, printer2, needsEnterAfterHeader, pathToResponse, project, onFinishPrinting, null){
            Object L$0;
            int label;
            final /* synthetic */ HttpSucceedResponsePresentation this$0;
            final /* synthetic */ HttpClientMessagePrinter $printer;
            final /* synthetic */ boolean $needsEnterAfterHeader;
            final /* synthetic */ HttpRequestResponseFileResult $pathToResponse;
            final /* synthetic */ Project $project;
            final /* synthetic */ Runnable $onFinishPrinting;
            {
                this.this$0 = $receiver;
                this.$printer = $printer;
                this.$needsEnterAfterHeader = $needsEnterAfterHeader;
                this.$pathToResponse = $pathToResponse;
                this.$project = $project;
                this.$onFinishPrinting = $onFinishPrinting;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!(HttpSucceedResponsePresentation.access$getBody$p(this.this$0) instanceof CommonClientResponseBody.Binary)) ** GOTO lbl18
                        this.label = 1;
                        v0 = this.this$0.awaitForContent((CommonClientResponseBody.Binary)HttpSucceedResponsePresentation.access$getBody$p(this.this$0), this.$printer, (KMutableProperty0<Long>)((KMutableProperty0)new MutablePropertyReference0Impl(this.this$0.getResponse()){

                            public Object get() {
                                return ((CommonClientResponse)this.receiver).getExecutionTime();
                            }

                            public void set(Object value2) {
                                ((CommonClientResponse)this.receiver).setExecutionTime((Long)value2);
                            }
                        }), (Continuation<? super CommonClientResponseBody.Binary.Content>)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl12
lbl11:
                        // 1 sources

                        return var3_2;
lbl12:
                        // 1 sources

                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 3 sources

                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$needsEnterAfterHeader, this.$printer, this.this$0, this.$pathToResponse, this.$project, null){
                            int label;
                            final /* synthetic */ boolean $needsEnterAfterHeader;
                            final /* synthetic */ HttpClientMessagePrinter $printer;
                            final /* synthetic */ HttpSucceedResponsePresentation this$0;
                            final /* synthetic */ HttpRequestResponseFileResult $pathToResponse;
                            final /* synthetic */ Project $project;
                            {
                                this.$needsEnterAfterHeader = $needsEnterAfterHeader;
                                this.$printer = $printer;
                                this.this$0 = $receiver;
                                this.$pathToResponse = $pathToResponse;
                                this.$project = $project;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (this.$needsEnterAfterHeader) {
                                            this.$printer.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                                        }
                                        this.this$0.printResponseFilePath(this.$printer, this.$pathToResponse);
                                        this.this$0.printStatus(this.$printer);
                                        this.this$0.printCookieStorage(this.$project, this.$printer);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v1 != var3_2) goto lbl22
lbl21:
                        // 1 sources

                        return var3_2;
lbl22:
                        // 1 sources

                        ** GOTO lbl28
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl28:
                        // 2 sources

                        this.label = 3;
                        v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$onFinishPrinting, null){
                            int label;
                            final /* synthetic */ Runnable $onFinishPrinting;
                            {
                                this.$onFinishPrinting = $onFinishPrinting;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Unit unit;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Runnable runnable = this.$onFinishPrinting;
                                        if (runnable != null) {
                                            runnable.run();
                                            unit = Unit.INSTANCE;
                                        } else {
                                            unit = null;
                                        }
                                        return unit;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v2 == var3_2) {
                            return var3_2;
                        }
                        break;
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        break;
                    }
                }
                catch (Exception e) {
                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)e);
                    this.label = 4;
                    v3 = this.this$0.handleResponsePrintingException(e, this.$printer, (Continuation<? super Unit>)((Continuation)this));
                    ** if (v3 != var3_2) goto lbl44
lbl43:
                    // 1 sources

                    return var3_2;
lbl44:
                    // 1 sources

                    ** GOTO lbl51
                }
                {
                    case 4: {
                        e = (Exception)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl51:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 5;
                        v4 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)((Continuation)this));
                        if (v4 == var3_2) {
                            return var3_2;
                        }
                        break;
                    }
                    case 5: {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                        break;
                    }
                }
                {
                    catch (Throwable var2_5) {
                        this.L$0 = var2_5;
                        this.label = 6;
                        v5 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)((Continuation)this));
                        if (v5 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl72
                    }
                }
                {
                    case 6: {
                        var2_6 = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl72:
                        // 2 sources

                        throw var2_6;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    protected final Object handleResponsePrintingException(@NotNull Exception e, @NotNull HttpClientMessagePrinter printer2, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(e, printer2, null){
            int label;
            final /* synthetic */ Exception $e;
            final /* synthetic */ HttpClientMessagePrinter $printer;
            {
                this.$e = $e;
                this.$printer = $printer;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Exception exception = this.$e;
                        if (exception instanceof ProcessCanceledException || exception instanceof CancellationException) {
                            this.$printer.print(RestClientBundle.message("rest.client.request.response.printing.interrupted.error", new Object[0]), ConsoleViewContentType.ERROR_OUTPUT);
                        } else if (exception instanceof IOException) {
                            this.$printer.print(((IOException)this.$e).getLocalizedMessage(), ConsoleViewContentType.ERROR_OUTPUT);
                        } else {
                            throw this.$e;
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    protected final Object awaitForContent(@NotNull CommonClientResponseBody.Binary body, @NotNull HttpClientMessagePrinter printer, @NotNull KMutableProperty0<Long> timeProperty, @NotNull Continuation<? super CommonClientResponseBody.Binary.Content> $completion) {
        block20: {
            if (!($completion instanceof awaitForContent.1)) ** GOTO lbl-1000
            var18_5 = $completion;
            if ((var18_5.label & -2147483648) != 0) {
                var18_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ HttpSucceedResponsePresentation this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.awaitForContent(null, null, null, (Continuation<? super CommonClientResponseBody.Binary.Content>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var19_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var5_8 = body.getContentDescriptor();
                    content = var5_8.component1();
                    bytesReceived = var5_8.component2();
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)body);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)printer);
                    $continuation.L$2 = timeProperty;
                    $continuation.L$3 = content;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)bytesReceived);
                    $continuation.label = 1;
                    v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Disposable>, Object>(body, printer, bytesReceived, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ CommonClientResponseBody.Binary $body;
                        final /* synthetic */ HttpClientMessagePrinter $printer;
                        final /* synthetic */ StateFlow<CommonClientResponseBody.Binary.DownloadingStatus> $bytesReceived;
                        {
                            this.$body = $body;
                            this.$printer = $printer;
                            this.$bytesReceived = $bytesReceived;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final Object invokeSuspend(Object $result) {
                            CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    void $this$withContext;
                                    ResultKt.throwOnFailure((Object)$result);
                                    DownloadingProgressBar downloadingProgressBar = new DownloadingProgressBar(this.$body.getDeclaredSize());
                                    StateFlow<CommonClientResponseBody.Binary.DownloadingStatus> stateFlow = this.$bytesReceived;
                                    DownloadingProgressBar it = downloadingProgressBar;
                                    boolean bl = false;
                                    it.attachIn((CoroutineScope)$this$withContext, stateFlow);
                                    DownloadingProgressBar progress = downloadingProgressBar;
                                    return this.$printer.addInlineEmbeddedComponent(progress, null);
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value2;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Disposable> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var19_7) {
                        return var19_7;
                    }
                    ** GOTO lbl33
                }
                case 1: {
                    bytesReceived = (StateFlow)$continuation.L$4;
                    content = (Deferred)$continuation.L$3;
                    timeProperty = (KMutableProperty0)$continuation.L$2;
                    printer = (HttpClientMessagePrinter)$continuation.L$1;
                    body = (CommonClientResponseBody.Binary)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl33:
                    // 2 sources

                    disposableInlay = (Disposable)v0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)body);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)printer);
                    $continuation.L$2 = timeProperty;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)content);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)bytesReceived);
                    $continuation.L$5 = disposableInlay;
                    $continuation.label = 2;
                    v1 = content.await((Continuation)$continuation);
                    ** if (v1 != var19_7) goto lbl46
lbl45:
                    // 1 sources

                    return var19_7;
lbl46:
                    // 1 sources

                    ** GOTO lbl58
                }
                case 2: {
                    disposableInlay = (Disposable)$continuation.L$5;
                    bytesReceived = (StateFlow)$continuation.L$4;
                    content = (Deferred)$continuation.L$3;
                    timeProperty = (KMutableProperty0)$continuation.L$2;
                    printer = (HttpClientMessagePrinter)$continuation.L$1;
                    body = (CommonClientResponseBody.Binary)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl58:
                    // 2 sources

                    var9_18 = v1;
                    receivedContent = (CommonClientResponseBody.Binary.Content)var9_18;
                    $i$a$-also-HttpSucceedResponsePresentation$awaitForContent$2 = 0;
                    var12_26 /* !! */  = (Long)timeProperty.invoke();
                    v2 = var12_26 /* !! */ ;
                    timeProperty.set((Object)Boxing.boxLong((long)((v2 != null ? v2.longValue() : 0L) + receivedContent.getDownloadingTime())));
                    var12_26 /* !! */  = $continuation;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)body);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)printer);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)timeProperty);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)content);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)bytesReceived);
                    $continuation.L$5 = disposableInlay;
                    $continuation.L$6 = var9_18;
                    $continuation.L$7 = receivedContent;
                    $continuation.L$8 = var12_26 /* !! */ ;
                    $continuation.I$0 = $i$a$-also-HttpSucceedResponsePresentation$awaitForContent$2;
                    $continuation.label = 3;
                    var13_30 = (Continuation)var12_26 /* !! */ ;
                    var14_33 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var13_30));
                    it = (Continuation)var14_33;
                    $i$a$-suspendCoroutine-HttpSucceedResponsePresentation$awaitForContent$2$1 = false;
                    receivedContent.getFileWithContent().refresh(true, false, new Runnable((Continuation<? super Unit>)it){
                        final /* synthetic */ Continuation<Unit> $it;
                        {
                            this.$it = $it;
                        }

                        public final void run() {
                            this.$it.resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
                        }
                    });
                    v3 = var14_33.getOrThrow();
                    if (v3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)var12_26 /* !! */ ));
                    }
                    v4 = v3;
                    if (v3 == var19_7) {
                        return var19_7;
                    }
                    ** GOTO lbl105
                }
                case 3: {
                    $i$a$-also-HttpSucceedResponsePresentation$awaitForContent$2 = $continuation.I$0;
                    var12_26 /* !! */  = $continuation.L$8;
                    receivedContent = (CommonClientResponseBody.Binary.Content)$continuation.L$7;
                    var9_18 = $continuation.L$6;
                    disposableInlay = (Disposable)$continuation.L$5;
                    bytesReceived = (StateFlow)$continuation.L$4;
                    content = (Deferred)$continuation.L$3;
                    timeProperty = (KMutableProperty0)$continuation.L$2;
                    printer = (HttpClientMessagePrinter)$continuation.L$1;
                    body = (CommonClientResponseBody.Binary)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl105:
                    // 2 sources

                    v5 = disposableInlay;
                    if (v5 == null) break;
                    it = v5;
                    $i$a$-let-HttpSucceedResponsePresentation$awaitForContent$3 = 0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)body);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)printer);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)timeProperty);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)content);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)bytesReceived);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)disposableInlay);
                    $continuation.L$6 = var9_18;
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)it);
                    $continuation.L$8 = null;
                    $continuation.I$0 = $i$a$-let-HttpSucceedResponsePresentation$awaitForContent$3;
                    $continuation.label = 4;
                    v6 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null){
                        int label;
                        final /* synthetic */ Disposable $it;
                        {
                            this.$it = $it;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Disposer.dispose((Disposable)this.$it);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v6 == var19_7) {
                        return var19_7;
                    }
                    break;
                }
                case 4: {
                    $i$a$-let-HttpSucceedResponsePresentation$awaitForContent$3 = $continuation.I$0;
                    it = (Disposable)$continuation.L$7;
                    var9_18 = $continuation.L$6;
                    disposableInlay = (Disposable)$continuation.L$5;
                    bytesReceived = (StateFlow)$continuation.L$4;
                    content = (Deferred)$continuation.L$3;
                    timeProperty = (KMutableProperty0)$continuation.L$2;
                    printer = (HttpClientMessagePrinter)$continuation.L$1;
                    body = (CommonClientResponseBody.Binary)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
                    break;
                }
            }
            return var9_18;
            catch (Throwable var10_21) {
                v7 = disposableInlay;
                if (v7 == null) break block20;
                it = v7;
                $i$a$-let-HttpSucceedResponsePresentation$awaitForContent$3 = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)body);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)printer);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)timeProperty);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)content);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)bytesReceived);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)disposableInlay);
                $continuation.L$6 = var10_21;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)it);
                $continuation.L$8 = null;
                $continuation.I$0 = $i$a$-let-HttpSucceedResponsePresentation$awaitForContent$3;
                $continuation.label = 5;
                v8 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)$continuation);
                if (v8 == var19_7) {
                    return var19_7;
                }
                break block20;
            }
            {
                case 5: {
                    $i$a$-let-HttpSucceedResponsePresentation$awaitForContent$3 = $continuation.I$0;
                    it = (Disposable)$continuation.L$7;
                    var10_22 = (Throwable)$continuation.L$6;
                    disposableInlay = (Disposable)$continuation.L$5;
                    bytesReceived = (StateFlow)$continuation.L$4;
                    content = (Deferred)$continuation.L$3;
                    timeProperty = (KMutableProperty0)$continuation.L$2;
                    printer = (HttpClientMessagePrinter)$continuation.L$1;
                    body = (CommonClientResponseBody.Binary)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v8 = $result;
                    break;
                }
            }
        }
        throw var10_22;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    protected final void printCookieStorage(@NotNull Project project, @NotNull HttpClientMessagePrinter printer2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)printer2, (String)"printer");
        if (!this.withCookieJar) {
            return;
        }
        HttpRequestCookiesStorage storage = HttpRequestCookiesStorage.getInstance(project);
        try {
            if (storage.hasCookies()) {
                printer2.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                printer2.print(RestClientBundle.message("http.request.cookie.jar.cookie.preserved", new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
                this.addCustomPresentations(printer2, HttpResponseCustomPresentation.Order.IN_COOKIE);
                printer2.print("\n> " + HttpRequestCookiesStorage.getDefaultCookieFilePath(project) + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
            }
        }
        catch (CookieStorageInvalidFileException e) {
            printer2.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            Object[] objectArray = new Object[]{e.getMessage()};
            printer2.print(RestClientBundle.message("http.request.cookie.jar.cookie.preserved.failed", objectArray), ConsoleViewContentType.ERROR_OUTPUT);
            printer2.print("\n> " + HttpRequestCookiesStorage.getDefaultCookieFilePath(project) + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    protected final boolean printHeader(@NotNull HttpClientMessagePrinter printer2, @Nullable HttpResponseFoldingModelFactory foldingModelFactory, boolean addLineBreak) {
        Intrinsics.checkNotNullParameter((Object)printer2, (String)"printer");
        this.addCustomPresentations(printer2, HttpResponseCustomPresentation.Order.BEFORE_HEADER);
        if (this.response instanceof StructuredPresentableClientResponse) {
            boolean bl;
            StructuredPresentationHeader header = ((StructuredPresentableClientResponse)((Object)this.response)).getStructuredPresentationHeader();
            boolean printedAnything = false;
            HttpResponseFoldingModelFactory httpResponseFoldingModelFactory = foldingModelFactory;
            PlainFoldingModel foldingModel = httpResponseFoldingModelFactory != null ? httpResponseFoldingModelFactory.createPlainModel() : null;
            int offset = 0;
            Iterator iterator = ((Iterable)header.getElements()).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                StructuredPresentationHeader.Element element = (StructuredPresentationHeader.Element)iterator.next();
                if (!(((CharSequence)element.getText()).length() > 0)) continue;
                printedAnything = true;
                printer2.print(element.getText(), ConsoleViewContentType.SYSTEM_OUTPUT);
                if (element instanceof StructuredPresentationHeader.Element.Summarized) {
                    PlainFoldingModel plainFoldingModel = foldingModel;
                    if (plainFoldingModel != null) {
                        TextRange textRange = TextRange.create((int)offset, (int)(offset + ((StructuredPresentationHeader.Element.Summarized)element).getText().length() - 1));
                        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
                        plainFoldingModel.addFoldingForRelativeRange(textRange, ((StructuredPresentationHeader.Element.Summarized)element).getSummary(), HttpResponseFoldingModelFactoryKt.getHEADERS_ID(), !(this.body instanceof CommonClientResponseBody.Empty));
                    }
                }
                if (index != CollectionsKt.getLastIndex(header.getElements())) {
                    printer2.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                }
                offset += element.getText().length() + 1;
            }
            if (printedAnything) {
                this.addCustomPresentations(printer2, HttpResponseCustomPresentation.Order.AFTER_HEADER);
            }
            if (printedAnything && addLineBreak) {
                printer2.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                bl = false;
            } else {
                bl = printedAnything;
            }
            return bl;
        }
        String header = this.response.getPresentationHeader();
        if (StringUtil.isNotEmpty((String)header)) {
            printer2.print(header, ConsoleViewContentType.SYSTEM_OUTPUT);
            this.addCustomPresentations(printer2, HttpResponseCustomPresentation.Order.AFTER_HEADER);
            if (addLineBreak) {
                printer2.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                return false;
            }
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean printHeader$default(HttpSucceedResponsePresentation httpSucceedResponsePresentation, HttpClientMessagePrinter httpClientMessagePrinter, HttpResponseFoldingModelFactory httpResponseFoldingModelFactory, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: printHeader");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return httpSucceedResponsePresentation.printHeader(httpClientMessagePrinter, httpResponseFoldingModelFactory, bl);
    }

    private final void addCustomPresentations(HttpClientMessagePrinter printer2, HttpResponseCustomPresentation.Order order) {
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)CUSTOM_PRESENTATIONS_EP_NAME.getExtensionList()), arg_0 -> HttpSucceedResponsePresentation.addCustomPresentations$lambda$3(order, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpResponseCustomPresentation it = (HttpResponseCustomPresentation)element$iv;
            boolean bl = false;
            it.print(this.response, this.request, printer2);
        }
    }

    protected final void printStatus(@NotNull HttpClientMessagePrinter printer2) {
        Intrinsics.checkNotNullParameter((Object)printer2, (String)"printer");
        if (!StringsKt.isBlank((CharSequence)this.response.getPresentationFooter())) {
            printer2.print(this.response.getPresentationFooter() + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    }

    protected final void printResponseFilePath(@NotNull HttpClientMessagePrinter printer2, @Nullable HttpRequestResponseFileResult pathToResponse) {
        Intrinsics.checkNotNullParameter((Object)printer2, (String)"printer");
        if (pathToResponse instanceof HttpRequestResponseFileResult.Error) {
            printer2.print("> ", ConsoleViewContentType.ERROR_OUTPUT);
            Object[] objectArray = new Object[]{((HttpRequestResponseFileResult.Error)pathToResponse).getError().getLocalizedMessage()};
            printer2.print(RestClientBundle.message("rest.client.request.response.file.error.message", objectArray), ConsoleViewContentType.ERROR_OUTPUT);
            printer2.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            return;
        }
        if (pathToResponse instanceof HttpRequestResponseFileResult.ExactFile && StringUtil.isNotEmpty((String)((HttpRequestResponseFileResult.ExactFile)pathToResponse).getFileName())) {
            printer2.print(RestClientBundle.message("rest.client.request.response.file.created.message", new Object[0]) + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
            printer2.print("> " + ((HttpRequestResponseFileResult.ExactFile)pathToResponse).getFileName(), ConsoleViewContentType.NORMAL_OUTPUT);
            this.addCustomPresentations(printer2, HttpResponseCustomPresentation.Order.AFTER_FILE_PATH);
        } else {
            printer2.print(RestClientBundle.message("rest.client.request.response.body.empty", new Object[0]), ConsoleViewContentType.NORMAL_OUTPUT);
        }
        printer2.print("\n\n", ConsoleViewContentType.NORMAL_OUTPUT);
    }

    private static final boolean addCustomPresentations$lambda$3(HttpResponseCustomPresentation.Order $order, HttpResponseCustomPresentation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getOrder() == $order;
    }

    public static final /* synthetic */ CommonClientResponseBody access$getBody$p(HttpSucceedResponsePresentation $this) {
        return $this.body;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpSucceedResponsePresentation$Companion;", "", "<init>", "()V", "CUSTOM_PRESENTATIONS_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/httpClient/http/request/run/console/HttpResponseCustomPresentation;", "intellij.restClient"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\fH\u0016R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpSucceedResponsePresentation$DownloadingProgressBar;", "Ljavax/swing/JPanel;", "declaredSize", "", "<init>", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "progress", "Ljavax/swing/JProgressBar;", "statusText", "Ljavax/swing/JLabel;", "attachIn", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "bytesReceived", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/intellij/httpClient/execution/common/CommonClientResponseBody$Binary$DownloadingStatus;", "toPercentOf", "", "allValue", "addNotify", "intellij.restClient"})
    private static final class DownloadingProgressBar
    extends JPanel {
        @Nullable
        private final Long declaredSize;
        @NotNull
        private final JProgressBar progress;
        @NotNull
        private final JLabel statusText;

        public DownloadingProgressBar(@Nullable Long declaredSize) {
            super(new BorderLayout());
            this.declaredSize = declaredSize;
            if (this.declaredSize != null) {
                this.progress = new JProgressBar(0, 100);
                this.progress.setIndeterminate(false);
                Object[] objectArray = new Object[]{"0 B", StringUtil.formatFileSize((long)this.declaredSize)};
                this.statusText = new JLabel(RestClientBundle.message("rest.client.request.response.downloading.with.bound.status", objectArray));
            } else {
                this.progress = new JProgressBar();
                this.progress.setIndeterminate(true);
                Object[] objectArray = new Object[]{"0 B"};
                this.statusText = new JLabel(RestClientBundle.message("rest.client.request.response.downloading.without.bound.status", objectArray));
            }
            this.add((Component)this.progress, "Center");
            this.add((Component)this.statusText, "East");
            this.statusText.setBorder(JBUI.Borders.empty((int)5));
            this.statusText.setBackground(null);
            this.progress.setBackground(null);
            this.setBackground(null);
        }

        public final void attachIn(@NotNull CoroutineScope coroutineScope, @NotNull StateFlow<? extends CommonClientResponseBody.Binary.DownloadingStatus> bytesReceived) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter(bytesReceived, (String)"bytesReceived");
            BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)HttpClientCoroutinesServiceKt.getHttpClientTasks(Dispatchers.INSTANCE)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(bytesReceived, this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ StateFlow<CommonClientResponseBody.Binary.DownloadingStatus> $bytesReceived;
                final /* synthetic */ DownloadingProgressBar this$0;
                {
                    this.$bytesReceived = $bytesReceived;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$launch;
                            ResultKt.throwOnFailure((Object)$result);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                            this.label = 1;
                            Object object2 = FlowKt.throttle((Flow)((Flow)this.$bytesReceived), (long)TimeUnit.SECONDS.toMillis(1L)).collect(new FlowCollector((CoroutineScope)$this$launch, this.this$0){
                                final /* synthetic */ CoroutineScope $$this$launch;
                                final /* synthetic */ DownloadingProgressBar this$0;
                                {
                                    this.$$this$launch = $$this$launch;
                                    this.this$0 = $receiver;
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object emit(CommonClientResponseBody.Binary.DownloadingStatus it, Continuation<? super Unit> $completion) {
                                    if (!($completion instanceof attachIn.emit.1)) ** GOTO lbl-1000
                                    var4_3 = $completion;
                                    if ((var4_3.label & -2147483648) != 0) {
                                        var4_3.label -= -2147483648;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        $continuation = new ContinuationImpl(this, $completion){
                                            Object L$0;
                                            /* synthetic */ Object result;
                                            final /* synthetic */ attachIn.1<T> this$0;
                                            int label;
                                            {
                                                this.this$0 = this$0;
                                                super($completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                this.result = $result;
                                                this.label |= Integer.MIN_VALUE;
                                                return this.this$0.emit(null, (Continuation<Unit>)((Continuation)this));
                                            }
                                        };
                                    }
                                    $result = $continuation.result;
                                    var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch ($continuation.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            $continuation.L$0 = it;
                                            $continuation.label = 1;
                                            v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, it, null){
                                                int label;
                                                final /* synthetic */ DownloadingProgressBar this$0;
                                                final /* synthetic */ CommonClientResponseBody.Binary.DownloadingStatus $it;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$it = $it;
                                                    super(2, $completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            if (DownloadingProgressBar.access$getDeclaredSize$p(this.this$0) != null) {
                                                                DownloadingProgressBar.access$getProgress$p(this.this$0).setValue(DownloadingProgressBar.access$toPercentOf(this.this$0, this.$it.getValue(), DownloadingProgressBar.access$getDeclaredSize$p(this.this$0)));
                                                                Object[] objectArray = new Object[]{StringUtil.formatFileSize((long)this.$it.getValue()), StringUtil.formatFileSize((long)DownloadingProgressBar.access$getDeclaredSize$p(this.this$0))};
                                                                DownloadingProgressBar.access$getStatusText$p(this.this$0).setText(RestClientBundle.message("rest.client.request.response.downloading.with.bound.status", objectArray));
                                                            } else {
                                                                Object[] objectArray = new Object[]{StringUtil.formatFileSize((long)this.$it.getValue())};
                                                                DownloadingProgressBar.access$getStatusText$p(this.this$0).setText(RestClientBundle.message("rest.client.request.response.downloading.without.bound.status", objectArray));
                                                            }
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)$continuation);
                                            if (v0 == var5_5) {
                                                return var5_5;
                                            }
                                            ** GOTO lbl22
                                        }
                                        case 1: {
                                            it = (CommonClientResponseBody.Binary.DownloadingStatus)$continuation.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl22:
                                            // 2 sources

                                            if (it instanceof CommonClientResponseBody.Binary.DownloadingStatus.Final) {
                                                CoroutineScopeKt.cancel$default((CoroutineScope)this.$$this$launch, null, (int)1, null);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }
                            }, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        private final int toPercentOf(long $this$toPercentOf, long allValue) {
            return (int)((double)$this$toPercentOf / (double)allValue * (double)100);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.getParent().setBackground(null);
        }

        public static final /* synthetic */ Long access$getDeclaredSize$p(DownloadingProgressBar $this) {
            return $this.declaredSize;
        }

        public static final /* synthetic */ JProgressBar access$getProgress$p(DownloadingProgressBar $this) {
            return $this.progress;
        }

        public static final /* synthetic */ int access$toPercentOf(DownloadingProgressBar $this, long $receiver, long allValue) {
            return $this.toPercentOf($receiver, allValue);
        }

        public static final /* synthetic */ JLabel access$getStatusText$p(DownloadingProgressBar $this) {
            return $this.statusText;
        }
    }
}

