/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.GenericJdbcHelperBase;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AthenaJdbcHelper
extends GenericJdbcHelperBase {
    public AthenaJdbcHelper(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        super("ATHENA", version, connection, jdbcClassLoader);
    }

    public AthenaJdbcHelper() {
        this(null, null, null);
    }

    private AthenaJdbcHelper(@NotNull AthenaJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            AthenaJdbcHelper.$$$reportNull$$$0(0);
        }
        if (jdbcClassLoader == null) {
            AthenaJdbcHelper.$$$reportNull$$$0(1);
        }
        super(helper, jdbcClassLoader);
    }

    @Override
    @NotNull
    protected GenericJdbcHelperBase create(@Nullable Connection delegate, @Nullable String product, String version, @Nullable ClassLoader jdbcClassLoader) {
        return new AthenaJdbcHelper(version, delegate, jdbcClassLoader);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new AthenaJdbcHelper(version, connection, jdbcClassLoader);
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            AthenaJdbcHelper.$$$reportNull$$$0(2);
        }
        return new AthenaJdbcHelper(this, jdbcClassLoader);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            AthenaJdbcHelper.$$$reportNull$$$0(3);
        }
        super.adjustType(e);
        if (e.typeName != null && e.typeName.equalsIgnoreCase("int")) {
            e.typeName = e.typeName + (Character.isUpperCase(e.typeName.charAt(2)) ? "EGER" : "eger");
        }
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            AthenaJdbcHelper.$$$reportNull$$$0(4);
        }
        return JdbcNativeUtil.detectString(url, ":awsathena:");
    }

    @Override
    public GenericJdbcHelperBase detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper, @Nullable ClassLoader jdbcClassLoader) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "Athena")) {
            return null;
        }
        return super.detect(delegate, product, productVer, connectHelper, jdbcClassLoader);
    }

    @Override
    protected void configureSimba(Driver driver, Properties properties, @Nullable Level level, @Nullable String logPath) {
        if (driver.getMajorVersion() < 3) {
            super.configureSimba(driver, properties, level, logPath);
            return;
        }
        if (level != null) {
            AthenaJdbcHelper.setIfEmpty(properties, "LogLevel", level == Level.OFF ? "OFF" : (level.intValue() >= Level.SEVERE.intValue() ? "ERROR" : (level.intValue() >= Level.WARNING.intValue() ? "WARN" : (level.intValue() >= Level.INFO.intValue() ? "INFO" : (level.intValue() >= Level.FINE.intValue() ? "DEBUG" : "TRACE")))));
        }
        if (logPath != null) {
            AthenaJdbcHelper.setIfEmpty(properties, "LogPath", logPath);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/AthenaJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "bindClassLoader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

