/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgGPlumJdbcHelperBase;
import java.sql.Connection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class YBJdbcHelper
extends PgGPlumJdbcHelperBase {
    private static final Pattern YB_VERSION_PATTERN = Pattern.compile("-YB-(\\d+(?:\\.\\d+)*)");

    public YBJdbcHelper(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        super("YUGABYTE", version, connection, jdbcClassLoader);
    }

    public YBJdbcHelper() {
        this(null, null, null);
    }

    private YBJdbcHelper(@NotNull YBJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            YBJdbcHelper.$$$reportNull$$$0(0);
        }
        if (jdbcClassLoader == null) {
            YBJdbcHelper.$$$reportNull$$$0(1);
        }
        super(helper, jdbcClassLoader);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new YBJdbcHelper(version, connection, jdbcClassLoader);
    }

    @Override
    public boolean supportsLimitMaxRows() {
        return false;
    }

    @Override
    @Nullable
    public Boolean supportsSavepoints() {
        return false;
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            YBJdbcHelper.$$$reportNull$$$0(2);
        }
        return new YBJdbcHelper(this, jdbcClassLoader);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return YBJdbcHelper.extractVersion(version);
    }

    @NotNull
    static YBJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer, @Nullable ClassLoader jdbcClassLoader) {
        String version = YBJdbcHelper.extractVersion(productVer);
        return new YBJdbcHelper(version, delegate, jdbcClassLoader);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, YB_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/YBJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "bindClassLoader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

