/*
 * Decompiled with CFR 0.152.
 */
package org.joox.selector;

import org.joox.selector.Assert;
import org.joox.selector.Specifier;

class PseudoNthSpecifier
implements Specifier {
    private final String value;
    private final String argument;
    private int a = 0;
    private int b = 0;

    public PseudoNthSpecifier(String value, String argument) {
        Assert.notNull(value, "value is null!");
        Assert.notNull(argument, "argument is null!");
        this.value = value;
        this.argument = argument;
        this.parseNth();
    }

    public String getArgument() {
        return this.argument;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public Specifier.Type getType() {
        return Specifier.Type.PSEUDO;
    }

    public boolean isMatch(int count) {
        if (this.a == 0) {
            return count == this.b;
        }
        if (this.a > 0) {
            if (count < this.b) {
                return false;
            }
            return (count - this.b) % this.a == 0;
        }
        if (count > this.b) {
            return false;
        }
        return (this.b - count) % -this.a == 0;
    }

    private void parseNth() {
        String str = this.argument.replaceAll("\\+|\\s+", "");
        if ("odd".equals(str)) {
            this.a = 2;
            this.b = 1;
        } else if ("even".equals(str)) {
            this.a = 2;
        } else {
            int n = str.indexOf(110);
            if (n != -1) {
                this.a = n == 0 ? 1 : (n == 1 && str.charAt(0) == '-' ? -1 : Integer.parseInt(str.substring(0, n)));
                if (n + 1 != str.length()) {
                    this.b = Integer.parseInt(str.substring(n + 1, str.length()));
                }
            } else {
                this.b = Integer.parseInt(str);
            }
        }
    }
}

