/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.DataRowKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnKind;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.impl.DataRowImplKt;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\n\bf\u0018\u0000 ;*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0001;J\u0014\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u0004H\u0016J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H&J\u0014\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u0004H\u0016J\u0013\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u00a6\u0002J\u0013\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u00a6\u0002J0\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\r\u001a\u00020\f2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000f\"\u00020\fH\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J)\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0011\"\u0004\b\u0001\u0010\u00122\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u00140\u0011H\u0096\u0002J\"\u0010\b\u001a\u0002H\u0012\"\u0004\b\u0001\u0010\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016H\u0096\u0002\u00a2\u0006\u0002\u0010\u0017JH\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\r\u001a\n\u0012\u0002\b\u00030\u0014j\u0002`\u00182\"\u0010\u000e\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u00030\u0014j\u0002`\u00180\u000f\"\n\u0012\u0002\b\u00030\u0014j\u0002`\u0018H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J^\u0010\b\u001a\u0002H\u0012\"\u0004\b\u0001\u0010\u00122H\u0010\u001a\u001aD\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\f\b\u001c\u0012\b\b\u000b\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u0002H\u00120\u001bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u0012`\u001e\u00a2\u0006\u0002\b\u001fH\u0096\u0002\u00a2\u0006\u0002\u0010 J\u0013\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\"H\u0096\u0002J\"\u0010\b\u001a\u0002H\u0012\"\u0004\b\u0001\u0010\u00122\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014H\u00a6\u0002\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\n\u0012\u0002\b\u00030\u0000j\u0002`&2\u0006\u0010'\u001a\u00020\fH\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH&J#\u0010)\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0001\u0010\u00122\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014H&\u00a2\u0006\u0002\u0010$J\b\u0010*\u001a\u00020\nH&J\u0010\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0011H&J0\u0010,\u001a\u00020\n\"\u000e\b\u0001\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120-*\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\u000e\u001a\u0002H\u0012H\u0096\u0002\u00a2\u0006\u0002\u0010.J\u001b\u0010/\u001a\u000200*\b\u0012\u0004\u0012\u0002000\u00142\u0006\u00101\u001a\u000200H\u0096\u0002J\u001b\u0010/\u001a\u000200*\b\u0012\u0004\u0012\u0002000\u00142\u0006\u00101\u001a\u00020\nH\u0096\u0002J\u001b\u0010/\u001a\u000200*\b\u0012\u0004\u0012\u0002000\u00142\u0006\u00101\u001a\u000202H\u0096\u0002J\u001b\u0010/\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u00101\u001a\u00020\nH\u0096\u0002J\u001b\u0010/\u001a\u000202*\b\u0012\u0004\u0012\u0002020\u00142\u0006\u00101\u001a\u00020\nH\u0096\u0002J\u001b\u0010/\u001a\u000202*\b\u0012\u0004\u0012\u0002020\u00142\u0006\u00101\u001a\u000202H\u0096\u0002J&\u0010\b\u001a\u00020\"*\u00020\f2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000f\"\u00020\fH\u0096\u0002\u00a2\u0006\u0002\u00103J\u0018\u00104\u001a\u0002H\u0012\"\u0004\b\u0001\u0010\u0012*\u00020\fH\u0096\u0002\u00a2\u0006\u0002\u00105J\u0018\u00104\u001a\u0002H\u0012\"\u0004\b\u0001\u0010\u0012*\u00020\"H\u0096\u0002\u00a2\u0006\u0002\u00106J\u001e\u00104\u001a\u0002H\u0012\"\u0004\b\u0001\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u0014H\u0096\u0002\u00a2\u0006\u0002\u0010$J\u001b\u00107\u001a\u000200*\u0002002\f\u00108\u001a\b\u0012\u0004\u0012\u0002000\u0014H\u0096\u0002J\u001b\u00107\u001a\u00020\n*\u00020\n2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0096\u0002J\u001b\u00107\u001a\u000202*\u0002022\f\u00108\u001a\b\u0012\u0004\u0012\u0002020\u0014H\u0096\u0002J\u001b\u00107\u001a\u000200*\b\u0012\u0004\u0012\u0002000\u00142\u0006\u00101\u001a\u000200H\u0096\u0002J\u001b\u00107\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u00101\u001a\u00020\nH\u0096\u0002J\u001b\u00107\u001a\u000202*\b\u0012\u0004\u0012\u0002020\u00142\u0006\u00101\u001a\u000202H\u0096\u0002J\u001b\u00109\u001a\u000200*\u0002002\f\u00108\u001a\b\u0012\u0004\u0012\u0002000\u0014H\u0096\u0002J\u001b\u00109\u001a\u00020\n*\u00020\n2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0096\u0002J\u001b\u00109\u001a\u000202*\u0002022\f\u00108\u001a\b\u0012\u0004\u0012\u0002020\u0014H\u0096\u0002J\u001b\u00109\u001a\u000200*\b\u0012\u0004\u0012\u0002000\u00142\u0006\u00101\u001a\u000200H\u0096\u0002J\u001b\u00109\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u00101\u001a\u00020\nH\u0096\u0002J\u001b\u00109\u001a\u000202*\b\u0012\u0004\u0012\u0002020\u00142\u0006\u00101\u001a\u000202H\u0096\u0002J\u001b\u00109\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u00101\u001a\u00020\fH\u0096\u0002J\u001b\u0010:\u001a\u000200*\b\u0012\u0004\u0012\u0002000\u00142\u0006\u00101\u001a\u000200H\u0096\u0002J\u001b\u0010:\u001a\u000200*\b\u0012\u0004\u0012\u0002000\u00142\u0006\u00101\u001a\u00020\nH\u0096\u0002J\u001b\u0010:\u001a\u000200*\b\u0012\u0004\u0012\u0002000\u00142\u0006\u00101\u001a\u000202H\u0096\u0002J\u001b\u0010:\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u00101\u001a\u00020\nH\u0096\u0002J\u001b\u0010:\u001a\u000202*\b\u0012\u0004\u0012\u0002020\u00142\u0006\u00101\u001a\u00020\nH\u0096\u0002J\u001b\u0010:\u001a\u000202*\b\u0012\u0004\u0012\u0002020\u00142\u0006\u00101\u001a\u000202H\u0096\u0002\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlinx/dataframe/DataRow;", "T", "", "backwardIterable", "", "df", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "forwardIterable", "get", "columnIndex", "", "name", "", "first", "other", "", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/kotlinx/dataframe/DataRow;", "", "R", "columns", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "property", "Lkotlin/reflect/KProperty;", "(Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "Lorg/jetbrains/kotlinx/dataframe/AnyColumnReference;", "(Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;[Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;)Lorg/jetbrains/kotlinx/dataframe/DataRow;", "expression", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "it", "Lorg/jetbrains/kotlinx/dataframe/RowExpression;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "path", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "column", "(Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;)Ljava/lang/Object;", "getColumnGroup", "Lorg/jetbrains/kotlinx/dataframe/AnyRow;", "columnName", "getOrNull", "getValueOrNull", "index", "values", "compareTo", "", "(Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;Ljava/lang/Comparable;)I", "div", "", "a", "", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "invoke", "(Ljava/lang/String;)Ljava/lang/Object;", "(Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;)Ljava/lang/Object;", "minus", "col", "plus", "times", "Companion", "core"})
public interface DataRow<T> {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlinx.dataframe.DataRow$Companion.$$INSTANCE;

    public int index();

    @NotNull
    public DataFrame<T> df();

    @Nullable
    public Object get(int var1);

    public <R> R get(@NotNull Function2<? super DataRow<? extends T>, ? super DataRow<? extends T>, ? extends R> var1);

    public <R> R get(@NotNull ColumnReference<? extends R> var1);

    @NotNull
    public <R> List<R> get(@NotNull List<? extends ColumnReference<? extends R>> var1);

    public <R> R get(@NotNull KProperty<? extends R> var1);

    @NotNull
    public DataRow<T> get(@NotNull ColumnReference<?> var1, ColumnReference<?> ... var2);

    @NotNull
    public DataRow<T> get(@NotNull String var1, String ... var2);

    @Nullable
    public Object get(@NotNull ColumnPath var1);

    @Nullable
    public Object get(@NotNull String var1);

    @NotNull
    public DataRow<?> getColumnGroup(@NotNull String var1);

    @Nullable
    public Object getOrNull(@NotNull String var1);

    @Nullable
    public <R> R getValueOrNull(@NotNull ColumnReference<? extends R> var1);

    @NotNull
    public List<Object> values();

    @NotNull
    public ColumnPath get(@NotNull String var1, String ... var2);

    public <R> R invoke(@NotNull ColumnReference<? extends R> var1);

    public <R> R invoke(@NotNull String var1);

    public <R> R invoke(@NotNull ColumnPath var1);

    @NotNull
    public Iterable<DataRow<T>> forwardIterable();

    @NotNull
    public Iterable<DataRow<T>> backwardIterable();

    public <R extends Comparable<? super R>> int compareTo(@NotNull ColumnReference<? extends R> var1, @NotNull R var2);

    public int plus(@NotNull ColumnReference<Integer> var1, int var2);

    public long plus(@NotNull ColumnReference<Long> var1, long var2);

    public double plus(@NotNull ColumnReference<Double> var1, double var2);

    @NotNull
    public String plus(@NotNull ColumnReference<String> var1, @NotNull String var2);

    public int plus(int var1, @NotNull ColumnReference<Integer> var2);

    public long plus(long var1, @NotNull ColumnReference<Long> var3);

    public double plus(double var1, @NotNull ColumnReference<Double> var3);

    public int minus(@NotNull ColumnReference<Integer> var1, int var2);

    public long minus(@NotNull ColumnReference<Long> var1, long var2);

    public double minus(@NotNull ColumnReference<Double> var1, double var2);

    public int minus(int var1, @NotNull ColumnReference<Integer> var2);

    public long minus(long var1, @NotNull ColumnReference<Long> var3);

    public double minus(double var1, @NotNull ColumnReference<Double> var3);

    public int times(@NotNull ColumnReference<Integer> var1, int var2);

    public long times(@NotNull ColumnReference<Long> var1, long var2);

    public double times(@NotNull ColumnReference<Double> var1, double var2);

    public double times(@NotNull ColumnReference<Double> var1, int var2);

    public long times(@NotNull ColumnReference<Long> var1, int var2);

    public double times(@NotNull ColumnReference<Double> var1, long var2);

    public int div(@NotNull ColumnReference<Integer> var1, int var2);

    public long div(@NotNull ColumnReference<Long> var1, long var2);

    public double div(@NotNull ColumnReference<Double> var1, double var2);

    public double div(@NotNull ColumnReference<Double> var1, int var2);

    public long div(@NotNull ColumnReference<Long> var1, int var2);

    public double div(@NotNull ColumnReference<Double> var1, long var2);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n\u0012\u0002\b\u00030\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlinx/dataframe/DataRow$Companion;", "", "()V", "empty", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lorg/jetbrains/kotlinx/dataframe/AnyRow;", "getEmpty", "()Lorg/jetbrains/kotlinx/dataframe/DataRow;", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final DataRow<?> empty;

        private Companion() {
        }

        @NotNull
        public final DataRow<?> getEmpty() {
            return empty;
        }

        static {
            $$INSTANCE = new Companion();
            empty = DataFrame.Companion.empty(1).get(0);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nDataRow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataRow.kt\norg/jetbrains/kotlinx/dataframe/DataRow$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1549#2:102\n1620#2,3:103\n*S KotlinDebug\n*F\n+ 1 DataRow.kt\norg/jetbrains/kotlinx/dataframe/DataRow$DefaultImpls\n*L\n29#1:102\n29#1:103,3\n*E\n"})
    public static final class DefaultImpls {
        public static <T, R> R get(@NotNull DataRow<? extends T> $this, @NotNull Function2<? super DataRow<? extends T>, ? super DataRow<? extends T>, ? extends R> expression) {
            Intrinsics.checkNotNullParameter(expression, (String)"expression");
            return (R)expression.invoke($this, $this);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static <T, R> List<R> get(@NotNull DataRow<? extends T> $this, @NotNull List<? extends ColumnReference<? extends R>> columns2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(columns2, (String)"columns");
            Iterable $this$map$iv = columns2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ColumnReference columnReference = (ColumnReference)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add($this.get(it));
            }
            return (List)destination$iv$iv;
        }

        public static <T, R> R get(@NotNull DataRow<? extends T> $this, @NotNull KProperty<? extends R> property) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            return (R)$this.get(UtilsKt.getColumnName(property));
        }

        @NotNull
        public static <T> DataRow<T> get(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<?> first2, ColumnReference<?> ... other) {
            Intrinsics.checkNotNullParameter(first2, (String)"first");
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return DataFrameKt.get(DataRowImplKt.getOwner($this), first2, Arrays.copyOf(other, other.length)).get(DataRowKt.getIndex($this));
        }

        @NotNull
        public static <T> DataRow<T> get(@NotNull DataRow<? extends T> $this, @NotNull String first2, String ... other) {
            Intrinsics.checkNotNullParameter((Object)first2, (String)"first");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return DataFrameKt.get(DataRowImplKt.getOwner($this), first2, Arrays.copyOf(other, other.length)).get(DataRowKt.getIndex($this));
        }

        @Nullable
        public static <T> Object get(@NotNull DataRow<? extends T> $this, @NotNull ColumnPath path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return DataRowImplKt.getOwner($this).get(path).get(DataRowKt.getIndex($this));
        }

        @NotNull
        public static <T> DataRow<?> getColumnGroup(@NotNull DataRow<? extends T> $this, @NotNull String columnName) {
            ColumnKind kind;
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            Object value = $this.get(columnName);
            if (value == null && (kind = $this.df().get(columnName).kind()) != ColumnKind.Group) {
                throw new IllegalStateException(("Cannot cast null value of a " + (Object)((Object)kind) + " to a " + Reflection.getOrCreateKotlinClass(DataRow.class)).toString());
            }
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.DataRow<*>{ org.jetbrains.kotlinx.dataframe.AliasesKt.AnyRow }");
            return (DataRow)value;
        }

        @NotNull
        public static <T> ColumnPath get(@NotNull DataRow<? extends T> $this, @NotNull String $receiver, String ... path) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new ColumnPath(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)$receiver), (Object[])path));
        }

        public static <T, R> R invoke(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<? extends R> $receiver) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return $this.get($receiver);
        }

        public static <T, R> R invoke(@NotNull DataRow<? extends T> $this, @NotNull String $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return (R)$this.get($receiver);
        }

        public static <T, R> R invoke(@NotNull DataRow<? extends T> $this, @NotNull ColumnPath $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return (R)$this.get($receiver);
        }

        @NotNull
        public static <T> Iterable<DataRow<T>> forwardIterable(@NotNull DataRow<? extends T> $this) {
            return UtilsKt.toIterable($this, forwardIterable.1.INSTANCE);
        }

        @NotNull
        public static <T> Iterable<DataRow<T>> backwardIterable(@NotNull DataRow<? extends T> $this) {
            return UtilsKt.toIterable($this, backwardIterable.1.INSTANCE);
        }

        public static <T, R extends Comparable<? super R>> int compareTo(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<? extends R> $receiver, @NotNull R other) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return ((Comparable)$this.get($receiver)).compareTo(other);
        }

        public static <T> int plus(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Integer> $receiver, int a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).intValue() + a;
        }

        public static <T> long plus(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Long> $receiver, long a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).longValue() + a;
        }

        public static <T> double plus(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Double> $receiver, double a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).doubleValue() + a;
        }

        @NotNull
        public static <T> String plus(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<String> $receiver, @NotNull String a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return $this.get($receiver) + a;
        }

        public static <T> int plus(@NotNull DataRow<? extends T> $this, int $receiver, @NotNull ColumnReference<Integer> col2) {
            Intrinsics.checkNotNullParameter(col2, (String)"col");
            return $receiver + ((Number)$this.get(col2)).intValue();
        }

        public static <T> long plus(@NotNull DataRow<? extends T> $this, long $receiver, @NotNull ColumnReference<Long> col2) {
            Intrinsics.checkNotNullParameter(col2, (String)"col");
            return $receiver + ((Number)$this.get(col2)).longValue();
        }

        public static <T> double plus(@NotNull DataRow<? extends T> $this, double $receiver, @NotNull ColumnReference<Double> col2) {
            Intrinsics.checkNotNullParameter(col2, (String)"col");
            return $receiver + ((Number)$this.get(col2)).doubleValue();
        }

        public static <T> int minus(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Integer> $receiver, int a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).intValue() - a;
        }

        public static <T> long minus(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Long> $receiver, long a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).longValue() - a;
        }

        public static <T> double minus(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Double> $receiver, double a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).doubleValue() - a;
        }

        public static <T> int minus(@NotNull DataRow<? extends T> $this, int $receiver, @NotNull ColumnReference<Integer> col2) {
            Intrinsics.checkNotNullParameter(col2, (String)"col");
            return $receiver - ((Number)$this.get(col2)).intValue();
        }

        public static <T> long minus(@NotNull DataRow<? extends T> $this, long $receiver, @NotNull ColumnReference<Long> col2) {
            Intrinsics.checkNotNullParameter(col2, (String)"col");
            return $receiver - ((Number)$this.get(col2)).longValue();
        }

        public static <T> double minus(@NotNull DataRow<? extends T> $this, double $receiver, @NotNull ColumnReference<Double> col2) {
            Intrinsics.checkNotNullParameter(col2, (String)"col");
            return $receiver - ((Number)$this.get(col2)).doubleValue();
        }

        public static <T> int times(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Integer> $receiver, int a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).intValue() * a;
        }

        public static <T> long times(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Long> $receiver, long a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).longValue() * a;
        }

        public static <T> double times(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Double> $receiver, double a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).doubleValue() * a;
        }

        public static <T> double times(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Double> $receiver, int a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).doubleValue() * (double)a;
        }

        public static <T> long times(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Long> $receiver, int a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).longValue() * (long)a;
        }

        public static <T> double times(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Double> $receiver, long a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).doubleValue() * (double)a;
        }

        public static <T> int div(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Integer> $receiver, int a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).intValue() / a;
        }

        public static <T> long div(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Long> $receiver, long a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).longValue() / a;
        }

        public static <T> double div(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Double> $receiver, double a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).doubleValue() / a;
        }

        public static <T> double div(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Double> $receiver, int a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).doubleValue() / (double)a;
        }

        public static <T> long div(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Long> $receiver, int a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).longValue() / (long)a;
        }

        public static <T> double div(@NotNull DataRow<? extends T> $this, @NotNull ColumnReference<Double> $receiver, long a) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return ((Number)$this.get($receiver)).doubleValue() / (double)a;
        }
    }
}

