/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.backend;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/recentFiles/backend/StopOnTwoSameNamesProcessor;", "Lcom/intellij/util/Processor;", "Lcom/intellij/openapi/vfs/VirtualFile;", "searchedName", "", "<init>", "(Ljava/lang/String;)V", "fileNameCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "areThereMoreThanOneFile", "", "process", "file", "intellij.platform.recentFiles.backend"})
final class StopOnTwoSameNamesProcessor
implements Processor<VirtualFile> {
    @NotNull
    private final String searchedName;
    @NotNull
    private AtomicInteger fileNameCounter;

    public StopOnTwoSameNamesProcessor(@NotNull String searchedName) {
        Intrinsics.checkNotNullParameter((Object)searchedName, (String)"searchedName");
        this.searchedName = searchedName;
        this.fileNameCounter = new AtomicInteger(0);
    }

    public final boolean areThereMoreThanOneFile() {
        return this.fileNameCounter.get() > 1;
    }

    public boolean process(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        if (!Intrinsics.areEqual((Object)this.searchedName, (Object)name)) {
            return true;
        }
        int newCount = this.fileNameCounter.incrementAndGet();
        return newCount <= 1;
    }
}

