/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.PathMappingProvider;
import com.intellij.remote.RemoteMappingsManager;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.PathMappingSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MappingsGatherer {
    @NotNull
    private final Project myProject;
    @NotNull
    private final RemoteSdkAdditionalData mySdkData;
    private final RemoteMappingsManager.Mappings myRemoteMappings;
    private boolean myAddUserDefined;
    private boolean myAddDisabled;

    public MappingsGatherer(@NotNull Project project, @NotNull RemoteSdkAdditionalData sdkData, @NotNull String prefix) {
        if (project == null) {
            MappingsGatherer.$$$reportNull$$$0(0);
        }
        if (sdkData == null) {
            MappingsGatherer.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            MappingsGatherer.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.mySdkData = sdkData;
        this.myRemoteMappings = RemoteMappingsManager.getInstance((Project)project).getForServer(prefix, sdkData.connectionCredentials().getId());
    }

    public MappingsGatherer addUserDefined(boolean value) {
        this.myAddUserDefined = value;
        return this;
    }

    public MappingsGatherer addDisabled(boolean value) {
        this.myAddDisabled = value;
        return this;
    }

    public List<PathMappingSettings.PathMapping> assemble() {
        HashMap<String, PathMappingSettings.PathMapping> map = new HashMap<String, PathMappingSettings.PathMapping>();
        for (PathMappingProvider mappingProvider : PathMappingProvider.getSuitableMappingProviders((RemoteSdkAdditionalData)this.mySdkData)) {
            PathMappingSettings providerSettings = mappingProvider.getPathMappingSettings(this.myProject, this.mySdkData);
            List mappings = providerSettings.getPathMappings();
            for (PathMappingSettings.PathMapping mapping : mappings) {
                if (!this.myAddDisabled && this.myRemoteMappings != null && Objects.equals(mapping.getRemoteRoot(), this.myRemoteMappings.getDisabled().get(mapping.getLocalRoot()))) continue;
                map.put(FileUtil.toSystemIndependentName((String)mapping.getLocalRoot()), mapping);
            }
        }
        if (this.myAddUserDefined && this.myRemoteMappings != null) {
            List settings = this.myRemoteMappings.getSettings();
            for (PathMappingSettings.PathMapping setting : settings) {
                map.put(FileUtil.toSystemIndependentName((String)setting.getLocalRoot()), setting);
            }
        }
        return new ArrayList<PathMappingSettings.PathMapping>(map.values());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sdkData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "prefix";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/plugins/remotesdk/ui/MappingsGatherer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

