/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.commandInterfaceConsole;

import com.intellij.commandInterface.commandLine.CommandLineLanguage;
import com.intellij.commandInterface.commandLine.psi.CommandLineFile;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.django.commandInterfaceConsole.CommandModeConsumer;
import com.intellij.python.django.commandInterfaceConsole.CommandsInfo;
import com.intellij.python.django.commandInterfaceConsole.ConsoleWithProcess;
import com.intellij.python.django.commandInterfaceConsole.ProcessModeConsumer;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Consumer;
import com.jetbrains.python.PythonPluginDisposable;
import com.jetbrains.python.psi.PyUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.border.MatteBorder;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CommandConsole
extends LanguageConsoleImpl
implements Consumer<String>,
Condition<LanguageConsoleView>,
ConsoleWithProcess {
    static final int BORDER_SIZE_PX = 3;
    @Nullable
    private final CommandsInfo myCommandsInfo;
    @NotNull
    private final Module myModule;
    @Nullable
    private Consumer<? super String> myCurrentConsumer;
    @NotNull
    private final Object myConsumerSemaphore;
    @NotNull
    private final Collection<Runnable> myStateChangeListeners;
    @Nullable
    private volatile ProcessHandler myProcessHandler;

    private CommandConsole(@NotNull Module module, @NotNull String title, @Nullable CommandsInfo commandsInfo) {
        if (module == null) {
            CommandConsole.$$$reportNull$$$0(0);
        }
        if (title == null) {
            CommandConsole.$$$reportNull$$$0(1);
        }
        super(new LanguageConsoleImpl.Helper(module.getProject(), (VirtualFile)new LightVirtualFile(title, (Language)CommandLineLanguage.INSTANCE, (CharSequence)"")){

            public void setupEditor(@NotNull EditorEx editor) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.setupEditor(editor);
                EditorSettings editorSettings = editor.getSettings();
                editorSettings.setAdditionalLinesCount(0);
                editorSettings.setAdditionalColumnsCount(0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/python/django/commandInterfaceConsole/CommandConsole$1", "setupEditor"));
            }
        });
        this.myConsumerSemaphore = new Object();
        this.myStateChangeListeners = new ArrayList<Runnable>();
        this.myCommandsInfo = commandsInfo;
        this.myModule = module;
    }

    public void requestFocus() {
        super.getPreferredFocusableComponent().requestFocus();
    }

    public void setInputText(@NotNull String query) {
        if (query == null) {
            CommandConsole.$$$reportNull$$$0(2);
        }
        super.setInputText(query);
        this.getConsoleEditor().getCaretModel().moveToOffset(query.length());
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        Function1<String, String> outputFilter;
        if (text == null) {
            CommandConsole.$$$reportNull$$$0(3);
        }
        if (contentType == null) {
            CommandConsole.$$$reportNull$$$0(4);
        }
        if (this.myCommandsInfo != null && (outputFilter = this.myCommandsInfo.getOutputFilter()) != null) {
            text = (String)outputFilter.invoke((Object)text);
        }
        super.print(text, contentType);
    }

    @NotNull
    static CommandConsole createConsole(@NotNull Module module, @Nls @NotNull String title, @Nullable CommandsInfo commandsInfo) {
        if (module == null) {
            CommandConsole.$$$reportNull$$$0(5);
        }
        if (title == null) {
            CommandConsole.$$$reportNull$$$0(6);
        }
        CommandConsole console = new CommandConsole(module, title, commandsInfo);
        console.setEditable(true);
        LanguageConsoleBuilder.registerExecuteAction((LanguageConsoleView)console, (Consumer)console, (String)title, (String)title, (Condition)console);
        console.switchToCommandMode();
        console.getComponent();
        console.getConsoleEditor().getSettings().setAdditionalLinesCount(2);
        Disposer.register((Disposable)PythonPluginDisposable.getInstance((Project)module.getProject()), (Disposable)console);
        console.addMessageFilter((Filter)new UrlFilter());
        CommandConsole commandConsole = console;
        if (commandConsole == null) {
            CommandConsole.$$$reportNull$$$0(7);
        }
        return commandConsole;
    }

    private static void configureLeftBorder(boolean enable, EditorEx ... editors) {
        if (editors == null) {
            CommandConsole.$$$reportNull$$$0(8);
        }
        for (EditorEx editor : editors) {
            Color backgroundColor = editor.getBackgroundColor();
            int thickness = enable ? 3 : 0;
            MatteBorder border = BorderFactory.createMatteBorder(0, thickness, 0, 0, backgroundColor);
            editor.getComponent().setBorder(border);
        }
    }

    public void attachToProcess(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            CommandConsole.$$$reportNull$$$0(9);
        }
        super.attachToProcess(processHandler);
        processHandler.addProcessListener((ProcessListener)new MyProcessListener());
    }

    private void switchToCommandMode() {
        this.myProcessHandler = null;
        this.setPrompt(this.getTitle() + " > ");
        ApplicationManager.getApplication().invokeAndWait(() -> {
            this.notifyStateChangeListeners();
            CommandConsole.configureLeftBorder(true, this.getConsoleEditor(), this.getHistoryViewer());
            this.setLanguage((Language)CommandLineLanguage.INSTANCE);
            CommandLineFile file = (CommandLineFile)PyUtil.as((Object)this.getFile(), CommandLineFile.class);
            this.resetConsumer(null);
            if (file == null || this.myCommandsInfo == null) {
                return;
            }
            file.setCommands(this.myCommandsInfo.getCommands());
            CommandConsole console = this;
            this.resetConsumer(new CommandModeConsumer(this.myCommandsInfo.getCommands(), this.myModule, console, this.myCommandsInfo.getUnknownCommandsExecutor()));
        }, ModalityState.nonModal());
    }

    private void switchToProcessMode(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            CommandConsole.$$$reportNull$$$0(10);
        }
        this.myProcessHandler = processHandler;
        ApplicationManager.getApplication().invokeAndWait(() -> {
            CommandConsole.configureLeftBorder(false, this.getConsoleEditor());
            this.notifyStateChangeListeners();
            this.resetConsumer(new ProcessModeConsumer(processHandler));
            this.setLanguage((Language)PlainTextLanguage.INSTANCE);
            this.setPrompt("");
        }, ModalityState.nonModal());
    }

    private void notifyStateChangeListeners() {
        for (Runnable listener : this.myStateChangeListeners) {
            listener.run();
        }
    }

    @Override
    @Nullable
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetConsumer(@Nullable Consumer<? super String> newConsumer) {
        Object object = this.myConsumerSemaphore;
        synchronized (object) {
            this.myCurrentConsumer = newConsumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean value(LanguageConsoleView t) {
        Object object = this.myConsumerSemaphore;
        synchronized (object) {
            return this.myCurrentConsumer != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(String t) {
        Object object = this.myConsumerSemaphore;
        synchronized (object) {
            if (this.myCurrentConsumer != null) {
                this.myCurrentConsumer.consume((Object)t);
            }
        }
    }

    void addStateChangeListener(@NotNull Runnable listener) {
        if (listener == null) {
            CommandConsole.$$$reportNull$$$0(11);
        }
        this.myStateChangeListeners.add(listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/commandInterfaceConsole/CommandConsole";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/commandInterfaceConsole/CommandConsole";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setInputText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureLeftBorder";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "switchToProcessMode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addStateChangeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    private final class MyProcessListener
    extends ProcessAdapter {
        private MyProcessListener() {
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                MyProcessListener.$$$reportNull$$$0(0);
            }
            super.processTerminated(event);
            CommandConsole.this.switchToCommandMode();
        }

        public void startNotified(@NotNull ProcessEvent event) {
            if (event == null) {
                MyProcessListener.$$$reportNull$$$0(1);
            }
            super.startNotified(event);
            CommandConsole.this.switchToProcessMode(event.getProcessHandler());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/python/django/commandInterfaceConsole/CommandConsole$MyProcessListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startNotified";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

