/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.net.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs2.provider.ftp.FtpFileType;
import org.apache.commons.vfs2.provider.ftp.JBFtpKeepAliveCommand;

public class FtpFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final String PREFIX = FtpFileSystemConfigBuilder.class.getName();
    private static final FtpFileSystemConfigBuilder BUILDER = new FtpFileSystemConfigBuilder();
    private static final String AUTODETECT_UTF8 = PREFIX + ".AUTODETECT_UTF8";
    private static final String CONNECT_TIMEOUT = PREFIX + ".CONNECT_TIMEOUT";
    private static final String DATA_TIMEOUT = PREFIX + ".DATA_TIMEOUT";
    private static final String DEFAULT_DATE_FORMAT = PREFIX + ".DEFAULT_DATE_FORMAT";
    private static final String ENCODING = PREFIX + ".ENCODING";
    private static final String FACTORY_KEY = FTPFileEntryParserFactory.class.getName() + ".KEY";
    private static final String FILE_TYPE = PREFIX + ".FILE_TYPE";
    private static final String PASSIVE_MODE = PREFIX + ".PASSIVE";
    private static final String PROXY = PREFIX + ".PROXY";
    private static final String RECENT_DATE_FORMAT = PREFIX + ".RECENT_DATE_FORMAT";
    private static final String REMOTE_VERIFICATION = PREFIX + ".REMOTE_VERIFICATION";
    private static final String SERVER_LANGUAGE_CODE = PREFIX + ".SERVER_LANGUAGE_CODE";
    private static final String SERVER_TIME_ZONE_ID = PREFIX + ".SERVER_TIME_ZONE_ID";
    private static final String SHORT_MONTH_NAMES = PREFIX + ".SHORT_MONTH_NAMES";
    private static final String SO_TIMEOUT = PREFIX + ".SO_TIMEOUT";
    private static final String USER_DIR_IS_ROOT = PREFIX + ".USER_DIR_IS_ROOT";
    private static final String TRANSFER_ABORTED_OK_REPLY_CODES = PREFIX + ".TRANSFER_ABORTED_OK_REPLY_CODES";
    private static final String CONTROL_KEEP_ALIVE_TIMEOUT = PREFIX + ".CONTROL_KEEP_ALIVE_TIMEOUT";
    private static final String CONTROL_KEEP_ALIVE_REPLY_TIMEOUT = PREFIX + ".CONTROL_KEEP_ALIVE_REPLY_TIMEOUT";
    private static final String MDTM_LAST_MODIFED_TIME = PREFIX + ".MDTM_LAST_MODIFED_TIME";
    private static final String SHOW_HIDDEN_FILES = PREFIX + ".SHOW_HIDDEN_FILES";
    private static final String HOME_FOLDER_OVERRIDE = PREFIX + ".HOME_FOLDER_OVERRIDE";
    private static final String COMPATIBLE_MODE = PREFIX + ".COMPATIBLE_MODE";
    private static final String SOCKET_FACTORY = PREFIX + ".SOCKET_FACTORY";
    private static final String SERVER_SOCKET_FACTORY = PREFIX + ".SERVER_SOCKET_FACTORY";
    private static final String FORCE_LIST_COMMAND = PREFIX + ".FORCE_LIST_COMMAND";
    private static final String KEEP_ALIVE_COMMAND = PREFIX + ".KEEP_ALIVE_COMMAND";
    private static final String NUMBER_OF_CONNECTIONS = PREFIX + ".CONNECTIONS_IN_POOL";
    private static final String PROTOCOL_COMMAND_LISTENER = PREFIX + ".PROTOCOL_COMMAND_LISTENER";

    private FtpFileSystemConfigBuilder() {
        super("ftp.");
    }

    protected FtpFileSystemConfigBuilder(String prefix) {
        super(prefix);
    }

    public static FtpFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return FtpFileSystem.class;
    }

    public static List<Integer> getSaneTransferAbortedOkReplyCodes() {
        return new ArrayList<Integer>(Arrays.asList(426, 550));
    }

    public List<Integer> getTransferAbortedOkReplyCodes(FileSystemOptions options) {
        return (List)this.getParam(options, TRANSFER_ABORTED_OK_REPLY_CODES);
    }

    public void setTransferAbortedOkReplyCodes(FileSystemOptions options, List<Integer> replyCodes) {
        this.setParam(options, TRANSFER_ABORTED_OK_REPLY_CODES, replyCodes);
    }

    @Deprecated
    public Integer getConnectTimeout(FileSystemOptions options) {
        return this.getDurationInteger(options, CONNECT_TIMEOUT);
    }

    public Duration getConnectTimeoutDuration(FileSystemOptions options) {
        return this.getDuration(options, CONNECT_TIMEOUT);
    }

    public void setConnectTimeout(FileSystemOptions options, Duration duration) {
        this.setParam(options, CONNECT_TIMEOUT, duration);
    }

    @Deprecated
    public void setConnectTimeout(FileSystemOptions options, Integer duration) {
        this.setConnectTimeout(options, Duration.ofMillis(duration.intValue()));
    }

    @Deprecated
    public Integer getDataTimeout(FileSystemOptions options) {
        return this.getDurationInteger(options, DATA_TIMEOUT);
    }

    public Duration getDataTimeoutDuration(FileSystemOptions options) {
        return this.getDuration(options, DATA_TIMEOUT);
    }

    public void setDataTimeout(FileSystemOptions options, Duration duration) {
        this.setParam(options, DATA_TIMEOUT, duration);
    }

    @Deprecated
    public void setDataTimeout(FileSystemOptions options, Integer duration) {
        this.setDataTimeout(options, Duration.ofMillis(duration.intValue()));
    }

    @Deprecated
    public Integer getSoTimeout(FileSystemOptions options) {
        return this.getDurationInteger(options, SO_TIMEOUT);
    }

    public Duration getSoTimeoutDuration(FileSystemOptions options) {
        return this.getDuration(options, SO_TIMEOUT);
    }

    public void setSoTimeout(FileSystemOptions options, Duration timeout) {
        this.setParam(options, SO_TIMEOUT, timeout);
    }

    @Deprecated
    public void setSoTimeout(FileSystemOptions options, Integer timeout) {
        this.setSoTimeout(options, Duration.ofMillis(timeout.intValue()));
    }

    public Boolean getAutodetectUTF8(FileSystemOptions options) {
        return this.getBoolean(options, AUTODETECT_UTF8);
    }

    public void setAutodetectUTF8(FileSystemOptions options, Boolean autodetectUTF8) {
        this.setParam(options, AUTODETECT_UTF8, autodetectUTF8);
    }

    public String getControlEncoding(FileSystemOptions options) {
        return this.getString(options, ENCODING);
    }

    public String getDefaultDateFormat(FileSystemOptions options) {
        return this.getString(options, DEFAULT_DATE_FORMAT);
    }

    public String getEntryParser(FileSystemOptions options) {
        return this.getString(options, FACTORY_KEY);
    }

    public FTPFileEntryParserFactory getEntryParserFactory(FileSystemOptions options) {
        return (FTPFileEntryParserFactory)this.getParam(options, FTPFileEntryParserFactory.class.getName());
    }

    public FtpFileType getFileType(FileSystemOptions options) {
        return this.getEnum(FtpFileType.class, options, FILE_TYPE);
    }

    public Boolean getPassiveMode(FileSystemOptions options) {
        return this.getBoolean(options, PASSIVE_MODE);
    }

    public Proxy getProxy(FileSystemOptions options) {
        return (Proxy)this.getParam(options, PROXY);
    }

    public String getRecentDateFormat(FileSystemOptions options) {
        return this.getString(options, RECENT_DATE_FORMAT);
    }

    public Boolean getRemoteVerification(FileSystemOptions options) {
        return this.getBoolean(options, REMOTE_VERIFICATION);
    }

    public String getServerLanguageCode(FileSystemOptions options) {
        return this.getString(options, SERVER_LANGUAGE_CODE);
    }

    public String getServerTimeZoneId(FileSystemOptions options) {
        return this.getString(options, SERVER_TIME_ZONE_ID);
    }

    public String[] getShortMonthNames(FileSystemOptions options) {
        return (String[])this.getParam(options, SHORT_MONTH_NAMES);
    }

    public Boolean getUserDirIsRoot(FileSystemOptions options) {
        return this.getBoolean(options, USER_DIR_IS_ROOT, Boolean.TRUE);
    }

    public void setControlEncoding(FileSystemOptions options, String encoding) {
        this.setParam(options, ENCODING, encoding);
    }

    public void setDefaultDateFormat(FileSystemOptions options, String defaultDateFormat) {
        this.setParam(options, DEFAULT_DATE_FORMAT, defaultDateFormat);
    }

    public void setEntryParser(FileSystemOptions options, String key) {
        this.setParam(options, FACTORY_KEY, key);
    }

    public void setEntryParserFactory(FileSystemOptions options, FTPFileEntryParserFactory factory) {
        this.setParam(options, FTPFileEntryParserFactory.class.getName(), factory);
    }

    public void setFileType(FileSystemOptions options, FtpFileType ftpFileType) {
        this.setParam(options, FILE_TYPE, (Object)ftpFileType);
    }

    public void setPassiveMode(FileSystemOptions options, boolean passiveMode) {
        this.setParam(options, PASSIVE_MODE, this.toBooleanObject(passiveMode));
    }

    public void setProxy(FileSystemOptions options, Proxy proxy) {
        this.setParam(options, PROXY, proxy);
    }

    public void setRecentDateFormat(FileSystemOptions options, String recentDateFormat) {
        this.setParam(options, RECENT_DATE_FORMAT, recentDateFormat);
    }

    public void setRemoteVerification(FileSystemOptions options, boolean remoteVerification) {
        this.setParam(options, REMOTE_VERIFICATION, remoteVerification);
    }

    public void setServerLanguageCode(FileSystemOptions options, String serverLanguageCode) {
        this.setParam(options, SERVER_LANGUAGE_CODE, serverLanguageCode);
    }

    public void setServerTimeZoneId(FileSystemOptions options, String serverTimeZoneId) {
        this.setParam(options, SERVER_TIME_ZONE_ID, serverTimeZoneId);
    }

    public void setShortMonthNames(FileSystemOptions options, String[] shortMonthNames) {
        String[] clone = null;
        if (shortMonthNames != null) {
            clone = new String[shortMonthNames.length];
            System.arraycopy(shortMonthNames, 0, clone, 0, shortMonthNames.length);
        }
        this.setParam(options, SHORT_MONTH_NAMES, clone);
    }

    public void setUserDirIsRoot(FileSystemOptions options, boolean userDirIsRoot) {
        this.setParam(options, USER_DIR_IS_ROOT, this.toBooleanObject(userDirIsRoot));
    }

    public Boolean getMdtmLastModifiedTime(FileSystemOptions options) {
        return this.getBoolean(options, MDTM_LAST_MODIFED_TIME);
    }

    public void setMdtmLastModifiedTime(FileSystemOptions options, boolean mdtm) {
        this.setParam(options, MDTM_LAST_MODIFED_TIME, this.toBooleanObject(mdtm));
    }

    public boolean isShowHiddenFiles(FileSystemOptions options) {
        return this.getBoolean(options, SHOW_HIDDEN_FILES, false);
    }

    public void setShowHiddenFiles(FileSystemOptions options, boolean value) {
        this.setParam(options, SHOW_HIDDEN_FILES, (Object)value);
    }

    public String getHomeFolderOverride(FileSystemOptions options) {
        return this.getString(options, HOME_FOLDER_OVERRIDE);
    }

    public void setHomeFolderOverride(FileSystemOptions options, String value) {
        this.setParam(options, HOME_FOLDER_OVERRIDE, value);
    }

    public boolean isCompatibleMode(FileSystemOptions options) {
        return this.getBoolean(options, COMPATIBLE_MODE, false);
    }

    public void setCompatibleMode(FileSystemOptions options, boolean value) {
        this.setParam(options, COMPATIBLE_MODE, (Object)value);
    }

    public SocketFactory getSocketFactory(FileSystemOptions options) {
        return (SocketFactory)this.getParam(options, SOCKET_FACTORY);
    }

    public void setSocketFactory(FileSystemOptions options, SocketFactory value) {
        this.setParam(options, SOCKET_FACTORY, value);
    }

    public ServerSocketFactory getServerSocketFactory(FileSystemOptions options) {
        return (ServerSocketFactory)this.getParam(options, SERVER_SOCKET_FACTORY);
    }

    public void setServerSocketFactory(FileSystemOptions options, ServerSocketFactory value) {
        this.setParam(options, SERVER_SOCKET_FACTORY, value);
    }

    public boolean isForceListCommand(FileSystemOptions options) {
        return this.getBoolean(options, FORCE_LIST_COMMAND, false);
    }

    public void setForceListCommand(FileSystemOptions options, boolean value) {
        this.setParam(options, FORCE_LIST_COMMAND, (Object)value);
    }

    public JBFtpKeepAliveCommand getKeepAliveCommand(FileSystemOptions options) {
        return this.getEnum(JBFtpKeepAliveCommand.class, options, KEEP_ALIVE_COMMAND);
    }

    public void setKeepAliveCommand(FileSystemOptions options, JBFtpKeepAliveCommand value) {
        this.setParam(options, KEEP_ALIVE_COMMAND, (Object)value);
    }

    public void setConnections(FileSystemOptions options, Integer value) {
        this.setParam(options, NUMBER_OF_CONNECTIONS, value);
    }

    public Integer getConnections(FileSystemOptions options) {
        return this.getInteger(options, NUMBER_OF_CONNECTIONS);
    }

    public ProtocolCommandListener getProtocolCommandListener(FileSystemOptions options) {
        return (ProtocolCommandListener)this.getParam(options, PROTOCOL_COMMAND_LISTENER);
    }

    public void setProtocolCommandListener(FileSystemOptions options, ProtocolCommandListener value) {
        this.setParam(options, PROTOCOL_COMMAND_LISTENER, value);
    }

    public Duration getControlKeepAliveTimeout(FileSystemOptions options) {
        return this.getDuration(options, CONTROL_KEEP_ALIVE_TIMEOUT);
    }

    public Duration getControlKeepAliveReplyTimeout(FileSystemOptions options) {
        return this.getDuration(options, CONTROL_KEEP_ALIVE_REPLY_TIMEOUT);
    }

    public void setControlKeepAliveTimeout(FileSystemOptions options, Duration controlKeepAliveTimeout) {
        this.setParam(options, CONTROL_KEEP_ALIVE_TIMEOUT, controlKeepAliveTimeout);
    }

    public void setControlKeepAliveReplyTimeout(FileSystemOptions options, Duration controlKeepAliveReplyTimeout) {
        this.setParam(options, CONTROL_KEEP_ALIVE_REPLY_TIMEOUT, controlKeepAliveReplyTimeout);
    }
}

