/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.util.MemoryDumpHelper;
import com.jetbrains.performancePlugin.Timer;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class MemoryDumpCommand
extends AbstractCommand {
    public static final String PREFIX = "%memoryDump";

    public MemoryDumpCommand(@NotNull String text, int line) {
        if (text == null) {
            MemoryDumpCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Promise promise;
        if (context == null) {
            MemoryDumpCommand.$$$reportNull$$$0(1);
        }
        try {
            String path = MemoryDumpCommand.getMemoryDumpPath();
            MemoryDumpCommand.captureZippedMemoryDump(path);
            context.message("Memory snapshot is saved at " + path, this.getLine());
            promise = Promises.resolvedPromise();
        }
        catch (Exception e) {
            Promise promise2 = Promises.rejectedPromise((String)"Memory dump can't be collected");
            if (promise2 == null) {
                MemoryDumpCommand.$$$reportNull$$$0(3);
            }
            return promise2;
        }
        if (promise == null) {
            MemoryDumpCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    @NotNull
    public static String getMemoryDumpPath() {
        String memoryDumpPath = System.getProperties().getProperty("memory.snapshots.path", PathManager.getLogPath());
        String currentTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        String string = memoryDumpPath + File.separator + Timer.instance.getActivityName() + "-" + currentTime + ".zip";
        if (string == null) {
            MemoryDumpCommand.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void captureZippedMemoryDump(String dumpPath) throws Exception {
        if (!MemoryDumpHelper.memoryDumpAvailable()) {
            throw new RuntimeException("Memory dump is not available");
        }
        System.gc();
        MemoryDumpHelper.captureMemoryDumpZipped((String)dumpPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/MemoryDumpCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/MemoryDumpCommand";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemoryDumpPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

