/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentSourceType;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLabel;
import com.intellij.docker.agent.settings.DockerLink;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.agent.util.DockerUtil;
import com.intellij.docker.remote.run.runtime.UnixPathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerAgentDeploymentConfigImpl
implements DockerAgentDeploymentConfig {
    private final String[] myImageTags;
    private DockerVolumeBinding[] myVolumesBinding;
    private String[] myCommand;
    private String myWorkingDir;
    private DockerVolumesFrom[] myVolumesFrom;
    private DockerEnvVar[] myEnvVars;
    private DockerEnvVar[] myBuildArgs;
    private String myContainerName;
    private Boolean myPublishAllPorts;
    private DockerPortBinding[] myPortBindings;
    private Integer[] myExposedPorts;
    private Boolean myNetworkDisabled;
    private String myNetworkMode;
    private DockerLink[] myLinks;
    private String[] myExtraHosts;
    private String myUser;
    private String[] myEntrypoint;
    private DockerLabel[] myLabels;
    private Boolean myStdinOnce;

    public DockerAgentDeploymentConfigImpl(@NotNull String image, DockerVolumeBinding @Nullable [] volumesBinding) {
        if (image == null) {
            DockerAgentDeploymentConfigImpl.$$$reportNull$$$0(0);
        }
        this.myImageTags = new String[]{image};
        this.withVolumeBindings(volumesBinding);
    }

    @Override
    public String @NotNull [] getImageTags() {
        if (this.myImageTags == null) {
            DockerAgentDeploymentConfigImpl.$$$reportNull$$$0(1);
        }
        return this.myImageTags;
    }

    @Override
    public String getContainerName() {
        return this.myContainerName;
    }

    public DockerAgentDeploymentConfigImpl withContainerName(String containerName) {
        this.myContainerName = containerName;
        return this;
    }

    @Override
    public String sourceType() {
        return DockerAgentSourceType.IMAGE.name();
    }

    @Override
    public boolean isCreateContainerOnly() {
        return true;
    }

    @Override
    public String getUser() {
        return this.myUser;
    }

    public DockerAgentDeploymentConfigImpl withUser(String user2) {
        this.myUser = user2;
        return this;
    }

    @Override
    public DockerLabel[] getLabels() {
        return this.myLabels;
    }

    public DockerAgentDeploymentConfigImpl withLabels(DockerLabel[] labels) {
        this.myLabels = labels;
        return this;
    }

    @Override
    public DockerPortBinding[] getPortBindings() {
        return this.myPortBindings;
    }

    public DockerAgentDeploymentConfigImpl withPortBindings(DockerPortBinding[] portBindings) {
        this.myPortBindings = portBindings;
        return this;
    }

    @Override
    public Boolean getPublishAllPorts() {
        return this.myPublishAllPorts;
    }

    public DockerAgentDeploymentConfigImpl withPublishAllPorts(boolean publishAllPorts) {
        this.myPublishAllPorts = publishAllPorts;
        return this;
    }

    public DockerAgentDeploymentConfigImpl withExposedPorts(Integer[] exposedPorts) {
        this.myExposedPorts = exposedPorts;
        return this;
    }

    @Override
    public Integer[] getExposedPorts() {
        return this.myExposedPorts;
    }

    @Override
    public DockerLink[] getLinks() {
        return this.myLinks;
    }

    public DockerAgentDeploymentConfigImpl withLinks(List<? extends DockerLink> links) {
        this.myLinks = links.toArray(new DockerLink[0]);
        return this;
    }

    @Override
    public DockerVolumeBinding[] getVolumeBindings() {
        return this.myVolumesBinding;
    }

    public DockerAgentDeploymentConfigImpl withVolumeBindings(DockerVolumeBinding[] volumesBinding) {
        this.myVolumesBinding = DockerUtil.mapArray(volumesBinding, DockerVolumeBinding.class, source -> {
            DockerVolumeBindingImpl result2 = new DockerVolumeBindingImpl((DockerVolumeBinding)source);
            if (source.getHostPath() != null) {
                result2.setHostPath(UnixPathUtil.toUnixPath(source.getHostPath()));
            }
            return result2;
        });
        return this;
    }

    @Override
    public DockerEnvVar[] getEnvVars() {
        return this.myEnvVars;
    }

    @Override
    public DockerEnvVar[] getBuildArgs() {
        return this.myBuildArgs;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{imageTags=" + Arrays.toString(this.myImageTags) + ", volumesBinding=" + Arrays.toString(this.myVolumesBinding) + ", command=" + Arrays.toString(this.myCommand) + ", workingDir='" + this.myWorkingDir + "', volumesFrom=" + Arrays.toString(this.myVolumesFrom) + ", envVars=" + Arrays.toString(this.myEnvVars) + ", buildArgs=" + Arrays.toString(this.myBuildArgs) + ", containerName='" + this.myContainerName + "', publishAllPorts=" + this.myPublishAllPorts + ", portBindings=" + Arrays.toString(this.myPortBindings) + ", exposedPorts=" + Arrays.toString((Object[])this.myExposedPorts) + ", networkDisabled=" + this.myNetworkDisabled + ", networkMode='" + this.myNetworkMode + "', links=" + Arrays.toString(this.myLinks) + ", extraHosts=" + Arrays.toString(this.myExtraHosts) + ", user='" + this.myUser + "', entrypoint=" + Arrays.toString(this.myEntrypoint) + ", labels=" + Arrays.toString(this.myLabels) + ", stdinOnce=" + this.myStdinOnce + "}";
    }

    private static DockerEnvVar @NotNull [] createEnvArray(@NotNull Map<String, String> env2, boolean passParentEnvironment) {
        if (env2 == null) {
            DockerAgentDeploymentConfigImpl.$$$reportNull$$$0(2);
        }
        ArrayList<DockerEnvVarImpl> result2 = new ArrayList<DockerEnvVarImpl>();
        for (Map.Entry<String, String> entry : env2.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            String key = entry.getKey();
            if (passParentEnvironment && "PATH".equalsIgnoreCase(key)) {
                value = (String)value + ":$PATH";
            }
            DockerEnvVarImpl envVar = new DockerEnvVarImpl();
            envVar.setName(key);
            envVar.setValue((String)value);
            result2.add(envVar);
        }
        DockerEnvVar[] dockerEnvVarArray = result2.toArray(new DockerEnvVar[0]);
        if (dockerEnvVarArray == null) {
            DockerAgentDeploymentConfigImpl.$$$reportNull$$$0(3);
        }
        return dockerEnvVarArray;
    }

    public DockerAgentDeploymentConfigImpl withEnvs(Map<String, String> envs) {
        this.myEnvVars = DockerAgentDeploymentConfigImpl.createEnvArray(envs, true);
        return this;
    }

    public DockerAgentDeploymentConfigImpl withEnvs(DockerEnvVar @Nullable [] envVars) {
        this.myEnvVars = envVars;
        return this;
    }

    public DockerAgentDeploymentConfigImpl withBuildArgs(Map<String, String> buildArgs2) {
        this.myBuildArgs = DockerAgentDeploymentConfigImpl.createEnvArray(buildArgs2 == null ? Collections.emptyMap() : buildArgs2, false);
        return this;
    }

    public DockerAgentDeploymentConfigImpl withBuildArgs(DockerEnvVar @Nullable [] buildArgs2) {
        this.myBuildArgs = buildArgs2;
        return this;
    }

    @Override
    public String[] getEntrypoint() {
        return this.myEntrypoint;
    }

    public DockerAgentDeploymentConfigImpl withEntrypoint(String ... entrypoint) {
        this.myEntrypoint = entrypoint;
        return this;
    }

    @Override
    public String[] getCommand() {
        return this.myCommand;
    }

    public DockerAgentDeploymentConfigImpl withCommand(String ... command) {
        this.myCommand = command;
        return this;
    }

    @Override
    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    public DockerAgentDeploymentConfigImpl withWorkingDir(String workingDir2) {
        this.myWorkingDir = workingDir2;
        return this;
    }

    @Override
    public DockerVolumesFrom[] getVolumesFrom() {
        return this.myVolumesFrom;
    }

    public DockerAgentDeploymentConfigImpl withVolumesFrom(DockerVolumesFrom ... volumesFrom2) {
        this.myVolumesFrom = volumesFrom2;
        return this;
    }

    @Override
    public Boolean getNetworkDisabled() {
        return this.myNetworkDisabled;
    }

    public DockerAgentDeploymentConfigImpl withNetworkDisabled(boolean networkDisabled) {
        this.myNetworkDisabled = networkDisabled;
        return this;
    }

    @Override
    public String getNetworkMode() {
        return this.myNetworkMode;
    }

    public DockerAgentDeploymentConfigImpl withNetworkMode(String networkMode) {
        this.myNetworkMode = networkMode;
        return this;
    }

    @Override
    public String[] getExtraHosts() {
        return this.myExtraHosts;
    }

    public DockerAgentDeploymentConfigImpl withExtraHosts(String[] extraHosts) {
        this.myExtraHosts = extraHosts;
        return this;
    }

    @Override
    public Boolean getStdinOnce() {
        return this.myStdinOnce;
    }

    public DockerAgentDeploymentConfigImpl withStdinOnce(Boolean stdinOnce) {
        this.myStdinOnce = stdinOnce;
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/runtime/DockerAgentDeploymentConfigImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/runtime/DockerAgentDeploymentConfigImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImageTags";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnvArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createEnvArray";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

