/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.database.dialects.sqlite.SqliteUtilsKt;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqliteErrorHandler
extends BaseDatabaseErrorHandler {
    @Override
    public int getErrorOffset(@NotNull Project project, @NotNull ErrorInfo errorInfo, @NotNull String queryText) {
        if (project == null) {
            SqliteErrorHandler.$$$reportNull$$$0(0);
        }
        if (errorInfo == null) {
            SqliteErrorHandler.$$$reportNull$$$0(1);
        }
        if (queryText == null) {
            SqliteErrorHandler.$$$reportNull$$$0(2);
        }
        BaseDatabaseErrorHandler.OffsetInfo offsetInfo = new BaseDatabaseErrorHandler.OffsetInfoBuilder(errorInfo.getMessage(), "\\bnear \"([^\"]*)\":").groupNear(1).build();
        return SqliteErrorHandler.getOffsetImpl(offsetInfo, queryText, SqliteErrorHandler.byTokenFinder(DbSqlUtilCore.getSqlDialect(Dbms.SQLITE), project, Integer.MAX_VALUE));
    }

    @Override
    @NotNull
    protected ErrorInfo getErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
        if (original == null) {
            SqliteErrorHandler.$$$reportNull$$$0(3);
        }
        if (cause == null) {
            SqliteErrorHandler.$$$reportNull$$$0(4);
        }
        String causeMsg = GridUtilCore.getMessage((Throwable)cause);
        if (dataSource != null && SqliteUtilsKt.isLockableSqliteUnderWSL(dataSource) && causeMsg.startsWith("[SQLITE_BUSY]")) {
            return new SqliteWSLFileLocked(dataSource, original, cause);
        }
        ErrorInfo errorInfo = super.getErrorInfo(dataSource, original, cause);
        if (errorInfo == null) {
            SqliteErrorHandler.$$$reportNull$$$0(5);
        }
        return errorInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/sqlite/SqliteErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/sqlite/SqliteErrorHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorOffset";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getErrorInfo";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static class SqliteWSLFileLocked
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        SqliteWSLFileLocked(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                SqliteWSLFileLocked.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                SqliteWSLFileLocked.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                SqliteWSLFileLocked.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                SqliteWSLFileLocked.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(GridUtilCore.getMessage((Throwable)this.myCause));
            sb.append('\n');
            sb.append(DatabaseBundle.message("sqlite.wsl.notification.description", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/sqlite/SqliteErrorHandler$SqliteWSLFileLocked";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

