/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;

public class PointLocation {
    public static boolean isOnLine(Coordinate p2, Coordinate[] line) {
        RobustLineIntersector lineIntersector = new RobustLineIntersector();
        for (int i2 = 1; i2 < line.length; ++i2) {
            Coordinate p0 = line[i2 - 1];
            Coordinate p1 = line[i2];
            ((LineIntersector)lineIntersector).computeIntersection(p2, p0, p1);
            if (!lineIntersector.hasIntersection()) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnLine(Coordinate p2, CoordinateSequence line) {
        RobustLineIntersector lineIntersector = new RobustLineIntersector();
        Coordinate p0 = new Coordinate();
        Coordinate p1 = new Coordinate();
        int n = line.size();
        for (int i2 = 1; i2 < n; ++i2) {
            line.getCoordinate(i2 - 1, p0);
            line.getCoordinate(i2, p1);
            ((LineIntersector)lineIntersector).computeIntersection(p2, p0, p1);
            if (!lineIntersector.hasIntersection()) continue;
            return true;
        }
        return false;
    }

    public static boolean isInRing(Coordinate p2, Coordinate[] ring) {
        return PointLocation.locateInRing(p2, ring) != 2;
    }

    public static int locateInRing(Coordinate p2, Coordinate[] ring) {
        return RayCrossingCounter.locatePointInRing(p2, ring);
    }
}

