/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.algorithm.Length;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.BoundaryOp;

public class LineString
extends Geometry
implements Lineal {
    private static final long serialVersionUID = 3110669828065365560L;
    public static final int MINIMUM_VALID_SIZE = 2;
    protected CoordinateSequence points;

    public LineString(Coordinate[] points, PrecisionModel precisionModel, int SRID) {
        super(new GeometryFactory(precisionModel, SRID));
        this.init(this.getFactory().getCoordinateSequenceFactory().create(points));
    }

    public LineString(CoordinateSequence points, GeometryFactory factory) {
        super(factory);
        this.init(points);
    }

    private void init(CoordinateSequence points) {
        if (points == null) {
            points = this.getFactory().getCoordinateSequenceFactory().create(new Coordinate[0]);
        }
        if (points.size() > 0 && points.size() < 2) {
            throw new IllegalArgumentException("Invalid number of points in LineString (found " + points.size() + " - must be 0 or >= " + 2 + ")");
        }
        this.points = points;
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.points.toCoordinateArray();
    }

    public CoordinateSequence getCoordinateSequence() {
        return this.points;
    }

    public Coordinate getCoordinateN(int n) {
        return this.points.getCoordinate(n);
    }

    @Override
    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.points.getCoordinate(0);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public int getBoundaryDimension() {
        if (this.isClosed()) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.points.size() == 0;
    }

    @Override
    public int getNumPoints() {
        return this.points.size();
    }

    public Point getPointN(int n) {
        return this.getFactory().createPoint(this.points.getCoordinate(n));
    }

    public Point getStartPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPointN(0);
    }

    public Point getEndPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPointN(this.getNumPoints() - 1);
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        return this.getCoordinateN(0).equals2D(this.getCoordinateN(this.getNumPoints() - 1));
    }

    public boolean isRing() {
        return this.isClosed() && this.isSimple();
    }

    @Override
    public String getGeometryType() {
        return "LineString";
    }

    @Override
    public double getLength() {
        return Length.ofLine(this.points);
    }

    @Override
    public Geometry getBoundary() {
        return new BoundaryOp(this).getBoundary();
    }

    @Override
    public LineString reverse() {
        return (LineString)super.reverse();
    }

    @Override
    protected LineString reverseInternal() {
        CoordinateSequence seq = this.points.copy();
        CoordinateSequences.reverse(seq);
        return this.getFactory().createLineString(seq);
    }

    public boolean isCoordinate(Coordinate pt) {
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            if (!this.points.getCoordinate(i2).equals(pt)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        if (this.isEmpty()) {
            return new Envelope();
        }
        return this.points.expandEnvelope(new Envelope());
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        LineString otherLineString = (LineString)other;
        if (this.points.size() != otherLineString.points.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            if (this.equal(this.points.getCoordinate(i2), otherLineString.points.getCoordinate(i2), tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void apply(CoordinateFilter filter) {
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            filter.filter(this.points.getCoordinate(i2));
        }
    }

    @Override
    public void apply(CoordinateSequenceFilter filter) {
        if (this.points.size() == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            filter.filter(this.points, i2);
            if (filter.isDone()) break;
        }
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(GeometryFilter filter) {
        filter.filter(this);
    }

    @Override
    public void apply(GeometryComponentFilter filter) {
        filter.filter(this);
    }

    @Override
    public Object clone() {
        return this.copy();
    }

    @Override
    protected LineString copyInternal() {
        return new LineString(this.points.copy(), this.factory);
    }

    @Override
    public void normalize() {
        for (int i2 = 0; i2 < this.points.size() / 2; ++i2) {
            int j = this.points.size() - 1 - i2;
            if (this.points.getCoordinate(i2).equals(this.points.getCoordinate(j))) continue;
            if (this.points.getCoordinate(i2).compareTo(this.points.getCoordinate(j)) > 0) {
                CoordinateSequence copy = this.points.copy();
                CoordinateSequences.reverse(copy);
                this.points = copy;
            }
            return;
        }
    }

    @Override
    protected boolean isEquivalentClass(Geometry other) {
        return other instanceof LineString;
    }

    @Override
    protected int compareToSameClass(Object o) {
        int j;
        LineString line = (LineString)o;
        int i2 = 0;
        for (j = 0; i2 < this.points.size() && j < line.points.size(); ++i2, ++j) {
            int comparison = this.points.getCoordinate(i2).compareTo(line.points.getCoordinate(j));
            if (comparison == 0) continue;
            return comparison;
        }
        if (i2 < this.points.size()) {
            return 1;
        }
        if (j < line.points.size()) {
            return -1;
        }
        return 0;
    }

    @Override
    protected int compareToSameClass(Object o, CoordinateSequenceComparator comp) {
        LineString line = (LineString)o;
        return comp.compare(this.points, line.points);
    }

    @Override
    protected int getTypeCode() {
        return 2;
    }
}

