/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snapround;

import org.locationtech.jts.algorithm.CGAlgorithmsDD;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.io.WKTWriter;

public class HotPixel {
    private static final double TOLERANCE = 0.5;
    private Coordinate originalPt;
    private double scaleFactor;
    private double hpx;
    private double hpy;
    private boolean isNode = false;
    private static final int UPPER_RIGHT = 0;
    private static final int UPPER_LEFT = 1;
    private static final int LOWER_LEFT = 2;
    private static final int LOWER_RIGHT = 3;

    public HotPixel(Coordinate pt, double scaleFactor) {
        this.originalPt = pt;
        this.scaleFactor = scaleFactor;
        if (scaleFactor <= 0.0) {
            throw new IllegalArgumentException("Scale factor must be non-zero");
        }
        if (scaleFactor != 1.0) {
            this.hpx = this.scaleRound(pt.getX());
            this.hpy = this.scaleRound(pt.getY());
        } else {
            this.hpx = pt.getX();
            this.hpy = pt.getY();
        }
    }

    public Coordinate getCoordinate() {
        return this.originalPt;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public double getWidth() {
        return 1.0 / this.scaleFactor;
    }

    public boolean isNode() {
        return this.isNode;
    }

    public void setToNode() {
        this.isNode = true;
    }

    private double scaleRound(double val) {
        return Math.round(val * this.scaleFactor);
    }

    private double scale(double val) {
        return val * this.scaleFactor;
    }

    public boolean intersects(Coordinate p2) {
        double x = this.scale(p2.x);
        double y = this.scale(p2.y);
        if (x >= this.hpx + 0.5) {
            return false;
        }
        if (x < this.hpx - 0.5) {
            return false;
        }
        if (y >= this.hpy + 0.5) {
            return false;
        }
        return !(y < this.hpy - 0.5);
    }

    public boolean intersects(Coordinate p0, Coordinate p1) {
        if (this.scaleFactor == 1.0) {
            return this.intersectsScaled(p0.x, p0.y, p1.x, p1.y);
        }
        double sp0x = this.scale(p0.x);
        double sp0y = this.scale(p0.y);
        double sp1x = this.scale(p1.x);
        double sp1y = this.scale(p1.y);
        return this.intersectsScaled(sp0x, sp0y, sp1x, sp1y);
    }

    private boolean intersectsScaled(double p0x, double p0y, double p1x, double p1y) {
        double px = p0x;
        double py = p0y;
        double qx = p1x;
        double qy = p1y;
        if (px > qx) {
            px = p1x;
            py = p1y;
            qx = p0x;
            qy = p0y;
        }
        double maxx = this.hpx + 0.5;
        double segMinx = Math.min(px, qx);
        if (segMinx >= maxx) {
            return false;
        }
        double minx = this.hpx - 0.5;
        double segMaxx = Math.max(px, qx);
        if (segMaxx < minx) {
            return false;
        }
        double maxy = this.hpy + 0.5;
        double segMiny = Math.min(py, qy);
        if (segMiny >= maxy) {
            return false;
        }
        double miny = this.hpy - 0.5;
        double segMaxy = Math.max(py, qy);
        if (segMaxy < miny) {
            return false;
        }
        if (px == qx) {
            return true;
        }
        if (py == qy) {
            return true;
        }
        int orientUL = CGAlgorithmsDD.orientationIndex(px, py, qx, qy, minx, maxy);
        if (orientUL == 0) {
            return !(py < qy);
        }
        int orientUR = CGAlgorithmsDD.orientationIndex(px, py, qx, qy, maxx, maxy);
        if (orientUR == 0) {
            return !(py > qy);
        }
        if (orientUL != orientUR) {
            return true;
        }
        int orientLL = CGAlgorithmsDD.orientationIndex(px, py, qx, qy, minx, miny);
        if (orientLL == 0) {
            return true;
        }
        if (orientLL != orientUL) {
            return true;
        }
        int orientLR = CGAlgorithmsDD.orientationIndex(px, py, qx, qy, maxx, miny);
        if (orientLR == 0) {
            return !(py < qy);
        }
        if (orientLL != orientLR) {
            return true;
        }
        return orientLR != orientUR;
    }

    private boolean intersectsPixelClosure(Coordinate p0, Coordinate p1) {
        double minx = this.hpx - 0.5;
        double maxx = this.hpx + 0.5;
        double miny = this.hpy - 0.5;
        double maxy = this.hpy + 0.5;
        Coordinate[] corner = new Coordinate[]{new Coordinate(maxx, maxy), new Coordinate(minx, maxy), new Coordinate(minx, miny), new Coordinate(maxx, miny)};
        RobustLineIntersector li = new RobustLineIntersector();
        li.computeIntersection(p0, p1, corner[0], corner[1]);
        if (li.hasIntersection()) {
            return true;
        }
        li.computeIntersection(p0, p1, corner[1], corner[2]);
        if (li.hasIntersection()) {
            return true;
        }
        li.computeIntersection(p0, p1, corner[2], corner[3]);
        if (li.hasIntersection()) {
            return true;
        }
        li.computeIntersection(p0, p1, corner[3], corner[0]);
        return li.hasIntersection();
    }

    public String toString() {
        return "HP(" + WKTWriter.format(this.originalPt) + ")";
    }
}

