/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Quadrant;

class PolygonNode {
    PolygonNode() {
    }

    public static boolean isCrossing(Coordinate nodePt, Coordinate a0, Coordinate a1, Coordinate b0, Coordinate b1) {
        boolean isBetween1;
        boolean isBetween0;
        Coordinate aLo = a0;
        Coordinate aHi = a1;
        if (PolygonNode.isAngleGreater(nodePt, aLo, aHi)) {
            aLo = a1;
            aHi = a0;
        }
        return (isBetween0 = PolygonNode.isBetween(nodePt, b0, aLo, aHi)) != (isBetween1 = PolygonNode.isBetween(nodePt, b1, aLo, aHi));
    }

    public static boolean isInteriorSegment(Coordinate nodePt, Coordinate a0, Coordinate a1, Coordinate b) {
        boolean isBetween;
        Coordinate aLo = a0;
        Coordinate aHi = a1;
        boolean isInteriorBetween = true;
        if (PolygonNode.isAngleGreater(nodePt, aLo, aHi)) {
            aLo = a1;
            aHi = a0;
            isInteriorBetween = false;
        }
        boolean isInterior = (isBetween = PolygonNode.isBetween(nodePt, b, aLo, aHi)) && isInteriorBetween || !isBetween && !isInteriorBetween;
        return isInterior;
    }

    private static boolean isBetween(Coordinate origin, Coordinate p2, Coordinate e0, Coordinate e1) {
        boolean isGreater0 = PolygonNode.isAngleGreater(origin, p2, e0);
        if (!isGreater0) {
            return false;
        }
        boolean isGreater1 = PolygonNode.isAngleGreater(origin, p2, e1);
        return !isGreater1;
    }

    private static boolean isAngleGreater(Coordinate origin, Coordinate p2, Coordinate q) {
        int quadrantQ;
        int quadrantP = PolygonNode.quadrant(origin, p2);
        if (quadrantP > (quadrantQ = PolygonNode.quadrant(origin, q))) {
            return true;
        }
        if (quadrantP < quadrantQ) {
            return false;
        }
        int orient = Orientation.index(origin, q, p2);
        return orient == 1;
    }

    private static int quadrant(Coordinate origin, Coordinate p2) {
        double dx = p2.getX() - origin.getX();
        double dy = p2.getY() - origin.getY();
        return Quadrant.quadrant(dx, dy);
    }
}

