/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.EnvReader;
import com.intellij.util.EnvironmentUtil;
import com.jetbrains.python.run.PyVirtualEnvReaderKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0014J\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/run/PyVirtualEnvReader;", "Lcom/intellij/util/EnvReader;", "virtualEnvSdkPath", "", "<init>", "(Ljava/lang/String;)V", "activate", "Lkotlin/Pair;", "getActivate", "()Lkotlin/Pair;", "getShell", "readPythonEnv", "", "getShellProcessCommand", "", "Companion", "intellij.python.sdk"})
public final class PyVirtualEnvReader
extends EnvReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String virtualEnvSdkPath;
    @Nullable
    private final Pair<String, String> activate;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final List<String> virtualEnvVars;

    public PyVirtualEnvReader(@NotNull String virtualEnvSdkPath) {
        Intrinsics.checkNotNullParameter((Object)virtualEnvSdkPath, (String)"virtualEnvSdkPath");
        this.virtualEnvSdkPath = virtualEnvSdkPath;
        this.activate = PyVirtualEnvReaderKt.findActivateScript(this.virtualEnvSdkPath, this.getShell());
    }

    @Nullable
    public final Pair<String, String> getActivate() {
        return this.activate;
    }

    @Nullable
    protected String getShell() {
        return Files.exists(Path.of("/bin/bash", new String[0]), new LinkOption[0]) ? "/bin/bash" : (Files.exists(Path.of("/bin/sh", new String[0]), new LinkOption[0]) ? "/bin/sh" : super.getShell());
    }

    @NotNull
    public final Map<String, String> readPythonEnv() {
        try {
            if (SystemInfo.isUnix) {
                Map map2 = super.readShellEnv(null, EnvironmentUtil.getEnvironmentMap());
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"readShellEnv(...)");
                return map2;
            }
            if (this.activate != null) {
                Map map3 = this.readBatEnv(Paths.get((String)this.activate.getFirst(), new String[0]), CollectionsKt.listOfNotNull((Object)this.activate.getSecond()));
                Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"readBatEnv(...)");
                return map3;
            }
            LOG.error("Can't find activate script for " + this.virtualEnvSdkPath);
        }
        catch (Exception e) {
            LOG.warn("Couldn't read shell environment: " + e.getMessage());
        }
        return new LinkedHashMap();
    }

    @NotNull
    protected List<String> getShellProcessCommand() {
        List list;
        String shellPath = this.getShell();
        if (shellPath == null || !new File(shellPath).canExecute()) {
            throw new RuntimeException("shell:" + shellPath);
        }
        if (this.activate != null) {
            String activateArg = this.activate.getSecond() != null ? "'" + this.activate.getFirst() + "' '" + this.activate.getSecond() + "'" : "'" + this.activate.getFirst() + "'";
            Object[] objectArray = new String[]{shellPath, "-c", ". " + activateArg};
            list = CollectionsKt.mutableListOf((Object[])objectArray);
        } else {
            List list2 = super.getShellProcessCommand();
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getShellProcessCommand(...)");
        }
        return list;
    }

    static {
        Logger logger = Logger.getInstance(PyVirtualEnvReader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new String[]{"PATH", "PS1", "VIRTUAL_ENV", "PYTHONHOME", "PROMPT", "_OLD_VIRTUAL_PROMPT", "_OLD_VIRTUAL_PYTHONHOME", "_OLD_VIRTUAL_PATH", "CONDA_SHLVL", "CONDA_PROMPT_MODIFIER", "CONDA_PREFIX", "CONDA_DEFAULT_ENV", "GDAL_DATA", "PROJ_LIB", "JAVA_HOME", "JAVA_LD_LIBRARY_PATH"};
        virtualEnvVars = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/run/PyVirtualEnvReader$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "virtualEnvVars", "", "", "filterVirtualEnvVars", "", "env", "intellij.python.sdk"})
    @SourceDebugExtension(value={"SMAP\nPyVirtualEnvReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyVirtualEnvReader.kt\ncom/jetbrains/python/run/PyVirtualEnvReader$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n488#2,3:125\n491#2,4:131\n1761#3,3:128\n*S KotlinDebug\n*F\n+ 1 PyVirtualEnvReader.kt\ncom/jetbrains/python/run/PyVirtualEnvReader$Companion\n*L\n28#1:125,3\n28#1:131,4\n28#1:128,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> filterVirtualEnvVars(@NotNull Map<String, String> env) {
            Intrinsics.checkNotNullParameter(env, (String)"env");
            Map<String, String> $this$filterKeys$iv = env;
            boolean $i$f$filterKeys = false;
            LinkedHashMap<String, String> result$iv = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry$iv : $this$filterKeys$iv.entrySet()) {
                boolean bl;
                block4: {
                    String k = entry$iv.getKey();
                    boolean bl2 = false;
                    Iterable $this$any$iv = virtualEnvVars;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!StringsKt.equals((String)it, (String)k, (boolean)true)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            return result$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

