/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileEditorListener;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileEditorTracker;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.DisposableWrapperList;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u001d\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u001aH\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u000fH\u0003J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u000fH\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/javascript/nodejs/packageJson/PackageJsonFileEditorTracker;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "Lcom/intellij/javascript/nodejs/packageJson/PackageJsonFileEditorListener;", "openPackageJsonFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "disposableByPackageJson", "", "changesDispatcher", "Lcom/intellij/javascript/nodejs/packageJson/PackageJsonFileManager$PackageJsonChangesListener;", "documentListener", "Lcom/intellij/openapi/editor/event/DocumentListener;", "getOpenPackageJsonFiles", "", "getOpenPackageJsonFiles$intellij_javascript_impl", "addListener", "", "listener", "addListener$intellij_javascript_impl", "trackEvents", "trackDocumentChanges", "packageJson", "stopTrackingDocumentChanges", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nPackageJsonFileEditorTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageJsonFileEditorTracker.kt\ncom/intellij/javascript/nodejs/packageJson/PackageJsonFileEditorTracker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,123:1\n3829#2:124\n4344#2,2:125\n14#3:127\n*S KotlinDebug\n*F\n+ 1 PackageJsonFileEditorTracker.kt\ncom/intellij/javascript/nodejs/packageJson/PackageJsonFileEditorTracker\n*L\n46#1:124\n46#1:125,2\n113#1:127\n*E\n"})
public final class PackageJsonFileEditorTracker {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final DisposableWrapperList<PackageJsonFileEditorListener> listeners;
    @NotNull
    private final Set<VirtualFile> openPackageJsonFiles;
    @NotNull
    private final Map<VirtualFile, Disposable> disposableByPackageJson;
    @NotNull
    private final PackageJsonFileManager.PackageJsonChangesListener changesDispatcher;
    @NotNull
    private final DocumentListener documentListener;

    /*
     * WARNING - void declaration
     */
    public PackageJsonFileEditorTracker(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.parentDisposable = CoroutineScopeKt.asDisposable((CoroutineScope)this.coroutineScope);
        this.listeners = new DisposableWrapperList();
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.openPackageJsonFiles = set;
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.disposableByPackageJson = concurrentMap;
        MessageBus messageBus = this.project.getMessageBus();
        Topic<PackageJsonFileManager.PackageJsonChangesListener> topic = PackageJsonFileManager.CHANGES_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"CHANGES_TOPIC");
        Object object = messageBus.syncPublisher(topic);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"syncPublisher(...)");
        this.changesDispatcher = (PackageJsonFileManager.PackageJsonChangesListener)object;
        this.documentListener = new DocumentListener(this){
            final /* synthetic */ PackageJsonFileEditorTracker this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile file = FileDocumentManager.getInstance().getFile(event.getDocument());
                if (file != null && PackageJsonUtil.isPackageJsonFile(file)) {
                    PackageJsonFileManager.PackageJsonChangeEvent event2 = new PackageJsonFileManager.PackageJsonChangeEvent(PackageJsonFileManager.PackageJsonEventType.DOCUMENT_CONTENT_CHANGED, file);
                    PackageJsonFileEditorTracker.access$getChangesDispatcher$p(this.this$0).onChange(CollectionsKt.listOf((Object)event2));
                }
            }
        };
        this.trackEvents();
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this.project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        Object[] $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!PackageJsonUtil.isPackageJsonFile(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List initialOpenFiles = (List)destination$iv$iv;
        if (!((Collection)initialOpenFiles).isEmpty()) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<? extends VirtualFile>)initialOpenFiles, this, null){
                int label;
                final /* synthetic */ List<VirtualFile> $initialOpenFiles;
                final /* synthetic */ PackageJsonFileEditorTracker this$0;
                {
                    this.$initialOpenFiles = $initialOpenFiles;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = CoroutinesKt.readActionBlocking(() -> 1.invokeSuspend$lambda$0(this.$initialOpenFiles, this.this$0), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Unit invokeSuspend$lambda$0(List $initialOpenFiles, PackageJsonFileEditorTracker this$0) {
                    for (VirtualFile file : $initialOpenFiles) {
                        Intrinsics.checkNotNull((Object)file);
                        this$0.trackDocumentChanges(file);
                    }
                    return Unit.INSTANCE;
                }
            }), (int)3, null);
        }
        this.openPackageJsonFiles.addAll(initialOpenFiles);
    }

    @NotNull
    public final Set<VirtualFile> getOpenPackageJsonFiles$intellij_javascript_impl() {
        return this.openPackageJsonFiles;
    }

    public final void addListener$intellij_javascript_impl(@NotNull Disposable parentDisposable, @NotNull PackageJsonFileEditorListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add((Object)listener2, parentDisposable);
    }

    private final void trackEvents() {
        FileEditorManagerListener listener2 = new FileEditorManagerListener(this){
            final /* synthetic */ PackageJsonFileEditorTracker this$0;
            {
                this.this$0 = $receiver;
            }

            public void fileOpened(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (PackageJsonUtil.isPackageJsonFile(file) && PackageJsonFileEditorTracker.access$getOpenPackageJsonFiles$p(this.this$0).add(file)) {
                    ReadAction.run(() -> trackEvents.listener.1.fileOpened$lambda$0(this.this$0, file));
                    Iterator iterator = PackageJsonFileEditorTracker.access$getListeners$p(this.this$0).iterator();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
                    Iterator iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        PackageJsonFileEditorListener listener2 = (PackageJsonFileEditorListener)iterator2.next();
                        listener2.fileOpened(file);
                    }
                }
            }

            public void fileClosed(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                boolean removed = PackageJsonFileEditorTracker.access$getOpenPackageJsonFiles$p(this.this$0).remove(file);
                if (removed) {
                    ReadAction.run(() -> trackEvents.listener.1.fileClosed$lambda$1(this.this$0, file));
                    Iterator iterator = PackageJsonFileEditorTracker.access$getListeners$p(this.this$0).iterator();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
                    Iterator iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        PackageJsonFileEditorListener listener2 = (PackageJsonFileEditorListener)iterator2.next();
                        listener2.fileClosed(file);
                    }
                }
            }

            private static final void fileOpened$lambda$0(PackageJsonFileEditorTracker this$0, VirtualFile $file) {
                PackageJsonFileEditorTracker.access$trackDocumentChanges(this$0, $file);
            }

            private static final void fileClosed$lambda$1(PackageJsonFileEditorTracker this$0, VirtualFile $file) {
                PackageJsonFileEditorTracker.access$stopTrackingDocumentChanges(this$0, $file);
            }
        };
        SimpleMessageBusConnection simpleMessageBusConnection = this.project.getMessageBus().connect(this.coroutineScope);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        simpleMessageBusConnection.subscribe(topic, (Object)listener2);
    }

    @RequiresReadLock
    private final void trackDocumentChanges(VirtualFile packageJson) {
        block1: {
            Document document;
            Disposable disposable = Disposer.newDisposable((Disposable)this.parentDisposable);
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable disposable2 = disposable;
            if (this.disposableByPackageJson.putIfAbsent(packageJson, disposable2) != null) {
                Disposer.dispose((Disposable)disposable2);
                return;
            }
            Document document2 = document = FileDocumentManager.getInstance().getDocument(packageJson);
            if (document2 == null) break block1;
            document2.addDocumentListener(this.documentListener, disposable2);
        }
    }

    @RequiresReadLock
    private final void stopTrackingDocumentChanges(VirtualFile packageJson) {
        Disposable disposable = this.disposableByPackageJson.remove(packageJson);
        if (disposable != null) {
            Disposer.dispose((Disposable)disposable);
        } else {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(PackageJsonFileEditorTracker.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("No disposable found for package.json");
        }
    }

    public static final /* synthetic */ Set access$getOpenPackageJsonFiles$p(PackageJsonFileEditorTracker $this) {
        return $this.openPackageJsonFiles;
    }

    public static final /* synthetic */ DisposableWrapperList access$getListeners$p(PackageJsonFileEditorTracker $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ void access$stopTrackingDocumentChanges(PackageJsonFileEditorTracker $this, VirtualFile packageJson) {
        $this.stopTrackingDocumentChanges(packageJson);
    }

    public static final /* synthetic */ PackageJsonFileManager.PackageJsonChangesListener access$getChangesDispatcher$p(PackageJsonFileEditorTracker $this) {
        return $this.changesDispatcher;
    }
}

