/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class JSArrowFunctionBracesCanBeRemovedInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSArrowFunctionBracesCanBeRemovedInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSArrowFunctionBracesCanBeRemovedInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSFunctionExpression(@NotNull JSFunctionExpression functionExpression) {
                ProblemHighlightType problemHighlightType;
                ASTNode redundantNode;
                if (functionExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!DialectDetector.hasFeature(functionExpression, JSLanguageFeature.FOR_OF) || !functionExpression.isArrowFunction()) {
                    return;
                }
                JSBlockStatement body = functionExpression.getBlock();
                JSExpression expression = JSArrowFunctionBracesCanBeRemovedInspection.getSingleExpression(body);
                JSElement statement = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)expression, JSStatement.class);
                if (body == null || expression == null || statement == null) {
                    return;
                }
                ASTNode aSTNode = redundantNode = statement instanceof JSReturnStatement ? statement.getNode().findChildByType(JSTokenTypes.RETURN_KEYWORD) : body.getNode().findChildByType(JSTokenTypes.LBRACE);
                if (redundantNode == null) {
                    return;
                }
                ConvertToShorthandFix fix = new ConvertToShorthandFix(functionExpression);
                String description = JavaScriptBundle.message("js.arrow.function.braces.can.be.removed.problem.description", new Object[0]);
                int functionStartOffset = functionExpression.getTextRange().getStartOffset();
                TextRange redundantRange = TextRange.from((int)(redundantNode.getStartOffset() - functionStartOffset), (int)redundantNode.getTextLength());
                boolean shouldReportAsInfo = expression instanceof JSAssignmentExpression;
                Object object = shouldReportAsInfo ? (holder.isOnTheFly() ? ProblemHighlightType.INFORMATION : null) : (problemHighlightType = ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                if (problemHighlightType != null) {
                    holder.registerProblem((PsiElement)functionExpression, description, problemHighlightType, redundantRange, new LocalQuickFix[]{fix});
                }
                if (holder.isOnTheFly()) {
                    TextRange infoRange = TextRange.from((int)0, (int)(redundantNode.getTextRange().getStartOffset() - functionStartOffset - 1));
                    holder.registerProblem((PsiElement)functionExpression, description, ProblemHighlightType.INFORMATION, infoRange, new LocalQuickFix[]{fix});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionExpression", "com/intellij/lang/javascript/inspections/JSArrowFunctionBracesCanBeRemovedInspection$1", "visitJSFunctionExpression"));
            }
        };
    }

    @Nullable
    public static JSExpression getSingleExpression(@Nullable JSBlockStatement block) {
        if (block == null) {
            return null;
        }
        JSBlockStatement statement = block;
        while (statement instanceof JSBlockStatement) {
            List<PsiElement> blockElements = JSArrowFunctionBracesCanBeRemovedInspection.getStatementsAndComments(statement);
            if (blockElements.size() != 1) {
                return null;
            }
            statement = blockElements.get(0);
        }
        if (statement instanceof JSReturnStatement) {
            return ((JSReturnStatement)((Object)statement)).getExpression();
        }
        if (statement instanceof JSExpressionStatement) {
            if (JSPsiImplUtils.isUseStrictStatement(statement)) {
                return null;
            }
            JSExpression expression = ((JSExpressionStatement)((Object)statement)).getExpression();
            return expression instanceof JSCommaExpression ? null : expression;
        }
        return null;
    }

    private static @Unmodifiable List<PsiElement> getStatementsAndComments(@NotNull JSBlockStatement block) {
        if (block == null) {
            JSArrowFunctionBracesCanBeRemovedInspection.$$$reportNull$$$0(2);
        }
        return ContainerUtil.filter((Object[])block.getChildren(), element2 -> JSChangeUtil.isSourceElementOrComment(element2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSArrowFunctionBracesCanBeRemovedInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getStatementsAndComments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConvertToShorthandFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected ConvertToShorthandFix(@Nullable PsiElement element2) {
            super(element2);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("js.arrow.function.braces.can.be.removed.fix.family.name", new Object[0]);
            if (string == null) {
                ConvertToShorthandFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                ConvertToShorthandFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ConvertToShorthandFix.$$$reportNull$$$0(2);
            }
            if (psiFile == null) {
                ConvertToShorthandFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                ConvertToShorthandFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                ConvertToShorthandFix.$$$reportNull$$$0(5);
            }
            JSFunctionExpression arrowFunction = (JSFunctionExpression)startElement;
            JSBlockStatement body = arrowFunction.getBlock();
            JSExpression expression = JSArrowFunctionBracesCanBeRemovedInspection.getSingleExpression(body);
            if (body == null || expression == null) {
                return;
            }
            boolean shouldPlaceResultOnNewLine = expression.textContains('\n') && !(expression instanceof JSObjectLiteralExpression);
            JSExpression replacement = JSPsiImplUtils.parensAroundArrowFunctionBodyRequired(expression) ? JSChangeUtil.wrapInParentheses(expression) : expression;
            JSElement replaced = JSChangeUtil.replaceElement(body, replacement);
            if (shouldPlaceResultOnNewLine) {
                JSChangeUtil.addWs(replaced.getParent().getNode(), replaced.getNode(), "\n");
            }
            FormatFixer.create((PsiElement)replaced, FormatFixer.Mode.Reformat).fixFormat();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSArrowFunctionBracesCanBeRemovedInspection$ConvertToShorthandFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSArrowFunctionBracesCanBeRemovedInspection$ConvertToShorthandFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

