/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSStatementWithLabelReference;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSStatementImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStatementWithLabelReferenceImpl
extends JSStatementImpl
implements JSStatementWithLabelReference {
    private volatile PsiReference[] myReferences;

    protected JSStatementWithLabelReferenceImpl(IElementType elementType) {
        super(elementType);
    }

    @Override
    @Nullable
    public String getLabel() {
        ASTNode label = this.getLabelIdentifierNode();
        return label != null ? label.getText() : null;
    }

    protected ASTNode getLabelIdentifierNode() {
        return this.getNode().findChildByType(JSTokenTypes.IDENTIFIER);
    }

    @Override
    @Nullable
    public PsiElement getLabelIdentifier() {
        ASTNode labelNode = this.getLabelIdentifierNode();
        return labelNode != null ? labelNode.getPsi() : null;
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] references = this.myReferences;
        if (references == null) {
            PsiReference[] psiReferenceArray;
            ASTNode label = this.getLabelIdentifierNode();
            if (label != null) {
                PsiReference[] psiReferenceArray2 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray2;
                psiReferenceArray2[0] = this.createReference(label.getPsi());
            } else {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
            }
            references = psiReferenceArray;
            this.myReferences = psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = (PsiReference[])references.clone();
        if (psiReferenceArray == null) {
            JSStatementWithLabelReferenceImpl.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    public void clearCaches() {
        super.clearCaches();
        this.myReferences = null;
    }

    @NotNull
    protected LabelReference createReference(PsiElement label) {
        return new LabelReference(label);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSStatementWithLabelReferenceImpl", "getReferences"));
    }

    protected class LabelReference
    implements PsiReference {
        private final PsiElement labelNode;

        protected LabelReference(PsiElement _labelNode) {
            this.labelNode = _labelNode;
        }

        @NotNull
        public PsiElement getElement() {
            JSStatementWithLabelReferenceImpl jSStatementWithLabelReferenceImpl = JSStatementWithLabelReferenceImpl.this;
            if (jSStatementWithLabelReferenceImpl == null) {
                LabelReference.$$$reportNull$$$0(0);
            }
            return jSStatementWithLabelReferenceImpl;
        }

        @NotNull
        public TextRange getRangeInElement() {
            int startOffsetInParent = this.labelNode.getStartOffsetInParent();
            return new TextRange(startOffsetInParent, startOffsetInParent + this.labelNode.getTextLength());
        }

        @Nullable
        public PsiElement resolve() {
            final PsiElement[] result2 = new PsiElement[1];
            this.processElements((PsiElementProcessor<? super JSLabeledStatement>)new PsiElementProcessor<JSLabeledStatement>(){
                private final String label;
                {
                    this.label = LabelReference.this.getCanonicalText();
                }

                public boolean execute(@NotNull JSLabeledStatement element2) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (this.label.equals(element2.getLabel())) {
                        result2[0] = element2;
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSStatementWithLabelReferenceImpl$LabelReference$1", "execute"));
                }
            });
            return result2[0];
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.labelNode.getText();
            if (string == null) {
                LabelReference.$$$reportNull$$$0(1);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                LabelReference.$$$reportNull$$$0(2);
            }
            JSChangeUtil.doIdentifierReplacement(this.getElement(), this.labelNode, newElementName);
            return this.getElement();
        }

        public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
            if (element2 == null) {
                LabelReference.$$$reportNull$$$0(3);
            }
            return null;
        }

        public boolean isReferenceTo(@NotNull PsiElement element2) {
            if (element2 == null) {
                LabelReference.$$$reportNull$$$0(4);
            }
            return JSStatementWithLabelReferenceImpl.this.getManager().areElementsEquivalent(this.resolve(), element2);
        }

        public Object @NotNull [] getVariants() {
            final ArrayList labels = new ArrayList(1);
            this.processElements((PsiElementProcessor<? super JSLabeledStatement>)new PsiElementProcessor<JSLabeledStatement>(){

                public boolean execute(@NotNull JSLabeledStatement element2) {
                    if (element2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    labels.add(element2.getLabel());
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSStatementWithLabelReferenceImpl$LabelReference$2", "execute"));
                }
            });
            Object[] objectArray = ArrayUtilRt.toStringArray(labels);
            if (objectArray == null) {
                LabelReference.$$$reportNull$$$0(5);
            }
            return objectArray;
        }

        protected void processElements(PsiElementProcessor<? super JSLabeledStatement> processor) {
            for (PsiElement run2 = JSStatementWithLabelReferenceImpl.this.getParent(); run2 != null; run2 = run2.getParent()) {
                if (run2 instanceof JSLabeledStatement && !processor.execute((PsiElement)((JSLabeledStatement)run2))) {
                    return;
                }
                if (run2 instanceof JSFunction) break;
            }
        }

        public boolean isSoft() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSStatementWithLabelReferenceImpl$LabelReference";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSStatementWithLabelReferenceImpl$LabelReference";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

