/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.accessibility;

import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveProcessor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSAccessibilityChecker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptImportTypeChecker
extends JSAccessibilityChecker {
    public static final TypeScriptImportTypeChecker INSTANCE = new TypeScriptImportTypeChecker();
    private final Class[] myClasses = new Class[]{ES6ImportSpecifier.class, TypeScriptImportStatement.class};

    @Override
    protected Class<? extends JSElement> @NotNull [] getSuitableClasses() {
        if (this.myClasses == null) {
            TypeScriptImportTypeChecker.$$$reportNull$$$0(0);
        }
        return this.myClasses;
    }

    @Override
    protected @Nullable JSResolveResult.ProblemKind checkImpl(@Nullable PsiElement place, @NotNull PsiElement element2) {
        if (element2 == null) {
            TypeScriptImportTypeChecker.$$$reportNull$$$0(1);
        }
        if (place == null || !TypeScriptImportTypeChecker.isImportTypeElement(element2) || TypeScriptImportTypeChecker.isInsideType(place)) {
            return null;
        }
        return JSResolveResult.ProblemKind.ELEMENT_IS_NOT_ACCESSIBLE;
    }

    private static boolean isImportTypeElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            TypeScriptImportTypeChecker.$$$reportNull$$$0(2);
        }
        if (element2 instanceof ES6ImportSpecifier) {
            ES6ImportExportSpecifier.ImportExportSpecifierKind kind = ((ES6ImportSpecifier)element2).getSpecifierKind();
            if (kind == ES6ImportExportSpecifier.ImportExportSpecifierKind.IMPORT_TYPE) {
                return true;
            }
            ES6ImportDeclaration declaration = ((ES6ImportSpecifier)element2).getDeclaration();
            return declaration != null && declaration.getImportExportPrefixKind() == ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE;
        }
        if (element2 instanceof TypeScriptImportStatement) {
            return ((TypeScriptImportStatement)element2).isTypeImport();
        }
        return false;
    }

    private static boolean isInsideType(@NotNull PsiElement place) {
        if (place == null) {
            TypeScriptImportTypeChecker.$$$reportNull$$$0(3);
        }
        return PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{TypeScriptType.class}) != null;
    }

    @Override
    public boolean isAvailable(AccessibilityProcessingHandler handler, SinkResolveProcessor<?> resolveProcessor) {
        return ((ResultSink)resolveProcessor.getResultSink()).isTypeScript() && resolveProcessor instanceof TypeScriptResolveProcessor && !((TypeScriptResolveProcessor)resolveProcessor).isStrictTypeContext();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/accessibility/TypeScriptImportTypeChecker";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/accessibility/TypeScriptImportTypeChecker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkImpl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isImportTypeElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInsideType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

