/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInsertModifierFix
extends PsiUpdateModCommandAction<JSAttributeListOwner> {
    private static final Logger LOG = Logger.getInstance(JSInsertModifierFix.class);
    private final JSAttributeList.ModifierType myModifier;

    public JSInsertModifierFix(JSAttributeListOwner element2, JSAttributeList.ModifierType modifier) {
        super((PsiElement)element2);
        this.myModifier = modifier;
    }

    @IntentionName
    public static String getSetModifierText(@NotNull JSAttributeListOwner myClassOrMethod, @NotNull String modifierOrVisibility) {
        if (myClassOrMethod == null) {
            JSInsertModifierFix.$$$reportNull$$$0(0);
        }
        if (modifierOrVisibility == null) {
            JSInsertModifierFix.$$$reportNull$$$0(1);
        }
        return JavaScriptBundle.message("javascript.fix.set.element.visibility", new JSNamedElementPresenter((PsiElement)myClassOrMethod).describeWithShortName(), modifierOrVisibility);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull JSAttributeListOwner myClassOrMethod) {
        if (context2 == null) {
            JSInsertModifierFix.$$$reportNull$$$0(2);
        }
        if (myClassOrMethod == null) {
            JSInsertModifierFix.$$$reportNull$$$0(3);
        }
        return Presentation.of((String)JSInsertModifierFix.getSetModifierText(myClassOrMethod, this.getModifier().keyword));
    }

    private JSAttributeList.ModifierType getModifier() {
        return this.myModifier;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.fix.visibility.family", new Object[0]);
        if (string == null) {
            JSInsertModifierFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context2, @NotNull JSAttributeListOwner owner, @NotNull ModPsiUpdater updater) {
        JSAttributeList list;
        if (context2 == null) {
            JSInsertModifierFix.$$$reportNull$$$0(5);
        }
        if (owner == null) {
            JSInsertModifierFix.$$$reportNull$$$0(6);
        }
        if (updater == null) {
            JSInsertModifierFix.$$$reportNull$$$0(7);
        }
        if ((list = owner.getAttributeList()) == null) {
            LOG.error("Attribute list must exist");
            return;
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(list);
        wrapper.overrideModifier(this.getModifier(), true);
        wrapper.applyTo(owner);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myClassOrMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierOrVisibility";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSInsertModifierFix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSInsertModifierFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSetModifierText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

