/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.functionmetrics.CyclomaticComplexityVisitor;
import com.sixrr.inspectjs.functionmetrics.FunctionMetricsInspection;
import org.jetbrains.annotations.NotNull;

public final class CyclomaticComplexityJSInspection
extends FunctionMetricsInspection {
    @Override
    protected int getDefaultLimit() {
        return 10;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionJSBundle.message("function.complexity.limit.parameter", new Object[0]);
    }

    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        JSFunction function = (JSFunction)((PsiElement)args[0]).getParent();
        assert (function != null);
        CyclomaticComplexityVisitor visitor = new CyclomaticComplexityVisitor();
        PsiElement lastChild = function.getLastChild();
        assert (lastChild != null);
        lastChild.accept((PsiElementVisitor)visitor);
        int coupling = visitor.getComplexity();
        if (CyclomaticComplexityJSInspection.functionHasIdentifier(function)) {
            String string = InspectionJSBundle.message("function.ref.is.overly.complex.cyclomatic.complexity.error.string", coupling);
            if (string == null) {
                CyclomaticComplexityJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionJSBundle.message("anonymous.function.is.overly.complex.cyclomatic.complexity.error.string", coupling);
        if (string == null) {
            CyclomaticComplexityJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/functionmetrics/CyclomaticComplexityJSInspection", "buildErrorString"));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
            PsiElement lastChild;
            if (function == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (!((lastChild = function.getLastChild()) instanceof JSBlockStatement)) {
                return;
            }
            CyclomaticComplexityVisitor visitor = new CyclomaticComplexityVisitor();
            lastChild.accept((PsiElementVisitor)visitor);
            int complexity = visitor.getComplexity();
            if (complexity <= CyclomaticComplexityJSInspection.this.getLimit()) {
                return;
            }
            this.registerFunctionError(function);
        }

        @Override
        public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.visitJSFunctionDeclaration(node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/sixrr/inspectjs/functionmetrics/CyclomaticComplexityJSInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionDeclaration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

