/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.UpdateContext;
import com.intellij.notebooks.visualization.controllers.selfUpdate.SelfManagedCellController;
import com.intellij.notebooks.visualization.controllers.selfUpdate.SelfManagedControllerFactory;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellInput;
import com.intellij.notebooks.visualization.ui.EditorCellOutputsView;
import com.intellij.notebooks.visualization.ui.EditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.cellsDnD.DropHighlightable;
import com.intellij.notebooks.visualization.ui.providers.frame.EditorCellFrameManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u001fH\u0002J\b\u0010#\u001a\u00020\u001fH\u0016J\b\u0010$\u001a\u00020\u001fH\u0002J\b\u0010%\u001a\u00020\u0014H\u0002J\u0006\u0010&\u001a\u00020\u001fJ\u0006\u0010'\u001a\u00020\u001fJ\b\u0010(\u001a\u00020\u001fH\u0002J\b\u0010)\u001a\u00020*H\u0016J\u0006\u0010+\u001a\u00020\u001fJ\u0006\u0010,\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006-"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellView;", "Lcom/intellij/notebooks/visualization/ui/EditorCellViewComponent;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "getCell", "()Lcom/intellij/notebooks/visualization/ui/EditorCell;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "input", "Lcom/intellij/notebooks/visualization/ui/EditorCellInput;", "getInput", "()Lcom/intellij/notebooks/visualization/ui/EditorCellInput;", "value", "Lcom/intellij/notebooks/visualization/ui/EditorCellOutputsView;", "outputs", "getOutputs", "()Lcom/intellij/notebooks/visualization/ui/EditorCellOutputsView;", "isSelected", "", "()Z", "isHovered", "controllers", "", "Lcom/intellij/notebooks/visualization/controllers/selfUpdate/SelfManagedCellController;", "getControllers", "()Ljava/util/List;", "controllers$delegate", "Lkotlin/Lazy;", "update", "", "updateContext", "Lcom/intellij/notebooks/visualization/UpdateContext;", "updateInput", "doCheckAndRebuildInlays", "updateOutputs", "hasOutputs", "onViewportChanges", "updateHovered", "updateFolding", "calculateBounds", "Ljava/awt/Rectangle;", "addDropHighlightIfApplicable", "removeDropHighlightIfPresent", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorCellView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellView.kt\ncom/intellij/notebooks/visualization/ui/EditorCellView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1869#2,2:124\n808#2,11:127\n808#2,11:138\n1#3:126\n*S KotlinDebug\n*F\n+ 1 EditorCellView.kt\ncom/intellij/notebooks/visualization/ui/EditorCellView\n*L\n60#1:124,2\n117#1:127,11\n121#1:138,11\n*E\n"})
public final class EditorCellView
extends EditorCellViewComponent {
    @NotNull
    private final EditorCell cell;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final EditorCellInput input;
    @Nullable
    private EditorCellOutputsView outputs;
    @NotNull
    private final Lazy controllers$delegate;

    /*
     * WARNING - void declaration
     */
    public EditorCellView(@NotNull EditorCell cell) {
        void it;
        EditorCellInput editorCellInput;
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.cell = cell;
        this.editor = this.cell.getEditor();
        EditorCellInput editorCellInput2 = editorCellInput = new EditorCellInput(this.cell);
        EditorCellView editorCellView = this;
        boolean bl = false;
        this.add((EditorCellViewComponent)it);
        editorCellView.input = editorCellInput;
        this.controllers$delegate = LazyKt.lazy(() -> EditorCellView.controllers_delegate$lambda$1(this));
        NotebookEditorUiUtilKt.bind((ObservableProperty)this.cell.getSource(), (Disposable)this, arg_0 -> EditorCellView._init_$lambda$2(this, arg_0));
        NotebookEditorUiUtilKt.bind((ObservableProperty)this.cell.isSelected(), (Disposable)this, arg_0 -> EditorCellView._init_$lambda$3(this, arg_0));
        NotebookEditorUiUtilKt.bind((ObservableProperty)this.cell.isHovered(), (Disposable)this, arg_0 -> EditorCellView._init_$lambda$4(this, arg_0));
        this.updateOutputs();
        this.checkAndRebuildInlays();
    }

    @NotNull
    public final EditorCell getCell() {
        return this.cell;
    }

    @NotNull
    public final EditorCellInput getInput() {
        return this.input;
    }

    @Nullable
    public final EditorCellOutputsView getOutputs() {
        return this.outputs;
    }

    public final boolean isSelected() {
        return this.cell.isSelected().get();
    }

    private final boolean isHovered() {
        return this.cell.isHovered().get();
    }

    @NotNull
    public final List<SelfManagedCellController> getControllers() {
        Lazy lazy = this.controllers$delegate;
        return (List)lazy.getValue();
    }

    public final void update(@NotNull UpdateContext updateContext) {
        Intrinsics.checkNotNullParameter((Object)updateContext, (String)"updateContext");
        this.input.updateInput();
        this.updateOutputs();
        this.updateCellFolding(updateContext);
    }

    private final void updateInput() {
        this.input.updateInput();
    }

    @Override
    public void doCheckAndRebuildInlays() {
        block1: {
            Iterable $this$forEach$iv = this.getControllers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SelfManagedCellController it = (SelfManagedCellController)element$iv;
                boolean bl = false;
                it.checkAndRebuildInlays();
            }
            EditorCellFrameManager editorCellFrameManager = this.cell.getCellFrameManager();
            if (editorCellFrameManager == null) break block1;
            editorCellFrameManager.updateCellFrameShow();
        }
    }

    private final void updateOutputs() {
        ActionsKt.runInEdt$default(null, () -> EditorCellView.updateOutputs$lambda$8(this), (int)1, null);
    }

    private final boolean hasOutputs() {
        return this.cell.getInterval().getType() == NotebookCellLines.CellType.CODE && (this.editor.getEditorKind() != EditorKind.DIFF || Registry.Companion.is("jupyter.diff.viewer.output"));
    }

    public final void onViewportChanges() {
        block0: {
            this.input.onViewportChange();
            EditorCellOutputsView editorCellOutputsView = this.outputs;
            if (editorCellOutputsView == null) break block0;
            editorCellOutputsView.onViewportChange();
        }
    }

    public final void updateHovered() {
        this.updateFolding();
    }

    private final void updateFolding() {
        block1: {
            this.input.getFolding().setVisible(this.isHovered() || this.isSelected());
            this.input.getFolding().setSelected(this.isSelected());
            EditorCellOutputsView editorCellOutputsView = this.outputs;
            if (editorCellOutputsView != null) {
                editorCellOutputsView.setFoldingsVisible(this.isHovered() || this.isSelected());
            }
            EditorCellOutputsView editorCellOutputsView2 = this.outputs;
            if (editorCellOutputsView2 == null) break block1;
            editorCellOutputsView2.setFoldingsSelected(this.isSelected());
        }
    }

    @Override
    @NotNull
    public Rectangle calculateBounds() {
        int n;
        Object outputRectangle;
        Object object;
        Rectangle inputBounds = this.input.calculateBounds();
        EditorCellOutputsView currentOutputs = this.outputs;
        Object object2 = currentOutputs;
        if (object2 != null && (object2 = ((EditorCellOutputsView)object2).calculateBounds()) != null) {
            Object object3;
            Object it = object3 = object2;
            boolean bl = false;
            object = !((Rectangle)it).isEmpty() ? object3 : null;
        } else {
            object = null;
        }
        Object object4 = outputRectangle = object;
        if (object4 != null) {
            Object it = object4;
            boolean bl = false;
            n = ((Rectangle)it).height + ((Rectangle)it).y - inputBounds.y;
        } else {
            n = inputBounds.height;
        }
        int height = n;
        return new Rectangle(0, inputBounds.y, this.editor.getContentSize().width, height);
    }

    /*
     * WARNING - void declaration
     */
    public final void addDropHighlightIfApplicable() {
        block1: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.getControllers();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DropHighlightable)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            DropHighlightable dropHighlightable = (DropHighlightable)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (dropHighlightable == null) break block1;
            dropHighlightable.addDropHighlight();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeDropHighlightIfPresent() {
        block1: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.getControllers();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DropHighlightable)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            DropHighlightable dropHighlightable = (DropHighlightable)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (dropHighlightable == null) break block1;
            dropHighlightable.removeDropHighlight();
        }
    }

    private static final List controllers_delegate$lambda$1(EditorCellView this$0) {
        return SelfManagedControllerFactory.Companion.createControllers(this$0);
    }

    private static final Unit _init_$lambda$2(EditorCellView this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateInput();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(EditorCellView this$0, boolean it) {
        this$0.updateFolding();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(EditorCellView this$0, boolean it) {
        this$0.updateHovered();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit updateOutputs$lambda$8(EditorCellView this$0) {
        block2: {
            block0: {
                block1: {
                    void it;
                    EditorCellOutputsView editorCellOutputsView;
                    if (!this$0.hasOutputs()) break block0;
                    if (this$0.outputs != null) break block1;
                    EditorCellOutputsView editorCellOutputsView2 = editorCellOutputsView = new EditorCellOutputsView(this$0.editor, this$0.cell, null, 4, null);
                    EditorCellView editorCellView = this$0;
                    boolean bl = false;
                    this$0.add((EditorCellViewComponent)it);
                    editorCellView.outputs = editorCellOutputsView;
                    this$0.updateFolding();
                    break block2;
                }
                EditorCellOutputsView editorCellOutputsView = this$0.outputs;
                if (editorCellOutputsView == null) break block2;
                editorCellOutputsView.update();
                break block2;
            }
            EditorCellOutputsView editorCellOutputsView = this$0.outputs;
            if (editorCellOutputsView == null) break block2;
            EditorCellOutputsView it = editorCellOutputsView;
            boolean bl = false;
            this$0.remove(it);
            this$0.outputs = null;
        }
        return Unit.INSTANCE;
    }
}

