/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// RequestTarget struct for RequestTarget
type RequestTarget struct {
	Target *ResourceReference `json:"target,omitempty"`
	Status *string            `json:"status,omitempty"`
}

// NewRequestTarget instantiates a new RequestTarget object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRequestTarget() *RequestTarget {
	this := RequestTarget{}

	return &this
}

// NewRequestTargetWithDefaults instantiates a new RequestTarget object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRequestTargetWithDefaults() *RequestTarget {
	this := RequestTarget{}
	return &this
}

// GetTarget returns the Target field value
// If the value is explicit nil, nil is returned
func (o *RequestTarget) GetTarget() *ResourceReference {
	if o == nil {
		return nil
	}

	return o.Target

}

// GetTargetOk returns a tuple with the Target field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RequestTarget) GetTargetOk() (*ResourceReference, bool) {
	if o == nil {
		return nil, false
	}

	return o.Target, true
}

// SetTarget sets field value
func (o *RequestTarget) SetTarget(v ResourceReference) {

	o.Target = &v

}

// HasTarget returns a boolean if a field has been set.
func (o *RequestTarget) HasTarget() bool {
	if o != nil && o.Target != nil {
		return true
	}

	return false
}

// GetStatus returns the Status field value
// If the value is explicit nil, nil is returned
func (o *RequestTarget) GetStatus() *string {
	if o == nil {
		return nil
	}

	return o.Status

}

// GetStatusOk returns a tuple with the Status field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RequestTarget) GetStatusOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Status, true
}

// SetStatus sets field value
func (o *RequestTarget) SetStatus(v string) {

	o.Status = &v

}

// HasStatus returns a boolean if a field has been set.
func (o *RequestTarget) HasStatus() bool {
	if o != nil && o.Status != nil {
		return true
	}

	return false
}

func (o RequestTarget) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Target != nil {
		toSerialize["target"] = o.Target
	}

	if o.Status != nil {
		toSerialize["status"] = o.Status
	}

	return json.Marshal(toSerialize)
}

type NullableRequestTarget struct {
	value *RequestTarget
	isSet bool
}

func (v NullableRequestTarget) Get() *RequestTarget {
	return v.value
}

func (v *NullableRequestTarget) Set(val *RequestTarget) {
	v.value = val
	v.isSet = true
}

func (v NullableRequestTarget) IsSet() bool {
	return v.isSet
}

func (v *NullableRequestTarget) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRequestTarget(val *RequestTarget) *NullableRequestTarget {
	return &NullableRequestTarget{value: val, isSet: true}
}

func (v NullableRequestTarget) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRequestTarget) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
