//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/config/filter/http/aws_request_signing/v2alpha/aws_request_signing.proto

package v2alpha

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on AwsRequestSigning with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *AwsRequestSigning) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AwsRequestSigning with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AwsRequestSigningMultiError, or nil if none found.
func (m *AwsRequestSigning) ValidateAll() error {
	return m.validate(true)
}

func (m *AwsRequestSigning) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetServiceName()) < 1 {
		err := AwsRequestSigningValidationError{
			field:  "ServiceName",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetRegion()) < 1 {
		err := AwsRequestSigningValidationError{
			field:  "Region",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for HostRewrite

	if len(errors) > 0 {
		return AwsRequestSigningMultiError(errors)
	}

	return nil
}

// AwsRequestSigningMultiError is an error wrapping multiple validation errors
// returned by AwsRequestSigning.ValidateAll() if the designated constraints
// aren't met.
type AwsRequestSigningMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AwsRequestSigningMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AwsRequestSigningMultiError) AllErrors() []error { return m }

// AwsRequestSigningValidationError is the validation error returned by
// AwsRequestSigning.Validate if the designated constraints aren't met.
type AwsRequestSigningValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AwsRequestSigningValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AwsRequestSigningValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AwsRequestSigningValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AwsRequestSigningValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AwsRequestSigningValidationError) ErrorName() string {
	return "AwsRequestSigningValidationError"
}

// Error satisfies the builtin error interface
func (e AwsRequestSigningValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAwsRequestSigning.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AwsRequestSigningValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AwsRequestSigningValidationError{}
