// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package connectcasesiface provides an interface to enable mocking the Amazon Connect Cases service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package connectcasesiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/connectcases"
)

// ConnectCasesAPI provides an interface to enable mocking the
// connectcases.ConnectCases service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Connect Cases.
//	func myFunc(svc connectcasesiface.ConnectCasesAPI) bool {
//	    // Make svc.BatchGetField request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := connectcases.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockConnectCasesClient struct {
//	    connectcasesiface.ConnectCasesAPI
//	}
//	func (m *mockConnectCasesClient) BatchGetField(input *connectcases.BatchGetFieldInput) (*connectcases.BatchGetFieldOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockConnectCasesClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ConnectCasesAPI interface {
	BatchGetField(*connectcases.BatchGetFieldInput) (*connectcases.BatchGetFieldOutput, error)
	BatchGetFieldWithContext(aws.Context, *connectcases.BatchGetFieldInput, ...request.Option) (*connectcases.BatchGetFieldOutput, error)
	BatchGetFieldRequest(*connectcases.BatchGetFieldInput) (*request.Request, *connectcases.BatchGetFieldOutput)

	BatchPutFieldOptions(*connectcases.BatchPutFieldOptionsInput) (*connectcases.BatchPutFieldOptionsOutput, error)
	BatchPutFieldOptionsWithContext(aws.Context, *connectcases.BatchPutFieldOptionsInput, ...request.Option) (*connectcases.BatchPutFieldOptionsOutput, error)
	BatchPutFieldOptionsRequest(*connectcases.BatchPutFieldOptionsInput) (*request.Request, *connectcases.BatchPutFieldOptionsOutput)

	CreateCase(*connectcases.CreateCaseInput) (*connectcases.CreateCaseOutput, error)
	CreateCaseWithContext(aws.Context, *connectcases.CreateCaseInput, ...request.Option) (*connectcases.CreateCaseOutput, error)
	CreateCaseRequest(*connectcases.CreateCaseInput) (*request.Request, *connectcases.CreateCaseOutput)

	CreateDomain(*connectcases.CreateDomainInput) (*connectcases.CreateDomainOutput, error)
	CreateDomainWithContext(aws.Context, *connectcases.CreateDomainInput, ...request.Option) (*connectcases.CreateDomainOutput, error)
	CreateDomainRequest(*connectcases.CreateDomainInput) (*request.Request, *connectcases.CreateDomainOutput)

	CreateField(*connectcases.CreateFieldInput) (*connectcases.CreateFieldOutput, error)
	CreateFieldWithContext(aws.Context, *connectcases.CreateFieldInput, ...request.Option) (*connectcases.CreateFieldOutput, error)
	CreateFieldRequest(*connectcases.CreateFieldInput) (*request.Request, *connectcases.CreateFieldOutput)

	CreateLayout(*connectcases.CreateLayoutInput) (*connectcases.CreateLayoutOutput, error)
	CreateLayoutWithContext(aws.Context, *connectcases.CreateLayoutInput, ...request.Option) (*connectcases.CreateLayoutOutput, error)
	CreateLayoutRequest(*connectcases.CreateLayoutInput) (*request.Request, *connectcases.CreateLayoutOutput)

	CreateRelatedItem(*connectcases.CreateRelatedItemInput) (*connectcases.CreateRelatedItemOutput, error)
	CreateRelatedItemWithContext(aws.Context, *connectcases.CreateRelatedItemInput, ...request.Option) (*connectcases.CreateRelatedItemOutput, error)
	CreateRelatedItemRequest(*connectcases.CreateRelatedItemInput) (*request.Request, *connectcases.CreateRelatedItemOutput)

	CreateTemplate(*connectcases.CreateTemplateInput) (*connectcases.CreateTemplateOutput, error)
	CreateTemplateWithContext(aws.Context, *connectcases.CreateTemplateInput, ...request.Option) (*connectcases.CreateTemplateOutput, error)
	CreateTemplateRequest(*connectcases.CreateTemplateInput) (*request.Request, *connectcases.CreateTemplateOutput)

	DeleteDomain(*connectcases.DeleteDomainInput) (*connectcases.DeleteDomainOutput, error)
	DeleteDomainWithContext(aws.Context, *connectcases.DeleteDomainInput, ...request.Option) (*connectcases.DeleteDomainOutput, error)
	DeleteDomainRequest(*connectcases.DeleteDomainInput) (*request.Request, *connectcases.DeleteDomainOutput)

	DeleteField(*connectcases.DeleteFieldInput) (*connectcases.DeleteFieldOutput, error)
	DeleteFieldWithContext(aws.Context, *connectcases.DeleteFieldInput, ...request.Option) (*connectcases.DeleteFieldOutput, error)
	DeleteFieldRequest(*connectcases.DeleteFieldInput) (*request.Request, *connectcases.DeleteFieldOutput)

	DeleteLayout(*connectcases.DeleteLayoutInput) (*connectcases.DeleteLayoutOutput, error)
	DeleteLayoutWithContext(aws.Context, *connectcases.DeleteLayoutInput, ...request.Option) (*connectcases.DeleteLayoutOutput, error)
	DeleteLayoutRequest(*connectcases.DeleteLayoutInput) (*request.Request, *connectcases.DeleteLayoutOutput)

	DeleteTemplate(*connectcases.DeleteTemplateInput) (*connectcases.DeleteTemplateOutput, error)
	DeleteTemplateWithContext(aws.Context, *connectcases.DeleteTemplateInput, ...request.Option) (*connectcases.DeleteTemplateOutput, error)
	DeleteTemplateRequest(*connectcases.DeleteTemplateInput) (*request.Request, *connectcases.DeleteTemplateOutput)

	GetCase(*connectcases.GetCaseInput) (*connectcases.GetCaseOutput, error)
	GetCaseWithContext(aws.Context, *connectcases.GetCaseInput, ...request.Option) (*connectcases.GetCaseOutput, error)
	GetCaseRequest(*connectcases.GetCaseInput) (*request.Request, *connectcases.GetCaseOutput)

	GetCasePages(*connectcases.GetCaseInput, func(*connectcases.GetCaseOutput, bool) bool) error
	GetCasePagesWithContext(aws.Context, *connectcases.GetCaseInput, func(*connectcases.GetCaseOutput, bool) bool, ...request.Option) error

	GetCaseAuditEvents(*connectcases.GetCaseAuditEventsInput) (*connectcases.GetCaseAuditEventsOutput, error)
	GetCaseAuditEventsWithContext(aws.Context, *connectcases.GetCaseAuditEventsInput, ...request.Option) (*connectcases.GetCaseAuditEventsOutput, error)
	GetCaseAuditEventsRequest(*connectcases.GetCaseAuditEventsInput) (*request.Request, *connectcases.GetCaseAuditEventsOutput)

	GetCaseAuditEventsPages(*connectcases.GetCaseAuditEventsInput, func(*connectcases.GetCaseAuditEventsOutput, bool) bool) error
	GetCaseAuditEventsPagesWithContext(aws.Context, *connectcases.GetCaseAuditEventsInput, func(*connectcases.GetCaseAuditEventsOutput, bool) bool, ...request.Option) error

	GetCaseEventConfiguration(*connectcases.GetCaseEventConfigurationInput) (*connectcases.GetCaseEventConfigurationOutput, error)
	GetCaseEventConfigurationWithContext(aws.Context, *connectcases.GetCaseEventConfigurationInput, ...request.Option) (*connectcases.GetCaseEventConfigurationOutput, error)
	GetCaseEventConfigurationRequest(*connectcases.GetCaseEventConfigurationInput) (*request.Request, *connectcases.GetCaseEventConfigurationOutput)

	GetDomain(*connectcases.GetDomainInput) (*connectcases.GetDomainOutput, error)
	GetDomainWithContext(aws.Context, *connectcases.GetDomainInput, ...request.Option) (*connectcases.GetDomainOutput, error)
	GetDomainRequest(*connectcases.GetDomainInput) (*request.Request, *connectcases.GetDomainOutput)

	GetLayout(*connectcases.GetLayoutInput) (*connectcases.GetLayoutOutput, error)
	GetLayoutWithContext(aws.Context, *connectcases.GetLayoutInput, ...request.Option) (*connectcases.GetLayoutOutput, error)
	GetLayoutRequest(*connectcases.GetLayoutInput) (*request.Request, *connectcases.GetLayoutOutput)

	GetTemplate(*connectcases.GetTemplateInput) (*connectcases.GetTemplateOutput, error)
	GetTemplateWithContext(aws.Context, *connectcases.GetTemplateInput, ...request.Option) (*connectcases.GetTemplateOutput, error)
	GetTemplateRequest(*connectcases.GetTemplateInput) (*request.Request, *connectcases.GetTemplateOutput)

	ListCasesForContact(*connectcases.ListCasesForContactInput) (*connectcases.ListCasesForContactOutput, error)
	ListCasesForContactWithContext(aws.Context, *connectcases.ListCasesForContactInput, ...request.Option) (*connectcases.ListCasesForContactOutput, error)
	ListCasesForContactRequest(*connectcases.ListCasesForContactInput) (*request.Request, *connectcases.ListCasesForContactOutput)

	ListCasesForContactPages(*connectcases.ListCasesForContactInput, func(*connectcases.ListCasesForContactOutput, bool) bool) error
	ListCasesForContactPagesWithContext(aws.Context, *connectcases.ListCasesForContactInput, func(*connectcases.ListCasesForContactOutput, bool) bool, ...request.Option) error

	ListDomains(*connectcases.ListDomainsInput) (*connectcases.ListDomainsOutput, error)
	ListDomainsWithContext(aws.Context, *connectcases.ListDomainsInput, ...request.Option) (*connectcases.ListDomainsOutput, error)
	ListDomainsRequest(*connectcases.ListDomainsInput) (*request.Request, *connectcases.ListDomainsOutput)

	ListDomainsPages(*connectcases.ListDomainsInput, func(*connectcases.ListDomainsOutput, bool) bool) error
	ListDomainsPagesWithContext(aws.Context, *connectcases.ListDomainsInput, func(*connectcases.ListDomainsOutput, bool) bool, ...request.Option) error

	ListFieldOptions(*connectcases.ListFieldOptionsInput) (*connectcases.ListFieldOptionsOutput, error)
	ListFieldOptionsWithContext(aws.Context, *connectcases.ListFieldOptionsInput, ...request.Option) (*connectcases.ListFieldOptionsOutput, error)
	ListFieldOptionsRequest(*connectcases.ListFieldOptionsInput) (*request.Request, *connectcases.ListFieldOptionsOutput)

	ListFieldOptionsPages(*connectcases.ListFieldOptionsInput, func(*connectcases.ListFieldOptionsOutput, bool) bool) error
	ListFieldOptionsPagesWithContext(aws.Context, *connectcases.ListFieldOptionsInput, func(*connectcases.ListFieldOptionsOutput, bool) bool, ...request.Option) error

	ListFields(*connectcases.ListFieldsInput) (*connectcases.ListFieldsOutput, error)
	ListFieldsWithContext(aws.Context, *connectcases.ListFieldsInput, ...request.Option) (*connectcases.ListFieldsOutput, error)
	ListFieldsRequest(*connectcases.ListFieldsInput) (*request.Request, *connectcases.ListFieldsOutput)

	ListFieldsPages(*connectcases.ListFieldsInput, func(*connectcases.ListFieldsOutput, bool) bool) error
	ListFieldsPagesWithContext(aws.Context, *connectcases.ListFieldsInput, func(*connectcases.ListFieldsOutput, bool) bool, ...request.Option) error

	ListLayouts(*connectcases.ListLayoutsInput) (*connectcases.ListLayoutsOutput, error)
	ListLayoutsWithContext(aws.Context, *connectcases.ListLayoutsInput, ...request.Option) (*connectcases.ListLayoutsOutput, error)
	ListLayoutsRequest(*connectcases.ListLayoutsInput) (*request.Request, *connectcases.ListLayoutsOutput)

	ListLayoutsPages(*connectcases.ListLayoutsInput, func(*connectcases.ListLayoutsOutput, bool) bool) error
	ListLayoutsPagesWithContext(aws.Context, *connectcases.ListLayoutsInput, func(*connectcases.ListLayoutsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*connectcases.ListTagsForResourceInput) (*connectcases.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *connectcases.ListTagsForResourceInput, ...request.Option) (*connectcases.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*connectcases.ListTagsForResourceInput) (*request.Request, *connectcases.ListTagsForResourceOutput)

	ListTemplates(*connectcases.ListTemplatesInput) (*connectcases.ListTemplatesOutput, error)
	ListTemplatesWithContext(aws.Context, *connectcases.ListTemplatesInput, ...request.Option) (*connectcases.ListTemplatesOutput, error)
	ListTemplatesRequest(*connectcases.ListTemplatesInput) (*request.Request, *connectcases.ListTemplatesOutput)

	ListTemplatesPages(*connectcases.ListTemplatesInput, func(*connectcases.ListTemplatesOutput, bool) bool) error
	ListTemplatesPagesWithContext(aws.Context, *connectcases.ListTemplatesInput, func(*connectcases.ListTemplatesOutput, bool) bool, ...request.Option) error

	PutCaseEventConfiguration(*connectcases.PutCaseEventConfigurationInput) (*connectcases.PutCaseEventConfigurationOutput, error)
	PutCaseEventConfigurationWithContext(aws.Context, *connectcases.PutCaseEventConfigurationInput, ...request.Option) (*connectcases.PutCaseEventConfigurationOutput, error)
	PutCaseEventConfigurationRequest(*connectcases.PutCaseEventConfigurationInput) (*request.Request, *connectcases.PutCaseEventConfigurationOutput)

	SearchCases(*connectcases.SearchCasesInput) (*connectcases.SearchCasesOutput, error)
	SearchCasesWithContext(aws.Context, *connectcases.SearchCasesInput, ...request.Option) (*connectcases.SearchCasesOutput, error)
	SearchCasesRequest(*connectcases.SearchCasesInput) (*request.Request, *connectcases.SearchCasesOutput)

	SearchCasesPages(*connectcases.SearchCasesInput, func(*connectcases.SearchCasesOutput, bool) bool) error
	SearchCasesPagesWithContext(aws.Context, *connectcases.SearchCasesInput, func(*connectcases.SearchCasesOutput, bool) bool, ...request.Option) error

	SearchRelatedItems(*connectcases.SearchRelatedItemsInput) (*connectcases.SearchRelatedItemsOutput, error)
	SearchRelatedItemsWithContext(aws.Context, *connectcases.SearchRelatedItemsInput, ...request.Option) (*connectcases.SearchRelatedItemsOutput, error)
	SearchRelatedItemsRequest(*connectcases.SearchRelatedItemsInput) (*request.Request, *connectcases.SearchRelatedItemsOutput)

	SearchRelatedItemsPages(*connectcases.SearchRelatedItemsInput, func(*connectcases.SearchRelatedItemsOutput, bool) bool) error
	SearchRelatedItemsPagesWithContext(aws.Context, *connectcases.SearchRelatedItemsInput, func(*connectcases.SearchRelatedItemsOutput, bool) bool, ...request.Option) error

	TagResource(*connectcases.TagResourceInput) (*connectcases.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *connectcases.TagResourceInput, ...request.Option) (*connectcases.TagResourceOutput, error)
	TagResourceRequest(*connectcases.TagResourceInput) (*request.Request, *connectcases.TagResourceOutput)

	UntagResource(*connectcases.UntagResourceInput) (*connectcases.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *connectcases.UntagResourceInput, ...request.Option) (*connectcases.UntagResourceOutput, error)
	UntagResourceRequest(*connectcases.UntagResourceInput) (*request.Request, *connectcases.UntagResourceOutput)

	UpdateCase(*connectcases.UpdateCaseInput) (*connectcases.UpdateCaseOutput, error)
	UpdateCaseWithContext(aws.Context, *connectcases.UpdateCaseInput, ...request.Option) (*connectcases.UpdateCaseOutput, error)
	UpdateCaseRequest(*connectcases.UpdateCaseInput) (*request.Request, *connectcases.UpdateCaseOutput)

	UpdateField(*connectcases.UpdateFieldInput) (*connectcases.UpdateFieldOutput, error)
	UpdateFieldWithContext(aws.Context, *connectcases.UpdateFieldInput, ...request.Option) (*connectcases.UpdateFieldOutput, error)
	UpdateFieldRequest(*connectcases.UpdateFieldInput) (*request.Request, *connectcases.UpdateFieldOutput)

	UpdateLayout(*connectcases.UpdateLayoutInput) (*connectcases.UpdateLayoutOutput, error)
	UpdateLayoutWithContext(aws.Context, *connectcases.UpdateLayoutInput, ...request.Option) (*connectcases.UpdateLayoutOutput, error)
	UpdateLayoutRequest(*connectcases.UpdateLayoutInput) (*request.Request, *connectcases.UpdateLayoutOutput)

	UpdateTemplate(*connectcases.UpdateTemplateInput) (*connectcases.UpdateTemplateOutput, error)
	UpdateTemplateWithContext(aws.Context, *connectcases.UpdateTemplateInput, ...request.Option) (*connectcases.UpdateTemplateOutput, error)
	UpdateTemplateRequest(*connectcases.UpdateTemplateInput) (*request.Request, *connectcases.UpdateTemplateOutput)
}

var _ ConnectCasesAPI = (*connectcases.ConnectCases)(nil)
