// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wellarchitected

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateLenses = "AssociateLenses"

// AssociateLensesRequest generates a "aws/request.Request" representing the
// client's request for the AssociateLenses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateLenses for more information on using the AssociateLenses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateLensesRequest method.
//	req, resp := client.AssociateLensesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/AssociateLenses
func (c *WellArchitected) AssociateLensesRequest(input *AssociateLensesInput) (req *request.Request, output *AssociateLensesOutput) {
	op := &request.Operation{
		Name:       opAssociateLenses,
		HTTPMethod: "PATCH",
		HTTPPath:   "/workloads/{WorkloadId}/associateLenses",
	}

	if input == nil {
		input = &AssociateLensesInput{}
	}

	output = &AssociateLensesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateLenses API operation for AWS Well-Architected Tool.
//
// Associate a lens to a workload.
//
// Up to 10 lenses can be associated with a workload in a single API operation.
// A maximum of 20 lenses can be associated with a workload.
//
// # Disclaimer
//
// By accessing and/or applying custom lenses created by another Amazon Web
// Services user or account, you acknowledge that custom lenses created by other
// users and shared with you are Third Party Content as defined in the Amazon
// Web Services Customer Agreement.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation AssociateLenses for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/AssociateLenses
func (c *WellArchitected) AssociateLenses(input *AssociateLensesInput) (*AssociateLensesOutput, error) {
	req, out := c.AssociateLensesRequest(input)
	return out, req.Send()
}

// AssociateLensesWithContext is the same as AssociateLenses with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateLenses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) AssociateLensesWithContext(ctx aws.Context, input *AssociateLensesInput, opts ...request.Option) (*AssociateLensesOutput, error) {
	req, out := c.AssociateLensesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateProfiles = "AssociateProfiles"

// AssociateProfilesRequest generates a "aws/request.Request" representing the
// client's request for the AssociateProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateProfiles for more information on using the AssociateProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateProfilesRequest method.
//	req, resp := client.AssociateProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/AssociateProfiles
func (c *WellArchitected) AssociateProfilesRequest(input *AssociateProfilesInput) (req *request.Request, output *AssociateProfilesOutput) {
	op := &request.Operation{
		Name:       opAssociateProfiles,
		HTTPMethod: "PATCH",
		HTTPPath:   "/workloads/{WorkloadId}/associateProfiles",
	}

	if input == nil {
		input = &AssociateProfilesInput{}
	}

	output = &AssociateProfilesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateProfiles API operation for AWS Well-Architected Tool.
//
// Associate a profile with a workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation AssociateProfiles for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/AssociateProfiles
func (c *WellArchitected) AssociateProfiles(input *AssociateProfilesInput) (*AssociateProfilesOutput, error) {
	req, out := c.AssociateProfilesRequest(input)
	return out, req.Send()
}

// AssociateProfilesWithContext is the same as AssociateProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) AssociateProfilesWithContext(ctx aws.Context, input *AssociateProfilesInput, opts ...request.Option) (*AssociateProfilesOutput, error) {
	req, out := c.AssociateProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLensShare = "CreateLensShare"

// CreateLensShareRequest generates a "aws/request.Request" representing the
// client's request for the CreateLensShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLensShare for more information on using the CreateLensShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLensShareRequest method.
//	req, resp := client.CreateLensShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateLensShare
func (c *WellArchitected) CreateLensShareRequest(input *CreateLensShareInput) (req *request.Request, output *CreateLensShareOutput) {
	op := &request.Operation{
		Name:       opCreateLensShare,
		HTTPMethod: "POST",
		HTTPPath:   "/lenses/{LensAlias}/shares",
	}

	if input == nil {
		input = &CreateLensShareInput{}
	}

	output = &CreateLensShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLensShare API operation for AWS Well-Architected Tool.
//
// Create a lens share.
//
// The owner of a lens can share it with other Amazon Web Services accounts,
// users, an organization, and organizational units (OUs) in the same Amazon
// Web Services Region. Lenses provided by Amazon Web Services (Amazon Web Services
// Official Content) cannot be shared.
//
// Shared access to a lens is not removed until the lens invitation is deleted.
//
// If you share a lens with an organization or OU, all accounts in the organization
// or OU are granted access to the lens.
//
// For more information, see Sharing a custom lens (https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-sharing.html)
// in the Well-Architected Tool User Guide.
//
// # Disclaimer
//
// By sharing your custom lenses with other Amazon Web Services accounts, you
// acknowledge that Amazon Web Services will make your custom lenses available
// to those other accounts. Those other accounts may continue to access and
// use your shared custom lenses even if you delete the custom lenses from your
// own Amazon Web Services account or terminate your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation CreateLensShare for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ServiceQuotaExceededException
//     The user has reached their resource quota.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateLensShare
func (c *WellArchitected) CreateLensShare(input *CreateLensShareInput) (*CreateLensShareOutput, error) {
	req, out := c.CreateLensShareRequest(input)
	return out, req.Send()
}

// CreateLensShareWithContext is the same as CreateLensShare with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLensShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) CreateLensShareWithContext(ctx aws.Context, input *CreateLensShareInput, opts ...request.Option) (*CreateLensShareOutput, error) {
	req, out := c.CreateLensShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLensVersion = "CreateLensVersion"

// CreateLensVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateLensVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLensVersion for more information on using the CreateLensVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLensVersionRequest method.
//	req, resp := client.CreateLensVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateLensVersion
func (c *WellArchitected) CreateLensVersionRequest(input *CreateLensVersionInput) (req *request.Request, output *CreateLensVersionOutput) {
	op := &request.Operation{
		Name:       opCreateLensVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/lenses/{LensAlias}/versions",
	}

	if input == nil {
		input = &CreateLensVersionInput{}
	}

	output = &CreateLensVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLensVersion API operation for AWS Well-Architected Tool.
//
// Create a new lens version.
//
// A lens can have up to 100 versions.
//
// Use this operation to publish a new lens version after you have imported
// a lens. The LensAlias is used to identify the lens to be published. The owner
// of a lens can share the lens with other Amazon Web Services accounts and
// users in the same Amazon Web Services Region. Only the owner of a lens can
// delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation CreateLensVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ServiceQuotaExceededException
//     The user has reached their resource quota.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateLensVersion
func (c *WellArchitected) CreateLensVersion(input *CreateLensVersionInput) (*CreateLensVersionOutput, error) {
	req, out := c.CreateLensVersionRequest(input)
	return out, req.Send()
}

// CreateLensVersionWithContext is the same as CreateLensVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLensVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) CreateLensVersionWithContext(ctx aws.Context, input *CreateLensVersionInput, opts ...request.Option) (*CreateLensVersionOutput, error) {
	req, out := c.CreateLensVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMilestone = "CreateMilestone"

// CreateMilestoneRequest generates a "aws/request.Request" representing the
// client's request for the CreateMilestone operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMilestone for more information on using the CreateMilestone
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMilestoneRequest method.
//	req, resp := client.CreateMilestoneRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateMilestone
func (c *WellArchitected) CreateMilestoneRequest(input *CreateMilestoneInput) (req *request.Request, output *CreateMilestoneOutput) {
	op := &request.Operation{
		Name:       opCreateMilestone,
		HTTPMethod: "POST",
		HTTPPath:   "/workloads/{WorkloadId}/milestones",
	}

	if input == nil {
		input = &CreateMilestoneInput{}
	}

	output = &CreateMilestoneOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMilestone API operation for AWS Well-Architected Tool.
//
// Create a milestone for an existing workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation CreateMilestone for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ServiceQuotaExceededException
//     The user has reached their resource quota.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateMilestone
func (c *WellArchitected) CreateMilestone(input *CreateMilestoneInput) (*CreateMilestoneOutput, error) {
	req, out := c.CreateMilestoneRequest(input)
	return out, req.Send()
}

// CreateMilestoneWithContext is the same as CreateMilestone with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMilestone for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) CreateMilestoneWithContext(ctx aws.Context, input *CreateMilestoneInput, opts ...request.Option) (*CreateMilestoneOutput, error) {
	req, out := c.CreateMilestoneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProfile = "CreateProfile"

// CreateProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProfile for more information on using the CreateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProfileRequest method.
//	req, resp := client.CreateProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateProfile
func (c *WellArchitected) CreateProfileRequest(input *CreateProfileInput) (req *request.Request, output *CreateProfileOutput) {
	op := &request.Operation{
		Name:       opCreateProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/profiles",
	}

	if input == nil {
		input = &CreateProfileInput{}
	}

	output = &CreateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProfile API operation for AWS Well-Architected Tool.
//
// Create a profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation CreateProfile for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - ServiceQuotaExceededException
//     The user has reached their resource quota.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateProfile
func (c *WellArchitected) CreateProfile(input *CreateProfileInput) (*CreateProfileOutput, error) {
	req, out := c.CreateProfileRequest(input)
	return out, req.Send()
}

// CreateProfileWithContext is the same as CreateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) CreateProfileWithContext(ctx aws.Context, input *CreateProfileInput, opts ...request.Option) (*CreateProfileOutput, error) {
	req, out := c.CreateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProfileShare = "CreateProfileShare"

// CreateProfileShareRequest generates a "aws/request.Request" representing the
// client's request for the CreateProfileShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProfileShare for more information on using the CreateProfileShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProfileShareRequest method.
//	req, resp := client.CreateProfileShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateProfileShare
func (c *WellArchitected) CreateProfileShareRequest(input *CreateProfileShareInput) (req *request.Request, output *CreateProfileShareOutput) {
	op := &request.Operation{
		Name:       opCreateProfileShare,
		HTTPMethod: "POST",
		HTTPPath:   "/profiles/{ProfileArn}/shares",
	}

	if input == nil {
		input = &CreateProfileShareInput{}
	}

	output = &CreateProfileShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProfileShare API operation for AWS Well-Architected Tool.
//
// Create a profile share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation CreateProfileShare for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ServiceQuotaExceededException
//     The user has reached their resource quota.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateProfileShare
func (c *WellArchitected) CreateProfileShare(input *CreateProfileShareInput) (*CreateProfileShareOutput, error) {
	req, out := c.CreateProfileShareRequest(input)
	return out, req.Send()
}

// CreateProfileShareWithContext is the same as CreateProfileShare with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProfileShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) CreateProfileShareWithContext(ctx aws.Context, input *CreateProfileShareInput, opts ...request.Option) (*CreateProfileShareOutput, error) {
	req, out := c.CreateProfileShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReviewTemplate = "CreateReviewTemplate"

// CreateReviewTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateReviewTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReviewTemplate for more information on using the CreateReviewTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateReviewTemplateRequest method.
//	req, resp := client.CreateReviewTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateReviewTemplate
func (c *WellArchitected) CreateReviewTemplateRequest(input *CreateReviewTemplateInput) (req *request.Request, output *CreateReviewTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateReviewTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/reviewTemplates",
	}

	if input == nil {
		input = &CreateReviewTemplateInput{}
	}

	output = &CreateReviewTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReviewTemplate API operation for AWS Well-Architected Tool.
//
// Create a review template.
//
// # Disclaimer
//
// Do not include or gather personal identifiable information (PII) of end users
// or other identifiable individuals in or via your review templates. If your
// review template or those shared with you and used in your account do include
// or collect PII you are responsible for: ensuring that the included PII is
// processed in accordance with applicable law, providing adequate privacy notices,
// and obtaining necessary consents for processing such data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation CreateReviewTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - ServiceQuotaExceededException
//     The user has reached their resource quota.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateReviewTemplate
func (c *WellArchitected) CreateReviewTemplate(input *CreateReviewTemplateInput) (*CreateReviewTemplateOutput, error) {
	req, out := c.CreateReviewTemplateRequest(input)
	return out, req.Send()
}

// CreateReviewTemplateWithContext is the same as CreateReviewTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReviewTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) CreateReviewTemplateWithContext(ctx aws.Context, input *CreateReviewTemplateInput, opts ...request.Option) (*CreateReviewTemplateOutput, error) {
	req, out := c.CreateReviewTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTemplateShare = "CreateTemplateShare"

// CreateTemplateShareRequest generates a "aws/request.Request" representing the
// client's request for the CreateTemplateShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTemplateShare for more information on using the CreateTemplateShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTemplateShareRequest method.
//	req, resp := client.CreateTemplateShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateTemplateShare
func (c *WellArchitected) CreateTemplateShareRequest(input *CreateTemplateShareInput) (req *request.Request, output *CreateTemplateShareOutput) {
	op := &request.Operation{
		Name:       opCreateTemplateShare,
		HTTPMethod: "POST",
		HTTPPath:   "/templates/shares/{TemplateArn}",
	}

	if input == nil {
		input = &CreateTemplateShareInput{}
	}

	output = &CreateTemplateShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTemplateShare API operation for AWS Well-Architected Tool.
//
// Create a review template share.
//
// The owner of a review template can share it with other Amazon Web Services
// accounts, users, an organization, and organizational units (OUs) in the same
// Amazon Web Services Region.
//
// Shared access to a review template is not removed until the review template
// share invitation is deleted.
//
// If you share a review template with an organization or OU, all accounts in
// the organization or OU are granted access to the review template.
//
// # Disclaimer
//
// By sharing your review template with other Amazon Web Services accounts,
// you acknowledge that Amazon Web Services will make your review template available
// to those other accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation CreateTemplateShare for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ServiceQuotaExceededException
//     The user has reached their resource quota.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateTemplateShare
func (c *WellArchitected) CreateTemplateShare(input *CreateTemplateShareInput) (*CreateTemplateShareOutput, error) {
	req, out := c.CreateTemplateShareRequest(input)
	return out, req.Send()
}

// CreateTemplateShareWithContext is the same as CreateTemplateShare with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTemplateShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) CreateTemplateShareWithContext(ctx aws.Context, input *CreateTemplateShareInput, opts ...request.Option) (*CreateTemplateShareOutput, error) {
	req, out := c.CreateTemplateShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkload = "CreateWorkload"

// CreateWorkloadRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkload for more information on using the CreateWorkload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkloadRequest method.
//	req, resp := client.CreateWorkloadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateWorkload
func (c *WellArchitected) CreateWorkloadRequest(input *CreateWorkloadInput) (req *request.Request, output *CreateWorkloadOutput) {
	op := &request.Operation{
		Name:       opCreateWorkload,
		HTTPMethod: "POST",
		HTTPPath:   "/workloads",
	}

	if input == nil {
		input = &CreateWorkloadInput{}
	}

	output = &CreateWorkloadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkload API operation for AWS Well-Architected Tool.
//
// Create a new workload.
//
// The owner of a workload can share the workload with other Amazon Web Services
// accounts, users, an organization, and organizational units (OUs) in the same
// Amazon Web Services Region. Only the owner of a workload can delete it.
//
// For more information, see Defining a Workload (https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html)
// in the Well-Architected Tool User Guide.
//
// Either AwsRegions, NonAwsRegions, or both must be specified when creating
// a workload.
//
// You also must specify ReviewOwner, even though the parameter is listed as
// not being required in the following section.
//
// When creating a workload using a review template, you must have the following
// IAM permissions:
//
//   - wellarchitected:GetReviewTemplate
//
//   - wellarchitected:GetReviewTemplateAnswer
//
//   - wellarchitected:ListReviewTemplateAnswers
//
//   - wellarchitected:GetReviewTemplateLensReview
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation CreateWorkload for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - ServiceQuotaExceededException
//     The user has reached their resource quota.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateWorkload
func (c *WellArchitected) CreateWorkload(input *CreateWorkloadInput) (*CreateWorkloadOutput, error) {
	req, out := c.CreateWorkloadRequest(input)
	return out, req.Send()
}

// CreateWorkloadWithContext is the same as CreateWorkload with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) CreateWorkloadWithContext(ctx aws.Context, input *CreateWorkloadInput, opts ...request.Option) (*CreateWorkloadOutput, error) {
	req, out := c.CreateWorkloadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkloadShare = "CreateWorkloadShare"

// CreateWorkloadShareRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkloadShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkloadShare for more information on using the CreateWorkloadShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkloadShareRequest method.
//	req, resp := client.CreateWorkloadShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateWorkloadShare
func (c *WellArchitected) CreateWorkloadShareRequest(input *CreateWorkloadShareInput) (req *request.Request, output *CreateWorkloadShareOutput) {
	op := &request.Operation{
		Name:       opCreateWorkloadShare,
		HTTPMethod: "POST",
		HTTPPath:   "/workloads/{WorkloadId}/shares",
	}

	if input == nil {
		input = &CreateWorkloadShareInput{}
	}

	output = &CreateWorkloadShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkloadShare API operation for AWS Well-Architected Tool.
//
// Create a workload share.
//
// The owner of a workload can share it with other Amazon Web Services accounts
// and users in the same Amazon Web Services Region. Shared access to a workload
// is not removed until the workload invitation is deleted.
//
// If you share a workload with an organization or OU, all accounts in the organization
// or OU are granted access to the workload.
//
// For more information, see Sharing a workload (https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html)
// in the Well-Architected Tool User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation CreateWorkloadShare for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ServiceQuotaExceededException
//     The user has reached their resource quota.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateWorkloadShare
func (c *WellArchitected) CreateWorkloadShare(input *CreateWorkloadShareInput) (*CreateWorkloadShareOutput, error) {
	req, out := c.CreateWorkloadShareRequest(input)
	return out, req.Send()
}

// CreateWorkloadShareWithContext is the same as CreateWorkloadShare with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkloadShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) CreateWorkloadShareWithContext(ctx aws.Context, input *CreateWorkloadShareInput, opts ...request.Option) (*CreateWorkloadShareOutput, error) {
	req, out := c.CreateWorkloadShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLens = "DeleteLens"

// DeleteLensRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLens operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLens for more information on using the DeleteLens
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLensRequest method.
//	req, resp := client.DeleteLensRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteLens
func (c *WellArchitected) DeleteLensRequest(input *DeleteLensInput) (req *request.Request, output *DeleteLensOutput) {
	op := &request.Operation{
		Name:       opDeleteLens,
		HTTPMethod: "DELETE",
		HTTPPath:   "/lenses/{LensAlias}",
	}

	if input == nil {
		input = &DeleteLensInput{}
	}

	output = &DeleteLensOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLens API operation for AWS Well-Architected Tool.
//
// Delete an existing lens.
//
// Only the owner of a lens can delete it. After the lens is deleted, Amazon
// Web Services accounts and users that you shared the lens with can continue
// to use it, but they will no longer be able to apply it to new workloads.
//
// # Disclaimer
//
// By sharing your custom lenses with other Amazon Web Services accounts, you
// acknowledge that Amazon Web Services will make your custom lenses available
// to those other accounts. Those other accounts may continue to access and
// use your shared custom lenses even if you delete the custom lenses from your
// own Amazon Web Services account or terminate your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation DeleteLens for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteLens
func (c *WellArchitected) DeleteLens(input *DeleteLensInput) (*DeleteLensOutput, error) {
	req, out := c.DeleteLensRequest(input)
	return out, req.Send()
}

// DeleteLensWithContext is the same as DeleteLens with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLens for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) DeleteLensWithContext(ctx aws.Context, input *DeleteLensInput, opts ...request.Option) (*DeleteLensOutput, error) {
	req, out := c.DeleteLensRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLensShare = "DeleteLensShare"

// DeleteLensShareRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLensShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLensShare for more information on using the DeleteLensShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLensShareRequest method.
//	req, resp := client.DeleteLensShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteLensShare
func (c *WellArchitected) DeleteLensShareRequest(input *DeleteLensShareInput) (req *request.Request, output *DeleteLensShareOutput) {
	op := &request.Operation{
		Name:       opDeleteLensShare,
		HTTPMethod: "DELETE",
		HTTPPath:   "/lenses/{LensAlias}/shares/{ShareId}",
	}

	if input == nil {
		input = &DeleteLensShareInput{}
	}

	output = &DeleteLensShareOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLensShare API operation for AWS Well-Architected Tool.
//
// Delete a lens share.
//
// After the lens share is deleted, Amazon Web Services accounts, users, organizations,
// and organizational units (OUs) that you shared the lens with can continue
// to use it, but they will no longer be able to apply it to new workloads.
//
// # Disclaimer
//
// By sharing your custom lenses with other Amazon Web Services accounts, you
// acknowledge that Amazon Web Services will make your custom lenses available
// to those other accounts. Those other accounts may continue to access and
// use your shared custom lenses even if you delete the custom lenses from your
// own Amazon Web Services account or terminate your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation DeleteLensShare for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteLensShare
func (c *WellArchitected) DeleteLensShare(input *DeleteLensShareInput) (*DeleteLensShareOutput, error) {
	req, out := c.DeleteLensShareRequest(input)
	return out, req.Send()
}

// DeleteLensShareWithContext is the same as DeleteLensShare with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLensShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) DeleteLensShareWithContext(ctx aws.Context, input *DeleteLensShareInput, opts ...request.Option) (*DeleteLensShareOutput, error) {
	req, out := c.DeleteLensShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProfile = "DeleteProfile"

// DeleteProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProfile for more information on using the DeleteProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProfileRequest method.
//	req, resp := client.DeleteProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteProfile
func (c *WellArchitected) DeleteProfileRequest(input *DeleteProfileInput) (req *request.Request, output *DeleteProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/profiles/{ProfileArn}",
	}

	if input == nil {
		input = &DeleteProfileInput{}
	}

	output = &DeleteProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProfile API operation for AWS Well-Architected Tool.
//
// Delete a profile.
//
// # Disclaimer
//
// By sharing your profile with other Amazon Web Services accounts, you acknowledge
// that Amazon Web Services will make your profile available to those other
// accounts. Those other accounts may continue to access and use your shared
// profile even if you delete the profile from your own Amazon Web Services
// account or terminate your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation DeleteProfile for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteProfile
func (c *WellArchitected) DeleteProfile(input *DeleteProfileInput) (*DeleteProfileOutput, error) {
	req, out := c.DeleteProfileRequest(input)
	return out, req.Send()
}

// DeleteProfileWithContext is the same as DeleteProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) DeleteProfileWithContext(ctx aws.Context, input *DeleteProfileInput, opts ...request.Option) (*DeleteProfileOutput, error) {
	req, out := c.DeleteProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProfileShare = "DeleteProfileShare"

// DeleteProfileShareRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProfileShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProfileShare for more information on using the DeleteProfileShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProfileShareRequest method.
//	req, resp := client.DeleteProfileShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteProfileShare
func (c *WellArchitected) DeleteProfileShareRequest(input *DeleteProfileShareInput) (req *request.Request, output *DeleteProfileShareOutput) {
	op := &request.Operation{
		Name:       opDeleteProfileShare,
		HTTPMethod: "DELETE",
		HTTPPath:   "/profiles/{ProfileArn}/shares/{ShareId}",
	}

	if input == nil {
		input = &DeleteProfileShareInput{}
	}

	output = &DeleteProfileShareOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProfileShare API operation for AWS Well-Architected Tool.
//
// Delete a profile share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation DeleteProfileShare for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteProfileShare
func (c *WellArchitected) DeleteProfileShare(input *DeleteProfileShareInput) (*DeleteProfileShareOutput, error) {
	req, out := c.DeleteProfileShareRequest(input)
	return out, req.Send()
}

// DeleteProfileShareWithContext is the same as DeleteProfileShare with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProfileShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) DeleteProfileShareWithContext(ctx aws.Context, input *DeleteProfileShareInput, opts ...request.Option) (*DeleteProfileShareOutput, error) {
	req, out := c.DeleteProfileShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReviewTemplate = "DeleteReviewTemplate"

// DeleteReviewTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReviewTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReviewTemplate for more information on using the DeleteReviewTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReviewTemplateRequest method.
//	req, resp := client.DeleteReviewTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteReviewTemplate
func (c *WellArchitected) DeleteReviewTemplateRequest(input *DeleteReviewTemplateInput) (req *request.Request, output *DeleteReviewTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteReviewTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/reviewTemplates/{TemplateArn}",
	}

	if input == nil {
		input = &DeleteReviewTemplateInput{}
	}

	output = &DeleteReviewTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteReviewTemplate API operation for AWS Well-Architected Tool.
//
// Delete a review template.
//
// Only the owner of a review template can delete it.
//
// After the review template is deleted, Amazon Web Services accounts, users,
// organizations, and organizational units (OUs) that you shared the review
// template with will no longer be able to apply it to new workloads.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation DeleteReviewTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteReviewTemplate
func (c *WellArchitected) DeleteReviewTemplate(input *DeleteReviewTemplateInput) (*DeleteReviewTemplateOutput, error) {
	req, out := c.DeleteReviewTemplateRequest(input)
	return out, req.Send()
}

// DeleteReviewTemplateWithContext is the same as DeleteReviewTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReviewTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) DeleteReviewTemplateWithContext(ctx aws.Context, input *DeleteReviewTemplateInput, opts ...request.Option) (*DeleteReviewTemplateOutput, error) {
	req, out := c.DeleteReviewTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTemplateShare = "DeleteTemplateShare"

// DeleteTemplateShareRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTemplateShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTemplateShare for more information on using the DeleteTemplateShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTemplateShareRequest method.
//	req, resp := client.DeleteTemplateShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteTemplateShare
func (c *WellArchitected) DeleteTemplateShareRequest(input *DeleteTemplateShareInput) (req *request.Request, output *DeleteTemplateShareOutput) {
	op := &request.Operation{
		Name:       opDeleteTemplateShare,
		HTTPMethod: "DELETE",
		HTTPPath:   "/templates/shares/{TemplateArn}/{ShareId}",
	}

	if input == nil {
		input = &DeleteTemplateShareInput{}
	}

	output = &DeleteTemplateShareOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTemplateShare API operation for AWS Well-Architected Tool.
//
// Delete a review template share.
//
// After the review template share is deleted, Amazon Web Services accounts,
// users, organizations, and organizational units (OUs) that you shared the
// review template with will no longer be able to apply it to new workloads.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation DeleteTemplateShare for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteTemplateShare
func (c *WellArchitected) DeleteTemplateShare(input *DeleteTemplateShareInput) (*DeleteTemplateShareOutput, error) {
	req, out := c.DeleteTemplateShareRequest(input)
	return out, req.Send()
}

// DeleteTemplateShareWithContext is the same as DeleteTemplateShare with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTemplateShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) DeleteTemplateShareWithContext(ctx aws.Context, input *DeleteTemplateShareInput, opts ...request.Option) (*DeleteTemplateShareOutput, error) {
	req, out := c.DeleteTemplateShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkload = "DeleteWorkload"

// DeleteWorkloadRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkload for more information on using the DeleteWorkload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkloadRequest method.
//	req, resp := client.DeleteWorkloadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteWorkload
func (c *WellArchitected) DeleteWorkloadRequest(input *DeleteWorkloadInput) (req *request.Request, output *DeleteWorkloadOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkload,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workloads/{WorkloadId}",
	}

	if input == nil {
		input = &DeleteWorkloadInput{}
	}

	output = &DeleteWorkloadOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkload API operation for AWS Well-Architected Tool.
//
// Delete an existing workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation DeleteWorkload for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteWorkload
func (c *WellArchitected) DeleteWorkload(input *DeleteWorkloadInput) (*DeleteWorkloadOutput, error) {
	req, out := c.DeleteWorkloadRequest(input)
	return out, req.Send()
}

// DeleteWorkloadWithContext is the same as DeleteWorkload with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) DeleteWorkloadWithContext(ctx aws.Context, input *DeleteWorkloadInput, opts ...request.Option) (*DeleteWorkloadOutput, error) {
	req, out := c.DeleteWorkloadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkloadShare = "DeleteWorkloadShare"

// DeleteWorkloadShareRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkloadShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkloadShare for more information on using the DeleteWorkloadShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkloadShareRequest method.
//	req, resp := client.DeleteWorkloadShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteWorkloadShare
func (c *WellArchitected) DeleteWorkloadShareRequest(input *DeleteWorkloadShareInput) (req *request.Request, output *DeleteWorkloadShareOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkloadShare,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workloads/{WorkloadId}/shares/{ShareId}",
	}

	if input == nil {
		input = &DeleteWorkloadShareInput{}
	}

	output = &DeleteWorkloadShareOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkloadShare API operation for AWS Well-Architected Tool.
//
// Delete a workload share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation DeleteWorkloadShare for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteWorkloadShare
func (c *WellArchitected) DeleteWorkloadShare(input *DeleteWorkloadShareInput) (*DeleteWorkloadShareOutput, error) {
	req, out := c.DeleteWorkloadShareRequest(input)
	return out, req.Send()
}

// DeleteWorkloadShareWithContext is the same as DeleteWorkloadShare with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkloadShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) DeleteWorkloadShareWithContext(ctx aws.Context, input *DeleteWorkloadShareInput, opts ...request.Option) (*DeleteWorkloadShareOutput, error) {
	req, out := c.DeleteWorkloadShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateLenses = "DisassociateLenses"

// DisassociateLensesRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateLenses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateLenses for more information on using the DisassociateLenses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateLensesRequest method.
//	req, resp := client.DisassociateLensesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DisassociateLenses
func (c *WellArchitected) DisassociateLensesRequest(input *DisassociateLensesInput) (req *request.Request, output *DisassociateLensesOutput) {
	op := &request.Operation{
		Name:       opDisassociateLenses,
		HTTPMethod: "PATCH",
		HTTPPath:   "/workloads/{WorkloadId}/disassociateLenses",
	}

	if input == nil {
		input = &DisassociateLensesInput{}
	}

	output = &DisassociateLensesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateLenses API operation for AWS Well-Architected Tool.
//
// Disassociate a lens from a workload.
//
// Up to 10 lenses can be disassociated from a workload in a single API operation.
//
// The Amazon Web Services Well-Architected Framework lens (wellarchitected)
// cannot be removed from a workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation DisassociateLenses for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DisassociateLenses
func (c *WellArchitected) DisassociateLenses(input *DisassociateLensesInput) (*DisassociateLensesOutput, error) {
	req, out := c.DisassociateLensesRequest(input)
	return out, req.Send()
}

// DisassociateLensesWithContext is the same as DisassociateLenses with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateLenses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) DisassociateLensesWithContext(ctx aws.Context, input *DisassociateLensesInput, opts ...request.Option) (*DisassociateLensesOutput, error) {
	req, out := c.DisassociateLensesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateProfiles = "DisassociateProfiles"

// DisassociateProfilesRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateProfiles for more information on using the DisassociateProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateProfilesRequest method.
//	req, resp := client.DisassociateProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DisassociateProfiles
func (c *WellArchitected) DisassociateProfilesRequest(input *DisassociateProfilesInput) (req *request.Request, output *DisassociateProfilesOutput) {
	op := &request.Operation{
		Name:       opDisassociateProfiles,
		HTTPMethod: "PATCH",
		HTTPPath:   "/workloads/{WorkloadId}/disassociateProfiles",
	}

	if input == nil {
		input = &DisassociateProfilesInput{}
	}

	output = &DisassociateProfilesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateProfiles API operation for AWS Well-Architected Tool.
//
// Disassociate a profile from a workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation DisassociateProfiles for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DisassociateProfiles
func (c *WellArchitected) DisassociateProfiles(input *DisassociateProfilesInput) (*DisassociateProfilesOutput, error) {
	req, out := c.DisassociateProfilesRequest(input)
	return out, req.Send()
}

// DisassociateProfilesWithContext is the same as DisassociateProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) DisassociateProfilesWithContext(ctx aws.Context, input *DisassociateProfilesInput, opts ...request.Option) (*DisassociateProfilesOutput, error) {
	req, out := c.DisassociateProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportLens = "ExportLens"

// ExportLensRequest generates a "aws/request.Request" representing the
// client's request for the ExportLens operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportLens for more information on using the ExportLens
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExportLensRequest method.
//	req, resp := client.ExportLensRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ExportLens
func (c *WellArchitected) ExportLensRequest(input *ExportLensInput) (req *request.Request, output *ExportLensOutput) {
	op := &request.Operation{
		Name:       opExportLens,
		HTTPMethod: "GET",
		HTTPPath:   "/lenses/{LensAlias}/export",
	}

	if input == nil {
		input = &ExportLensInput{}
	}

	output = &ExportLensOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportLens API operation for AWS Well-Architected Tool.
//
// Export an existing lens.
//
// Only the owner of a lens can export it. Lenses provided by Amazon Web Services
// (Amazon Web Services Official Content) cannot be exported.
//
// Lenses are defined in JSON. For more information, see JSON format specification
// (https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html)
// in the Well-Architected Tool User Guide.
//
// # Disclaimer
//
// Do not include or gather personal identifiable information (PII) of end users
// or other identifiable individuals in or via your custom lenses. If your custom
// lens or those shared with you and used in your account do include or collect
// PII you are responsible for: ensuring that the included PII is processed
// in accordance with applicable law, providing adequate privacy notices, and
// obtaining necessary consents for processing such data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ExportLens for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ExportLens
func (c *WellArchitected) ExportLens(input *ExportLensInput) (*ExportLensOutput, error) {
	req, out := c.ExportLensRequest(input)
	return out, req.Send()
}

// ExportLensWithContext is the same as ExportLens with the addition of
// the ability to pass a context and additional request options.
//
// See ExportLens for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ExportLensWithContext(ctx aws.Context, input *ExportLensInput, opts ...request.Option) (*ExportLensOutput, error) {
	req, out := c.ExportLensRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnswer = "GetAnswer"

// GetAnswerRequest generates a "aws/request.Request" representing the
// client's request for the GetAnswer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnswer for more information on using the GetAnswer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAnswerRequest method.
//	req, resp := client.GetAnswerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetAnswer
func (c *WellArchitected) GetAnswerRequest(input *GetAnswerInput) (req *request.Request, output *GetAnswerOutput) {
	op := &request.Operation{
		Name:       opGetAnswer,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers/{QuestionId}",
	}

	if input == nil {
		input = &GetAnswerInput{}
	}

	output = &GetAnswerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAnswer API operation for AWS Well-Architected Tool.
//
// Get the answer to a specific question in a workload review.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetAnswer for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetAnswer
func (c *WellArchitected) GetAnswer(input *GetAnswerInput) (*GetAnswerOutput, error) {
	req, out := c.GetAnswerRequest(input)
	return out, req.Send()
}

// GetAnswerWithContext is the same as GetAnswer with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnswer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetAnswerWithContext(ctx aws.Context, input *GetAnswerInput, opts ...request.Option) (*GetAnswerOutput, error) {
	req, out := c.GetAnswerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConsolidatedReport = "GetConsolidatedReport"

// GetConsolidatedReportRequest generates a "aws/request.Request" representing the
// client's request for the GetConsolidatedReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConsolidatedReport for more information on using the GetConsolidatedReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetConsolidatedReportRequest method.
//	req, resp := client.GetConsolidatedReportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetConsolidatedReport
func (c *WellArchitected) GetConsolidatedReportRequest(input *GetConsolidatedReportInput) (req *request.Request, output *GetConsolidatedReportOutput) {
	op := &request.Operation{
		Name:       opGetConsolidatedReport,
		HTTPMethod: "GET",
		HTTPPath:   "/consolidatedReport",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetConsolidatedReportInput{}
	}

	output = &GetConsolidatedReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConsolidatedReport API operation for AWS Well-Architected Tool.
//
// Get a consolidated report of your workloads.
//
// You can optionally choose to include workloads that have been shared with
// you.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetConsolidatedReport for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetConsolidatedReport
func (c *WellArchitected) GetConsolidatedReport(input *GetConsolidatedReportInput) (*GetConsolidatedReportOutput, error) {
	req, out := c.GetConsolidatedReportRequest(input)
	return out, req.Send()
}

// GetConsolidatedReportWithContext is the same as GetConsolidatedReport with the addition of
// the ability to pass a context and additional request options.
//
// See GetConsolidatedReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetConsolidatedReportWithContext(ctx aws.Context, input *GetConsolidatedReportInput, opts ...request.Option) (*GetConsolidatedReportOutput, error) {
	req, out := c.GetConsolidatedReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetConsolidatedReportPages iterates over the pages of a GetConsolidatedReport operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetConsolidatedReport method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetConsolidatedReport operation.
//	pageNum := 0
//	err := client.GetConsolidatedReportPages(params,
//	    func(page *wellarchitected.GetConsolidatedReportOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) GetConsolidatedReportPages(input *GetConsolidatedReportInput, fn func(*GetConsolidatedReportOutput, bool) bool) error {
	return c.GetConsolidatedReportPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetConsolidatedReportPagesWithContext same as GetConsolidatedReportPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetConsolidatedReportPagesWithContext(ctx aws.Context, input *GetConsolidatedReportInput, fn func(*GetConsolidatedReportOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetConsolidatedReportInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetConsolidatedReportRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetConsolidatedReportOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetGlobalSettings = "GetGlobalSettings"

// GetGlobalSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetGlobalSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGlobalSettings for more information on using the GetGlobalSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGlobalSettingsRequest method.
//	req, resp := client.GetGlobalSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetGlobalSettings
func (c *WellArchitected) GetGlobalSettingsRequest(input *GetGlobalSettingsInput) (req *request.Request, output *GetGlobalSettingsOutput) {
	op := &request.Operation{
		Name:       opGetGlobalSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/global-settings",
	}

	if input == nil {
		input = &GetGlobalSettingsInput{}
	}

	output = &GetGlobalSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGlobalSettings API operation for AWS Well-Architected Tool.
//
// Global settings for all workloads.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetGlobalSettings for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetGlobalSettings
func (c *WellArchitected) GetGlobalSettings(input *GetGlobalSettingsInput) (*GetGlobalSettingsOutput, error) {
	req, out := c.GetGlobalSettingsRequest(input)
	return out, req.Send()
}

// GetGlobalSettingsWithContext is the same as GetGlobalSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetGlobalSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetGlobalSettingsWithContext(ctx aws.Context, input *GetGlobalSettingsInput, opts ...request.Option) (*GetGlobalSettingsOutput, error) {
	req, out := c.GetGlobalSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLens = "GetLens"

// GetLensRequest generates a "aws/request.Request" representing the
// client's request for the GetLens operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLens for more information on using the GetLens
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLensRequest method.
//	req, resp := client.GetLensRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLens
func (c *WellArchitected) GetLensRequest(input *GetLensInput) (req *request.Request, output *GetLensOutput) {
	op := &request.Operation{
		Name:       opGetLens,
		HTTPMethod: "GET",
		HTTPPath:   "/lenses/{LensAlias}",
	}

	if input == nil {
		input = &GetLensInput{}
	}

	output = &GetLensOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLens API operation for AWS Well-Architected Tool.
//
// Get an existing lens.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetLens for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLens
func (c *WellArchitected) GetLens(input *GetLensInput) (*GetLensOutput, error) {
	req, out := c.GetLensRequest(input)
	return out, req.Send()
}

// GetLensWithContext is the same as GetLens with the addition of
// the ability to pass a context and additional request options.
//
// See GetLens for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetLensWithContext(ctx aws.Context, input *GetLensInput, opts ...request.Option) (*GetLensOutput, error) {
	req, out := c.GetLensRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLensReview = "GetLensReview"

// GetLensReviewRequest generates a "aws/request.Request" representing the
// client's request for the GetLensReview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLensReview for more information on using the GetLensReview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLensReviewRequest method.
//	req, resp := client.GetLensReviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensReview
func (c *WellArchitected) GetLensReviewRequest(input *GetLensReviewInput) (req *request.Request, output *GetLensReviewOutput) {
	op := &request.Operation{
		Name:       opGetLensReview,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews/{LensAlias}",
	}

	if input == nil {
		input = &GetLensReviewInput{}
	}

	output = &GetLensReviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLensReview API operation for AWS Well-Architected Tool.
//
// Get lens review.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetLensReview for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensReview
func (c *WellArchitected) GetLensReview(input *GetLensReviewInput) (*GetLensReviewOutput, error) {
	req, out := c.GetLensReviewRequest(input)
	return out, req.Send()
}

// GetLensReviewWithContext is the same as GetLensReview with the addition of
// the ability to pass a context and additional request options.
//
// See GetLensReview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetLensReviewWithContext(ctx aws.Context, input *GetLensReviewInput, opts ...request.Option) (*GetLensReviewOutput, error) {
	req, out := c.GetLensReviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLensReviewReport = "GetLensReviewReport"

// GetLensReviewReportRequest generates a "aws/request.Request" representing the
// client's request for the GetLensReviewReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLensReviewReport for more information on using the GetLensReviewReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLensReviewReportRequest method.
//	req, resp := client.GetLensReviewReportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensReviewReport
func (c *WellArchitected) GetLensReviewReportRequest(input *GetLensReviewReportInput) (req *request.Request, output *GetLensReviewReportOutput) {
	op := &request.Operation{
		Name:       opGetLensReviewReport,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews/{LensAlias}/report",
	}

	if input == nil {
		input = &GetLensReviewReportInput{}
	}

	output = &GetLensReviewReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLensReviewReport API operation for AWS Well-Architected Tool.
//
// Get lens review report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetLensReviewReport for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensReviewReport
func (c *WellArchitected) GetLensReviewReport(input *GetLensReviewReportInput) (*GetLensReviewReportOutput, error) {
	req, out := c.GetLensReviewReportRequest(input)
	return out, req.Send()
}

// GetLensReviewReportWithContext is the same as GetLensReviewReport with the addition of
// the ability to pass a context and additional request options.
//
// See GetLensReviewReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetLensReviewReportWithContext(ctx aws.Context, input *GetLensReviewReportInput, opts ...request.Option) (*GetLensReviewReportOutput, error) {
	req, out := c.GetLensReviewReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLensVersionDifference = "GetLensVersionDifference"

// GetLensVersionDifferenceRequest generates a "aws/request.Request" representing the
// client's request for the GetLensVersionDifference operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLensVersionDifference for more information on using the GetLensVersionDifference
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLensVersionDifferenceRequest method.
//	req, resp := client.GetLensVersionDifferenceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensVersionDifference
func (c *WellArchitected) GetLensVersionDifferenceRequest(input *GetLensVersionDifferenceInput) (req *request.Request, output *GetLensVersionDifferenceOutput) {
	op := &request.Operation{
		Name:       opGetLensVersionDifference,
		HTTPMethod: "GET",
		HTTPPath:   "/lenses/{LensAlias}/versionDifference",
	}

	if input == nil {
		input = &GetLensVersionDifferenceInput{}
	}

	output = &GetLensVersionDifferenceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLensVersionDifference API operation for AWS Well-Architected Tool.
//
// Get lens version differences.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetLensVersionDifference for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensVersionDifference
func (c *WellArchitected) GetLensVersionDifference(input *GetLensVersionDifferenceInput) (*GetLensVersionDifferenceOutput, error) {
	req, out := c.GetLensVersionDifferenceRequest(input)
	return out, req.Send()
}

// GetLensVersionDifferenceWithContext is the same as GetLensVersionDifference with the addition of
// the ability to pass a context and additional request options.
//
// See GetLensVersionDifference for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetLensVersionDifferenceWithContext(ctx aws.Context, input *GetLensVersionDifferenceInput, opts ...request.Option) (*GetLensVersionDifferenceOutput, error) {
	req, out := c.GetLensVersionDifferenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMilestone = "GetMilestone"

// GetMilestoneRequest generates a "aws/request.Request" representing the
// client's request for the GetMilestone operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMilestone for more information on using the GetMilestone
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMilestoneRequest method.
//	req, resp := client.GetMilestoneRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetMilestone
func (c *WellArchitected) GetMilestoneRequest(input *GetMilestoneInput) (req *request.Request, output *GetMilestoneOutput) {
	op := &request.Operation{
		Name:       opGetMilestone,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}/milestones/{MilestoneNumber}",
	}

	if input == nil {
		input = &GetMilestoneInput{}
	}

	output = &GetMilestoneOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMilestone API operation for AWS Well-Architected Tool.
//
// Get a milestone for an existing workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetMilestone for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetMilestone
func (c *WellArchitected) GetMilestone(input *GetMilestoneInput) (*GetMilestoneOutput, error) {
	req, out := c.GetMilestoneRequest(input)
	return out, req.Send()
}

// GetMilestoneWithContext is the same as GetMilestone with the addition of
// the ability to pass a context and additional request options.
//
// See GetMilestone for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetMilestoneWithContext(ctx aws.Context, input *GetMilestoneInput, opts ...request.Option) (*GetMilestoneOutput, error) {
	req, out := c.GetMilestoneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProfile = "GetProfile"

// GetProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProfile for more information on using the GetProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProfileRequest method.
//	req, resp := client.GetProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetProfile
func (c *WellArchitected) GetProfileRequest(input *GetProfileInput) (req *request.Request, output *GetProfileOutput) {
	op := &request.Operation{
		Name:       opGetProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/profiles/{ProfileArn}",
	}

	if input == nil {
		input = &GetProfileInput{}
	}

	output = &GetProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProfile API operation for AWS Well-Architected Tool.
//
// Get profile information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetProfile for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetProfile
func (c *WellArchitected) GetProfile(input *GetProfileInput) (*GetProfileOutput, error) {
	req, out := c.GetProfileRequest(input)
	return out, req.Send()
}

// GetProfileWithContext is the same as GetProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetProfileWithContext(ctx aws.Context, input *GetProfileInput, opts ...request.Option) (*GetProfileOutput, error) {
	req, out := c.GetProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProfileTemplate = "GetProfileTemplate"

// GetProfileTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetProfileTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProfileTemplate for more information on using the GetProfileTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProfileTemplateRequest method.
//	req, resp := client.GetProfileTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetProfileTemplate
func (c *WellArchitected) GetProfileTemplateRequest(input *GetProfileTemplateInput) (req *request.Request, output *GetProfileTemplateOutput) {
	op := &request.Operation{
		Name:       opGetProfileTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/profileTemplate",
	}

	if input == nil {
		input = &GetProfileTemplateInput{}
	}

	output = &GetProfileTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProfileTemplate API operation for AWS Well-Architected Tool.
//
// Get profile template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetProfileTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetProfileTemplate
func (c *WellArchitected) GetProfileTemplate(input *GetProfileTemplateInput) (*GetProfileTemplateOutput, error) {
	req, out := c.GetProfileTemplateRequest(input)
	return out, req.Send()
}

// GetProfileTemplateWithContext is the same as GetProfileTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetProfileTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetProfileTemplateWithContext(ctx aws.Context, input *GetProfileTemplateInput, opts ...request.Option) (*GetProfileTemplateOutput, error) {
	req, out := c.GetProfileTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReviewTemplate = "GetReviewTemplate"

// GetReviewTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetReviewTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReviewTemplate for more information on using the GetReviewTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReviewTemplateRequest method.
//	req, resp := client.GetReviewTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetReviewTemplate
func (c *WellArchitected) GetReviewTemplateRequest(input *GetReviewTemplateInput) (req *request.Request, output *GetReviewTemplateOutput) {
	op := &request.Operation{
		Name:       opGetReviewTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/reviewTemplates/{TemplateArn}",
	}

	if input == nil {
		input = &GetReviewTemplateInput{}
	}

	output = &GetReviewTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReviewTemplate API operation for AWS Well-Architected Tool.
//
// Get review template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetReviewTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetReviewTemplate
func (c *WellArchitected) GetReviewTemplate(input *GetReviewTemplateInput) (*GetReviewTemplateOutput, error) {
	req, out := c.GetReviewTemplateRequest(input)
	return out, req.Send()
}

// GetReviewTemplateWithContext is the same as GetReviewTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetReviewTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetReviewTemplateWithContext(ctx aws.Context, input *GetReviewTemplateInput, opts ...request.Option) (*GetReviewTemplateOutput, error) {
	req, out := c.GetReviewTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReviewTemplateAnswer = "GetReviewTemplateAnswer"

// GetReviewTemplateAnswerRequest generates a "aws/request.Request" representing the
// client's request for the GetReviewTemplateAnswer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReviewTemplateAnswer for more information on using the GetReviewTemplateAnswer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReviewTemplateAnswerRequest method.
//	req, resp := client.GetReviewTemplateAnswerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetReviewTemplateAnswer
func (c *WellArchitected) GetReviewTemplateAnswerRequest(input *GetReviewTemplateAnswerInput) (req *request.Request, output *GetReviewTemplateAnswerOutput) {
	op := &request.Operation{
		Name:       opGetReviewTemplateAnswer,
		HTTPMethod: "GET",
		HTTPPath:   "/reviewTemplates/{TemplateArn}/lensReviews/{LensAlias}/answers/{QuestionId}",
	}

	if input == nil {
		input = &GetReviewTemplateAnswerInput{}
	}

	output = &GetReviewTemplateAnswerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReviewTemplateAnswer API operation for AWS Well-Architected Tool.
//
// Get review template answer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetReviewTemplateAnswer for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetReviewTemplateAnswer
func (c *WellArchitected) GetReviewTemplateAnswer(input *GetReviewTemplateAnswerInput) (*GetReviewTemplateAnswerOutput, error) {
	req, out := c.GetReviewTemplateAnswerRequest(input)
	return out, req.Send()
}

// GetReviewTemplateAnswerWithContext is the same as GetReviewTemplateAnswer with the addition of
// the ability to pass a context and additional request options.
//
// See GetReviewTemplateAnswer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetReviewTemplateAnswerWithContext(ctx aws.Context, input *GetReviewTemplateAnswerInput, opts ...request.Option) (*GetReviewTemplateAnswerOutput, error) {
	req, out := c.GetReviewTemplateAnswerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReviewTemplateLensReview = "GetReviewTemplateLensReview"

// GetReviewTemplateLensReviewRequest generates a "aws/request.Request" representing the
// client's request for the GetReviewTemplateLensReview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReviewTemplateLensReview for more information on using the GetReviewTemplateLensReview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReviewTemplateLensReviewRequest method.
//	req, resp := client.GetReviewTemplateLensReviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetReviewTemplateLensReview
func (c *WellArchitected) GetReviewTemplateLensReviewRequest(input *GetReviewTemplateLensReviewInput) (req *request.Request, output *GetReviewTemplateLensReviewOutput) {
	op := &request.Operation{
		Name:       opGetReviewTemplateLensReview,
		HTTPMethod: "GET",
		HTTPPath:   "/reviewTemplates/{TemplateArn}/lensReviews/{LensAlias}",
	}

	if input == nil {
		input = &GetReviewTemplateLensReviewInput{}
	}

	output = &GetReviewTemplateLensReviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReviewTemplateLensReview API operation for AWS Well-Architected Tool.
//
// Get a lens review associated with a review template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetReviewTemplateLensReview for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetReviewTemplateLensReview
func (c *WellArchitected) GetReviewTemplateLensReview(input *GetReviewTemplateLensReviewInput) (*GetReviewTemplateLensReviewOutput, error) {
	req, out := c.GetReviewTemplateLensReviewRequest(input)
	return out, req.Send()
}

// GetReviewTemplateLensReviewWithContext is the same as GetReviewTemplateLensReview with the addition of
// the ability to pass a context and additional request options.
//
// See GetReviewTemplateLensReview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetReviewTemplateLensReviewWithContext(ctx aws.Context, input *GetReviewTemplateLensReviewInput, opts ...request.Option) (*GetReviewTemplateLensReviewOutput, error) {
	req, out := c.GetReviewTemplateLensReviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkload = "GetWorkload"

// GetWorkloadRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkload for more information on using the GetWorkload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetWorkloadRequest method.
//	req, resp := client.GetWorkloadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetWorkload
func (c *WellArchitected) GetWorkloadRequest(input *GetWorkloadInput) (req *request.Request, output *GetWorkloadOutput) {
	op := &request.Operation{
		Name:       opGetWorkload,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}",
	}

	if input == nil {
		input = &GetWorkloadInput{}
	}

	output = &GetWorkloadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkload API operation for AWS Well-Architected Tool.
//
// Get an existing workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation GetWorkload for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetWorkload
func (c *WellArchitected) GetWorkload(input *GetWorkloadInput) (*GetWorkloadOutput, error) {
	req, out := c.GetWorkloadRequest(input)
	return out, req.Send()
}

// GetWorkloadWithContext is the same as GetWorkload with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) GetWorkloadWithContext(ctx aws.Context, input *GetWorkloadInput, opts ...request.Option) (*GetWorkloadOutput, error) {
	req, out := c.GetWorkloadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportLens = "ImportLens"

// ImportLensRequest generates a "aws/request.Request" representing the
// client's request for the ImportLens operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportLens for more information on using the ImportLens
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportLensRequest method.
//	req, resp := client.ImportLensRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ImportLens
func (c *WellArchitected) ImportLensRequest(input *ImportLensInput) (req *request.Request, output *ImportLensOutput) {
	op := &request.Operation{
		Name:       opImportLens,
		HTTPMethod: "PUT",
		HTTPPath:   "/importLens",
	}

	if input == nil {
		input = &ImportLensInput{}
	}

	output = &ImportLensOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportLens API operation for AWS Well-Architected Tool.
//
// Import a new custom lens or update an existing custom lens.
//
// To update an existing custom lens, specify its ARN as the LensAlias. If no
// ARN is specified, a new custom lens is created.
//
// The new or updated lens will have a status of DRAFT. The lens cannot be applied
// to workloads or shared with other Amazon Web Services accounts until it's
// published with CreateLensVersion.
//
// Lenses are defined in JSON. For more information, see JSON format specification
// (https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html)
// in the Well-Architected Tool User Guide.
//
// A custom lens cannot exceed 500 KB in size.
//
// # Disclaimer
//
// Do not include or gather personal identifiable information (PII) of end users
// or other identifiable individuals in or via your custom lenses. If your custom
// lens or those shared with you and used in your account do include or collect
// PII you are responsible for: ensuring that the included PII is processed
// in accordance with applicable law, providing adequate privacy notices, and
// obtaining necessary consents for processing such data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ImportLens for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ServiceQuotaExceededException
//     The user has reached their resource quota.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ImportLens
func (c *WellArchitected) ImportLens(input *ImportLensInput) (*ImportLensOutput, error) {
	req, out := c.ImportLensRequest(input)
	return out, req.Send()
}

// ImportLensWithContext is the same as ImportLens with the addition of
// the ability to pass a context and additional request options.
//
// See ImportLens for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ImportLensWithContext(ctx aws.Context, input *ImportLensInput, opts ...request.Option) (*ImportLensOutput, error) {
	req, out := c.ImportLensRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAnswers = "ListAnswers"

// ListAnswersRequest generates a "aws/request.Request" representing the
// client's request for the ListAnswers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnswers for more information on using the ListAnswers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAnswersRequest method.
//	req, resp := client.ListAnswersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListAnswers
func (c *WellArchitected) ListAnswersRequest(input *ListAnswersInput) (req *request.Request, output *ListAnswersOutput) {
	op := &request.Operation{
		Name:       opListAnswers,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnswersInput{}
	}

	output = &ListAnswersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnswers API operation for AWS Well-Architected Tool.
//
// List of answers for a particular workload and lens.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListAnswers for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListAnswers
func (c *WellArchitected) ListAnswers(input *ListAnswersInput) (*ListAnswersOutput, error) {
	req, out := c.ListAnswersRequest(input)
	return out, req.Send()
}

// ListAnswersWithContext is the same as ListAnswers with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnswers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListAnswersWithContext(ctx aws.Context, input *ListAnswersInput, opts ...request.Option) (*ListAnswersOutput, error) {
	req, out := c.ListAnswersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnswersPages iterates over the pages of a ListAnswers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnswers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAnswers operation.
//	pageNum := 0
//	err := client.ListAnswersPages(params,
//	    func(page *wellarchitected.ListAnswersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListAnswersPages(input *ListAnswersInput, fn func(*ListAnswersOutput, bool) bool) error {
	return c.ListAnswersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnswersPagesWithContext same as ListAnswersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListAnswersPagesWithContext(ctx aws.Context, input *ListAnswersInput, fn func(*ListAnswersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnswersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnswersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnswersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCheckDetails = "ListCheckDetails"

// ListCheckDetailsRequest generates a "aws/request.Request" representing the
// client's request for the ListCheckDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCheckDetails for more information on using the ListCheckDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCheckDetailsRequest method.
//	req, resp := client.ListCheckDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListCheckDetails
func (c *WellArchitected) ListCheckDetailsRequest(input *ListCheckDetailsInput) (req *request.Request, output *ListCheckDetailsOutput) {
	op := &request.Operation{
		Name:       opListCheckDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/workloads/{WorkloadId}/checks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCheckDetailsInput{}
	}

	output = &ListCheckDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCheckDetails API operation for AWS Well-Architected Tool.
//
// List of Trusted Advisor check details by account related to the workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListCheckDetails for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListCheckDetails
func (c *WellArchitected) ListCheckDetails(input *ListCheckDetailsInput) (*ListCheckDetailsOutput, error) {
	req, out := c.ListCheckDetailsRequest(input)
	return out, req.Send()
}

// ListCheckDetailsWithContext is the same as ListCheckDetails with the addition of
// the ability to pass a context and additional request options.
//
// See ListCheckDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListCheckDetailsWithContext(ctx aws.Context, input *ListCheckDetailsInput, opts ...request.Option) (*ListCheckDetailsOutput, error) {
	req, out := c.ListCheckDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCheckDetailsPages iterates over the pages of a ListCheckDetails operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCheckDetails method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCheckDetails operation.
//	pageNum := 0
//	err := client.ListCheckDetailsPages(params,
//	    func(page *wellarchitected.ListCheckDetailsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListCheckDetailsPages(input *ListCheckDetailsInput, fn func(*ListCheckDetailsOutput, bool) bool) error {
	return c.ListCheckDetailsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCheckDetailsPagesWithContext same as ListCheckDetailsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListCheckDetailsPagesWithContext(ctx aws.Context, input *ListCheckDetailsInput, fn func(*ListCheckDetailsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCheckDetailsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCheckDetailsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCheckDetailsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCheckSummaries = "ListCheckSummaries"

// ListCheckSummariesRequest generates a "aws/request.Request" representing the
// client's request for the ListCheckSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCheckSummaries for more information on using the ListCheckSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCheckSummariesRequest method.
//	req, resp := client.ListCheckSummariesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListCheckSummaries
func (c *WellArchitected) ListCheckSummariesRequest(input *ListCheckSummariesInput) (req *request.Request, output *ListCheckSummariesOutput) {
	op := &request.Operation{
		Name:       opListCheckSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/workloads/{WorkloadId}/checkSummaries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCheckSummariesInput{}
	}

	output = &ListCheckSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCheckSummaries API operation for AWS Well-Architected Tool.
//
// List of Trusted Advisor checks summarized for all accounts related to the
// workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListCheckSummaries for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListCheckSummaries
func (c *WellArchitected) ListCheckSummaries(input *ListCheckSummariesInput) (*ListCheckSummariesOutput, error) {
	req, out := c.ListCheckSummariesRequest(input)
	return out, req.Send()
}

// ListCheckSummariesWithContext is the same as ListCheckSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See ListCheckSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListCheckSummariesWithContext(ctx aws.Context, input *ListCheckSummariesInput, opts ...request.Option) (*ListCheckSummariesOutput, error) {
	req, out := c.ListCheckSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCheckSummariesPages iterates over the pages of a ListCheckSummaries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCheckSummaries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCheckSummaries operation.
//	pageNum := 0
//	err := client.ListCheckSummariesPages(params,
//	    func(page *wellarchitected.ListCheckSummariesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListCheckSummariesPages(input *ListCheckSummariesInput, fn func(*ListCheckSummariesOutput, bool) bool) error {
	return c.ListCheckSummariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCheckSummariesPagesWithContext same as ListCheckSummariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListCheckSummariesPagesWithContext(ctx aws.Context, input *ListCheckSummariesInput, fn func(*ListCheckSummariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCheckSummariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCheckSummariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCheckSummariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLensReviewImprovements = "ListLensReviewImprovements"

// ListLensReviewImprovementsRequest generates a "aws/request.Request" representing the
// client's request for the ListLensReviewImprovements operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLensReviewImprovements for more information on using the ListLensReviewImprovements
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLensReviewImprovementsRequest method.
//	req, resp := client.ListLensReviewImprovementsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviewImprovements
func (c *WellArchitected) ListLensReviewImprovementsRequest(input *ListLensReviewImprovementsInput) (req *request.Request, output *ListLensReviewImprovementsOutput) {
	op := &request.Operation{
		Name:       opListLensReviewImprovements,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews/{LensAlias}/improvements",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLensReviewImprovementsInput{}
	}

	output = &ListLensReviewImprovementsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLensReviewImprovements API operation for AWS Well-Architected Tool.
//
// List the improvements of a particular lens review.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListLensReviewImprovements for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviewImprovements
func (c *WellArchitected) ListLensReviewImprovements(input *ListLensReviewImprovementsInput) (*ListLensReviewImprovementsOutput, error) {
	req, out := c.ListLensReviewImprovementsRequest(input)
	return out, req.Send()
}

// ListLensReviewImprovementsWithContext is the same as ListLensReviewImprovements with the addition of
// the ability to pass a context and additional request options.
//
// See ListLensReviewImprovements for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListLensReviewImprovementsWithContext(ctx aws.Context, input *ListLensReviewImprovementsInput, opts ...request.Option) (*ListLensReviewImprovementsOutput, error) {
	req, out := c.ListLensReviewImprovementsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLensReviewImprovementsPages iterates over the pages of a ListLensReviewImprovements operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLensReviewImprovements method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLensReviewImprovements operation.
//	pageNum := 0
//	err := client.ListLensReviewImprovementsPages(params,
//	    func(page *wellarchitected.ListLensReviewImprovementsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListLensReviewImprovementsPages(input *ListLensReviewImprovementsInput, fn func(*ListLensReviewImprovementsOutput, bool) bool) error {
	return c.ListLensReviewImprovementsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLensReviewImprovementsPagesWithContext same as ListLensReviewImprovementsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListLensReviewImprovementsPagesWithContext(ctx aws.Context, input *ListLensReviewImprovementsInput, fn func(*ListLensReviewImprovementsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLensReviewImprovementsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLensReviewImprovementsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLensReviewImprovementsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLensReviews = "ListLensReviews"

// ListLensReviewsRequest generates a "aws/request.Request" representing the
// client's request for the ListLensReviews operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLensReviews for more information on using the ListLensReviews
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLensReviewsRequest method.
//	req, resp := client.ListLensReviewsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviews
func (c *WellArchitected) ListLensReviewsRequest(input *ListLensReviewsInput) (req *request.Request, output *ListLensReviewsOutput) {
	op := &request.Operation{
		Name:       opListLensReviews,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLensReviewsInput{}
	}

	output = &ListLensReviewsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLensReviews API operation for AWS Well-Architected Tool.
//
// List lens reviews for a particular workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListLensReviews for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviews
func (c *WellArchitected) ListLensReviews(input *ListLensReviewsInput) (*ListLensReviewsOutput, error) {
	req, out := c.ListLensReviewsRequest(input)
	return out, req.Send()
}

// ListLensReviewsWithContext is the same as ListLensReviews with the addition of
// the ability to pass a context and additional request options.
//
// See ListLensReviews for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListLensReviewsWithContext(ctx aws.Context, input *ListLensReviewsInput, opts ...request.Option) (*ListLensReviewsOutput, error) {
	req, out := c.ListLensReviewsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLensReviewsPages iterates over the pages of a ListLensReviews operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLensReviews method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLensReviews operation.
//	pageNum := 0
//	err := client.ListLensReviewsPages(params,
//	    func(page *wellarchitected.ListLensReviewsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListLensReviewsPages(input *ListLensReviewsInput, fn func(*ListLensReviewsOutput, bool) bool) error {
	return c.ListLensReviewsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLensReviewsPagesWithContext same as ListLensReviewsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListLensReviewsPagesWithContext(ctx aws.Context, input *ListLensReviewsInput, fn func(*ListLensReviewsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLensReviewsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLensReviewsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLensReviewsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLensShares = "ListLensShares"

// ListLensSharesRequest generates a "aws/request.Request" representing the
// client's request for the ListLensShares operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLensShares for more information on using the ListLensShares
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLensSharesRequest method.
//	req, resp := client.ListLensSharesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensShares
func (c *WellArchitected) ListLensSharesRequest(input *ListLensSharesInput) (req *request.Request, output *ListLensSharesOutput) {
	op := &request.Operation{
		Name:       opListLensShares,
		HTTPMethod: "GET",
		HTTPPath:   "/lenses/{LensAlias}/shares",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLensSharesInput{}
	}

	output = &ListLensSharesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLensShares API operation for AWS Well-Architected Tool.
//
// List the lens shares associated with the lens.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListLensShares for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensShares
func (c *WellArchitected) ListLensShares(input *ListLensSharesInput) (*ListLensSharesOutput, error) {
	req, out := c.ListLensSharesRequest(input)
	return out, req.Send()
}

// ListLensSharesWithContext is the same as ListLensShares with the addition of
// the ability to pass a context and additional request options.
//
// See ListLensShares for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListLensSharesWithContext(ctx aws.Context, input *ListLensSharesInput, opts ...request.Option) (*ListLensSharesOutput, error) {
	req, out := c.ListLensSharesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLensSharesPages iterates over the pages of a ListLensShares operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLensShares method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLensShares operation.
//	pageNum := 0
//	err := client.ListLensSharesPages(params,
//	    func(page *wellarchitected.ListLensSharesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListLensSharesPages(input *ListLensSharesInput, fn func(*ListLensSharesOutput, bool) bool) error {
	return c.ListLensSharesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLensSharesPagesWithContext same as ListLensSharesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListLensSharesPagesWithContext(ctx aws.Context, input *ListLensSharesInput, fn func(*ListLensSharesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLensSharesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLensSharesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLensSharesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLenses = "ListLenses"

// ListLensesRequest generates a "aws/request.Request" representing the
// client's request for the ListLenses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLenses for more information on using the ListLenses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLensesRequest method.
//	req, resp := client.ListLensesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLenses
func (c *WellArchitected) ListLensesRequest(input *ListLensesInput) (req *request.Request, output *ListLensesOutput) {
	op := &request.Operation{
		Name:       opListLenses,
		HTTPMethod: "GET",
		HTTPPath:   "/lenses",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLensesInput{}
	}

	output = &ListLensesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLenses API operation for AWS Well-Architected Tool.
//
// List the available lenses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListLenses for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLenses
func (c *WellArchitected) ListLenses(input *ListLensesInput) (*ListLensesOutput, error) {
	req, out := c.ListLensesRequest(input)
	return out, req.Send()
}

// ListLensesWithContext is the same as ListLenses with the addition of
// the ability to pass a context and additional request options.
//
// See ListLenses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListLensesWithContext(ctx aws.Context, input *ListLensesInput, opts ...request.Option) (*ListLensesOutput, error) {
	req, out := c.ListLensesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLensesPages iterates over the pages of a ListLenses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLenses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLenses operation.
//	pageNum := 0
//	err := client.ListLensesPages(params,
//	    func(page *wellarchitected.ListLensesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListLensesPages(input *ListLensesInput, fn func(*ListLensesOutput, bool) bool) error {
	return c.ListLensesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLensesPagesWithContext same as ListLensesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListLensesPagesWithContext(ctx aws.Context, input *ListLensesInput, fn func(*ListLensesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLensesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLensesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLensesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMilestones = "ListMilestones"

// ListMilestonesRequest generates a "aws/request.Request" representing the
// client's request for the ListMilestones operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMilestones for more information on using the ListMilestones
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMilestonesRequest method.
//	req, resp := client.ListMilestonesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListMilestones
func (c *WellArchitected) ListMilestonesRequest(input *ListMilestonesInput) (req *request.Request, output *ListMilestonesOutput) {
	op := &request.Operation{
		Name:       opListMilestones,
		HTTPMethod: "POST",
		HTTPPath:   "/workloads/{WorkloadId}/milestonesSummaries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMilestonesInput{}
	}

	output = &ListMilestonesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMilestones API operation for AWS Well-Architected Tool.
//
// List all milestones for an existing workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListMilestones for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListMilestones
func (c *WellArchitected) ListMilestones(input *ListMilestonesInput) (*ListMilestonesOutput, error) {
	req, out := c.ListMilestonesRequest(input)
	return out, req.Send()
}

// ListMilestonesWithContext is the same as ListMilestones with the addition of
// the ability to pass a context and additional request options.
//
// See ListMilestones for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListMilestonesWithContext(ctx aws.Context, input *ListMilestonesInput, opts ...request.Option) (*ListMilestonesOutput, error) {
	req, out := c.ListMilestonesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMilestonesPages iterates over the pages of a ListMilestones operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMilestones method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMilestones operation.
//	pageNum := 0
//	err := client.ListMilestonesPages(params,
//	    func(page *wellarchitected.ListMilestonesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListMilestonesPages(input *ListMilestonesInput, fn func(*ListMilestonesOutput, bool) bool) error {
	return c.ListMilestonesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMilestonesPagesWithContext same as ListMilestonesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListMilestonesPagesWithContext(ctx aws.Context, input *ListMilestonesInput, fn func(*ListMilestonesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMilestonesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMilestonesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMilestonesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNotifications = "ListNotifications"

// ListNotificationsRequest generates a "aws/request.Request" representing the
// client's request for the ListNotifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNotifications for more information on using the ListNotifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListNotificationsRequest method.
//	req, resp := client.ListNotificationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListNotifications
func (c *WellArchitected) ListNotificationsRequest(input *ListNotificationsInput) (req *request.Request, output *ListNotificationsOutput) {
	op := &request.Operation{
		Name:       opListNotifications,
		HTTPMethod: "POST",
		HTTPPath:   "/notifications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNotificationsInput{}
	}

	output = &ListNotificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNotifications API operation for AWS Well-Architected Tool.
//
// List lens notifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListNotifications for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListNotifications
func (c *WellArchitected) ListNotifications(input *ListNotificationsInput) (*ListNotificationsOutput, error) {
	req, out := c.ListNotificationsRequest(input)
	return out, req.Send()
}

// ListNotificationsWithContext is the same as ListNotifications with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListNotificationsWithContext(ctx aws.Context, input *ListNotificationsInput, opts ...request.Option) (*ListNotificationsOutput, error) {
	req, out := c.ListNotificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNotificationsPages iterates over the pages of a ListNotifications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNotifications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListNotifications operation.
//	pageNum := 0
//	err := client.ListNotificationsPages(params,
//	    func(page *wellarchitected.ListNotificationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListNotificationsPages(input *ListNotificationsInput, fn func(*ListNotificationsOutput, bool) bool) error {
	return c.ListNotificationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNotificationsPagesWithContext same as ListNotificationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListNotificationsPagesWithContext(ctx aws.Context, input *ListNotificationsInput, fn func(*ListNotificationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNotificationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNotificationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNotificationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProfileNotifications = "ListProfileNotifications"

// ListProfileNotificationsRequest generates a "aws/request.Request" representing the
// client's request for the ListProfileNotifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfileNotifications for more information on using the ListProfileNotifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProfileNotificationsRequest method.
//	req, resp := client.ListProfileNotificationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfileNotifications
func (c *WellArchitected) ListProfileNotificationsRequest(input *ListProfileNotificationsInput) (req *request.Request, output *ListProfileNotificationsOutput) {
	op := &request.Operation{
		Name:       opListProfileNotifications,
		HTTPMethod: "GET",
		HTTPPath:   "/profileNotifications/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProfileNotificationsInput{}
	}

	output = &ListProfileNotificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfileNotifications API operation for AWS Well-Architected Tool.
//
// List profile notifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListProfileNotifications for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfileNotifications
func (c *WellArchitected) ListProfileNotifications(input *ListProfileNotificationsInput) (*ListProfileNotificationsOutput, error) {
	req, out := c.ListProfileNotificationsRequest(input)
	return out, req.Send()
}

// ListProfileNotificationsWithContext is the same as ListProfileNotifications with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfileNotifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListProfileNotificationsWithContext(ctx aws.Context, input *ListProfileNotificationsInput, opts ...request.Option) (*ListProfileNotificationsOutput, error) {
	req, out := c.ListProfileNotificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProfileNotificationsPages iterates over the pages of a ListProfileNotifications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProfileNotifications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProfileNotifications operation.
//	pageNum := 0
//	err := client.ListProfileNotificationsPages(params,
//	    func(page *wellarchitected.ListProfileNotificationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListProfileNotificationsPages(input *ListProfileNotificationsInput, fn func(*ListProfileNotificationsOutput, bool) bool) error {
	return c.ListProfileNotificationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProfileNotificationsPagesWithContext same as ListProfileNotificationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListProfileNotificationsPagesWithContext(ctx aws.Context, input *ListProfileNotificationsInput, fn func(*ListProfileNotificationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProfileNotificationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProfileNotificationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProfileNotificationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProfileShares = "ListProfileShares"

// ListProfileSharesRequest generates a "aws/request.Request" representing the
// client's request for the ListProfileShares operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfileShares for more information on using the ListProfileShares
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProfileSharesRequest method.
//	req, resp := client.ListProfileSharesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfileShares
func (c *WellArchitected) ListProfileSharesRequest(input *ListProfileSharesInput) (req *request.Request, output *ListProfileSharesOutput) {
	op := &request.Operation{
		Name:       opListProfileShares,
		HTTPMethod: "GET",
		HTTPPath:   "/profiles/{ProfileArn}/shares",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProfileSharesInput{}
	}

	output = &ListProfileSharesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfileShares API operation for AWS Well-Architected Tool.
//
// List profile shares.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListProfileShares for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfileShares
func (c *WellArchitected) ListProfileShares(input *ListProfileSharesInput) (*ListProfileSharesOutput, error) {
	req, out := c.ListProfileSharesRequest(input)
	return out, req.Send()
}

// ListProfileSharesWithContext is the same as ListProfileShares with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfileShares for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListProfileSharesWithContext(ctx aws.Context, input *ListProfileSharesInput, opts ...request.Option) (*ListProfileSharesOutput, error) {
	req, out := c.ListProfileSharesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProfileSharesPages iterates over the pages of a ListProfileShares operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProfileShares method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProfileShares operation.
//	pageNum := 0
//	err := client.ListProfileSharesPages(params,
//	    func(page *wellarchitected.ListProfileSharesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListProfileSharesPages(input *ListProfileSharesInput, fn func(*ListProfileSharesOutput, bool) bool) error {
	return c.ListProfileSharesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProfileSharesPagesWithContext same as ListProfileSharesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListProfileSharesPagesWithContext(ctx aws.Context, input *ListProfileSharesInput, fn func(*ListProfileSharesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProfileSharesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProfileSharesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProfileSharesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProfiles = "ListProfiles"

// ListProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfiles for more information on using the ListProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProfilesRequest method.
//	req, resp := client.ListProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfiles
func (c *WellArchitected) ListProfilesRequest(input *ListProfilesInput) (req *request.Request, output *ListProfilesOutput) {
	op := &request.Operation{
		Name:       opListProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/profileSummaries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProfilesInput{}
	}

	output = &ListProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfiles API operation for AWS Well-Architected Tool.
//
// List profiles.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListProfiles for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfiles
func (c *WellArchitected) ListProfiles(input *ListProfilesInput) (*ListProfilesOutput, error) {
	req, out := c.ListProfilesRequest(input)
	return out, req.Send()
}

// ListProfilesWithContext is the same as ListProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListProfilesWithContext(ctx aws.Context, input *ListProfilesInput, opts ...request.Option) (*ListProfilesOutput, error) {
	req, out := c.ListProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProfilesPages iterates over the pages of a ListProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProfiles operation.
//	pageNum := 0
//	err := client.ListProfilesPages(params,
//	    func(page *wellarchitected.ListProfilesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListProfilesPages(input *ListProfilesInput, fn func(*ListProfilesOutput, bool) bool) error {
	return c.ListProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProfilesPagesWithContext same as ListProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListProfilesPagesWithContext(ctx aws.Context, input *ListProfilesInput, fn func(*ListProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReviewTemplateAnswers = "ListReviewTemplateAnswers"

// ListReviewTemplateAnswersRequest generates a "aws/request.Request" representing the
// client's request for the ListReviewTemplateAnswers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReviewTemplateAnswers for more information on using the ListReviewTemplateAnswers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReviewTemplateAnswersRequest method.
//	req, resp := client.ListReviewTemplateAnswersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListReviewTemplateAnswers
func (c *WellArchitected) ListReviewTemplateAnswersRequest(input *ListReviewTemplateAnswersInput) (req *request.Request, output *ListReviewTemplateAnswersOutput) {
	op := &request.Operation{
		Name:       opListReviewTemplateAnswers,
		HTTPMethod: "GET",
		HTTPPath:   "/reviewTemplates/{TemplateArn}/lensReviews/{LensAlias}/answers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReviewTemplateAnswersInput{}
	}

	output = &ListReviewTemplateAnswersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReviewTemplateAnswers API operation for AWS Well-Architected Tool.
//
// List the answers of a review template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListReviewTemplateAnswers for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListReviewTemplateAnswers
func (c *WellArchitected) ListReviewTemplateAnswers(input *ListReviewTemplateAnswersInput) (*ListReviewTemplateAnswersOutput, error) {
	req, out := c.ListReviewTemplateAnswersRequest(input)
	return out, req.Send()
}

// ListReviewTemplateAnswersWithContext is the same as ListReviewTemplateAnswers with the addition of
// the ability to pass a context and additional request options.
//
// See ListReviewTemplateAnswers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListReviewTemplateAnswersWithContext(ctx aws.Context, input *ListReviewTemplateAnswersInput, opts ...request.Option) (*ListReviewTemplateAnswersOutput, error) {
	req, out := c.ListReviewTemplateAnswersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReviewTemplateAnswersPages iterates over the pages of a ListReviewTemplateAnswers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReviewTemplateAnswers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReviewTemplateAnswers operation.
//	pageNum := 0
//	err := client.ListReviewTemplateAnswersPages(params,
//	    func(page *wellarchitected.ListReviewTemplateAnswersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListReviewTemplateAnswersPages(input *ListReviewTemplateAnswersInput, fn func(*ListReviewTemplateAnswersOutput, bool) bool) error {
	return c.ListReviewTemplateAnswersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReviewTemplateAnswersPagesWithContext same as ListReviewTemplateAnswersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListReviewTemplateAnswersPagesWithContext(ctx aws.Context, input *ListReviewTemplateAnswersInput, fn func(*ListReviewTemplateAnswersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReviewTemplateAnswersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReviewTemplateAnswersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReviewTemplateAnswersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReviewTemplates = "ListReviewTemplates"

// ListReviewTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListReviewTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReviewTemplates for more information on using the ListReviewTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReviewTemplatesRequest method.
//	req, resp := client.ListReviewTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListReviewTemplates
func (c *WellArchitected) ListReviewTemplatesRequest(input *ListReviewTemplatesInput) (req *request.Request, output *ListReviewTemplatesOutput) {
	op := &request.Operation{
		Name:       opListReviewTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/reviewTemplates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReviewTemplatesInput{}
	}

	output = &ListReviewTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReviewTemplates API operation for AWS Well-Architected Tool.
//
// List review templates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListReviewTemplates for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListReviewTemplates
func (c *WellArchitected) ListReviewTemplates(input *ListReviewTemplatesInput) (*ListReviewTemplatesOutput, error) {
	req, out := c.ListReviewTemplatesRequest(input)
	return out, req.Send()
}

// ListReviewTemplatesWithContext is the same as ListReviewTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListReviewTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListReviewTemplatesWithContext(ctx aws.Context, input *ListReviewTemplatesInput, opts ...request.Option) (*ListReviewTemplatesOutput, error) {
	req, out := c.ListReviewTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReviewTemplatesPages iterates over the pages of a ListReviewTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReviewTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReviewTemplates operation.
//	pageNum := 0
//	err := client.ListReviewTemplatesPages(params,
//	    func(page *wellarchitected.ListReviewTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListReviewTemplatesPages(input *ListReviewTemplatesInput, fn func(*ListReviewTemplatesOutput, bool) bool) error {
	return c.ListReviewTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReviewTemplatesPagesWithContext same as ListReviewTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListReviewTemplatesPagesWithContext(ctx aws.Context, input *ListReviewTemplatesInput, fn func(*ListReviewTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReviewTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReviewTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReviewTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListShareInvitations = "ListShareInvitations"

// ListShareInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the ListShareInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListShareInvitations for more information on using the ListShareInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListShareInvitationsRequest method.
//	req, resp := client.ListShareInvitationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListShareInvitations
func (c *WellArchitected) ListShareInvitationsRequest(input *ListShareInvitationsInput) (req *request.Request, output *ListShareInvitationsOutput) {
	op := &request.Operation{
		Name:       opListShareInvitations,
		HTTPMethod: "GET",
		HTTPPath:   "/shareInvitations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListShareInvitationsInput{}
	}

	output = &ListShareInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListShareInvitations API operation for AWS Well-Architected Tool.
//
// List the share invitations.
//
// WorkloadNamePrefix, LensNamePrefix, ProfileNamePrefix, and TemplateNamePrefix
// are mutually exclusive. Use the parameter that matches your ShareResourceType.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListShareInvitations for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListShareInvitations
func (c *WellArchitected) ListShareInvitations(input *ListShareInvitationsInput) (*ListShareInvitationsOutput, error) {
	req, out := c.ListShareInvitationsRequest(input)
	return out, req.Send()
}

// ListShareInvitationsWithContext is the same as ListShareInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See ListShareInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListShareInvitationsWithContext(ctx aws.Context, input *ListShareInvitationsInput, opts ...request.Option) (*ListShareInvitationsOutput, error) {
	req, out := c.ListShareInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListShareInvitationsPages iterates over the pages of a ListShareInvitations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListShareInvitations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListShareInvitations operation.
//	pageNum := 0
//	err := client.ListShareInvitationsPages(params,
//	    func(page *wellarchitected.ListShareInvitationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListShareInvitationsPages(input *ListShareInvitationsInput, fn func(*ListShareInvitationsOutput, bool) bool) error {
	return c.ListShareInvitationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListShareInvitationsPagesWithContext same as ListShareInvitationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListShareInvitationsPagesWithContext(ctx aws.Context, input *ListShareInvitationsInput, fn func(*ListShareInvitationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListShareInvitationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListShareInvitationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListShareInvitationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListTagsForResource
func (c *WellArchitected) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{WorkloadArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Well-Architected Tool.
//
// List the tags for a resource.
//
// The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile
// ARN, or review template ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListTagsForResource
func (c *WellArchitected) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTemplateShares = "ListTemplateShares"

// ListTemplateSharesRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplateShares operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplateShares for more information on using the ListTemplateShares
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTemplateSharesRequest method.
//	req, resp := client.ListTemplateSharesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListTemplateShares
func (c *WellArchitected) ListTemplateSharesRequest(input *ListTemplateSharesInput) (req *request.Request, output *ListTemplateSharesOutput) {
	op := &request.Operation{
		Name:       opListTemplateShares,
		HTTPMethod: "GET",
		HTTPPath:   "/templates/shares/{TemplateArn}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplateSharesInput{}
	}

	output = &ListTemplateSharesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplateShares API operation for AWS Well-Architected Tool.
//
// List review template shares.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListTemplateShares for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListTemplateShares
func (c *WellArchitected) ListTemplateShares(input *ListTemplateSharesInput) (*ListTemplateSharesOutput, error) {
	req, out := c.ListTemplateSharesRequest(input)
	return out, req.Send()
}

// ListTemplateSharesWithContext is the same as ListTemplateShares with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplateShares for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListTemplateSharesWithContext(ctx aws.Context, input *ListTemplateSharesInput, opts ...request.Option) (*ListTemplateSharesOutput, error) {
	req, out := c.ListTemplateSharesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplateSharesPages iterates over the pages of a ListTemplateShares operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplateShares method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTemplateShares operation.
//	pageNum := 0
//	err := client.ListTemplateSharesPages(params,
//	    func(page *wellarchitected.ListTemplateSharesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListTemplateSharesPages(input *ListTemplateSharesInput, fn func(*ListTemplateSharesOutput, bool) bool) error {
	return c.ListTemplateSharesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplateSharesPagesWithContext same as ListTemplateSharesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListTemplateSharesPagesWithContext(ctx aws.Context, input *ListTemplateSharesInput, fn func(*ListTemplateSharesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplateSharesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplateSharesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplateSharesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkloadShares = "ListWorkloadShares"

// ListWorkloadSharesRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkloadShares operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkloadShares for more information on using the ListWorkloadShares
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWorkloadSharesRequest method.
//	req, resp := client.ListWorkloadSharesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloadShares
func (c *WellArchitected) ListWorkloadSharesRequest(input *ListWorkloadSharesInput) (req *request.Request, output *ListWorkloadSharesOutput) {
	op := &request.Operation{
		Name:       opListWorkloadShares,
		HTTPMethod: "GET",
		HTTPPath:   "/workloads/{WorkloadId}/shares",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkloadSharesInput{}
	}

	output = &ListWorkloadSharesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkloadShares API operation for AWS Well-Architected Tool.
//
// List the workload shares associated with the workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListWorkloadShares for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloadShares
func (c *WellArchitected) ListWorkloadShares(input *ListWorkloadSharesInput) (*ListWorkloadSharesOutput, error) {
	req, out := c.ListWorkloadSharesRequest(input)
	return out, req.Send()
}

// ListWorkloadSharesWithContext is the same as ListWorkloadShares with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkloadShares for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListWorkloadSharesWithContext(ctx aws.Context, input *ListWorkloadSharesInput, opts ...request.Option) (*ListWorkloadSharesOutput, error) {
	req, out := c.ListWorkloadSharesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkloadSharesPages iterates over the pages of a ListWorkloadShares operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkloadShares method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWorkloadShares operation.
//	pageNum := 0
//	err := client.ListWorkloadSharesPages(params,
//	    func(page *wellarchitected.ListWorkloadSharesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListWorkloadSharesPages(input *ListWorkloadSharesInput, fn func(*ListWorkloadSharesOutput, bool) bool) error {
	return c.ListWorkloadSharesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkloadSharesPagesWithContext same as ListWorkloadSharesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListWorkloadSharesPagesWithContext(ctx aws.Context, input *ListWorkloadSharesInput, fn func(*ListWorkloadSharesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkloadSharesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkloadSharesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkloadSharesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkloads = "ListWorkloads"

// ListWorkloadsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkloads operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkloads for more information on using the ListWorkloads
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWorkloadsRequest method.
//	req, resp := client.ListWorkloadsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloads
func (c *WellArchitected) ListWorkloadsRequest(input *ListWorkloadsInput) (req *request.Request, output *ListWorkloadsOutput) {
	op := &request.Operation{
		Name:       opListWorkloads,
		HTTPMethod: "POST",
		HTTPPath:   "/workloadsSummaries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkloadsInput{}
	}

	output = &ListWorkloadsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkloads API operation for AWS Well-Architected Tool.
//
// Paginated list of workloads.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation ListWorkloads for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloads
func (c *WellArchitected) ListWorkloads(input *ListWorkloadsInput) (*ListWorkloadsOutput, error) {
	req, out := c.ListWorkloadsRequest(input)
	return out, req.Send()
}

// ListWorkloadsWithContext is the same as ListWorkloads with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkloads for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListWorkloadsWithContext(ctx aws.Context, input *ListWorkloadsInput, opts ...request.Option) (*ListWorkloadsOutput, error) {
	req, out := c.ListWorkloadsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkloadsPages iterates over the pages of a ListWorkloads operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkloads method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWorkloads operation.
//	pageNum := 0
//	err := client.ListWorkloadsPages(params,
//	    func(page *wellarchitected.ListWorkloadsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WellArchitected) ListWorkloadsPages(input *ListWorkloadsInput, fn func(*ListWorkloadsOutput, bool) bool) error {
	return c.ListWorkloadsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkloadsPagesWithContext same as ListWorkloadsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) ListWorkloadsPagesWithContext(ctx aws.Context, input *ListWorkloadsInput, fn func(*ListWorkloadsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkloadsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkloadsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkloadsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/TagResource
func (c *WellArchitected) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{WorkloadArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Well-Architected Tool.
//
// Adds one or more tags to the specified resource.
//
// The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile
// ARN, or review template ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/TagResource
func (c *WellArchitected) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UntagResource
func (c *WellArchitected) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{WorkloadArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Well-Architected Tool.
//
// Deletes specified tags from a resource.
//
// The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile
// ARN, or review template ARN.
//
// To specify multiple tags, use separate tagKeys parameters, for example:
//
// DELETE /tags/WorkloadArn?tagKeys=key1&tagKeys=key2
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UntagResource
func (c *WellArchitected) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAnswer = "UpdateAnswer"

// UpdateAnswerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAnswer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAnswer for more information on using the UpdateAnswer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAnswerRequest method.
//	req, resp := client.UpdateAnswerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateAnswer
func (c *WellArchitected) UpdateAnswerRequest(input *UpdateAnswerInput) (req *request.Request, output *UpdateAnswerOutput) {
	op := &request.Operation{
		Name:       opUpdateAnswer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers/{QuestionId}",
	}

	if input == nil {
		input = &UpdateAnswerInput{}
	}

	output = &UpdateAnswerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAnswer API operation for AWS Well-Architected Tool.
//
// Update the answer to a specific question in a workload review.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpdateAnswer for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateAnswer
func (c *WellArchitected) UpdateAnswer(input *UpdateAnswerInput) (*UpdateAnswerOutput, error) {
	req, out := c.UpdateAnswerRequest(input)
	return out, req.Send()
}

// UpdateAnswerWithContext is the same as UpdateAnswer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAnswer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpdateAnswerWithContext(ctx aws.Context, input *UpdateAnswerInput, opts ...request.Option) (*UpdateAnswerOutput, error) {
	req, out := c.UpdateAnswerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGlobalSettings = "UpdateGlobalSettings"

// UpdateGlobalSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGlobalSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGlobalSettings for more information on using the UpdateGlobalSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGlobalSettingsRequest method.
//	req, resp := client.UpdateGlobalSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateGlobalSettings
func (c *WellArchitected) UpdateGlobalSettingsRequest(input *UpdateGlobalSettingsInput) (req *request.Request, output *UpdateGlobalSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateGlobalSettings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/global-settings",
	}

	if input == nil {
		input = &UpdateGlobalSettingsInput{}
	}

	output = &UpdateGlobalSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateGlobalSettings API operation for AWS Well-Architected Tool.
//
// Update whether the Amazon Web Services account is opted into organization
// sharing and discovery integration features.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpdateGlobalSettings for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateGlobalSettings
func (c *WellArchitected) UpdateGlobalSettings(input *UpdateGlobalSettingsInput) (*UpdateGlobalSettingsOutput, error) {
	req, out := c.UpdateGlobalSettingsRequest(input)
	return out, req.Send()
}

// UpdateGlobalSettingsWithContext is the same as UpdateGlobalSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGlobalSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpdateGlobalSettingsWithContext(ctx aws.Context, input *UpdateGlobalSettingsInput, opts ...request.Option) (*UpdateGlobalSettingsOutput, error) {
	req, out := c.UpdateGlobalSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIntegration = "UpdateIntegration"

// UpdateIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIntegration for more information on using the UpdateIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIntegrationRequest method.
//	req, resp := client.UpdateIntegrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateIntegration
func (c *WellArchitected) UpdateIntegrationRequest(input *UpdateIntegrationInput) (req *request.Request, output *UpdateIntegrationOutput) {
	op := &request.Operation{
		Name:       opUpdateIntegration,
		HTTPMethod: "POST",
		HTTPPath:   "/workloads/{WorkloadId}/updateIntegration",
	}

	if input == nil {
		input = &UpdateIntegrationInput{}
	}

	output = &UpdateIntegrationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateIntegration API operation for AWS Well-Architected Tool.
//
// Update integration features.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpdateIntegration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateIntegration
func (c *WellArchitected) UpdateIntegration(input *UpdateIntegrationInput) (*UpdateIntegrationOutput, error) {
	req, out := c.UpdateIntegrationRequest(input)
	return out, req.Send()
}

// UpdateIntegrationWithContext is the same as UpdateIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpdateIntegrationWithContext(ctx aws.Context, input *UpdateIntegrationInput, opts ...request.Option) (*UpdateIntegrationOutput, error) {
	req, out := c.UpdateIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLensReview = "UpdateLensReview"

// UpdateLensReviewRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLensReview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLensReview for more information on using the UpdateLensReview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLensReviewRequest method.
//	req, resp := client.UpdateLensReviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateLensReview
func (c *WellArchitected) UpdateLensReviewRequest(input *UpdateLensReviewInput) (req *request.Request, output *UpdateLensReviewOutput) {
	op := &request.Operation{
		Name:       opUpdateLensReview,
		HTTPMethod: "PATCH",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews/{LensAlias}",
	}

	if input == nil {
		input = &UpdateLensReviewInput{}
	}

	output = &UpdateLensReviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLensReview API operation for AWS Well-Architected Tool.
//
// Update lens review for a particular workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpdateLensReview for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateLensReview
func (c *WellArchitected) UpdateLensReview(input *UpdateLensReviewInput) (*UpdateLensReviewOutput, error) {
	req, out := c.UpdateLensReviewRequest(input)
	return out, req.Send()
}

// UpdateLensReviewWithContext is the same as UpdateLensReview with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLensReview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpdateLensReviewWithContext(ctx aws.Context, input *UpdateLensReviewInput, opts ...request.Option) (*UpdateLensReviewOutput, error) {
	req, out := c.UpdateLensReviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProfile = "UpdateProfile"

// UpdateProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProfile for more information on using the UpdateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProfileRequest method.
//	req, resp := client.UpdateProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateProfile
func (c *WellArchitected) UpdateProfileRequest(input *UpdateProfileInput) (req *request.Request, output *UpdateProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateProfile,
		HTTPMethod: "PATCH",
		HTTPPath:   "/profiles/{ProfileArn}",
	}

	if input == nil {
		input = &UpdateProfileInput{}
	}

	output = &UpdateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProfile API operation for AWS Well-Architected Tool.
//
// Update a profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpdateProfile for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateProfile
func (c *WellArchitected) UpdateProfile(input *UpdateProfileInput) (*UpdateProfileOutput, error) {
	req, out := c.UpdateProfileRequest(input)
	return out, req.Send()
}

// UpdateProfileWithContext is the same as UpdateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpdateProfileWithContext(ctx aws.Context, input *UpdateProfileInput, opts ...request.Option) (*UpdateProfileOutput, error) {
	req, out := c.UpdateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReviewTemplate = "UpdateReviewTemplate"

// UpdateReviewTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReviewTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateReviewTemplate for more information on using the UpdateReviewTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateReviewTemplateRequest method.
//	req, resp := client.UpdateReviewTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateReviewTemplate
func (c *WellArchitected) UpdateReviewTemplateRequest(input *UpdateReviewTemplateInput) (req *request.Request, output *UpdateReviewTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateReviewTemplate,
		HTTPMethod: "PATCH",
		HTTPPath:   "/reviewTemplates/{TemplateArn}",
	}

	if input == nil {
		input = &UpdateReviewTemplateInput{}
	}

	output = &UpdateReviewTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateReviewTemplate API operation for AWS Well-Architected Tool.
//
// Update a review template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpdateReviewTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateReviewTemplate
func (c *WellArchitected) UpdateReviewTemplate(input *UpdateReviewTemplateInput) (*UpdateReviewTemplateOutput, error) {
	req, out := c.UpdateReviewTemplateRequest(input)
	return out, req.Send()
}

// UpdateReviewTemplateWithContext is the same as UpdateReviewTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReviewTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpdateReviewTemplateWithContext(ctx aws.Context, input *UpdateReviewTemplateInput, opts ...request.Option) (*UpdateReviewTemplateOutput, error) {
	req, out := c.UpdateReviewTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReviewTemplateAnswer = "UpdateReviewTemplateAnswer"

// UpdateReviewTemplateAnswerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReviewTemplateAnswer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateReviewTemplateAnswer for more information on using the UpdateReviewTemplateAnswer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateReviewTemplateAnswerRequest method.
//	req, resp := client.UpdateReviewTemplateAnswerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateReviewTemplateAnswer
func (c *WellArchitected) UpdateReviewTemplateAnswerRequest(input *UpdateReviewTemplateAnswerInput) (req *request.Request, output *UpdateReviewTemplateAnswerOutput) {
	op := &request.Operation{
		Name:       opUpdateReviewTemplateAnswer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/reviewTemplates/{TemplateArn}/lensReviews/{LensAlias}/answers/{QuestionId}",
	}

	if input == nil {
		input = &UpdateReviewTemplateAnswerInput{}
	}

	output = &UpdateReviewTemplateAnswerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateReviewTemplateAnswer API operation for AWS Well-Architected Tool.
//
// Update a review template answer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpdateReviewTemplateAnswer for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateReviewTemplateAnswer
func (c *WellArchitected) UpdateReviewTemplateAnswer(input *UpdateReviewTemplateAnswerInput) (*UpdateReviewTemplateAnswerOutput, error) {
	req, out := c.UpdateReviewTemplateAnswerRequest(input)
	return out, req.Send()
}

// UpdateReviewTemplateAnswerWithContext is the same as UpdateReviewTemplateAnswer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReviewTemplateAnswer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpdateReviewTemplateAnswerWithContext(ctx aws.Context, input *UpdateReviewTemplateAnswerInput, opts ...request.Option) (*UpdateReviewTemplateAnswerOutput, error) {
	req, out := c.UpdateReviewTemplateAnswerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReviewTemplateLensReview = "UpdateReviewTemplateLensReview"

// UpdateReviewTemplateLensReviewRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReviewTemplateLensReview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateReviewTemplateLensReview for more information on using the UpdateReviewTemplateLensReview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateReviewTemplateLensReviewRequest method.
//	req, resp := client.UpdateReviewTemplateLensReviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateReviewTemplateLensReview
func (c *WellArchitected) UpdateReviewTemplateLensReviewRequest(input *UpdateReviewTemplateLensReviewInput) (req *request.Request, output *UpdateReviewTemplateLensReviewOutput) {
	op := &request.Operation{
		Name:       opUpdateReviewTemplateLensReview,
		HTTPMethod: "PATCH",
		HTTPPath:   "/reviewTemplates/{TemplateArn}/lensReviews/{LensAlias}",
	}

	if input == nil {
		input = &UpdateReviewTemplateLensReviewInput{}
	}

	output = &UpdateReviewTemplateLensReviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateReviewTemplateLensReview API operation for AWS Well-Architected Tool.
//
// Update a lens review associated with a review template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpdateReviewTemplateLensReview for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateReviewTemplateLensReview
func (c *WellArchitected) UpdateReviewTemplateLensReview(input *UpdateReviewTemplateLensReviewInput) (*UpdateReviewTemplateLensReviewOutput, error) {
	req, out := c.UpdateReviewTemplateLensReviewRequest(input)
	return out, req.Send()
}

// UpdateReviewTemplateLensReviewWithContext is the same as UpdateReviewTemplateLensReview with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReviewTemplateLensReview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpdateReviewTemplateLensReviewWithContext(ctx aws.Context, input *UpdateReviewTemplateLensReviewInput, opts ...request.Option) (*UpdateReviewTemplateLensReviewOutput, error) {
	req, out := c.UpdateReviewTemplateLensReviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateShareInvitation = "UpdateShareInvitation"

// UpdateShareInvitationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateShareInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateShareInvitation for more information on using the UpdateShareInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateShareInvitationRequest method.
//	req, resp := client.UpdateShareInvitationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateShareInvitation
func (c *WellArchitected) UpdateShareInvitationRequest(input *UpdateShareInvitationInput) (req *request.Request, output *UpdateShareInvitationOutput) {
	op := &request.Operation{
		Name:       opUpdateShareInvitation,
		HTTPMethod: "PATCH",
		HTTPPath:   "/shareInvitations/{ShareInvitationId}",
	}

	if input == nil {
		input = &UpdateShareInvitationInput{}
	}

	output = &UpdateShareInvitationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateShareInvitation API operation for AWS Well-Architected Tool.
//
// Update a workload or custom lens share invitation.
//
// This API operation can be called independently of any resource. Previous
// documentation implied that a workload ARN must be specified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpdateShareInvitation for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateShareInvitation
func (c *WellArchitected) UpdateShareInvitation(input *UpdateShareInvitationInput) (*UpdateShareInvitationOutput, error) {
	req, out := c.UpdateShareInvitationRequest(input)
	return out, req.Send()
}

// UpdateShareInvitationWithContext is the same as UpdateShareInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateShareInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpdateShareInvitationWithContext(ctx aws.Context, input *UpdateShareInvitationInput, opts ...request.Option) (*UpdateShareInvitationOutput, error) {
	req, out := c.UpdateShareInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkload = "UpdateWorkload"

// UpdateWorkloadRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkload for more information on using the UpdateWorkload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkloadRequest method.
//	req, resp := client.UpdateWorkloadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateWorkload
func (c *WellArchitected) UpdateWorkloadRequest(input *UpdateWorkloadInput) (req *request.Request, output *UpdateWorkloadOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkload,
		HTTPMethod: "PATCH",
		HTTPPath:   "/workloads/{WorkloadId}",
	}

	if input == nil {
		input = &UpdateWorkloadInput{}
	}

	output = &UpdateWorkloadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkload API operation for AWS Well-Architected Tool.
//
// Update an existing workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpdateWorkload for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateWorkload
func (c *WellArchitected) UpdateWorkload(input *UpdateWorkloadInput) (*UpdateWorkloadOutput, error) {
	req, out := c.UpdateWorkloadRequest(input)
	return out, req.Send()
}

// UpdateWorkloadWithContext is the same as UpdateWorkload with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpdateWorkloadWithContext(ctx aws.Context, input *UpdateWorkloadInput, opts ...request.Option) (*UpdateWorkloadOutput, error) {
	req, out := c.UpdateWorkloadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkloadShare = "UpdateWorkloadShare"

// UpdateWorkloadShareRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkloadShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkloadShare for more information on using the UpdateWorkloadShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkloadShareRequest method.
//	req, resp := client.UpdateWorkloadShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateWorkloadShare
func (c *WellArchitected) UpdateWorkloadShareRequest(input *UpdateWorkloadShareInput) (req *request.Request, output *UpdateWorkloadShareOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkloadShare,
		HTTPMethod: "PATCH",
		HTTPPath:   "/workloads/{WorkloadId}/shares/{ShareId}",
	}

	if input == nil {
		input = &UpdateWorkloadShareInput{}
	}

	output = &UpdateWorkloadShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkloadShare API operation for AWS Well-Architected Tool.
//
// Update a workload share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpdateWorkloadShare for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateWorkloadShare
func (c *WellArchitected) UpdateWorkloadShare(input *UpdateWorkloadShareInput) (*UpdateWorkloadShareOutput, error) {
	req, out := c.UpdateWorkloadShareRequest(input)
	return out, req.Send()
}

// UpdateWorkloadShareWithContext is the same as UpdateWorkloadShare with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkloadShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpdateWorkloadShareWithContext(ctx aws.Context, input *UpdateWorkloadShareInput, opts ...request.Option) (*UpdateWorkloadShareOutput, error) {
	req, out := c.UpdateWorkloadShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpgradeLensReview = "UpgradeLensReview"

// UpgradeLensReviewRequest generates a "aws/request.Request" representing the
// client's request for the UpgradeLensReview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpgradeLensReview for more information on using the UpgradeLensReview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpgradeLensReviewRequest method.
//	req, resp := client.UpgradeLensReviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpgradeLensReview
func (c *WellArchitected) UpgradeLensReviewRequest(input *UpgradeLensReviewInput) (req *request.Request, output *UpgradeLensReviewOutput) {
	op := &request.Operation{
		Name:       opUpgradeLensReview,
		HTTPMethod: "PUT",
		HTTPPath:   "/workloads/{WorkloadId}/lensReviews/{LensAlias}/upgrade",
	}

	if input == nil {
		input = &UpgradeLensReviewInput{}
	}

	output = &UpgradeLensReviewOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpgradeLensReview API operation for AWS Well-Architected Tool.
//
// Upgrade lens review for a particular workload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpgradeLensReview for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The user has reached their resource quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpgradeLensReview
func (c *WellArchitected) UpgradeLensReview(input *UpgradeLensReviewInput) (*UpgradeLensReviewOutput, error) {
	req, out := c.UpgradeLensReviewRequest(input)
	return out, req.Send()
}

// UpgradeLensReviewWithContext is the same as UpgradeLensReview with the addition of
// the ability to pass a context and additional request options.
//
// See UpgradeLensReview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpgradeLensReviewWithContext(ctx aws.Context, input *UpgradeLensReviewInput, opts ...request.Option) (*UpgradeLensReviewOutput, error) {
	req, out := c.UpgradeLensReviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpgradeProfileVersion = "UpgradeProfileVersion"

// UpgradeProfileVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpgradeProfileVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpgradeProfileVersion for more information on using the UpgradeProfileVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpgradeProfileVersionRequest method.
//	req, resp := client.UpgradeProfileVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpgradeProfileVersion
func (c *WellArchitected) UpgradeProfileVersionRequest(input *UpgradeProfileVersionInput) (req *request.Request, output *UpgradeProfileVersionOutput) {
	op := &request.Operation{
		Name:       opUpgradeProfileVersion,
		HTTPMethod: "PUT",
		HTTPPath:   "/workloads/{WorkloadId}/profiles/{ProfileArn}/upgrade",
	}

	if input == nil {
		input = &UpgradeProfileVersionInput{}
	}

	output = &UpgradeProfileVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpgradeProfileVersion API operation for AWS Well-Architected Tool.
//
// Upgrade a profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpgradeProfileVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The user has reached their resource quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpgradeProfileVersion
func (c *WellArchitected) UpgradeProfileVersion(input *UpgradeProfileVersionInput) (*UpgradeProfileVersionOutput, error) {
	req, out := c.UpgradeProfileVersionRequest(input)
	return out, req.Send()
}

// UpgradeProfileVersionWithContext is the same as UpgradeProfileVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpgradeProfileVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpgradeProfileVersionWithContext(ctx aws.Context, input *UpgradeProfileVersionInput, opts ...request.Option) (*UpgradeProfileVersionOutput, error) {
	req, out := c.UpgradeProfileVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpgradeReviewTemplateLensReview = "UpgradeReviewTemplateLensReview"

// UpgradeReviewTemplateLensReviewRequest generates a "aws/request.Request" representing the
// client's request for the UpgradeReviewTemplateLensReview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpgradeReviewTemplateLensReview for more information on using the UpgradeReviewTemplateLensReview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpgradeReviewTemplateLensReviewRequest method.
//	req, resp := client.UpgradeReviewTemplateLensReviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpgradeReviewTemplateLensReview
func (c *WellArchitected) UpgradeReviewTemplateLensReviewRequest(input *UpgradeReviewTemplateLensReviewInput) (req *request.Request, output *UpgradeReviewTemplateLensReviewOutput) {
	op := &request.Operation{
		Name:       opUpgradeReviewTemplateLensReview,
		HTTPMethod: "PUT",
		HTTPPath:   "/reviewTemplates/{TemplateArn}/lensReviews/{LensAlias}/upgrade",
	}

	if input == nil {
		input = &UpgradeReviewTemplateLensReviewInput{}
	}

	output = &UpgradeReviewTemplateLensReviewOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpgradeReviewTemplateLensReview API operation for AWS Well-Architected Tool.
//
// Upgrade the lens review of a review template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Well-Architected Tool's
// API operation UpgradeReviewTemplateLensReview for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input is not valid.
//
//   - ResourceNotFoundException
//     The requested resource was not found.
//
//   - ConflictException
//     The resource has already been processed, was deleted, or is too large.
//
//   - InternalServerException
//     There is a problem with the Well-Architected Tool API service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpgradeReviewTemplateLensReview
func (c *WellArchitected) UpgradeReviewTemplateLensReview(input *UpgradeReviewTemplateLensReviewInput) (*UpgradeReviewTemplateLensReviewOutput, error) {
	req, out := c.UpgradeReviewTemplateLensReviewRequest(input)
	return out, req.Send()
}

// UpgradeReviewTemplateLensReviewWithContext is the same as UpgradeReviewTemplateLensReview with the addition of
// the ability to pass a context and additional request options.
//
// See UpgradeReviewTemplateLensReview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WellArchitected) UpgradeReviewTemplateLensReviewWithContext(ctx aws.Context, input *UpgradeReviewTemplateLensReviewInput, opts ...request.Option) (*UpgradeReviewTemplateLensReviewOutput, error) {
	req, out := c.UpgradeReviewTemplateLensReviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// User does not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Account-level: Input for the Jira configuration.
type AccountJiraConfigurationInput_ struct {
	_ struct{} `type:"structure"`

	// Account-level: Configuration status of the Jira integration.
	IntegrationStatus *string `type:"string" enum:"IntegrationStatusInput_"`

	// Account-level: Jira issue management status.
	IssueManagementStatus *string `type:"string" enum:"AccountJiraIssueManagementStatus"`

	// Account-level: Jira issue management type.
	IssueManagementType *string `type:"string" enum:"IssueManagementType"`

	// Account-level: Jira project key to sync workloads to.
	JiraProjectKey *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountJiraConfigurationInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountJiraConfigurationInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountJiraConfigurationInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountJiraConfigurationInput_"}
	if s.JiraProjectKey != nil && len(*s.JiraProjectKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JiraProjectKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIntegrationStatus sets the IntegrationStatus field's value.
func (s *AccountJiraConfigurationInput_) SetIntegrationStatus(v string) *AccountJiraConfigurationInput_ {
	s.IntegrationStatus = &v
	return s
}

// SetIssueManagementStatus sets the IssueManagementStatus field's value.
func (s *AccountJiraConfigurationInput_) SetIssueManagementStatus(v string) *AccountJiraConfigurationInput_ {
	s.IssueManagementStatus = &v
	return s
}

// SetIssueManagementType sets the IssueManagementType field's value.
func (s *AccountJiraConfigurationInput_) SetIssueManagementType(v string) *AccountJiraConfigurationInput_ {
	s.IssueManagementType = &v
	return s
}

// SetJiraProjectKey sets the JiraProjectKey field's value.
func (s *AccountJiraConfigurationInput_) SetJiraProjectKey(v string) *AccountJiraConfigurationInput_ {
	s.JiraProjectKey = &v
	return s
}

// Account-level: Output configuration of the Jira integration.
type AccountJiraConfigurationOutput_ struct {
	_ struct{} `type:"structure"`

	// Account-level: Configuration status of the Jira integration.
	IntegrationStatus *string `type:"string" enum:"IntegrationStatus"`

	// Account-level: Jira issue management status.
	IssueManagementStatus *string `type:"string" enum:"AccountJiraIssueManagementStatus"`

	// Account-level: Jira issue management type.
	IssueManagementType *string `type:"string" enum:"IssueManagementType"`

	// Account-level: Jira project key to sync workloads to.
	JiraProjectKey *string `min:"1" type:"string"`

	// Account-level: Status message on configuration of the Jira integration.
	StatusMessage *string `min:"1" type:"string"`

	// Account-level: Jira subdomain URL.
	Subdomain *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountJiraConfigurationOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountJiraConfigurationOutput_) GoString() string {
	return s.String()
}

// SetIntegrationStatus sets the IntegrationStatus field's value.
func (s *AccountJiraConfigurationOutput_) SetIntegrationStatus(v string) *AccountJiraConfigurationOutput_ {
	s.IntegrationStatus = &v
	return s
}

// SetIssueManagementStatus sets the IssueManagementStatus field's value.
func (s *AccountJiraConfigurationOutput_) SetIssueManagementStatus(v string) *AccountJiraConfigurationOutput_ {
	s.IssueManagementStatus = &v
	return s
}

// SetIssueManagementType sets the IssueManagementType field's value.
func (s *AccountJiraConfigurationOutput_) SetIssueManagementType(v string) *AccountJiraConfigurationOutput_ {
	s.IssueManagementType = &v
	return s
}

// SetJiraProjectKey sets the JiraProjectKey field's value.
func (s *AccountJiraConfigurationOutput_) SetJiraProjectKey(v string) *AccountJiraConfigurationOutput_ {
	s.JiraProjectKey = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *AccountJiraConfigurationOutput_) SetStatusMessage(v string) *AccountJiraConfigurationOutput_ {
	s.StatusMessage = &v
	return s
}

// SetSubdomain sets the Subdomain field's value.
func (s *AccountJiraConfigurationOutput_) SetSubdomain(v string) *AccountJiraConfigurationOutput_ {
	s.Subdomain = &v
	return s
}

// The choice level additional resources for a custom lens.
//
// This field does not apply to Amazon Web Services official lenses.
type AdditionalResources struct {
	_ struct{} `type:"structure"`

	// The URLs for additional resources, either helpful resources or improvement
	// plans, for a custom lens. Up to five additional URLs can be specified.
	Content []*ChoiceContent `type:"list"`

	// Type of additional resource for a custom lens.
	Type *string `type:"string" enum:"AdditionalResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalResources) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalResources) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *AdditionalResources) SetContent(v []*ChoiceContent) *AdditionalResources {
	s.Content = v
	return s
}

// SetType sets the Type field's value.
func (s *AdditionalResources) SetType(v string) *AdditionalResources {
	s.Type = &v
	return s
}

// An answer of the question.
type Answer struct {
	_ struct{} `type:"structure"`

	// A list of selected choices to a question in your workload.
	ChoiceAnswers []*ChoiceAnswer `type:"list"`

	// List of choices available for a question.
	Choices []*Choice `type:"list"`

	// The helpful resource text to be displayed for a custom lens.
	//
	// This field does not apply to Amazon Web Services official lenses.
	HelpfulResourceDisplayText *string `min:"1" type:"string"`

	// The helpful resource URL.
	//
	// For Amazon Web Services official lenses, this is the helpful resource URL
	// for a question or choice.
	//
	// For custom lenses, this is the helpful resource URL for a question and is
	// only provided if HelpfulResourceDisplayText was specified for the question.
	HelpfulResourceUrl *string `min:"1" type:"string"`

	// The improvement plan URL for a question in an Amazon Web Services official
	// lenses.
	//
	// This value is only available if the question has been answered.
	//
	// This value does not apply to custom lenses.
	ImprovementPlanUrl *string `min:"1" type:"string"`

	// Defines whether this question is applicable to a lens review.
	IsApplicable *bool `type:"boolean"`

	// Configuration of the Jira integration.
	JiraConfiguration *JiraConfiguration `type:"structure"`

	// The notes associated with the workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	Notes *string `type:"string"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// The description of the question.
	QuestionDescription *string `min:"1" type:"string"`

	// The ID of the question.
	QuestionId *string `min:"1" type:"string"`

	// The title of the question.
	QuestionTitle *string `min:"1" type:"string"`

	// The reason why the question is not applicable to your workload.
	Reason *string `type:"string" enum:"AnswerReason"`

	// The risk for a given workload, lens review, pillar, or question.
	Risk *string `type:"string" enum:"Risk"`

	// List of selected choice IDs in a question answer.
	//
	// The values entered replace the previously selected choices.
	SelectedChoices []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Answer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Answer) GoString() string {
	return s.String()
}

// SetChoiceAnswers sets the ChoiceAnswers field's value.
func (s *Answer) SetChoiceAnswers(v []*ChoiceAnswer) *Answer {
	s.ChoiceAnswers = v
	return s
}

// SetChoices sets the Choices field's value.
func (s *Answer) SetChoices(v []*Choice) *Answer {
	s.Choices = v
	return s
}

// SetHelpfulResourceDisplayText sets the HelpfulResourceDisplayText field's value.
func (s *Answer) SetHelpfulResourceDisplayText(v string) *Answer {
	s.HelpfulResourceDisplayText = &v
	return s
}

// SetHelpfulResourceUrl sets the HelpfulResourceUrl field's value.
func (s *Answer) SetHelpfulResourceUrl(v string) *Answer {
	s.HelpfulResourceUrl = &v
	return s
}

// SetImprovementPlanUrl sets the ImprovementPlanUrl field's value.
func (s *Answer) SetImprovementPlanUrl(v string) *Answer {
	s.ImprovementPlanUrl = &v
	return s
}

// SetIsApplicable sets the IsApplicable field's value.
func (s *Answer) SetIsApplicable(v bool) *Answer {
	s.IsApplicable = &v
	return s
}

// SetJiraConfiguration sets the JiraConfiguration field's value.
func (s *Answer) SetJiraConfiguration(v *JiraConfiguration) *Answer {
	s.JiraConfiguration = v
	return s
}

// SetNotes sets the Notes field's value.
func (s *Answer) SetNotes(v string) *Answer {
	s.Notes = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *Answer) SetPillarId(v string) *Answer {
	s.PillarId = &v
	return s
}

// SetQuestionDescription sets the QuestionDescription field's value.
func (s *Answer) SetQuestionDescription(v string) *Answer {
	s.QuestionDescription = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *Answer) SetQuestionId(v string) *Answer {
	s.QuestionId = &v
	return s
}

// SetQuestionTitle sets the QuestionTitle field's value.
func (s *Answer) SetQuestionTitle(v string) *Answer {
	s.QuestionTitle = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *Answer) SetReason(v string) *Answer {
	s.Reason = &v
	return s
}

// SetRisk sets the Risk field's value.
func (s *Answer) SetRisk(v string) *Answer {
	s.Risk = &v
	return s
}

// SetSelectedChoices sets the SelectedChoices field's value.
func (s *Answer) SetSelectedChoices(v []*string) *Answer {
	s.SelectedChoices = v
	return s
}

// An answer summary of a lens review in a workload.
type AnswerSummary struct {
	_ struct{} `type:"structure"`

	// A list of selected choices to a question in your workload.
	ChoiceAnswerSummaries []*ChoiceAnswerSummary `type:"list"`

	// List of choices available for a question.
	Choices []*Choice `type:"list"`

	// Defines whether this question is applicable to a lens review.
	IsApplicable *bool `type:"boolean"`

	// Configuration of the Jira integration.
	JiraConfiguration *JiraConfiguration `type:"structure"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// The ID of the question.
	QuestionId *string `min:"1" type:"string"`

	// The title of the question.
	QuestionTitle *string `min:"1" type:"string"`

	// The type of the question.
	QuestionType *string `type:"string" enum:"QuestionType"`

	// The reason why a choice is non-applicable to a question in your workload.
	Reason *string `type:"string" enum:"AnswerReason"`

	// The risk for a given workload, lens review, pillar, or question.
	Risk *string `type:"string" enum:"Risk"`

	// List of selected choice IDs in a question answer.
	//
	// The values entered replace the previously selected choices.
	SelectedChoices []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnswerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnswerSummary) GoString() string {
	return s.String()
}

// SetChoiceAnswerSummaries sets the ChoiceAnswerSummaries field's value.
func (s *AnswerSummary) SetChoiceAnswerSummaries(v []*ChoiceAnswerSummary) *AnswerSummary {
	s.ChoiceAnswerSummaries = v
	return s
}

// SetChoices sets the Choices field's value.
func (s *AnswerSummary) SetChoices(v []*Choice) *AnswerSummary {
	s.Choices = v
	return s
}

// SetIsApplicable sets the IsApplicable field's value.
func (s *AnswerSummary) SetIsApplicable(v bool) *AnswerSummary {
	s.IsApplicable = &v
	return s
}

// SetJiraConfiguration sets the JiraConfiguration field's value.
func (s *AnswerSummary) SetJiraConfiguration(v *JiraConfiguration) *AnswerSummary {
	s.JiraConfiguration = v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *AnswerSummary) SetPillarId(v string) *AnswerSummary {
	s.PillarId = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *AnswerSummary) SetQuestionId(v string) *AnswerSummary {
	s.QuestionId = &v
	return s
}

// SetQuestionTitle sets the QuestionTitle field's value.
func (s *AnswerSummary) SetQuestionTitle(v string) *AnswerSummary {
	s.QuestionTitle = &v
	return s
}

// SetQuestionType sets the QuestionType field's value.
func (s *AnswerSummary) SetQuestionType(v string) *AnswerSummary {
	s.QuestionType = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *AnswerSummary) SetReason(v string) *AnswerSummary {
	s.Reason = &v
	return s
}

// SetRisk sets the Risk field's value.
func (s *AnswerSummary) SetRisk(v string) *AnswerSummary {
	s.Risk = &v
	return s
}

// SetSelectedChoices sets the SelectedChoices field's value.
func (s *AnswerSummary) SetSelectedChoices(v []*string) *AnswerSummary {
	s.SelectedChoices = v
	return s
}

// Input to associate lens reviews.
type AssociateLensesInput struct {
	_ struct{} `type:"structure"`

	// List of lens aliases to associate or disassociate with a workload. Up to
	// 10 lenses can be specified.
	//
	// Identify a lens using its LensSummary$LensAlias.
	//
	// LensAliases is a required field
	LensAliases []*string `min:"1" type:"list" required:"true"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLensesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLensesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateLensesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateLensesInput"}
	if s.LensAliases == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAliases"))
	}
	if s.LensAliases != nil && len(s.LensAliases) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAliases", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAliases sets the LensAliases field's value.
func (s *AssociateLensesInput) SetLensAliases(v []*string) *AssociateLensesInput {
	s.LensAliases = v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *AssociateLensesInput) SetWorkloadId(v string) *AssociateLensesInput {
	s.WorkloadId = &v
	return s
}

type AssociateLensesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLensesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLensesOutput) GoString() string {
	return s.String()
}

type AssociateProfilesInput struct {
	_ struct{} `type:"structure"`

	// The list of profile ARNs to associate with the workload.
	//
	// ProfileArns is a required field
	ProfileArns []*string `min:"1" type:"list" required:"true"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateProfilesInput"}
	if s.ProfileArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileArns"))
	}
	if s.ProfileArns != nil && len(s.ProfileArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileArns", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileArns sets the ProfileArns field's value.
func (s *AssociateProfilesInput) SetProfileArns(v []*string) *AssociateProfilesInput {
	s.ProfileArns = v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *AssociateProfilesInput) SetWorkloadId(v string) *AssociateProfilesInput {
	s.WorkloadId = &v
	return s
}

type AssociateProfilesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateProfilesOutput) GoString() string {
	return s.String()
}

// A best practice, or question choice, that has been identified as a risk in
// this question.
type BestPractice struct {
	_ struct{} `type:"structure"`

	// The ID of a choice.
	ChoiceId *string `min:"1" type:"string"`

	// The title of a choice.
	ChoiceTitle *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BestPractice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BestPractice) GoString() string {
	return s.String()
}

// SetChoiceId sets the ChoiceId field's value.
func (s *BestPractice) SetChoiceId(v string) *BestPractice {
	s.ChoiceId = &v
	return s
}

// SetChoiceTitle sets the ChoiceTitle field's value.
func (s *BestPractice) SetChoiceTitle(v string) *BestPractice {
	s.ChoiceTitle = &v
	return s
}

// Account details for a Well-Architected best practice in relation to Trusted
// Advisor checks.
type CheckDetail struct {
	_ struct{} `type:"structure"`

	// An Amazon Web Services account ID.
	AccountId *string `min:"12" type:"string"`

	// The ID of a choice.
	ChoiceId *string `min:"1" type:"string"`

	// Trusted Advisor check description.
	Description *string `type:"string"`

	// Count of flagged resources associated to the check.
	FlaggedResources *int64 `min:"1" type:"integer"`

	// Trusted Advisor check ID.
	Id *string `type:"string"`

	// Well-Architected Lens ARN associated to the check.
	LensArn *string `type:"string"`

	// Trusted Advisor check name.
	Name *string `type:"string"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// Provider of the check related to the best practice.
	Provider *string `type:"string" enum:"CheckProvider"`

	// The ID of the question.
	QuestionId *string `min:"1" type:"string"`

	// Reason associated to the check.
	Reason *string `type:"string" enum:"CheckFailureReason"`

	// Status associated to the check.
	Status *string `type:"string" enum:"CheckStatus"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CheckDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CheckDetail) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *CheckDetail) SetAccountId(v string) *CheckDetail {
	s.AccountId = &v
	return s
}

// SetChoiceId sets the ChoiceId field's value.
func (s *CheckDetail) SetChoiceId(v string) *CheckDetail {
	s.ChoiceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CheckDetail) SetDescription(v string) *CheckDetail {
	s.Description = &v
	return s
}

// SetFlaggedResources sets the FlaggedResources field's value.
func (s *CheckDetail) SetFlaggedResources(v int64) *CheckDetail {
	s.FlaggedResources = &v
	return s
}

// SetId sets the Id field's value.
func (s *CheckDetail) SetId(v string) *CheckDetail {
	s.Id = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *CheckDetail) SetLensArn(v string) *CheckDetail {
	s.LensArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CheckDetail) SetName(v string) *CheckDetail {
	s.Name = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *CheckDetail) SetPillarId(v string) *CheckDetail {
	s.PillarId = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *CheckDetail) SetProvider(v string) *CheckDetail {
	s.Provider = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *CheckDetail) SetQuestionId(v string) *CheckDetail {
	s.QuestionId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *CheckDetail) SetReason(v string) *CheckDetail {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CheckDetail) SetStatus(v string) *CheckDetail {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CheckDetail) SetUpdatedAt(v time.Time) *CheckDetail {
	s.UpdatedAt = &v
	return s
}

// Trusted Advisor check summary.
type CheckSummary struct {
	_ struct{} `type:"structure"`

	// Account summary associated to the check.
	AccountSummary map[string]*int64 `type:"map"`

	// The ID of a choice.
	ChoiceId *string `min:"1" type:"string"`

	// Trusted Advisor check description.
	Description *string `type:"string"`

	// Trusted Advisor check ID.
	Id *string `type:"string"`

	// Well-Architected Lens ARN associated to the check.
	LensArn *string `type:"string"`

	// Trusted Advisor check name.
	Name *string `type:"string"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// Provider of the check related to the best practice.
	Provider *string `type:"string" enum:"CheckProvider"`

	// The ID of the question.
	QuestionId *string `min:"1" type:"string"`

	// Status associated to the check.
	Status *string `type:"string" enum:"CheckStatus"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CheckSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CheckSummary) GoString() string {
	return s.String()
}

// SetAccountSummary sets the AccountSummary field's value.
func (s *CheckSummary) SetAccountSummary(v map[string]*int64) *CheckSummary {
	s.AccountSummary = v
	return s
}

// SetChoiceId sets the ChoiceId field's value.
func (s *CheckSummary) SetChoiceId(v string) *CheckSummary {
	s.ChoiceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CheckSummary) SetDescription(v string) *CheckSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CheckSummary) SetId(v string) *CheckSummary {
	s.Id = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *CheckSummary) SetLensArn(v string) *CheckSummary {
	s.LensArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CheckSummary) SetName(v string) *CheckSummary {
	s.Name = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *CheckSummary) SetPillarId(v string) *CheckSummary {
	s.PillarId = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *CheckSummary) SetProvider(v string) *CheckSummary {
	s.Provider = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *CheckSummary) SetQuestionId(v string) *CheckSummary {
	s.QuestionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CheckSummary) SetStatus(v string) *CheckSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CheckSummary) SetUpdatedAt(v time.Time) *CheckSummary {
	s.UpdatedAt = &v
	return s
}

// A choice available to answer question.
type Choice struct {
	_ struct{} `type:"structure"`

	// The additional resources for a choice in a custom lens.
	//
	// A choice can have up to two additional resources: one of type HELPFUL_RESOURCE,
	// one of type IMPROVEMENT_PLAN, or both.
	AdditionalResources []*AdditionalResources `type:"list"`

	// The ID of a choice.
	ChoiceId *string `min:"1" type:"string"`

	// The description of a choice.
	Description *string `min:"1" type:"string"`

	// The helpful resource (both text and URL) for a particular choice.
	//
	// This field only applies to custom lenses. Each choice can have only one helpful
	// resource.
	HelpfulResource *ChoiceContent `type:"structure"`

	// The improvement plan (both text and URL) for a particular choice.
	//
	// This field only applies to custom lenses. Each choice can have only one improvement
	// plan.
	ImprovementPlan *ChoiceContent `type:"structure"`

	// The title of a choice.
	Title *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Choice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Choice) GoString() string {
	return s.String()
}

// SetAdditionalResources sets the AdditionalResources field's value.
func (s *Choice) SetAdditionalResources(v []*AdditionalResources) *Choice {
	s.AdditionalResources = v
	return s
}

// SetChoiceId sets the ChoiceId field's value.
func (s *Choice) SetChoiceId(v string) *Choice {
	s.ChoiceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Choice) SetDescription(v string) *Choice {
	s.Description = &v
	return s
}

// SetHelpfulResource sets the HelpfulResource field's value.
func (s *Choice) SetHelpfulResource(v *ChoiceContent) *Choice {
	s.HelpfulResource = v
	return s
}

// SetImprovementPlan sets the ImprovementPlan field's value.
func (s *Choice) SetImprovementPlan(v *ChoiceContent) *Choice {
	s.ImprovementPlan = v
	return s
}

// SetTitle sets the Title field's value.
func (s *Choice) SetTitle(v string) *Choice {
	s.Title = &v
	return s
}

// A choice that has been answered on a question in your workload.
type ChoiceAnswer struct {
	_ struct{} `type:"structure"`

	// The ID of a choice.
	ChoiceId *string `min:"1" type:"string"`

	// The notes associated with a choice.
	Notes *string `type:"string"`

	// The reason why a choice is non-applicable to a question in your workload.
	Reason *string `type:"string" enum:"ChoiceReason"`

	// The status of a choice.
	Status *string `type:"string" enum:"ChoiceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChoiceAnswer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChoiceAnswer) GoString() string {
	return s.String()
}

// SetChoiceId sets the ChoiceId field's value.
func (s *ChoiceAnswer) SetChoiceId(v string) *ChoiceAnswer {
	s.ChoiceId = &v
	return s
}

// SetNotes sets the Notes field's value.
func (s *ChoiceAnswer) SetNotes(v string) *ChoiceAnswer {
	s.Notes = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ChoiceAnswer) SetReason(v string) *ChoiceAnswer {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChoiceAnswer) SetStatus(v string) *ChoiceAnswer {
	s.Status = &v
	return s
}

// A choice summary that has been answered on a question in your workload.
type ChoiceAnswerSummary struct {
	_ struct{} `type:"structure"`

	// The ID of a choice.
	ChoiceId *string `min:"1" type:"string"`

	// The reason why a choice is non-applicable to a question in your workload.
	Reason *string `type:"string" enum:"ChoiceReason"`

	// The status of a choice.
	Status *string `type:"string" enum:"ChoiceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChoiceAnswerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChoiceAnswerSummary) GoString() string {
	return s.String()
}

// SetChoiceId sets the ChoiceId field's value.
func (s *ChoiceAnswerSummary) SetChoiceId(v string) *ChoiceAnswerSummary {
	s.ChoiceId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ChoiceAnswerSummary) SetReason(v string) *ChoiceAnswerSummary {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChoiceAnswerSummary) SetStatus(v string) *ChoiceAnswerSummary {
	s.Status = &v
	return s
}

// The choice content.
type ChoiceContent struct {
	_ struct{} `type:"structure"`

	// The display text for the choice content.
	DisplayText *string `min:"1" type:"string"`

	// The URL for the choice content.
	Url *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChoiceContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChoiceContent) GoString() string {
	return s.String()
}

// SetDisplayText sets the DisplayText field's value.
func (s *ChoiceContent) SetDisplayText(v string) *ChoiceContent {
	s.DisplayText = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ChoiceContent) SetUrl(v string) *ChoiceContent {
	s.Url = &v
	return s
}

// The choice level improvement plan.
type ChoiceImprovementPlan struct {
	_ struct{} `type:"structure"`

	// The ID of a choice.
	ChoiceId *string `min:"1" type:"string"`

	// The display text for the improvement plan.
	DisplayText *string `min:"1" type:"string"`

	// The improvement plan URL for a question in an Amazon Web Services official
	// lenses.
	//
	// This value is only available if the question has been answered.
	//
	// This value does not apply to custom lenses.
	ImprovementPlanUrl *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChoiceImprovementPlan) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChoiceImprovementPlan) GoString() string {
	return s.String()
}

// SetChoiceId sets the ChoiceId field's value.
func (s *ChoiceImprovementPlan) SetChoiceId(v string) *ChoiceImprovementPlan {
	s.ChoiceId = &v
	return s
}

// SetDisplayText sets the DisplayText field's value.
func (s *ChoiceImprovementPlan) SetDisplayText(v string) *ChoiceImprovementPlan {
	s.DisplayText = &v
	return s
}

// SetImprovementPlanUrl sets the ImprovementPlanUrl field's value.
func (s *ChoiceImprovementPlan) SetImprovementPlanUrl(v string) *ChoiceImprovementPlan {
	s.ImprovementPlanUrl = &v
	return s
}

// A list of choices to be updated.
type ChoiceUpdate struct {
	_ struct{} `type:"structure"`

	// The notes associated with a choice.
	Notes *string `type:"string"`

	// The reason why a choice is non-applicable to a question in your workload.
	Reason *string `type:"string" enum:"ChoiceReason"`

	// The status of a choice.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ChoiceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChoiceUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChoiceUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChoiceUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChoiceUpdate"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotes sets the Notes field's value.
func (s *ChoiceUpdate) SetNotes(v string) *ChoiceUpdate {
	s.Notes = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ChoiceUpdate) SetReason(v string) *ChoiceUpdate {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChoiceUpdate) SetStatus(v string) *ChoiceUpdate {
	s.Status = &v
	return s
}

// The resource has already been processed, was deleted, or is too large.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"Message" type:"string"`

	// Identifier of the resource affected.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Type of the resource affected.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A metric that contributes to the consolidated report.
type ConsolidatedReportMetric struct {
	_ struct{} `type:"structure"`

	// The metrics for the lenses in the workload.
	Lenses []*LensMetric `type:"list"`

	// The total number of lenses applied to the workload.
	LensesAppliedCount *int64 `type:"integer"`

	// The metric type of a metric in the consolidated report. Currently only WORKLOAD
	// metric types are supported.
	MetricType *string `type:"string" enum:"MetricType"`

	// A map from risk names to the count of how many questions have that rating.
	RiskCounts map[string]*int64 `type:"map"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`

	// The ARN for the workload.
	WorkloadArn *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`

	// The name of the workload.
	//
	// The name must be unique within an account within an Amazon Web Services Region.
	// Spaces and capitalization are ignored when checking for uniqueness.
	WorkloadName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConsolidatedReportMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConsolidatedReportMetric) GoString() string {
	return s.String()
}

// SetLenses sets the Lenses field's value.
func (s *ConsolidatedReportMetric) SetLenses(v []*LensMetric) *ConsolidatedReportMetric {
	s.Lenses = v
	return s
}

// SetLensesAppliedCount sets the LensesAppliedCount field's value.
func (s *ConsolidatedReportMetric) SetLensesAppliedCount(v int64) *ConsolidatedReportMetric {
	s.LensesAppliedCount = &v
	return s
}

// SetMetricType sets the MetricType field's value.
func (s *ConsolidatedReportMetric) SetMetricType(v string) *ConsolidatedReportMetric {
	s.MetricType = &v
	return s
}

// SetRiskCounts sets the RiskCounts field's value.
func (s *ConsolidatedReportMetric) SetRiskCounts(v map[string]*int64) *ConsolidatedReportMetric {
	s.RiskCounts = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ConsolidatedReportMetric) SetUpdatedAt(v time.Time) *ConsolidatedReportMetric {
	s.UpdatedAt = &v
	return s
}

// SetWorkloadArn sets the WorkloadArn field's value.
func (s *ConsolidatedReportMetric) SetWorkloadArn(v string) *ConsolidatedReportMetric {
	s.WorkloadArn = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ConsolidatedReportMetric) SetWorkloadId(v string) *ConsolidatedReportMetric {
	s.WorkloadId = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *ConsolidatedReportMetric) SetWorkloadName(v string) *ConsolidatedReportMetric {
	s.WorkloadName = &v
	return s
}

type CreateLensShareInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The Amazon Web Services account ID, organization ID, or organizational unit
	// (OU) ID with which the workload, lens, profile, or review template is shared.
	//
	// SharedWith is a required field
	SharedWith *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLensShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLensShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLensShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLensShareInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.SharedWith == nil {
		invalidParams.Add(request.NewErrParamRequired("SharedWith"))
	}
	if s.SharedWith != nil && len(*s.SharedWith) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SharedWith", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateLensShareInput) SetClientRequestToken(v string) *CreateLensShareInput {
	s.ClientRequestToken = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *CreateLensShareInput) SetLensAlias(v string) *CreateLensShareInput {
	s.LensAlias = &v
	return s
}

// SetSharedWith sets the SharedWith field's value.
func (s *CreateLensShareInput) SetSharedWith(v string) *CreateLensShareInput {
	s.SharedWith = &v
	return s
}

type CreateLensShareOutput struct {
	_ struct{} `type:"structure"`

	// The ID associated with the share.
	ShareId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLensShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLensShareOutput) GoString() string {
	return s.String()
}

// SetShareId sets the ShareId field's value.
func (s *CreateLensShareOutput) SetShareId(v string) *CreateLensShareOutput {
	s.ShareId = &v
	return s
}

type CreateLensVersionInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// Set to true if this new major lens version.
	IsMajorVersion *bool `type:"boolean"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The version of the lens being created.
	//
	// LensVersion is a required field
	LensVersion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLensVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLensVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLensVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLensVersionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.LensVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("LensVersion"))
	}
	if s.LensVersion != nil && len(*s.LensVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateLensVersionInput) SetClientRequestToken(v string) *CreateLensVersionInput {
	s.ClientRequestToken = &v
	return s
}

// SetIsMajorVersion sets the IsMajorVersion field's value.
func (s *CreateLensVersionInput) SetIsMajorVersion(v bool) *CreateLensVersionInput {
	s.IsMajorVersion = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *CreateLensVersionInput) SetLensAlias(v string) *CreateLensVersionInput {
	s.LensAlias = &v
	return s
}

// SetLensVersion sets the LensVersion field's value.
func (s *CreateLensVersionInput) SetLensVersion(v string) *CreateLensVersionInput {
	s.LensVersion = &v
	return s
}

type CreateLensVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN for the lens.
	LensArn *string `type:"string"`

	// The version of the lens.
	LensVersion *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLensVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLensVersionOutput) GoString() string {
	return s.String()
}

// SetLensArn sets the LensArn field's value.
func (s *CreateLensVersionOutput) SetLensArn(v string) *CreateLensVersionOutput {
	s.LensArn = &v
	return s
}

// SetLensVersion sets the LensVersion field's value.
func (s *CreateLensVersionOutput) SetLensVersion(v string) *CreateLensVersionOutput {
	s.LensVersion = &v
	return s
}

// Input for milestone creation.
type CreateMilestoneInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The name of the milestone in a workload.
	//
	// Milestone names must be unique within a workload.
	//
	// MilestoneName is a required field
	MilestoneName *string `min:"3" type:"string" required:"true"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMilestoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMilestoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMilestoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMilestoneInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.MilestoneName == nil {
		invalidParams.Add(request.NewErrParamRequired("MilestoneName"))
	}
	if s.MilestoneName != nil && len(*s.MilestoneName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("MilestoneName", 3))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateMilestoneInput) SetClientRequestToken(v string) *CreateMilestoneInput {
	s.ClientRequestToken = &v
	return s
}

// SetMilestoneName sets the MilestoneName field's value.
func (s *CreateMilestoneInput) SetMilestoneName(v string) *CreateMilestoneInput {
	s.MilestoneName = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *CreateMilestoneInput) SetWorkloadId(v string) *CreateMilestoneInput {
	s.WorkloadId = &v
	return s
}

// Output of a create milestone call.
type CreateMilestoneOutput struct {
	_ struct{} `type:"structure"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMilestoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMilestoneOutput) GoString() string {
	return s.String()
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *CreateMilestoneOutput) SetMilestoneNumber(v int64) *CreateMilestoneOutput {
	s.MilestoneNumber = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *CreateMilestoneOutput) SetWorkloadId(v string) *CreateMilestoneOutput {
	s.WorkloadId = &v
	return s
}

type CreateProfileInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The profile description.
	//
	// ProfileDescription is a required field
	ProfileDescription *string `min:"3" type:"string" required:"true"`

	// Name of the profile.
	//
	// ProfileName is a required field
	ProfileName *string `min:"3" type:"string" required:"true"`

	// The profile questions.
	//
	// ProfileQuestions is a required field
	ProfileQuestions []*ProfileQuestionUpdate `type:"list" required:"true"`

	// The tags assigned to the profile.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProfileInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.ProfileDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileDescription"))
	}
	if s.ProfileDescription != nil && len(*s.ProfileDescription) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileDescription", 3))
	}
	if s.ProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 3))
	}
	if s.ProfileQuestions == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileQuestions"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ProfileQuestions != nil {
		for i, v := range s.ProfileQuestions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ProfileQuestions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateProfileInput) SetClientRequestToken(v string) *CreateProfileInput {
	s.ClientRequestToken = &v
	return s
}

// SetProfileDescription sets the ProfileDescription field's value.
func (s *CreateProfileInput) SetProfileDescription(v string) *CreateProfileInput {
	s.ProfileDescription = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *CreateProfileInput) SetProfileName(v string) *CreateProfileInput {
	s.ProfileName = &v
	return s
}

// SetProfileQuestions sets the ProfileQuestions field's value.
func (s *CreateProfileInput) SetProfileQuestions(v []*ProfileQuestionUpdate) *CreateProfileInput {
	s.ProfileQuestions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProfileInput) SetTags(v map[string]*string) *CreateProfileInput {
	s.Tags = v
	return s
}

type CreateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The profile ARN.
	ProfileArn *string `type:"string"`

	// Version of the profile.
	ProfileVersion *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileOutput) GoString() string {
	return s.String()
}

// SetProfileArn sets the ProfileArn field's value.
func (s *CreateProfileOutput) SetProfileArn(v string) *CreateProfileOutput {
	s.ProfileArn = &v
	return s
}

// SetProfileVersion sets the ProfileVersion field's value.
func (s *CreateProfileOutput) SetProfileVersion(v string) *CreateProfileOutput {
	s.ProfileVersion = &v
	return s
}

type CreateProfileShareInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The profile ARN.
	//
	// ProfileArn is a required field
	ProfileArn *string `location:"uri" locationName:"ProfileArn" type:"string" required:"true"`

	// The Amazon Web Services account ID, organization ID, or organizational unit
	// (OU) ID with which the workload, lens, profile, or review template is shared.
	//
	// SharedWith is a required field
	SharedWith *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProfileShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProfileShareInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.ProfileArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileArn"))
	}
	if s.ProfileArn != nil && len(*s.ProfileArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileArn", 1))
	}
	if s.SharedWith == nil {
		invalidParams.Add(request.NewErrParamRequired("SharedWith"))
	}
	if s.SharedWith != nil && len(*s.SharedWith) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SharedWith", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateProfileShareInput) SetClientRequestToken(v string) *CreateProfileShareInput {
	s.ClientRequestToken = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *CreateProfileShareInput) SetProfileArn(v string) *CreateProfileShareInput {
	s.ProfileArn = &v
	return s
}

// SetSharedWith sets the SharedWith field's value.
func (s *CreateProfileShareInput) SetSharedWith(v string) *CreateProfileShareInput {
	s.SharedWith = &v
	return s
}

type CreateProfileShareOutput struct {
	_ struct{} `type:"structure"`

	// The profile ARN.
	ProfileArn *string `type:"string"`

	// The ID associated with the share.
	ShareId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileShareOutput) GoString() string {
	return s.String()
}

// SetProfileArn sets the ProfileArn field's value.
func (s *CreateProfileShareOutput) SetProfileArn(v string) *CreateProfileShareOutput {
	s.ProfileArn = &v
	return s
}

// SetShareId sets the ShareId field's value.
func (s *CreateProfileShareOutput) SetShareId(v string) *CreateProfileShareOutput {
	s.ShareId = &v
	return s
}

type CreateReviewTemplateInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The review template description.
	//
	// Description is a required field
	Description *string `min:"3" type:"string" required:"true"`

	// Lenses applied to the review template.
	//
	// Lenses is a required field
	Lenses []*string `type:"list" required:"true"`

	// The notes associated with the workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	Notes *string `type:"string"`

	// The tags assigned to the review template.
	Tags map[string]*string `min:"1" type:"map"`

	// Name of the review template.
	//
	// TemplateName is a required field
	TemplateName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReviewTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReviewTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReviewTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReviewTemplateInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 3))
	}
	if s.Lenses == nil {
		invalidParams.Add(request.NewErrParamRequired("Lenses"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateReviewTemplateInput) SetClientRequestToken(v string) *CreateReviewTemplateInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateReviewTemplateInput) SetDescription(v string) *CreateReviewTemplateInput {
	s.Description = &v
	return s
}

// SetLenses sets the Lenses field's value.
func (s *CreateReviewTemplateInput) SetLenses(v []*string) *CreateReviewTemplateInput {
	s.Lenses = v
	return s
}

// SetNotes sets the Notes field's value.
func (s *CreateReviewTemplateInput) SetNotes(v string) *CreateReviewTemplateInput {
	s.Notes = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReviewTemplateInput) SetTags(v map[string]*string) *CreateReviewTemplateInput {
	s.Tags = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateReviewTemplateInput) SetTemplateName(v string) *CreateReviewTemplateInput {
	s.TemplateName = &v
	return s
}

type CreateReviewTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The review template ARN.
	TemplateArn *string `min:"50" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReviewTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReviewTemplateOutput) GoString() string {
	return s.String()
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *CreateReviewTemplateOutput) SetTemplateArn(v string) *CreateReviewTemplateOutput {
	s.TemplateArn = &v
	return s
}

type CreateTemplateShareInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Web Services account ID, organization ID, or organizational unit
	// (OU) ID with which the workload, lens, profile, or review template is shared.
	//
	// SharedWith is a required field
	SharedWith *string `min:"12" type:"string" required:"true"`

	// The review template ARN.
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"50" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTemplateShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTemplateShareInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.SharedWith == nil {
		invalidParams.Add(request.NewErrParamRequired("SharedWith"))
	}
	if s.SharedWith != nil && len(*s.SharedWith) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SharedWith", 12))
	}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateTemplateShareInput) SetClientRequestToken(v string) *CreateTemplateShareInput {
	s.ClientRequestToken = &v
	return s
}

// SetSharedWith sets the SharedWith field's value.
func (s *CreateTemplateShareInput) SetSharedWith(v string) *CreateTemplateShareInput {
	s.SharedWith = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *CreateTemplateShareInput) SetTemplateArn(v string) *CreateTemplateShareInput {
	s.TemplateArn = &v
	return s
}

type CreateTemplateShareOutput struct {
	_ struct{} `type:"structure"`

	// The ID associated with the share.
	ShareId *string `type:"string"`

	// The review template ARN.
	TemplateArn *string `min:"50" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateShareOutput) GoString() string {
	return s.String()
}

// SetShareId sets the ShareId field's value.
func (s *CreateTemplateShareOutput) SetShareId(v string) *CreateTemplateShareOutput {
	s.ShareId = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *CreateTemplateShareOutput) SetTemplateArn(v string) *CreateTemplateShareOutput {
	s.TemplateArn = &v
	return s
}

// Input for workload creation.
type CreateWorkloadInput struct {
	_ struct{} `type:"structure"`

	// The list of Amazon Web Services account IDs associated with the workload.
	AccountIds []*string `type:"list"`

	// List of AppRegistry application ARNs associated to the workload.
	Applications []*string `type:"list"`

	// The URL of the architectural design for the workload.
	ArchitecturalDesign *string `type:"string"`

	// The list of Amazon Web Services Regions associated with the workload, for
	// example, us-east-2, or ca-central-1.
	AwsRegions []*string `type:"list"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The description for the workload.
	//
	// Description is a required field
	Description *string `min:"3" type:"string" required:"true"`

	// Well-Architected discovery configuration settings associated to the workload.
	DiscoveryConfig *WorkloadDiscoveryConfig `type:"structure"`

	// The environment for the workload.
	//
	// Environment is a required field
	Environment *string `type:"string" required:"true" enum:"WorkloadEnvironment"`

	// The industry for the workload.
	Industry *string `type:"string"`

	// The industry type for the workload.
	//
	// If specified, must be one of the following:
	//
	//    * Agriculture
	//
	//    * Automobile
	//
	//    * Defense
	//
	//    * Design and Engineering
	//
	//    * Digital Advertising
	//
	//    * Education
	//
	//    * Environmental Protection
	//
	//    * Financial Services
	//
	//    * Gaming
	//
	//    * General Public Services
	//
	//    * Healthcare
	//
	//    * Hospitality
	//
	//    * InfoTech
	//
	//    * Justice and Public Safety
	//
	//    * Life Sciences
	//
	//    * Manufacturing
	//
	//    * Media & Entertainment
	//
	//    * Mining & Resources
	//
	//    * Oil & Gas
	//
	//    * Power & Utilities
	//
	//    * Professional Services
	//
	//    * Real Estate & Construction
	//
	//    * Retail & Wholesale
	//
	//    * Social Protection
	//
	//    * Telecommunications
	//
	//    * Travel, Transportation & Logistics
	//
	//    * Other
	IndustryType *string `type:"string"`

	// Jira configuration settings when creating a workload.
	JiraConfiguration *WorkloadJiraConfigurationInput_ `type:"structure"`

	// The list of lenses associated with the workload. Each lens is identified
	// by its LensSummary$LensAlias.
	//
	// If a review template that specifies lenses is applied to the workload, those
	// lenses are applied to the workload in addition to these lenses.
	//
	// Lenses is a required field
	Lenses []*string `type:"list" required:"true"`

	// The list of non-Amazon Web Services Regions associated with the workload.
	NonAwsRegions []*string `type:"list"`

	// The notes associated with the workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	Notes *string `type:"string"`

	// The priorities of the pillars, which are used to order items in the improvement
	// plan. Each pillar is represented by its PillarReviewSummary$PillarId.
	PillarPriorities []*string `type:"list"`

	// The list of profile ARNs associated with the workload.
	ProfileArns []*string `type:"list"`

	// The review owner of the workload. The name, email address, or identifier
	// for the primary group or individual that owns the workload review process.
	ReviewOwner *string `min:"3" type:"string"`

	// The list of review template ARNs to associate with the workload.
	ReviewTemplateArns []*string `type:"list"`

	// The tags to be associated with the workload.
	Tags map[string]*string `min:"1" type:"map"`

	// The name of the workload.
	//
	// The name must be unique within an account within an Amazon Web Services Region.
	// Spaces and capitalization are ignored when checking for uniqueness.
	//
	// WorkloadName is a required field
	WorkloadName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkloadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkloadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkloadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkloadInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 3))
	}
	if s.Environment == nil {
		invalidParams.Add(request.NewErrParamRequired("Environment"))
	}
	if s.Lenses == nil {
		invalidParams.Add(request.NewErrParamRequired("Lenses"))
	}
	if s.ReviewOwner != nil && len(*s.ReviewOwner) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ReviewOwner", 3))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.WorkloadName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadName"))
	}
	if s.WorkloadName != nil && len(*s.WorkloadName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadName", 3))
	}
	if s.JiraConfiguration != nil {
		if err := s.JiraConfiguration.Validate(); err != nil {
			invalidParams.AddNested("JiraConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *CreateWorkloadInput) SetAccountIds(v []*string) *CreateWorkloadInput {
	s.AccountIds = v
	return s
}

// SetApplications sets the Applications field's value.
func (s *CreateWorkloadInput) SetApplications(v []*string) *CreateWorkloadInput {
	s.Applications = v
	return s
}

// SetArchitecturalDesign sets the ArchitecturalDesign field's value.
func (s *CreateWorkloadInput) SetArchitecturalDesign(v string) *CreateWorkloadInput {
	s.ArchitecturalDesign = &v
	return s
}

// SetAwsRegions sets the AwsRegions field's value.
func (s *CreateWorkloadInput) SetAwsRegions(v []*string) *CreateWorkloadInput {
	s.AwsRegions = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateWorkloadInput) SetClientRequestToken(v string) *CreateWorkloadInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateWorkloadInput) SetDescription(v string) *CreateWorkloadInput {
	s.Description = &v
	return s
}

// SetDiscoveryConfig sets the DiscoveryConfig field's value.
func (s *CreateWorkloadInput) SetDiscoveryConfig(v *WorkloadDiscoveryConfig) *CreateWorkloadInput {
	s.DiscoveryConfig = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *CreateWorkloadInput) SetEnvironment(v string) *CreateWorkloadInput {
	s.Environment = &v
	return s
}

// SetIndustry sets the Industry field's value.
func (s *CreateWorkloadInput) SetIndustry(v string) *CreateWorkloadInput {
	s.Industry = &v
	return s
}

// SetIndustryType sets the IndustryType field's value.
func (s *CreateWorkloadInput) SetIndustryType(v string) *CreateWorkloadInput {
	s.IndustryType = &v
	return s
}

// SetJiraConfiguration sets the JiraConfiguration field's value.
func (s *CreateWorkloadInput) SetJiraConfiguration(v *WorkloadJiraConfigurationInput_) *CreateWorkloadInput {
	s.JiraConfiguration = v
	return s
}

// SetLenses sets the Lenses field's value.
func (s *CreateWorkloadInput) SetLenses(v []*string) *CreateWorkloadInput {
	s.Lenses = v
	return s
}

// SetNonAwsRegions sets the NonAwsRegions field's value.
func (s *CreateWorkloadInput) SetNonAwsRegions(v []*string) *CreateWorkloadInput {
	s.NonAwsRegions = v
	return s
}

// SetNotes sets the Notes field's value.
func (s *CreateWorkloadInput) SetNotes(v string) *CreateWorkloadInput {
	s.Notes = &v
	return s
}

// SetPillarPriorities sets the PillarPriorities field's value.
func (s *CreateWorkloadInput) SetPillarPriorities(v []*string) *CreateWorkloadInput {
	s.PillarPriorities = v
	return s
}

// SetProfileArns sets the ProfileArns field's value.
func (s *CreateWorkloadInput) SetProfileArns(v []*string) *CreateWorkloadInput {
	s.ProfileArns = v
	return s
}

// SetReviewOwner sets the ReviewOwner field's value.
func (s *CreateWorkloadInput) SetReviewOwner(v string) *CreateWorkloadInput {
	s.ReviewOwner = &v
	return s
}

// SetReviewTemplateArns sets the ReviewTemplateArns field's value.
func (s *CreateWorkloadInput) SetReviewTemplateArns(v []*string) *CreateWorkloadInput {
	s.ReviewTemplateArns = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkloadInput) SetTags(v map[string]*string) *CreateWorkloadInput {
	s.Tags = v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *CreateWorkloadInput) SetWorkloadName(v string) *CreateWorkloadInput {
	s.WorkloadName = &v
	return s
}

// Output of a create workload call.
type CreateWorkloadOutput struct {
	_ struct{} `type:"structure"`

	// The ARN for the workload.
	WorkloadArn *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkloadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkloadOutput) GoString() string {
	return s.String()
}

// SetWorkloadArn sets the WorkloadArn field's value.
func (s *CreateWorkloadOutput) SetWorkloadArn(v string) *CreateWorkloadOutput {
	s.WorkloadArn = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *CreateWorkloadOutput) SetWorkloadId(v string) *CreateWorkloadOutput {
	s.WorkloadId = &v
	return s
}

// Input for Create Workload Share
type CreateWorkloadShareInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// Permission granted on a share request.
	//
	// PermissionType is a required field
	PermissionType *string `type:"string" required:"true" enum:"PermissionType"`

	// The Amazon Web Services account ID, organization ID, or organizational unit
	// (OU) ID with which the workload, lens, profile, or review template is shared.
	//
	// SharedWith is a required field
	SharedWith *string `min:"12" type:"string" required:"true"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkloadShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkloadShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkloadShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkloadShareInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.PermissionType == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionType"))
	}
	if s.SharedWith == nil {
		invalidParams.Add(request.NewErrParamRequired("SharedWith"))
	}
	if s.SharedWith != nil && len(*s.SharedWith) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SharedWith", 12))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateWorkloadShareInput) SetClientRequestToken(v string) *CreateWorkloadShareInput {
	s.ClientRequestToken = &v
	return s
}

// SetPermissionType sets the PermissionType field's value.
func (s *CreateWorkloadShareInput) SetPermissionType(v string) *CreateWorkloadShareInput {
	s.PermissionType = &v
	return s
}

// SetSharedWith sets the SharedWith field's value.
func (s *CreateWorkloadShareInput) SetSharedWith(v string) *CreateWorkloadShareInput {
	s.SharedWith = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *CreateWorkloadShareInput) SetWorkloadId(v string) *CreateWorkloadShareInput {
	s.WorkloadId = &v
	return s
}

// Input for Create Workload Share
type CreateWorkloadShareOutput struct {
	_ struct{} `type:"structure"`

	// The ID associated with the share.
	ShareId *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkloadShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkloadShareOutput) GoString() string {
	return s.String()
}

// SetShareId sets the ShareId field's value.
func (s *CreateWorkloadShareOutput) SetShareId(v string) *CreateWorkloadShareOutput {
	s.ShareId = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *CreateWorkloadShareOutput) SetWorkloadId(v string) *CreateWorkloadShareOutput {
	s.WorkloadId = &v
	return s
}

type DeleteLensInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `location:"querystring" locationName:"ClientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The status of the lens to be deleted.
	//
	// LensStatus is a required field
	LensStatus *string `location:"querystring" locationName:"LensStatus" type:"string" required:"true" enum:"LensStatusType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLensInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLensInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLensInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLensInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.LensStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("LensStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteLensInput) SetClientRequestToken(v string) *DeleteLensInput {
	s.ClientRequestToken = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *DeleteLensInput) SetLensAlias(v string) *DeleteLensInput {
	s.LensAlias = &v
	return s
}

// SetLensStatus sets the LensStatus field's value.
func (s *DeleteLensInput) SetLensStatus(v string) *DeleteLensInput {
	s.LensStatus = &v
	return s
}

type DeleteLensOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLensOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLensOutput) GoString() string {
	return s.String()
}

type DeleteLensShareInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `location:"querystring" locationName:"ClientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The ID associated with the share.
	//
	// ShareId is a required field
	ShareId *string `location:"uri" locationName:"ShareId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLensShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLensShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLensShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLensShareInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.ShareId == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareId"))
	}
	if s.ShareId != nil && len(*s.ShareId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShareId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteLensShareInput) SetClientRequestToken(v string) *DeleteLensShareInput {
	s.ClientRequestToken = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *DeleteLensShareInput) SetLensAlias(v string) *DeleteLensShareInput {
	s.LensAlias = &v
	return s
}

// SetShareId sets the ShareId field's value.
func (s *DeleteLensShareInput) SetShareId(v string) *DeleteLensShareInput {
	s.ShareId = &v
	return s
}

type DeleteLensShareOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLensShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLensShareOutput) GoString() string {
	return s.String()
}

type DeleteProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `location:"querystring" locationName:"ClientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The profile ARN.
	//
	// ProfileArn is a required field
	ProfileArn *string `location:"uri" locationName:"ProfileArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProfileInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.ProfileArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileArn"))
	}
	if s.ProfileArn != nil && len(*s.ProfileArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteProfileInput) SetClientRequestToken(v string) *DeleteProfileInput {
	s.ClientRequestToken = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *DeleteProfileInput) SetProfileArn(v string) *DeleteProfileInput {
	s.ProfileArn = &v
	return s
}

type DeleteProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileOutput) GoString() string {
	return s.String()
}

type DeleteProfileShareInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `location:"querystring" locationName:"ClientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The profile ARN.
	//
	// ProfileArn is a required field
	ProfileArn *string `location:"uri" locationName:"ProfileArn" type:"string" required:"true"`

	// The ID associated with the share.
	//
	// ShareId is a required field
	ShareId *string `location:"uri" locationName:"ShareId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProfileShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProfileShareInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.ProfileArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileArn"))
	}
	if s.ProfileArn != nil && len(*s.ProfileArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileArn", 1))
	}
	if s.ShareId == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareId"))
	}
	if s.ShareId != nil && len(*s.ShareId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShareId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteProfileShareInput) SetClientRequestToken(v string) *DeleteProfileShareInput {
	s.ClientRequestToken = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *DeleteProfileShareInput) SetProfileArn(v string) *DeleteProfileShareInput {
	s.ProfileArn = &v
	return s
}

// SetShareId sets the ShareId field's value.
func (s *DeleteProfileShareInput) SetShareId(v string) *DeleteProfileShareInput {
	s.ShareId = &v
	return s
}

type DeleteProfileShareOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileShareOutput) GoString() string {
	return s.String()
}

type DeleteReviewTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `location:"querystring" locationName:"ClientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The review template ARN.
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"50" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReviewTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReviewTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReviewTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReviewTemplateInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteReviewTemplateInput) SetClientRequestToken(v string) *DeleteReviewTemplateInput {
	s.ClientRequestToken = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *DeleteReviewTemplateInput) SetTemplateArn(v string) *DeleteReviewTemplateInput {
	s.TemplateArn = &v
	return s
}

type DeleteReviewTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReviewTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReviewTemplateOutput) GoString() string {
	return s.String()
}

type DeleteTemplateShareInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `location:"querystring" locationName:"ClientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID associated with the share.
	//
	// ShareId is a required field
	ShareId *string `location:"uri" locationName:"ShareId" type:"string" required:"true"`

	// The review template ARN.
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"50" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTemplateShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTemplateShareInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.ShareId == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareId"))
	}
	if s.ShareId != nil && len(*s.ShareId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShareId", 1))
	}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteTemplateShareInput) SetClientRequestToken(v string) *DeleteTemplateShareInput {
	s.ClientRequestToken = &v
	return s
}

// SetShareId sets the ShareId field's value.
func (s *DeleteTemplateShareInput) SetShareId(v string) *DeleteTemplateShareInput {
	s.ShareId = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *DeleteTemplateShareInput) SetTemplateArn(v string) *DeleteTemplateShareInput {
	s.TemplateArn = &v
	return s
}

type DeleteTemplateShareOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateShareOutput) GoString() string {
	return s.String()
}

// Input for workload deletion.
type DeleteWorkloadInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `location:"querystring" locationName:"ClientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkloadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkloadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkloadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkloadInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteWorkloadInput) SetClientRequestToken(v string) *DeleteWorkloadInput {
	s.ClientRequestToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *DeleteWorkloadInput) SetWorkloadId(v string) *DeleteWorkloadInput {
	s.WorkloadId = &v
	return s
}

type DeleteWorkloadOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkloadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkloadOutput) GoString() string {
	return s.String()
}

// Input for Delete Workload Share
type DeleteWorkloadShareInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `location:"querystring" locationName:"ClientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID associated with the share.
	//
	// ShareId is a required field
	ShareId *string `location:"uri" locationName:"ShareId" type:"string" required:"true"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkloadShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkloadShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkloadShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkloadShareInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.ShareId == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareId"))
	}
	if s.ShareId != nil && len(*s.ShareId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShareId", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteWorkloadShareInput) SetClientRequestToken(v string) *DeleteWorkloadShareInput {
	s.ClientRequestToken = &v
	return s
}

// SetShareId sets the ShareId field's value.
func (s *DeleteWorkloadShareInput) SetShareId(v string) *DeleteWorkloadShareInput {
	s.ShareId = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *DeleteWorkloadShareInput) SetWorkloadId(v string) *DeleteWorkloadShareInput {
	s.WorkloadId = &v
	return s
}

type DeleteWorkloadShareOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkloadShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkloadShareOutput) GoString() string {
	return s.String()
}

// Input to disassociate lens reviews.
type DisassociateLensesInput struct {
	_ struct{} `type:"structure"`

	// List of lens aliases to associate or disassociate with a workload. Up to
	// 10 lenses can be specified.
	//
	// Identify a lens using its LensSummary$LensAlias.
	//
	// LensAliases is a required field
	LensAliases []*string `min:"1" type:"list" required:"true"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateLensesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateLensesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateLensesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateLensesInput"}
	if s.LensAliases == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAliases"))
	}
	if s.LensAliases != nil && len(s.LensAliases) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAliases", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAliases sets the LensAliases field's value.
func (s *DisassociateLensesInput) SetLensAliases(v []*string) *DisassociateLensesInput {
	s.LensAliases = v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *DisassociateLensesInput) SetWorkloadId(v string) *DisassociateLensesInput {
	s.WorkloadId = &v
	return s
}

type DisassociateLensesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateLensesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateLensesOutput) GoString() string {
	return s.String()
}

type DisassociateProfilesInput struct {
	_ struct{} `type:"structure"`

	// The list of profile ARNs to disassociate from the workload.
	//
	// ProfileArns is a required field
	ProfileArns []*string `min:"1" type:"list" required:"true"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateProfilesInput"}
	if s.ProfileArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileArns"))
	}
	if s.ProfileArns != nil && len(s.ProfileArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileArns", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileArns sets the ProfileArns field's value.
func (s *DisassociateProfilesInput) SetProfileArns(v []*string) *DisassociateProfilesInput {
	s.ProfileArns = v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *DisassociateProfilesInput) SetWorkloadId(v string) *DisassociateProfilesInput {
	s.WorkloadId = &v
	return s
}

type DisassociateProfilesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateProfilesOutput) GoString() string {
	return s.String()
}

type ExportLensInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The lens version to be exported.
	LensVersion *string `location:"querystring" locationName:"LensVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportLensInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportLensInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportLensInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportLensInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.LensVersion != nil && len(*s.LensVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *ExportLensInput) SetLensAlias(v string) *ExportLensInput {
	s.LensAlias = &v
	return s
}

// SetLensVersion sets the LensVersion field's value.
func (s *ExportLensInput) SetLensVersion(v string) *ExportLensInput {
	s.LensVersion = &v
	return s
}

type ExportLensOutput struct {
	_ struct{} `type:"structure"`

	// The JSON representation of a lens.
	LensJSON *string `min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportLensOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportLensOutput) GoString() string {
	return s.String()
}

// SetLensJSON sets the LensJSON field's value.
func (s *ExportLensOutput) SetLensJSON(v string) *ExportLensOutput {
	s.LensJSON = &v
	return s
}

// Input to get answer.
type GetAnswerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `location:"querystring" locationName:"MilestoneNumber" min:"1" type:"integer"`

	// The ID of the question.
	//
	// QuestionId is a required field
	QuestionId *string `location:"uri" locationName:"QuestionId" min:"1" type:"string" required:"true"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnswerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnswerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAnswerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAnswerInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.MilestoneNumber != nil && *s.MilestoneNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MilestoneNumber", 1))
	}
	if s.QuestionId == nil {
		invalidParams.Add(request.NewErrParamRequired("QuestionId"))
	}
	if s.QuestionId != nil && len(*s.QuestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuestionId", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *GetAnswerInput) SetLensAlias(v string) *GetAnswerInput {
	s.LensAlias = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *GetAnswerInput) SetMilestoneNumber(v int64) *GetAnswerInput {
	s.MilestoneNumber = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *GetAnswerInput) SetQuestionId(v string) *GetAnswerInput {
	s.QuestionId = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetAnswerInput) SetWorkloadId(v string) *GetAnswerInput {
	s.WorkloadId = &v
	return s
}

// Output of a get answer call.
type GetAnswerOutput struct {
	_ struct{} `type:"structure"`

	// An answer of the question.
	Answer *Answer `type:"structure"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The ARN for the lens.
	LensArn *string `type:"string"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnswerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAnswerOutput) GoString() string {
	return s.String()
}

// SetAnswer sets the Answer field's value.
func (s *GetAnswerOutput) SetAnswer(v *Answer) *GetAnswerOutput {
	s.Answer = v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *GetAnswerOutput) SetLensAlias(v string) *GetAnswerOutput {
	s.LensAlias = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *GetAnswerOutput) SetLensArn(v string) *GetAnswerOutput {
	s.LensArn = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *GetAnswerOutput) SetMilestoneNumber(v int64) *GetAnswerOutput {
	s.MilestoneNumber = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetAnswerOutput) SetWorkloadId(v string) *GetAnswerOutput {
	s.WorkloadId = &v
	return s
}

type GetConsolidatedReportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The format of the consolidated report.
	//
	// For PDF, Base64String is returned. For JSON, Metrics is returned.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"Format" type:"string" required:"true" enum:"ReportFormat"`

	// Set to true to have shared resources included in the report.
	IncludeSharedResources *bool `location:"querystring" locationName:"IncludeSharedResources" type:"boolean"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConsolidatedReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConsolidatedReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConsolidatedReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConsolidatedReportInput"}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFormat sets the Format field's value.
func (s *GetConsolidatedReportInput) SetFormat(v string) *GetConsolidatedReportInput {
	s.Format = &v
	return s
}

// SetIncludeSharedResources sets the IncludeSharedResources field's value.
func (s *GetConsolidatedReportInput) SetIncludeSharedResources(v bool) *GetConsolidatedReportInput {
	s.IncludeSharedResources = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetConsolidatedReportInput) SetMaxResults(v int64) *GetConsolidatedReportInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConsolidatedReportInput) SetNextToken(v string) *GetConsolidatedReportInput {
	s.NextToken = &v
	return s
}

type GetConsolidatedReportOutput struct {
	_ struct{} `type:"structure"`

	// The Base64-encoded string representation of a lens review report.
	//
	// This data can be used to create a PDF file.
	//
	// Only returned by GetConsolidatedReport when PDF format is requested.
	Base64String *string `type:"string"`

	// The metrics that make up the consolidated report.
	//
	// Only returned when JSON format is requested.
	Metrics []*ConsolidatedReportMetric `type:"list"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConsolidatedReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConsolidatedReportOutput) GoString() string {
	return s.String()
}

// SetBase64String sets the Base64String field's value.
func (s *GetConsolidatedReportOutput) SetBase64String(v string) *GetConsolidatedReportOutput {
	s.Base64String = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetConsolidatedReportOutput) SetMetrics(v []*ConsolidatedReportMetric) *GetConsolidatedReportOutput {
	s.Metrics = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConsolidatedReportOutput) SetNextToken(v string) *GetConsolidatedReportOutput {
	s.NextToken = &v
	return s
}

type GetGlobalSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGlobalSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGlobalSettingsInput) GoString() string {
	return s.String()
}

type GetGlobalSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Discovery integration status.
	DiscoveryIntegrationStatus *string `type:"string" enum:"DiscoveryIntegrationStatus"`

	// Jira configuration status.
	JiraConfiguration *AccountJiraConfigurationOutput_ `type:"structure"`

	// Amazon Web Services Organizations sharing status.
	OrganizationSharingStatus *string `type:"string" enum:"OrganizationSharingStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGlobalSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGlobalSettingsOutput) GoString() string {
	return s.String()
}

// SetDiscoveryIntegrationStatus sets the DiscoveryIntegrationStatus field's value.
func (s *GetGlobalSettingsOutput) SetDiscoveryIntegrationStatus(v string) *GetGlobalSettingsOutput {
	s.DiscoveryIntegrationStatus = &v
	return s
}

// SetJiraConfiguration sets the JiraConfiguration field's value.
func (s *GetGlobalSettingsOutput) SetJiraConfiguration(v *AccountJiraConfigurationOutput_) *GetGlobalSettingsOutput {
	s.JiraConfiguration = v
	return s
}

// SetOrganizationSharingStatus sets the OrganizationSharingStatus field's value.
func (s *GetGlobalSettingsOutput) SetOrganizationSharingStatus(v string) *GetGlobalSettingsOutput {
	s.OrganizationSharingStatus = &v
	return s
}

type GetLensInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The lens version to be retrieved.
	LensVersion *string `location:"querystring" locationName:"LensVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLensInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLensInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.LensVersion != nil && len(*s.LensVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *GetLensInput) SetLensAlias(v string) *GetLensInput {
	s.LensAlias = &v
	return s
}

// SetLensVersion sets the LensVersion field's value.
func (s *GetLensInput) SetLensVersion(v string) *GetLensInput {
	s.LensVersion = &v
	return s
}

type GetLensOutput struct {
	_ struct{} `type:"structure"`

	// A lens return object.
	Lens *Lens `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensOutput) GoString() string {
	return s.String()
}

// SetLens sets the Lens field's value.
func (s *GetLensOutput) SetLens(v *Lens) *GetLensOutput {
	s.Lens = v
	return s
}

// Input to get lens review.
type GetLensReviewInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `location:"querystring" locationName:"MilestoneNumber" min:"1" type:"integer"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensReviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensReviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLensReviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLensReviewInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.MilestoneNumber != nil && *s.MilestoneNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MilestoneNumber", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *GetLensReviewInput) SetLensAlias(v string) *GetLensReviewInput {
	s.LensAlias = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *GetLensReviewInput) SetMilestoneNumber(v int64) *GetLensReviewInput {
	s.MilestoneNumber = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetLensReviewInput) SetWorkloadId(v string) *GetLensReviewInput {
	s.WorkloadId = &v
	return s
}

// Output of a get lens review call.
type GetLensReviewOutput struct {
	_ struct{} `type:"structure"`

	// A lens review of a question.
	LensReview *LensReview `type:"structure"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensReviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensReviewOutput) GoString() string {
	return s.String()
}

// SetLensReview sets the LensReview field's value.
func (s *GetLensReviewOutput) SetLensReview(v *LensReview) *GetLensReviewOutput {
	s.LensReview = v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *GetLensReviewOutput) SetMilestoneNumber(v int64) *GetLensReviewOutput {
	s.MilestoneNumber = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetLensReviewOutput) SetWorkloadId(v string) *GetLensReviewOutput {
	s.WorkloadId = &v
	return s
}

// Input to get lens review report.
type GetLensReviewReportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `location:"querystring" locationName:"MilestoneNumber" min:"1" type:"integer"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensReviewReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensReviewReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLensReviewReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLensReviewReportInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.MilestoneNumber != nil && *s.MilestoneNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MilestoneNumber", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *GetLensReviewReportInput) SetLensAlias(v string) *GetLensReviewReportInput {
	s.LensAlias = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *GetLensReviewReportInput) SetMilestoneNumber(v int64) *GetLensReviewReportInput {
	s.MilestoneNumber = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetLensReviewReportInput) SetWorkloadId(v string) *GetLensReviewReportInput {
	s.WorkloadId = &v
	return s
}

// Output of a get lens review report call.
type GetLensReviewReportOutput struct {
	_ struct{} `type:"structure"`

	// A report of a lens review.
	LensReviewReport *LensReviewReport `type:"structure"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensReviewReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensReviewReportOutput) GoString() string {
	return s.String()
}

// SetLensReviewReport sets the LensReviewReport field's value.
func (s *GetLensReviewReportOutput) SetLensReviewReport(v *LensReviewReport) *GetLensReviewReportOutput {
	s.LensReviewReport = v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *GetLensReviewReportOutput) SetMilestoneNumber(v int64) *GetLensReviewReportOutput {
	s.MilestoneNumber = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetLensReviewReportOutput) SetWorkloadId(v string) *GetLensReviewReportOutput {
	s.WorkloadId = &v
	return s
}

type GetLensVersionDifferenceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The base version of the lens.
	BaseLensVersion *string `location:"querystring" locationName:"BaseLensVersion" min:"1" type:"string"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The lens version to target a difference for.
	TargetLensVersion *string `location:"querystring" locationName:"TargetLensVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensVersionDifferenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensVersionDifferenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLensVersionDifferenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLensVersionDifferenceInput"}
	if s.BaseLensVersion != nil && len(*s.BaseLensVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BaseLensVersion", 1))
	}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.TargetLensVersion != nil && len(*s.TargetLensVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetLensVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseLensVersion sets the BaseLensVersion field's value.
func (s *GetLensVersionDifferenceInput) SetBaseLensVersion(v string) *GetLensVersionDifferenceInput {
	s.BaseLensVersion = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *GetLensVersionDifferenceInput) SetLensAlias(v string) *GetLensVersionDifferenceInput {
	s.LensAlias = &v
	return s
}

// SetTargetLensVersion sets the TargetLensVersion field's value.
func (s *GetLensVersionDifferenceInput) SetTargetLensVersion(v string) *GetLensVersionDifferenceInput {
	s.TargetLensVersion = &v
	return s
}

type GetLensVersionDifferenceOutput struct {
	_ struct{} `type:"structure"`

	// The base version of the lens.
	BaseLensVersion *string `min:"1" type:"string"`

	// The latest version of the lens.
	LatestLensVersion *string `min:"1" type:"string"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The ARN for the lens.
	LensArn *string `type:"string"`

	// The target lens version for the lens.
	TargetLensVersion *string `min:"1" type:"string"`

	// The differences between the base and latest versions of the lens.
	VersionDifferences *VersionDifferences `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensVersionDifferenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLensVersionDifferenceOutput) GoString() string {
	return s.String()
}

// SetBaseLensVersion sets the BaseLensVersion field's value.
func (s *GetLensVersionDifferenceOutput) SetBaseLensVersion(v string) *GetLensVersionDifferenceOutput {
	s.BaseLensVersion = &v
	return s
}

// SetLatestLensVersion sets the LatestLensVersion field's value.
func (s *GetLensVersionDifferenceOutput) SetLatestLensVersion(v string) *GetLensVersionDifferenceOutput {
	s.LatestLensVersion = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *GetLensVersionDifferenceOutput) SetLensAlias(v string) *GetLensVersionDifferenceOutput {
	s.LensAlias = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *GetLensVersionDifferenceOutput) SetLensArn(v string) *GetLensVersionDifferenceOutput {
	s.LensArn = &v
	return s
}

// SetTargetLensVersion sets the TargetLensVersion field's value.
func (s *GetLensVersionDifferenceOutput) SetTargetLensVersion(v string) *GetLensVersionDifferenceOutput {
	s.TargetLensVersion = &v
	return s
}

// SetVersionDifferences sets the VersionDifferences field's value.
func (s *GetLensVersionDifferenceOutput) SetVersionDifferences(v *VersionDifferences) *GetLensVersionDifferenceOutput {
	s.VersionDifferences = v
	return s
}

// Input to get a milestone.
type GetMilestoneInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	//
	// MilestoneNumber is a required field
	MilestoneNumber *int64 `location:"uri" locationName:"MilestoneNumber" min:"1" type:"integer" required:"true"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMilestoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMilestoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMilestoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMilestoneInput"}
	if s.MilestoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("MilestoneNumber"))
	}
	if s.MilestoneNumber != nil && *s.MilestoneNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MilestoneNumber", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *GetMilestoneInput) SetMilestoneNumber(v int64) *GetMilestoneInput {
	s.MilestoneNumber = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetMilestoneInput) SetWorkloadId(v string) *GetMilestoneInput {
	s.WorkloadId = &v
	return s
}

// Output of a get milestone call.
type GetMilestoneOutput struct {
	_ struct{} `type:"structure"`

	// A milestone return object.
	Milestone *Milestone `type:"structure"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMilestoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMilestoneOutput) GoString() string {
	return s.String()
}

// SetMilestone sets the Milestone field's value.
func (s *GetMilestoneOutput) SetMilestone(v *Milestone) *GetMilestoneOutput {
	s.Milestone = v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetMilestoneOutput) SetWorkloadId(v string) *GetMilestoneOutput {
	s.WorkloadId = &v
	return s
}

type GetProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The profile ARN.
	//
	// ProfileArn is a required field
	ProfileArn *string `location:"uri" locationName:"ProfileArn" type:"string" required:"true"`

	// The profile version.
	ProfileVersion *string `location:"querystring" locationName:"ProfileVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProfileInput"}
	if s.ProfileArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileArn"))
	}
	if s.ProfileArn != nil && len(*s.ProfileArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileArn", 1))
	}
	if s.ProfileVersion != nil && len(*s.ProfileVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileArn sets the ProfileArn field's value.
func (s *GetProfileInput) SetProfileArn(v string) *GetProfileInput {
	s.ProfileArn = &v
	return s
}

// SetProfileVersion sets the ProfileVersion field's value.
func (s *GetProfileInput) SetProfileVersion(v string) *GetProfileInput {
	s.ProfileVersion = &v
	return s
}

type GetProfileOutput struct {
	_ struct{} `type:"structure"`

	// The profile.
	Profile *Profile `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileOutput) GoString() string {
	return s.String()
}

// SetProfile sets the Profile field's value.
func (s *GetProfileOutput) SetProfile(v *Profile) *GetProfileOutput {
	s.Profile = v
	return s
}

type GetProfileTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileTemplateInput) GoString() string {
	return s.String()
}

type GetProfileTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The profile template.
	ProfileTemplate *ProfileTemplate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileTemplateOutput) GoString() string {
	return s.String()
}

// SetProfileTemplate sets the ProfileTemplate field's value.
func (s *GetProfileTemplateOutput) SetProfileTemplate(v *ProfileTemplate) *GetProfileTemplateOutput {
	s.ProfileTemplate = v
	return s
}

type GetReviewTemplateAnswerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The ID of the question.
	//
	// QuestionId is a required field
	QuestionId *string `location:"uri" locationName:"QuestionId" min:"1" type:"string" required:"true"`

	// The review template ARN.
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"50" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReviewTemplateAnswerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReviewTemplateAnswerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReviewTemplateAnswerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReviewTemplateAnswerInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.QuestionId == nil {
		invalidParams.Add(request.NewErrParamRequired("QuestionId"))
	}
	if s.QuestionId != nil && len(*s.QuestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuestionId", 1))
	}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *GetReviewTemplateAnswerInput) SetLensAlias(v string) *GetReviewTemplateAnswerInput {
	s.LensAlias = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *GetReviewTemplateAnswerInput) SetQuestionId(v string) *GetReviewTemplateAnswerInput {
	s.QuestionId = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *GetReviewTemplateAnswerInput) SetTemplateArn(v string) *GetReviewTemplateAnswerInput {
	s.TemplateArn = &v
	return s
}

type GetReviewTemplateAnswerOutput struct {
	_ struct{} `type:"structure"`

	// An answer of the question.
	Answer *ReviewTemplateAnswer `type:"structure"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The review template ARN.
	TemplateArn *string `min:"50" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReviewTemplateAnswerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReviewTemplateAnswerOutput) GoString() string {
	return s.String()
}

// SetAnswer sets the Answer field's value.
func (s *GetReviewTemplateAnswerOutput) SetAnswer(v *ReviewTemplateAnswer) *GetReviewTemplateAnswerOutput {
	s.Answer = v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *GetReviewTemplateAnswerOutput) SetLensAlias(v string) *GetReviewTemplateAnswerOutput {
	s.LensAlias = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *GetReviewTemplateAnswerOutput) SetTemplateArn(v string) *GetReviewTemplateAnswerOutput {
	s.TemplateArn = &v
	return s
}

type GetReviewTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The review template ARN.
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"50" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReviewTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReviewTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReviewTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReviewTemplateInput"}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *GetReviewTemplateInput) SetTemplateArn(v string) *GetReviewTemplateInput {
	s.TemplateArn = &v
	return s
}

type GetReviewTemplateLensReviewInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The review template ARN.
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"50" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReviewTemplateLensReviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReviewTemplateLensReviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReviewTemplateLensReviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReviewTemplateLensReviewInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *GetReviewTemplateLensReviewInput) SetLensAlias(v string) *GetReviewTemplateLensReviewInput {
	s.LensAlias = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *GetReviewTemplateLensReviewInput) SetTemplateArn(v string) *GetReviewTemplateLensReviewInput {
	s.TemplateArn = &v
	return s
}

type GetReviewTemplateLensReviewOutput struct {
	_ struct{} `type:"structure"`

	// A lens review of a question.
	LensReview *ReviewTemplateLensReview `type:"structure"`

	// The review template ARN.
	TemplateArn *string `min:"50" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReviewTemplateLensReviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReviewTemplateLensReviewOutput) GoString() string {
	return s.String()
}

// SetLensReview sets the LensReview field's value.
func (s *GetReviewTemplateLensReviewOutput) SetLensReview(v *ReviewTemplateLensReview) *GetReviewTemplateLensReviewOutput {
	s.LensReview = v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *GetReviewTemplateLensReviewOutput) SetTemplateArn(v string) *GetReviewTemplateLensReviewOutput {
	s.TemplateArn = &v
	return s
}

type GetReviewTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The review template.
	ReviewTemplate *ReviewTemplate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReviewTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReviewTemplateOutput) GoString() string {
	return s.String()
}

// SetReviewTemplate sets the ReviewTemplate field's value.
func (s *GetReviewTemplateOutput) SetReviewTemplate(v *ReviewTemplate) *GetReviewTemplateOutput {
	s.ReviewTemplate = v
	return s
}

// Input to get a workload.
type GetWorkloadInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkloadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkloadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkloadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkloadInput"}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *GetWorkloadInput) SetWorkloadId(v string) *GetWorkloadInput {
	s.WorkloadId = &v
	return s
}

// Output of a get workload call.
type GetWorkloadOutput struct {
	_ struct{} `type:"structure"`

	// A workload return object.
	Workload *Workload `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkloadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkloadOutput) GoString() string {
	return s.String()
}

// SetWorkload sets the Workload field's value.
func (s *GetWorkloadOutput) SetWorkload(v *Workload) *GetWorkloadOutput {
	s.Workload = v
	return s
}

type ImportLensInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The JSON representation of a lens.
	//
	// JSONString is a required field
	JSONString *string `min:"2" type:"string" required:"true"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// Tags to associate to a lens.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportLensInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportLensInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportLensInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportLensInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.JSONString == nil {
		invalidParams.Add(request.NewErrParamRequired("JSONString"))
	}
	if s.JSONString != nil && len(*s.JSONString) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("JSONString", 2))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *ImportLensInput) SetClientRequestToken(v string) *ImportLensInput {
	s.ClientRequestToken = &v
	return s
}

// SetJSONString sets the JSONString field's value.
func (s *ImportLensInput) SetJSONString(v string) *ImportLensInput {
	s.JSONString = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *ImportLensInput) SetLensAlias(v string) *ImportLensInput {
	s.LensAlias = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportLensInput) SetTags(v map[string]*string) *ImportLensInput {
	s.Tags = v
	return s
}

type ImportLensOutput struct {
	_ struct{} `type:"structure"`

	// The ARN for the lens that was created or updated.
	LensArn *string `type:"string"`

	// The status of the imported lens.
	Status *string `type:"string" enum:"ImportLensStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportLensOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportLensOutput) GoString() string {
	return s.String()
}

// SetLensArn sets the LensArn field's value.
func (s *ImportLensOutput) SetLensArn(v string) *ImportLensOutput {
	s.LensArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ImportLensOutput) SetStatus(v string) *ImportLensOutput {
	s.Status = &v
	return s
}

// An improvement summary of a lens review in a workload.
type ImprovementSummary struct {
	_ struct{} `type:"structure"`

	// The improvement plan URL for a question in an Amazon Web Services official
	// lenses.
	//
	// This value is only available if the question has been answered.
	//
	// This value does not apply to custom lenses.
	ImprovementPlanUrl *string `min:"1" type:"string"`

	// The improvement plan details.
	ImprovementPlans []*ChoiceImprovementPlan `type:"list"`

	// Configuration of the Jira integration.
	JiraConfiguration *JiraConfiguration `type:"structure"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// The ID of the question.
	QuestionId *string `min:"1" type:"string"`

	// The title of the question.
	QuestionTitle *string `min:"1" type:"string"`

	// The risk for a given workload, lens review, pillar, or question.
	Risk *string `type:"string" enum:"Risk"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImprovementSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImprovementSummary) GoString() string {
	return s.String()
}

// SetImprovementPlanUrl sets the ImprovementPlanUrl field's value.
func (s *ImprovementSummary) SetImprovementPlanUrl(v string) *ImprovementSummary {
	s.ImprovementPlanUrl = &v
	return s
}

// SetImprovementPlans sets the ImprovementPlans field's value.
func (s *ImprovementSummary) SetImprovementPlans(v []*ChoiceImprovementPlan) *ImprovementSummary {
	s.ImprovementPlans = v
	return s
}

// SetJiraConfiguration sets the JiraConfiguration field's value.
func (s *ImprovementSummary) SetJiraConfiguration(v *JiraConfiguration) *ImprovementSummary {
	s.JiraConfiguration = v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *ImprovementSummary) SetPillarId(v string) *ImprovementSummary {
	s.PillarId = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *ImprovementSummary) SetQuestionId(v string) *ImprovementSummary {
	s.QuestionId = &v
	return s
}

// SetQuestionTitle sets the QuestionTitle field's value.
func (s *ImprovementSummary) SetQuestionTitle(v string) *ImprovementSummary {
	s.QuestionTitle = &v
	return s
}

// SetRisk sets the Risk field's value.
func (s *ImprovementSummary) SetRisk(v string) *ImprovementSummary {
	s.Risk = &v
	return s
}

// There is a problem with the Well-Architected Tool API service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Configuration of the Jira integration.
type JiraConfiguration struct {
	_ struct{} `type:"structure"`

	// The URL of the associated Jira issue.
	JiraIssueUrl *string `min:"1" type:"string"`

	// The date and time recorded.
	LastSyncedTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JiraConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JiraConfiguration) GoString() string {
	return s.String()
}

// SetJiraIssueUrl sets the JiraIssueUrl field's value.
func (s *JiraConfiguration) SetJiraIssueUrl(v string) *JiraConfiguration {
	s.JiraIssueUrl = &v
	return s
}

// SetLastSyncedTime sets the LastSyncedTime field's value.
func (s *JiraConfiguration) SetLastSyncedTime(v time.Time) *JiraConfiguration {
	s.LastSyncedTime = &v
	return s
}

// Selected questions in the workload.
type JiraSelectedQuestionConfiguration struct {
	_ struct{} `type:"structure"`

	// Selected pillars in the workload.
	SelectedPillars []*SelectedPillar `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JiraSelectedQuestionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JiraSelectedQuestionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JiraSelectedQuestionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JiraSelectedQuestionConfiguration"}
	if s.SelectedPillars != nil {
		for i, v := range s.SelectedPillars {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SelectedPillars", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSelectedPillars sets the SelectedPillars field's value.
func (s *JiraSelectedQuestionConfiguration) SetSelectedPillars(v []*SelectedPillar) *JiraSelectedQuestionConfiguration {
	s.SelectedPillars = v
	return s
}

// A lens return object.
type Lens struct {
	_ struct{} `type:"structure"`

	// The description of the lens.
	Description *string `min:"1" type:"string"`

	// The ARN of a lens.
	LensArn *string `type:"string"`

	// The version of a lens.
	LensVersion *string `min:"1" type:"string"`

	// The full name of the lens.
	Name *string `min:"1" type:"string"`

	// The Amazon Web Services account ID that owns the lens.
	Owner *string `type:"string"`

	// The ID assigned to the share invitation.
	ShareInvitationId *string `type:"string"`

	// The tags assigned to the lens.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Lens) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Lens) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Lens) SetDescription(v string) *Lens {
	s.Description = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *Lens) SetLensArn(v string) *Lens {
	s.LensArn = &v
	return s
}

// SetLensVersion sets the LensVersion field's value.
func (s *Lens) SetLensVersion(v string) *Lens {
	s.LensVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *Lens) SetName(v string) *Lens {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *Lens) SetOwner(v string) *Lens {
	s.Owner = &v
	return s
}

// SetShareInvitationId sets the ShareInvitationId field's value.
func (s *Lens) SetShareInvitationId(v string) *Lens {
	s.ShareInvitationId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Lens) SetTags(v map[string]*string) *Lens {
	s.Tags = v
	return s
}

// A metric for a particular lens in a workload.
type LensMetric struct {
	_ struct{} `type:"structure"`

	// The lens ARN.
	LensArn *string `type:"string"`

	// The metrics for the pillars in a lens.
	Pillars []*PillarMetric `type:"list"`

	// A map from risk names to the count of how many questions have that rating.
	RiskCounts map[string]*int64 `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensMetric) GoString() string {
	return s.String()
}

// SetLensArn sets the LensArn field's value.
func (s *LensMetric) SetLensArn(v string) *LensMetric {
	s.LensArn = &v
	return s
}

// SetPillars sets the Pillars field's value.
func (s *LensMetric) SetPillars(v []*PillarMetric) *LensMetric {
	s.Pillars = v
	return s
}

// SetRiskCounts sets the RiskCounts field's value.
func (s *LensMetric) SetRiskCounts(v map[string]*int64) *LensMetric {
	s.RiskCounts = v
	return s
}

// A lens review of a question.
type LensReview struct {
	_ struct{} `type:"structure"`

	// Jira configuration status of the Lens review.
	JiraConfiguration *JiraSelectedQuestionConfiguration `type:"structure"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The ARN for the lens.
	LensArn *string `type:"string"`

	// The full name of the lens.
	LensName *string `min:"1" type:"string"`

	// The status of the lens.
	LensStatus *string `type:"string" enum:"LensStatus"`

	// The version of the lens.
	LensVersion *string `min:"1" type:"string"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The notes associated with the workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	Notes *string `type:"string"`

	// List of pillar review summaries of lens review in a workload.
	PillarReviewSummaries []*PillarReviewSummary `type:"list"`

	// A map from risk names to the count of how many questions have that rating.
	PrioritizedRiskCounts map[string]*int64 `type:"map"`

	// The profiles associated with the workload.
	Profiles []*WorkloadProfile `type:"list"`

	// A map from risk names to the count of how many questions have that rating.
	RiskCounts map[string]*int64 `type:"map"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensReview) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensReview) GoString() string {
	return s.String()
}

// SetJiraConfiguration sets the JiraConfiguration field's value.
func (s *LensReview) SetJiraConfiguration(v *JiraSelectedQuestionConfiguration) *LensReview {
	s.JiraConfiguration = v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *LensReview) SetLensAlias(v string) *LensReview {
	s.LensAlias = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *LensReview) SetLensArn(v string) *LensReview {
	s.LensArn = &v
	return s
}

// SetLensName sets the LensName field's value.
func (s *LensReview) SetLensName(v string) *LensReview {
	s.LensName = &v
	return s
}

// SetLensStatus sets the LensStatus field's value.
func (s *LensReview) SetLensStatus(v string) *LensReview {
	s.LensStatus = &v
	return s
}

// SetLensVersion sets the LensVersion field's value.
func (s *LensReview) SetLensVersion(v string) *LensReview {
	s.LensVersion = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *LensReview) SetNextToken(v string) *LensReview {
	s.NextToken = &v
	return s
}

// SetNotes sets the Notes field's value.
func (s *LensReview) SetNotes(v string) *LensReview {
	s.Notes = &v
	return s
}

// SetPillarReviewSummaries sets the PillarReviewSummaries field's value.
func (s *LensReview) SetPillarReviewSummaries(v []*PillarReviewSummary) *LensReview {
	s.PillarReviewSummaries = v
	return s
}

// SetPrioritizedRiskCounts sets the PrioritizedRiskCounts field's value.
func (s *LensReview) SetPrioritizedRiskCounts(v map[string]*int64) *LensReview {
	s.PrioritizedRiskCounts = v
	return s
}

// SetProfiles sets the Profiles field's value.
func (s *LensReview) SetProfiles(v []*WorkloadProfile) *LensReview {
	s.Profiles = v
	return s
}

// SetRiskCounts sets the RiskCounts field's value.
func (s *LensReview) SetRiskCounts(v map[string]*int64) *LensReview {
	s.RiskCounts = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *LensReview) SetUpdatedAt(v time.Time) *LensReview {
	s.UpdatedAt = &v
	return s
}

// A report of a lens review.
type LensReviewReport struct {
	_ struct{} `type:"structure"`

	// The Base64-encoded string representation of a lens review report.
	//
	// This data can be used to create a PDF file.
	//
	// Only returned by GetConsolidatedReport when PDF format is requested.
	Base64String *string `type:"string"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The ARN for the lens.
	LensArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensReviewReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensReviewReport) GoString() string {
	return s.String()
}

// SetBase64String sets the Base64String field's value.
func (s *LensReviewReport) SetBase64String(v string) *LensReviewReport {
	s.Base64String = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *LensReviewReport) SetLensAlias(v string) *LensReviewReport {
	s.LensAlias = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *LensReviewReport) SetLensArn(v string) *LensReviewReport {
	s.LensArn = &v
	return s
}

// A lens review summary of a workload.
type LensReviewSummary struct {
	_ struct{} `type:"structure"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The ARN for the lens.
	LensArn *string `type:"string"`

	// The full name of the lens.
	LensName *string `min:"1" type:"string"`

	// The status of the lens.
	LensStatus *string `type:"string" enum:"LensStatus"`

	// The version of the lens.
	LensVersion *string `min:"1" type:"string"`

	// A map from risk names to the count of how many questions have that rating.
	PrioritizedRiskCounts map[string]*int64 `type:"map"`

	// The profiles associated with the workload.
	Profiles []*WorkloadProfile `type:"list"`

	// A map from risk names to the count of how many questions have that rating.
	RiskCounts map[string]*int64 `type:"map"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensReviewSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensReviewSummary) GoString() string {
	return s.String()
}

// SetLensAlias sets the LensAlias field's value.
func (s *LensReviewSummary) SetLensAlias(v string) *LensReviewSummary {
	s.LensAlias = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *LensReviewSummary) SetLensArn(v string) *LensReviewSummary {
	s.LensArn = &v
	return s
}

// SetLensName sets the LensName field's value.
func (s *LensReviewSummary) SetLensName(v string) *LensReviewSummary {
	s.LensName = &v
	return s
}

// SetLensStatus sets the LensStatus field's value.
func (s *LensReviewSummary) SetLensStatus(v string) *LensReviewSummary {
	s.LensStatus = &v
	return s
}

// SetLensVersion sets the LensVersion field's value.
func (s *LensReviewSummary) SetLensVersion(v string) *LensReviewSummary {
	s.LensVersion = &v
	return s
}

// SetPrioritizedRiskCounts sets the PrioritizedRiskCounts field's value.
func (s *LensReviewSummary) SetPrioritizedRiskCounts(v map[string]*int64) *LensReviewSummary {
	s.PrioritizedRiskCounts = v
	return s
}

// SetProfiles sets the Profiles field's value.
func (s *LensReviewSummary) SetProfiles(v []*WorkloadProfile) *LensReviewSummary {
	s.Profiles = v
	return s
}

// SetRiskCounts sets the RiskCounts field's value.
func (s *LensReviewSummary) SetRiskCounts(v map[string]*int64) *LensReviewSummary {
	s.RiskCounts = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *LensReviewSummary) SetUpdatedAt(v time.Time) *LensReviewSummary {
	s.UpdatedAt = &v
	return s
}

// A lens share summary return object.
type LensShareSummary struct {
	_ struct{} `type:"structure"`

	// The ID associated with the share.
	ShareId *string `type:"string"`

	// The Amazon Web Services account ID, organization ID, or organizational unit
	// (OU) ID with which the workload, lens, profile, or review template is shared.
	SharedWith *string `min:"12" type:"string"`

	// The status of the share request.
	Status *string `type:"string" enum:"ShareStatus"`

	// Optional message to compliment the Status field.
	StatusMessage *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensShareSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensShareSummary) GoString() string {
	return s.String()
}

// SetShareId sets the ShareId field's value.
func (s *LensShareSummary) SetShareId(v string) *LensShareSummary {
	s.ShareId = &v
	return s
}

// SetSharedWith sets the SharedWith field's value.
func (s *LensShareSummary) SetSharedWith(v string) *LensShareSummary {
	s.SharedWith = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *LensShareSummary) SetStatus(v string) *LensShareSummary {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *LensShareSummary) SetStatusMessage(v string) *LensShareSummary {
	s.StatusMessage = &v
	return s
}

// A lens summary of a lens.
type LensSummary struct {
	_ struct{} `type:"structure"`

	// The date and time recorded.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the lens.
	Description *string `min:"1" type:"string"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The ARN of the lens.
	LensArn *string `type:"string"`

	// The full name of the lens.
	LensName *string `min:"1" type:"string"`

	// The status of the lens.
	LensStatus *string `type:"string" enum:"LensStatus"`

	// The type of the lens.
	LensType *string `type:"string" enum:"LensType"`

	// The version of the lens.
	LensVersion *string `min:"1" type:"string"`

	// An Amazon Web Services account ID.
	Owner *string `min:"12" type:"string"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *LensSummary) SetCreatedAt(v time.Time) *LensSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *LensSummary) SetDescription(v string) *LensSummary {
	s.Description = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *LensSummary) SetLensAlias(v string) *LensSummary {
	s.LensAlias = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *LensSummary) SetLensArn(v string) *LensSummary {
	s.LensArn = &v
	return s
}

// SetLensName sets the LensName field's value.
func (s *LensSummary) SetLensName(v string) *LensSummary {
	s.LensName = &v
	return s
}

// SetLensStatus sets the LensStatus field's value.
func (s *LensSummary) SetLensStatus(v string) *LensSummary {
	s.LensStatus = &v
	return s
}

// SetLensType sets the LensType field's value.
func (s *LensSummary) SetLensType(v string) *LensSummary {
	s.LensType = &v
	return s
}

// SetLensVersion sets the LensVersion field's value.
func (s *LensSummary) SetLensVersion(v string) *LensSummary {
	s.LensVersion = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *LensSummary) SetOwner(v string) *LensSummary {
	s.Owner = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *LensSummary) SetUpdatedAt(v time.Time) *LensSummary {
	s.UpdatedAt = &v
	return s
}

// Lens upgrade summary return object.
type LensUpgradeSummary struct {
	_ struct{} `type:"structure"`

	// The current version of the lens.
	CurrentLensVersion *string `min:"1" type:"string"`

	// The latest version of the lens.
	LatestLensVersion *string `min:"1" type:"string"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The ARN for the lens.
	LensArn *string `type:"string"`

	// ResourceArn of the lens being upgraded
	ResourceArn *string `min:"50" type:"string"`

	// The name of the workload.
	//
	// The name must be unique within an account within an Amazon Web Services Region.
	// Spaces and capitalization are ignored when checking for uniqueness.
	ResourceName *string `min:"3" type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`

	// The name of the workload.
	//
	// The name must be unique within an account within an Amazon Web Services Region.
	// Spaces and capitalization are ignored when checking for uniqueness.
	WorkloadName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensUpgradeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LensUpgradeSummary) GoString() string {
	return s.String()
}

// SetCurrentLensVersion sets the CurrentLensVersion field's value.
func (s *LensUpgradeSummary) SetCurrentLensVersion(v string) *LensUpgradeSummary {
	s.CurrentLensVersion = &v
	return s
}

// SetLatestLensVersion sets the LatestLensVersion field's value.
func (s *LensUpgradeSummary) SetLatestLensVersion(v string) *LensUpgradeSummary {
	s.LatestLensVersion = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *LensUpgradeSummary) SetLensAlias(v string) *LensUpgradeSummary {
	s.LensAlias = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *LensUpgradeSummary) SetLensArn(v string) *LensUpgradeSummary {
	s.LensArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *LensUpgradeSummary) SetResourceArn(v string) *LensUpgradeSummary {
	s.ResourceArn = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *LensUpgradeSummary) SetResourceName(v string) *LensUpgradeSummary {
	s.ResourceName = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *LensUpgradeSummary) SetWorkloadId(v string) *LensUpgradeSummary {
	s.WorkloadId = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *LensUpgradeSummary) SetWorkloadName(v string) *LensUpgradeSummary {
	s.WorkloadName = &v
	return s
}

// Input to list answers.
type ListAnswersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `location:"querystring" locationName:"MilestoneNumber" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `location:"querystring" locationName:"PillarId" min:"1" type:"string"`

	// The priority of the question.
	QuestionPriority *string `location:"querystring" locationName:"QuestionPriority" type:"string" enum:"QuestionPriority"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnswersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnswersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnswersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAnswersInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MilestoneNumber != nil && *s.MilestoneNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MilestoneNumber", 1))
	}
	if s.PillarId != nil && len(*s.PillarId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PillarId", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *ListAnswersInput) SetLensAlias(v string) *ListAnswersInput {
	s.LensAlias = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnswersInput) SetMaxResults(v int64) *ListAnswersInput {
	s.MaxResults = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *ListAnswersInput) SetMilestoneNumber(v int64) *ListAnswersInput {
	s.MilestoneNumber = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnswersInput) SetNextToken(v string) *ListAnswersInput {
	s.NextToken = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *ListAnswersInput) SetPillarId(v string) *ListAnswersInput {
	s.PillarId = &v
	return s
}

// SetQuestionPriority sets the QuestionPriority field's value.
func (s *ListAnswersInput) SetQuestionPriority(v string) *ListAnswersInput {
	s.QuestionPriority = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListAnswersInput) SetWorkloadId(v string) *ListAnswersInput {
	s.WorkloadId = &v
	return s
}

// Output of a list answers call.
type ListAnswersOutput struct {
	_ struct{} `type:"structure"`

	// List of answer summaries of lens review in a workload.
	AnswerSummaries []*AnswerSummary `type:"list"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The ARN for the lens.
	LensArn *string `type:"string"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnswersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAnswersOutput) GoString() string {
	return s.String()
}

// SetAnswerSummaries sets the AnswerSummaries field's value.
func (s *ListAnswersOutput) SetAnswerSummaries(v []*AnswerSummary) *ListAnswersOutput {
	s.AnswerSummaries = v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *ListAnswersOutput) SetLensAlias(v string) *ListAnswersOutput {
	s.LensAlias = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *ListAnswersOutput) SetLensArn(v string) *ListAnswersOutput {
	s.LensArn = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *ListAnswersOutput) SetMilestoneNumber(v int64) *ListAnswersOutput {
	s.MilestoneNumber = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnswersOutput) SetNextToken(v string) *ListAnswersOutput {
	s.NextToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListAnswersOutput) SetWorkloadId(v string) *ListAnswersOutput {
	s.WorkloadId = &v
	return s
}

type ListCheckDetailsInput struct {
	_ struct{} `type:"structure"`

	// The ID of a choice.
	//
	// ChoiceId is a required field
	ChoiceId *string `min:"1" type:"string" required:"true"`

	// Well-Architected Lens ARN.
	//
	// LensArn is a required field
	LensArn *string `type:"string" required:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	//
	// PillarId is a required field
	PillarId *string `min:"1" type:"string" required:"true"`

	// The ID of the question.
	//
	// QuestionId is a required field
	QuestionId *string `min:"1" type:"string" required:"true"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCheckDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCheckDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCheckDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCheckDetailsInput"}
	if s.ChoiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChoiceId"))
	}
	if s.ChoiceId != nil && len(*s.ChoiceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChoiceId", 1))
	}
	if s.LensArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LensArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PillarId == nil {
		invalidParams.Add(request.NewErrParamRequired("PillarId"))
	}
	if s.PillarId != nil && len(*s.PillarId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PillarId", 1))
	}
	if s.QuestionId == nil {
		invalidParams.Add(request.NewErrParamRequired("QuestionId"))
	}
	if s.QuestionId != nil && len(*s.QuestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuestionId", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChoiceId sets the ChoiceId field's value.
func (s *ListCheckDetailsInput) SetChoiceId(v string) *ListCheckDetailsInput {
	s.ChoiceId = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *ListCheckDetailsInput) SetLensArn(v string) *ListCheckDetailsInput {
	s.LensArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCheckDetailsInput) SetMaxResults(v int64) *ListCheckDetailsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCheckDetailsInput) SetNextToken(v string) *ListCheckDetailsInput {
	s.NextToken = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *ListCheckDetailsInput) SetPillarId(v string) *ListCheckDetailsInput {
	s.PillarId = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *ListCheckDetailsInput) SetQuestionId(v string) *ListCheckDetailsInput {
	s.QuestionId = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListCheckDetailsInput) SetWorkloadId(v string) *ListCheckDetailsInput {
	s.WorkloadId = &v
	return s
}

type ListCheckDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The details about the Trusted Advisor checks related to the Well-Architected
	// best practice.
	CheckDetails []*CheckDetail `type:"list"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCheckDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCheckDetailsOutput) GoString() string {
	return s.String()
}

// SetCheckDetails sets the CheckDetails field's value.
func (s *ListCheckDetailsOutput) SetCheckDetails(v []*CheckDetail) *ListCheckDetailsOutput {
	s.CheckDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCheckDetailsOutput) SetNextToken(v string) *ListCheckDetailsOutput {
	s.NextToken = &v
	return s
}

type ListCheckSummariesInput struct {
	_ struct{} `type:"structure"`

	// The ID of a choice.
	//
	// ChoiceId is a required field
	ChoiceId *string `min:"1" type:"string" required:"true"`

	// Well-Architected Lens ARN.
	//
	// LensArn is a required field
	LensArn *string `type:"string" required:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	//
	// PillarId is a required field
	PillarId *string `min:"1" type:"string" required:"true"`

	// The ID of the question.
	//
	// QuestionId is a required field
	QuestionId *string `min:"1" type:"string" required:"true"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCheckSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCheckSummariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCheckSummariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCheckSummariesInput"}
	if s.ChoiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChoiceId"))
	}
	if s.ChoiceId != nil && len(*s.ChoiceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChoiceId", 1))
	}
	if s.LensArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LensArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PillarId == nil {
		invalidParams.Add(request.NewErrParamRequired("PillarId"))
	}
	if s.PillarId != nil && len(*s.PillarId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PillarId", 1))
	}
	if s.QuestionId == nil {
		invalidParams.Add(request.NewErrParamRequired("QuestionId"))
	}
	if s.QuestionId != nil && len(*s.QuestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuestionId", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChoiceId sets the ChoiceId field's value.
func (s *ListCheckSummariesInput) SetChoiceId(v string) *ListCheckSummariesInput {
	s.ChoiceId = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *ListCheckSummariesInput) SetLensArn(v string) *ListCheckSummariesInput {
	s.LensArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCheckSummariesInput) SetMaxResults(v int64) *ListCheckSummariesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCheckSummariesInput) SetNextToken(v string) *ListCheckSummariesInput {
	s.NextToken = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *ListCheckSummariesInput) SetPillarId(v string) *ListCheckSummariesInput {
	s.PillarId = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *ListCheckSummariesInput) SetQuestionId(v string) *ListCheckSummariesInput {
	s.QuestionId = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListCheckSummariesInput) SetWorkloadId(v string) *ListCheckSummariesInput {
	s.WorkloadId = &v
	return s
}

type ListCheckSummariesOutput struct {
	_ struct{} `type:"structure"`

	// List of Trusted Advisor summaries related to the Well-Architected best practice.
	CheckSummaries []*CheckSummary `type:"list"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCheckSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCheckSummariesOutput) GoString() string {
	return s.String()
}

// SetCheckSummaries sets the CheckSummaries field's value.
func (s *ListCheckSummariesOutput) SetCheckSummaries(v []*CheckSummary) *ListCheckSummariesOutput {
	s.CheckSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCheckSummariesOutput) SetNextToken(v string) *ListCheckSummariesOutput {
	s.NextToken = &v
	return s
}

// Input to list lens review improvements.
type ListLensReviewImprovementsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `location:"querystring" locationName:"MilestoneNumber" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `location:"querystring" locationName:"PillarId" min:"1" type:"string"`

	// The priority of the question.
	QuestionPriority *string `location:"querystring" locationName:"QuestionPriority" type:"string" enum:"QuestionPriority"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensReviewImprovementsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensReviewImprovementsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLensReviewImprovementsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLensReviewImprovementsInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MilestoneNumber != nil && *s.MilestoneNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MilestoneNumber", 1))
	}
	if s.PillarId != nil && len(*s.PillarId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PillarId", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *ListLensReviewImprovementsInput) SetLensAlias(v string) *ListLensReviewImprovementsInput {
	s.LensAlias = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLensReviewImprovementsInput) SetMaxResults(v int64) *ListLensReviewImprovementsInput {
	s.MaxResults = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *ListLensReviewImprovementsInput) SetMilestoneNumber(v int64) *ListLensReviewImprovementsInput {
	s.MilestoneNumber = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLensReviewImprovementsInput) SetNextToken(v string) *ListLensReviewImprovementsInput {
	s.NextToken = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *ListLensReviewImprovementsInput) SetPillarId(v string) *ListLensReviewImprovementsInput {
	s.PillarId = &v
	return s
}

// SetQuestionPriority sets the QuestionPriority field's value.
func (s *ListLensReviewImprovementsInput) SetQuestionPriority(v string) *ListLensReviewImprovementsInput {
	s.QuestionPriority = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListLensReviewImprovementsInput) SetWorkloadId(v string) *ListLensReviewImprovementsInput {
	s.WorkloadId = &v
	return s
}

// Output of a list lens review improvements call.
type ListLensReviewImprovementsOutput struct {
	_ struct{} `type:"structure"`

	// List of improvement summaries of lens review in a workload.
	ImprovementSummaries []*ImprovementSummary `type:"list"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The ARN for the lens.
	LensArn *string `type:"string"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensReviewImprovementsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensReviewImprovementsOutput) GoString() string {
	return s.String()
}

// SetImprovementSummaries sets the ImprovementSummaries field's value.
func (s *ListLensReviewImprovementsOutput) SetImprovementSummaries(v []*ImprovementSummary) *ListLensReviewImprovementsOutput {
	s.ImprovementSummaries = v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *ListLensReviewImprovementsOutput) SetLensAlias(v string) *ListLensReviewImprovementsOutput {
	s.LensAlias = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *ListLensReviewImprovementsOutput) SetLensArn(v string) *ListLensReviewImprovementsOutput {
	s.LensArn = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *ListLensReviewImprovementsOutput) SetMilestoneNumber(v int64) *ListLensReviewImprovementsOutput {
	s.MilestoneNumber = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLensReviewImprovementsOutput) SetNextToken(v string) *ListLensReviewImprovementsOutput {
	s.NextToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListLensReviewImprovementsOutput) SetWorkloadId(v string) *ListLensReviewImprovementsOutput {
	s.WorkloadId = &v
	return s
}

// Input to list lens reviews.
type ListLensReviewsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `location:"querystring" locationName:"MilestoneNumber" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensReviewsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensReviewsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLensReviewsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLensReviewsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MilestoneNumber != nil && *s.MilestoneNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MilestoneNumber", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLensReviewsInput) SetMaxResults(v int64) *ListLensReviewsInput {
	s.MaxResults = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *ListLensReviewsInput) SetMilestoneNumber(v int64) *ListLensReviewsInput {
	s.MilestoneNumber = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLensReviewsInput) SetNextToken(v string) *ListLensReviewsInput {
	s.NextToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListLensReviewsInput) SetWorkloadId(v string) *ListLensReviewsInput {
	s.WorkloadId = &v
	return s
}

// Output of a list lens reviews call.
type ListLensReviewsOutput struct {
	_ struct{} `type:"structure"`

	// List of lens summaries of lens reviews of a workload.
	LensReviewSummaries []*LensReviewSummary `type:"list"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensReviewsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensReviewsOutput) GoString() string {
	return s.String()
}

// SetLensReviewSummaries sets the LensReviewSummaries field's value.
func (s *ListLensReviewsOutput) SetLensReviewSummaries(v []*LensReviewSummary) *ListLensReviewsOutput {
	s.LensReviewSummaries = v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *ListLensReviewsOutput) SetMilestoneNumber(v int64) *ListLensReviewsOutput {
	s.MilestoneNumber = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLensReviewsOutput) SetNextToken(v string) *ListLensReviewsOutput {
	s.NextToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListLensReviewsOutput) SetWorkloadId(v string) *ListLensReviewsOutput {
	s.WorkloadId = &v
	return s
}

type ListLensSharesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The Amazon Web Services account ID, organization ID, or organizational unit
	// (OU) ID with which the lens is shared.
	SharedWithPrefix *string `location:"querystring" locationName:"SharedWithPrefix" type:"string"`

	// The status of the share request.
	Status *string `location:"querystring" locationName:"Status" type:"string" enum:"ShareStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensSharesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensSharesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLensSharesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLensSharesInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *ListLensSharesInput) SetLensAlias(v string) *ListLensSharesInput {
	s.LensAlias = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLensSharesInput) SetMaxResults(v int64) *ListLensSharesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLensSharesInput) SetNextToken(v string) *ListLensSharesInput {
	s.NextToken = &v
	return s
}

// SetSharedWithPrefix sets the SharedWithPrefix field's value.
func (s *ListLensSharesInput) SetSharedWithPrefix(v string) *ListLensSharesInput {
	s.SharedWithPrefix = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListLensSharesInput) SetStatus(v string) *ListLensSharesInput {
	s.Status = &v
	return s
}

type ListLensSharesOutput struct {
	_ struct{} `type:"structure"`

	// A list of lens share summaries.
	LensShareSummaries []*LensShareSummary `type:"list"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensSharesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensSharesOutput) GoString() string {
	return s.String()
}

// SetLensShareSummaries sets the LensShareSummaries field's value.
func (s *ListLensSharesOutput) SetLensShareSummaries(v []*LensShareSummary) *ListLensSharesOutput {
	s.LensShareSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLensSharesOutput) SetNextToken(v string) *ListLensSharesOutput {
	s.NextToken = &v
	return s
}

// Input to list lenses.
type ListLensesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The full name of the lens.
	LensName *string `location:"querystring" locationName:"LensName" min:"1" type:"string"`

	// The status of lenses to be returned.
	LensStatus *string `location:"querystring" locationName:"LensStatus" type:"string" enum:"LensStatusType"`

	// The type of lenses to be returned.
	LensType *string `location:"querystring" locationName:"LensType" type:"string" enum:"LensType"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLensesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLensesInput"}
	if s.LensName != nil && len(*s.LensName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensName sets the LensName field's value.
func (s *ListLensesInput) SetLensName(v string) *ListLensesInput {
	s.LensName = &v
	return s
}

// SetLensStatus sets the LensStatus field's value.
func (s *ListLensesInput) SetLensStatus(v string) *ListLensesInput {
	s.LensStatus = &v
	return s
}

// SetLensType sets the LensType field's value.
func (s *ListLensesInput) SetLensType(v string) *ListLensesInput {
	s.LensType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLensesInput) SetMaxResults(v int64) *ListLensesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLensesInput) SetNextToken(v string) *ListLensesInput {
	s.NextToken = &v
	return s
}

// Output of a list lenses call.
type ListLensesOutput struct {
	_ struct{} `type:"structure"`

	// List of lens summaries of available lenses.
	LensSummaries []*LensSummary `type:"list"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLensesOutput) GoString() string {
	return s.String()
}

// SetLensSummaries sets the LensSummaries field's value.
func (s *ListLensesOutput) SetLensSummaries(v []*LensSummary) *ListLensesOutput {
	s.LensSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLensesOutput) SetNextToken(v string) *ListLensesOutput {
	s.NextToken = &v
	return s
}

// Input to list all milestones for a workload.
type ListMilestonesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMilestonesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMilestonesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMilestonesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMilestonesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMilestonesInput) SetMaxResults(v int64) *ListMilestonesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMilestonesInput) SetNextToken(v string) *ListMilestonesInput {
	s.NextToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListMilestonesInput) SetWorkloadId(v string) *ListMilestonesInput {
	s.WorkloadId = &v
	return s
}

// Output of a list milestones call.
type ListMilestonesOutput struct {
	_ struct{} `type:"structure"`

	// A list of milestone summaries.
	MilestoneSummaries []*MilestoneSummary `type:"list"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMilestonesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMilestonesOutput) GoString() string {
	return s.String()
}

// SetMilestoneSummaries sets the MilestoneSummaries field's value.
func (s *ListMilestonesOutput) SetMilestoneSummaries(v []*MilestoneSummary) *ListMilestonesOutput {
	s.MilestoneSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMilestonesOutput) SetNextToken(v string) *ListMilestonesOutput {
	s.NextToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListMilestonesOutput) SetWorkloadId(v string) *ListMilestonesOutput {
	s.WorkloadId = &v
	return s
}

type ListNotificationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ARN for the related resource for the notification.
	//
	// Only one of WorkloadID or ResourceARN should be specified.
	ResourceArn *string `min:"50" type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNotificationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNotificationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 50))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNotificationsInput) SetMaxResults(v int64) *ListNotificationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotificationsInput) SetNextToken(v string) *ListNotificationsInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListNotificationsInput) SetResourceArn(v string) *ListNotificationsInput {
	s.ResourceArn = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListNotificationsInput) SetWorkloadId(v string) *ListNotificationsInput {
	s.WorkloadId = &v
	return s
}

type ListNotificationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// List of lens notification summaries in a workload.
	NotificationSummaries []*NotificationSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotificationsOutput) SetNextToken(v string) *ListNotificationsOutput {
	s.NextToken = &v
	return s
}

// SetNotificationSummaries sets the NotificationSummaries field's value.
func (s *ListNotificationsOutput) SetNotificationSummaries(v []*NotificationSummary) *ListNotificationsOutput {
	s.NotificationSummaries = v
	return s
}

type ListProfileNotificationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `location:"querystring" locationName:"WorkloadId" min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileNotificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileNotificationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfileNotificationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfileNotificationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProfileNotificationsInput) SetMaxResults(v int64) *ListProfileNotificationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileNotificationsInput) SetNextToken(v string) *ListProfileNotificationsInput {
	s.NextToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListProfileNotificationsInput) SetWorkloadId(v string) *ListProfileNotificationsInput {
	s.WorkloadId = &v
	return s
}

type ListProfileNotificationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// Notification summaries.
	NotificationSummaries []*ProfileNotificationSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileNotificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileNotificationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileNotificationsOutput) SetNextToken(v string) *ListProfileNotificationsOutput {
	s.NextToken = &v
	return s
}

// SetNotificationSummaries sets the NotificationSummaries field's value.
func (s *ListProfileNotificationsOutput) SetNotificationSummaries(v []*ProfileNotificationSummary) *ListProfileNotificationsOutput {
	s.NotificationSummaries = v
	return s
}

type ListProfileSharesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The profile ARN.
	//
	// ProfileArn is a required field
	ProfileArn *string `location:"uri" locationName:"ProfileArn" type:"string" required:"true"`

	// The Amazon Web Services account ID, organization ID, or organizational unit
	// (OU) ID with which the profile is shared.
	SharedWithPrefix *string `location:"querystring" locationName:"SharedWithPrefix" type:"string"`

	// The status of the share request.
	Status *string `location:"querystring" locationName:"Status" type:"string" enum:"ShareStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileSharesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileSharesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfileSharesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfileSharesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ProfileArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileArn"))
	}
	if s.ProfileArn != nil && len(*s.ProfileArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProfileSharesInput) SetMaxResults(v int64) *ListProfileSharesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileSharesInput) SetNextToken(v string) *ListProfileSharesInput {
	s.NextToken = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *ListProfileSharesInput) SetProfileArn(v string) *ListProfileSharesInput {
	s.ProfileArn = &v
	return s
}

// SetSharedWithPrefix sets the SharedWithPrefix field's value.
func (s *ListProfileSharesInput) SetSharedWithPrefix(v string) *ListProfileSharesInput {
	s.SharedWithPrefix = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListProfileSharesInput) SetStatus(v string) *ListProfileSharesInput {
	s.Status = &v
	return s
}

type ListProfileSharesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// Profile share summaries.
	ProfileShareSummaries []*ProfileShareSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileSharesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileSharesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileSharesOutput) SetNextToken(v string) *ListProfileSharesOutput {
	s.NextToken = &v
	return s
}

// SetProfileShareSummaries sets the ProfileShareSummaries field's value.
func (s *ListProfileSharesOutput) SetProfileShareSummaries(v []*ProfileShareSummary) *ListProfileSharesOutput {
	s.ProfileShareSummaries = v
	return s
}

type ListProfilesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// An optional string added to the beginning of each profile name returned in
	// the results.
	ProfileNamePrefix *string `location:"querystring" locationName:"ProfileNamePrefix" type:"string"`

	// Profile owner type.
	ProfileOwnerType *string `location:"querystring" locationName:"ProfileOwnerType" type:"string" enum:"ProfileOwnerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfilesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProfilesInput) SetMaxResults(v int64) *ListProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfilesInput) SetNextToken(v string) *ListProfilesInput {
	s.NextToken = &v
	return s
}

// SetProfileNamePrefix sets the ProfileNamePrefix field's value.
func (s *ListProfilesInput) SetProfileNamePrefix(v string) *ListProfilesInput {
	s.ProfileNamePrefix = &v
	return s
}

// SetProfileOwnerType sets the ProfileOwnerType field's value.
func (s *ListProfilesInput) SetProfileOwnerType(v string) *ListProfilesInput {
	s.ProfileOwnerType = &v
	return s
}

type ListProfilesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// Profile summaries.
	ProfileSummaries []*ProfileSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfilesOutput) SetNextToken(v string) *ListProfilesOutput {
	s.NextToken = &v
	return s
}

// SetProfileSummaries sets the ProfileSummaries field's value.
func (s *ListProfilesOutput) SetProfileSummaries(v []*ProfileSummary) *ListProfilesOutput {
	s.ProfileSummaries = v
	return s
}

type ListReviewTemplateAnswersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `location:"querystring" locationName:"PillarId" min:"1" type:"string"`

	// The ARN of the review template.
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"50" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReviewTemplateAnswersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReviewTemplateAnswersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReviewTemplateAnswersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReviewTemplateAnswersInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PillarId != nil && len(*s.PillarId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PillarId", 1))
	}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *ListReviewTemplateAnswersInput) SetLensAlias(v string) *ListReviewTemplateAnswersInput {
	s.LensAlias = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReviewTemplateAnswersInput) SetMaxResults(v int64) *ListReviewTemplateAnswersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReviewTemplateAnswersInput) SetNextToken(v string) *ListReviewTemplateAnswersInput {
	s.NextToken = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *ListReviewTemplateAnswersInput) SetPillarId(v string) *ListReviewTemplateAnswersInput {
	s.PillarId = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *ListReviewTemplateAnswersInput) SetTemplateArn(v string) *ListReviewTemplateAnswersInput {
	s.TemplateArn = &v
	return s
}

type ListReviewTemplateAnswersOutput struct {
	_ struct{} `type:"structure"`

	// List of answer summaries of a lens review in a review template.
	AnswerSummaries []*ReviewTemplateAnswerSummary `type:"list"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ARN of the review template.
	TemplateArn *string `min:"50" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReviewTemplateAnswersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReviewTemplateAnswersOutput) GoString() string {
	return s.String()
}

// SetAnswerSummaries sets the AnswerSummaries field's value.
func (s *ListReviewTemplateAnswersOutput) SetAnswerSummaries(v []*ReviewTemplateAnswerSummary) *ListReviewTemplateAnswersOutput {
	s.AnswerSummaries = v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *ListReviewTemplateAnswersOutput) SetLensAlias(v string) *ListReviewTemplateAnswersOutput {
	s.LensAlias = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReviewTemplateAnswersOutput) SetNextToken(v string) *ListReviewTemplateAnswersOutput {
	s.NextToken = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *ListReviewTemplateAnswersOutput) SetTemplateArn(v string) *ListReviewTemplateAnswersOutput {
	s.TemplateArn = &v
	return s
}

type ListReviewTemplatesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReviewTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReviewTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReviewTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReviewTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReviewTemplatesInput) SetMaxResults(v int64) *ListReviewTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReviewTemplatesInput) SetNextToken(v string) *ListReviewTemplatesInput {
	s.NextToken = &v
	return s
}

type ListReviewTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// List of review templates.
	ReviewTemplates []*ReviewTemplateSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReviewTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReviewTemplatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReviewTemplatesOutput) SetNextToken(v string) *ListReviewTemplatesOutput {
	s.NextToken = &v
	return s
}

// SetReviewTemplates sets the ReviewTemplates field's value.
func (s *ListReviewTemplatesOutput) SetReviewTemplates(v []*ReviewTemplateSummary) *ListReviewTemplatesOutput {
	s.ReviewTemplates = v
	return s
}

// Input for List Share Invitations
type ListShareInvitationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// An optional string added to the beginning of each lens name returned in the
	// results.
	LensNamePrefix *string `location:"querystring" locationName:"LensNamePrefix" type:"string"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// An optional string added to the beginning of each profile name returned in
	// the results.
	ProfileNamePrefix *string `location:"querystring" locationName:"ProfileNamePrefix" type:"string"`

	// The type of share invitations to be returned.
	ShareResourceType *string `location:"querystring" locationName:"ShareResourceType" type:"string" enum:"ShareResourceType"`

	// An optional string added to the beginning of each review template name returned
	// in the results.
	TemplateNamePrefix *string `location:"querystring" locationName:"TemplateNamePrefix" type:"string"`

	// An optional string added to the beginning of each workload name returned
	// in the results.
	WorkloadNamePrefix *string `location:"querystring" locationName:"WorkloadNamePrefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListShareInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListShareInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListShareInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListShareInvitationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensNamePrefix sets the LensNamePrefix field's value.
func (s *ListShareInvitationsInput) SetLensNamePrefix(v string) *ListShareInvitationsInput {
	s.LensNamePrefix = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListShareInvitationsInput) SetMaxResults(v int64) *ListShareInvitationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListShareInvitationsInput) SetNextToken(v string) *ListShareInvitationsInput {
	s.NextToken = &v
	return s
}

// SetProfileNamePrefix sets the ProfileNamePrefix field's value.
func (s *ListShareInvitationsInput) SetProfileNamePrefix(v string) *ListShareInvitationsInput {
	s.ProfileNamePrefix = &v
	return s
}

// SetShareResourceType sets the ShareResourceType field's value.
func (s *ListShareInvitationsInput) SetShareResourceType(v string) *ListShareInvitationsInput {
	s.ShareResourceType = &v
	return s
}

// SetTemplateNamePrefix sets the TemplateNamePrefix field's value.
func (s *ListShareInvitationsInput) SetTemplateNamePrefix(v string) *ListShareInvitationsInput {
	s.TemplateNamePrefix = &v
	return s
}

// SetWorkloadNamePrefix sets the WorkloadNamePrefix field's value.
func (s *ListShareInvitationsInput) SetWorkloadNamePrefix(v string) *ListShareInvitationsInput {
	s.WorkloadNamePrefix = &v
	return s
}

// Input for List Share Invitations
type ListShareInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// List of share invitation summaries in a workload.
	ShareInvitationSummaries []*ShareInvitationSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListShareInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListShareInvitationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListShareInvitationsOutput) SetNextToken(v string) *ListShareInvitationsOutput {
	s.NextToken = &v
	return s
}

// SetShareInvitationSummaries sets the ShareInvitationSummaries field's value.
func (s *ListShareInvitationsOutput) SetShareInvitationSummaries(v []*ShareInvitationSummary) *ListShareInvitationsOutput {
	s.ShareInvitationSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN for the workload.
	//
	// WorkloadArn is a required field
	WorkloadArn *string `location:"uri" locationName:"WorkloadArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.WorkloadArn == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadArn"))
	}
	if s.WorkloadArn != nil && len(*s.WorkloadArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkloadArn sets the WorkloadArn field's value.
func (s *ListTagsForResourceInput) SetWorkloadArn(v string) *ListTagsForResourceInput {
	s.WorkloadArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTemplateSharesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The Amazon Web Services account ID, organization ID, or organizational unit
	// (OU) ID with which the profile is shared.
	SharedWithPrefix *string `location:"querystring" locationName:"SharedWithPrefix" type:"string"`

	// The status of the share request.
	Status *string `location:"querystring" locationName:"Status" type:"string" enum:"ShareStatus"`

	// The review template ARN.
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"50" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplateSharesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplateSharesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTemplateSharesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTemplateSharesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTemplateSharesInput) SetMaxResults(v int64) *ListTemplateSharesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplateSharesInput) SetNextToken(v string) *ListTemplateSharesInput {
	s.NextToken = &v
	return s
}

// SetSharedWithPrefix sets the SharedWithPrefix field's value.
func (s *ListTemplateSharesInput) SetSharedWithPrefix(v string) *ListTemplateSharesInput {
	s.SharedWithPrefix = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTemplateSharesInput) SetStatus(v string) *ListTemplateSharesInput {
	s.Status = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *ListTemplateSharesInput) SetTemplateArn(v string) *ListTemplateSharesInput {
	s.TemplateArn = &v
	return s
}

type ListTemplateSharesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The review template ARN.
	TemplateArn *string `min:"50" type:"string"`

	// A review template share summary return object.
	TemplateShareSummaries []*TemplateShareSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplateSharesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplateSharesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplateSharesOutput) SetNextToken(v string) *ListTemplateSharesOutput {
	s.NextToken = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *ListTemplateSharesOutput) SetTemplateArn(v string) *ListTemplateSharesOutput {
	s.TemplateArn = &v
	return s
}

// SetTemplateShareSummaries sets the TemplateShareSummaries field's value.
func (s *ListTemplateSharesOutput) SetTemplateShareSummaries(v []*TemplateShareSummary) *ListTemplateSharesOutput {
	s.TemplateShareSummaries = v
	return s
}

// Input for List Workload Share
type ListWorkloadSharesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The Amazon Web Services account ID, organization ID, or organizational unit
	// (OU) ID with which the workload is shared.
	SharedWithPrefix *string `location:"querystring" locationName:"SharedWithPrefix" type:"string"`

	// The status of the share request.
	Status *string `location:"querystring" locationName:"Status" type:"string" enum:"ShareStatus"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadSharesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadSharesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkloadSharesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkloadSharesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkloadSharesInput) SetMaxResults(v int64) *ListWorkloadSharesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkloadSharesInput) SetNextToken(v string) *ListWorkloadSharesInput {
	s.NextToken = &v
	return s
}

// SetSharedWithPrefix sets the SharedWithPrefix field's value.
func (s *ListWorkloadSharesInput) SetSharedWithPrefix(v string) *ListWorkloadSharesInput {
	s.SharedWithPrefix = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListWorkloadSharesInput) SetStatus(v string) *ListWorkloadSharesInput {
	s.Status = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListWorkloadSharesInput) SetWorkloadId(v string) *ListWorkloadSharesInput {
	s.WorkloadId = &v
	return s
}

// Input for List Workload Share
type ListWorkloadSharesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`

	// A list of workload share summaries.
	WorkloadShareSummaries []*WorkloadShareSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadSharesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadSharesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkloadSharesOutput) SetNextToken(v string) *ListWorkloadSharesOutput {
	s.NextToken = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ListWorkloadSharesOutput) SetWorkloadId(v string) *ListWorkloadSharesOutput {
	s.WorkloadId = &v
	return s
}

// SetWorkloadShareSummaries sets the WorkloadShareSummaries field's value.
func (s *ListWorkloadSharesOutput) SetWorkloadShareSummaries(v []*WorkloadShareSummary) *ListWorkloadSharesOutput {
	s.WorkloadShareSummaries = v
	return s
}

// Input to list all workloads.
type ListWorkloadsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return for this request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// An optional string added to the beginning of each workload name returned
	// in the results.
	WorkloadNamePrefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkloadsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkloadsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkloadsInput) SetMaxResults(v int64) *ListWorkloadsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkloadsInput) SetNextToken(v string) *ListWorkloadsInput {
	s.NextToken = &v
	return s
}

// SetWorkloadNamePrefix sets the WorkloadNamePrefix field's value.
func (s *ListWorkloadsInput) SetWorkloadNamePrefix(v string) *ListWorkloadsInput {
	s.WorkloadNamePrefix = &v
	return s
}

// Output of a list workloads call.
type ListWorkloadsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// A list of workload summaries.
	WorkloadSummaries []*WorkloadSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkloadsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkloadsOutput) SetNextToken(v string) *ListWorkloadsOutput {
	s.NextToken = &v
	return s
}

// SetWorkloadSummaries sets the WorkloadSummaries field's value.
func (s *ListWorkloadsOutput) SetWorkloadSummaries(v []*WorkloadSummary) *ListWorkloadsOutput {
	s.WorkloadSummaries = v
	return s
}

// A milestone return object.
type Milestone struct {
	_ struct{} `type:"structure"`

	// The name of the milestone in a workload.
	//
	// Milestone names must be unique within a workload.
	MilestoneName *string `min:"3" type:"string"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The date and time recorded.
	RecordedAt *time.Time `type:"timestamp"`

	// A workload return object.
	Workload *Workload `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Milestone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Milestone) GoString() string {
	return s.String()
}

// SetMilestoneName sets the MilestoneName field's value.
func (s *Milestone) SetMilestoneName(v string) *Milestone {
	s.MilestoneName = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *Milestone) SetMilestoneNumber(v int64) *Milestone {
	s.MilestoneNumber = &v
	return s
}

// SetRecordedAt sets the RecordedAt field's value.
func (s *Milestone) SetRecordedAt(v time.Time) *Milestone {
	s.RecordedAt = &v
	return s
}

// SetWorkload sets the Workload field's value.
func (s *Milestone) SetWorkload(v *Workload) *Milestone {
	s.Workload = v
	return s
}

// A milestone summary return object.
type MilestoneSummary struct {
	_ struct{} `type:"structure"`

	// The name of the milestone in a workload.
	//
	// Milestone names must be unique within a workload.
	MilestoneName *string `min:"3" type:"string"`

	// The milestone number.
	//
	// A workload can have a maximum of 100 milestones.
	MilestoneNumber *int64 `min:"1" type:"integer"`

	// The date and time recorded.
	RecordedAt *time.Time `type:"timestamp"`

	// A workload summary return object.
	WorkloadSummary *WorkloadSummary `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MilestoneSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MilestoneSummary) GoString() string {
	return s.String()
}

// SetMilestoneName sets the MilestoneName field's value.
func (s *MilestoneSummary) SetMilestoneName(v string) *MilestoneSummary {
	s.MilestoneName = &v
	return s
}

// SetMilestoneNumber sets the MilestoneNumber field's value.
func (s *MilestoneSummary) SetMilestoneNumber(v int64) *MilestoneSummary {
	s.MilestoneNumber = &v
	return s
}

// SetRecordedAt sets the RecordedAt field's value.
func (s *MilestoneSummary) SetRecordedAt(v time.Time) *MilestoneSummary {
	s.RecordedAt = &v
	return s
}

// SetWorkloadSummary sets the WorkloadSummary field's value.
func (s *MilestoneSummary) SetWorkloadSummary(v *WorkloadSummary) *MilestoneSummary {
	s.WorkloadSummary = v
	return s
}

// A notification summary return object.
type NotificationSummary struct {
	_ struct{} `type:"structure"`

	// Summary of lens upgrade.
	LensUpgradeSummary *LensUpgradeSummary `type:"structure"`

	// The type of notification.
	Type *string `type:"string" enum:"NotificationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationSummary) GoString() string {
	return s.String()
}

// SetLensUpgradeSummary sets the LensUpgradeSummary field's value.
func (s *NotificationSummary) SetLensUpgradeSummary(v *LensUpgradeSummary) *NotificationSummary {
	s.LensUpgradeSummary = v
	return s
}

// SetType sets the Type field's value.
func (s *NotificationSummary) SetType(v string) *NotificationSummary {
	s.Type = &v
	return s
}

// A pillar difference return object.
type PillarDifference struct {
	_ struct{} `type:"structure"`

	// Indicates the type of change to the pillar.
	DifferenceStatus *string `type:"string" enum:"DifferenceStatus"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// The name of the pillar.
	PillarName *string `min:"1" type:"string"`

	// List of question differences.
	QuestionDifferences []*QuestionDifference `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PillarDifference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PillarDifference) GoString() string {
	return s.String()
}

// SetDifferenceStatus sets the DifferenceStatus field's value.
func (s *PillarDifference) SetDifferenceStatus(v string) *PillarDifference {
	s.DifferenceStatus = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *PillarDifference) SetPillarId(v string) *PillarDifference {
	s.PillarId = &v
	return s
}

// SetPillarName sets the PillarName field's value.
func (s *PillarDifference) SetPillarName(v string) *PillarDifference {
	s.PillarName = &v
	return s
}

// SetQuestionDifferences sets the QuestionDifferences field's value.
func (s *PillarDifference) SetQuestionDifferences(v []*QuestionDifference) *PillarDifference {
	s.QuestionDifferences = v
	return s
}

// A metric for a particular pillar in a lens.
type PillarMetric struct {
	_ struct{} `type:"structure"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// The questions that have been identified as risks in the pillar.
	Questions []*QuestionMetric `type:"list"`

	// A map from risk names to the count of how many questions have that rating.
	RiskCounts map[string]*int64 `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PillarMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PillarMetric) GoString() string {
	return s.String()
}

// SetPillarId sets the PillarId field's value.
func (s *PillarMetric) SetPillarId(v string) *PillarMetric {
	s.PillarId = &v
	return s
}

// SetQuestions sets the Questions field's value.
func (s *PillarMetric) SetQuestions(v []*QuestionMetric) *PillarMetric {
	s.Questions = v
	return s
}

// SetRiskCounts sets the RiskCounts field's value.
func (s *PillarMetric) SetRiskCounts(v map[string]*int64) *PillarMetric {
	s.RiskCounts = v
	return s
}

// A pillar review summary of a lens review.
type PillarReviewSummary struct {
	_ struct{} `type:"structure"`

	// The notes associated with the workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	Notes *string `type:"string"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// The name of the pillar.
	PillarName *string `min:"1" type:"string"`

	// A map from risk names to the count of how many questions have that rating.
	PrioritizedRiskCounts map[string]*int64 `type:"map"`

	// A map from risk names to the count of how many questions have that rating.
	RiskCounts map[string]*int64 `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PillarReviewSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PillarReviewSummary) GoString() string {
	return s.String()
}

// SetNotes sets the Notes field's value.
func (s *PillarReviewSummary) SetNotes(v string) *PillarReviewSummary {
	s.Notes = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *PillarReviewSummary) SetPillarId(v string) *PillarReviewSummary {
	s.PillarId = &v
	return s
}

// SetPillarName sets the PillarName field's value.
func (s *PillarReviewSummary) SetPillarName(v string) *PillarReviewSummary {
	s.PillarName = &v
	return s
}

// SetPrioritizedRiskCounts sets the PrioritizedRiskCounts field's value.
func (s *PillarReviewSummary) SetPrioritizedRiskCounts(v map[string]*int64) *PillarReviewSummary {
	s.PrioritizedRiskCounts = v
	return s
}

// SetRiskCounts sets the RiskCounts field's value.
func (s *PillarReviewSummary) SetRiskCounts(v map[string]*int64) *PillarReviewSummary {
	s.RiskCounts = v
	return s
}

// A profile.
type Profile struct {
	_ struct{} `type:"structure"`

	// The date and time recorded.
	CreatedAt *time.Time `type:"timestamp"`

	// An Amazon Web Services account ID.
	Owner *string `min:"12" type:"string"`

	// The profile ARN.
	ProfileArn *string `type:"string"`

	// The profile description.
	ProfileDescription *string `min:"3" type:"string"`

	// The profile name.
	ProfileName *string `min:"3" type:"string"`

	// Profile questions.
	ProfileQuestions []*ProfileQuestion `type:"list"`

	// The profile version.
	ProfileVersion *string `min:"1" type:"string"`

	// The ID assigned to the share invitation.
	ShareInvitationId *string `type:"string"`

	// The tags assigned to the profile.
	Tags map[string]*string `min:"1" type:"map"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Profile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Profile) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Profile) SetCreatedAt(v time.Time) *Profile {
	s.CreatedAt = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *Profile) SetOwner(v string) *Profile {
	s.Owner = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *Profile) SetProfileArn(v string) *Profile {
	s.ProfileArn = &v
	return s
}

// SetProfileDescription sets the ProfileDescription field's value.
func (s *Profile) SetProfileDescription(v string) *Profile {
	s.ProfileDescription = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *Profile) SetProfileName(v string) *Profile {
	s.ProfileName = &v
	return s
}

// SetProfileQuestions sets the ProfileQuestions field's value.
func (s *Profile) SetProfileQuestions(v []*ProfileQuestion) *Profile {
	s.ProfileQuestions = v
	return s
}

// SetProfileVersion sets the ProfileVersion field's value.
func (s *Profile) SetProfileVersion(v string) *Profile {
	s.ProfileVersion = &v
	return s
}

// SetShareInvitationId sets the ShareInvitationId field's value.
func (s *Profile) SetShareInvitationId(v string) *Profile {
	s.ShareInvitationId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Profile) SetTags(v map[string]*string) *Profile {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Profile) SetUpdatedAt(v time.Time) *Profile {
	s.UpdatedAt = &v
	return s
}

// The profile choice.
type ProfileChoice struct {
	_ struct{} `type:"structure"`

	// The description of a choice.
	ChoiceDescription *string `min:"1" type:"string"`

	// The ID of a choice.
	ChoiceId *string `min:"1" type:"string"`

	// The title of a choice.
	ChoiceTitle *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileChoice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileChoice) GoString() string {
	return s.String()
}

// SetChoiceDescription sets the ChoiceDescription field's value.
func (s *ProfileChoice) SetChoiceDescription(v string) *ProfileChoice {
	s.ChoiceDescription = &v
	return s
}

// SetChoiceId sets the ChoiceId field's value.
func (s *ProfileChoice) SetChoiceId(v string) *ProfileChoice {
	s.ChoiceId = &v
	return s
}

// SetChoiceTitle sets the ChoiceTitle field's value.
func (s *ProfileChoice) SetChoiceTitle(v string) *ProfileChoice {
	s.ChoiceTitle = &v
	return s
}

// The profile notification summary.
type ProfileNotificationSummary struct {
	_ struct{} `type:"structure"`

	// The current profile version.
	CurrentProfileVersion *string `min:"1" type:"string"`

	// The latest profile version.
	LatestProfileVersion *string `min:"1" type:"string"`

	// The profile ARN.
	ProfileArn *string `type:"string"`

	// The profile name.
	ProfileName *string `min:"3" type:"string"`

	// Type of notification.
	Type *string `type:"string" enum:"ProfileNotificationType"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`

	// The name of the workload.
	//
	// The name must be unique within an account within an Amazon Web Services Region.
	// Spaces and capitalization are ignored when checking for uniqueness.
	WorkloadName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileNotificationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileNotificationSummary) GoString() string {
	return s.String()
}

// SetCurrentProfileVersion sets the CurrentProfileVersion field's value.
func (s *ProfileNotificationSummary) SetCurrentProfileVersion(v string) *ProfileNotificationSummary {
	s.CurrentProfileVersion = &v
	return s
}

// SetLatestProfileVersion sets the LatestProfileVersion field's value.
func (s *ProfileNotificationSummary) SetLatestProfileVersion(v string) *ProfileNotificationSummary {
	s.LatestProfileVersion = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *ProfileNotificationSummary) SetProfileArn(v string) *ProfileNotificationSummary {
	s.ProfileArn = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *ProfileNotificationSummary) SetProfileName(v string) *ProfileNotificationSummary {
	s.ProfileName = &v
	return s
}

// SetType sets the Type field's value.
func (s *ProfileNotificationSummary) SetType(v string) *ProfileNotificationSummary {
	s.Type = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ProfileNotificationSummary) SetWorkloadId(v string) *ProfileNotificationSummary {
	s.WorkloadId = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *ProfileNotificationSummary) SetWorkloadName(v string) *ProfileNotificationSummary {
	s.WorkloadName = &v
	return s
}

// A profile question.
type ProfileQuestion struct {
	_ struct{} `type:"structure"`

	// The maximum number of selected choices.
	MaxSelectedChoices *int64 `type:"integer"`

	// The minimum number of selected choices.
	MinSelectedChoices *int64 `type:"integer"`

	// The question choices.
	QuestionChoices []*ProfileChoice `type:"list"`

	// The description of the question.
	QuestionDescription *string `min:"1" type:"string"`

	// The ID of the question.
	QuestionId *string `min:"1" type:"string"`

	// The title of the question.
	QuestionTitle *string `min:"1" type:"string"`

	// The selected choices.
	SelectedChoiceIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileQuestion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileQuestion) GoString() string {
	return s.String()
}

// SetMaxSelectedChoices sets the MaxSelectedChoices field's value.
func (s *ProfileQuestion) SetMaxSelectedChoices(v int64) *ProfileQuestion {
	s.MaxSelectedChoices = &v
	return s
}

// SetMinSelectedChoices sets the MinSelectedChoices field's value.
func (s *ProfileQuestion) SetMinSelectedChoices(v int64) *ProfileQuestion {
	s.MinSelectedChoices = &v
	return s
}

// SetQuestionChoices sets the QuestionChoices field's value.
func (s *ProfileQuestion) SetQuestionChoices(v []*ProfileChoice) *ProfileQuestion {
	s.QuestionChoices = v
	return s
}

// SetQuestionDescription sets the QuestionDescription field's value.
func (s *ProfileQuestion) SetQuestionDescription(v string) *ProfileQuestion {
	s.QuestionDescription = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *ProfileQuestion) SetQuestionId(v string) *ProfileQuestion {
	s.QuestionId = &v
	return s
}

// SetQuestionTitle sets the QuestionTitle field's value.
func (s *ProfileQuestion) SetQuestionTitle(v string) *ProfileQuestion {
	s.QuestionTitle = &v
	return s
}

// SetSelectedChoiceIds sets the SelectedChoiceIds field's value.
func (s *ProfileQuestion) SetSelectedChoiceIds(v []*string) *ProfileQuestion {
	s.SelectedChoiceIds = v
	return s
}

// An update to a profile question.
type ProfileQuestionUpdate struct {
	_ struct{} `type:"structure"`

	// The ID of the question.
	QuestionId *string `min:"1" type:"string"`

	// The selected choices.
	SelectedChoiceIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileQuestionUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileQuestionUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProfileQuestionUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProfileQuestionUpdate"}
	if s.QuestionId != nil && len(*s.QuestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuestionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQuestionId sets the QuestionId field's value.
func (s *ProfileQuestionUpdate) SetQuestionId(v string) *ProfileQuestionUpdate {
	s.QuestionId = &v
	return s
}

// SetSelectedChoiceIds sets the SelectedChoiceIds field's value.
func (s *ProfileQuestionUpdate) SetSelectedChoiceIds(v []*string) *ProfileQuestionUpdate {
	s.SelectedChoiceIds = v
	return s
}

// Summary of a profile share.
type ProfileShareSummary struct {
	_ struct{} `type:"structure"`

	// The ID associated with the share.
	ShareId *string `type:"string"`

	// The Amazon Web Services account ID, organization ID, or organizational unit
	// (OU) ID with which the workload, lens, profile, or review template is shared.
	SharedWith *string `min:"12" type:"string"`

	// The status of the share request.
	Status *string `type:"string" enum:"ShareStatus"`

	// Profile share invitation status message.
	StatusMessage *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileShareSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileShareSummary) GoString() string {
	return s.String()
}

// SetShareId sets the ShareId field's value.
func (s *ProfileShareSummary) SetShareId(v string) *ProfileShareSummary {
	s.ShareId = &v
	return s
}

// SetSharedWith sets the SharedWith field's value.
func (s *ProfileShareSummary) SetSharedWith(v string) *ProfileShareSummary {
	s.SharedWith = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProfileShareSummary) SetStatus(v string) *ProfileShareSummary {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ProfileShareSummary) SetStatusMessage(v string) *ProfileShareSummary {
	s.StatusMessage = &v
	return s
}

// Summary of a profile.
type ProfileSummary struct {
	_ struct{} `type:"structure"`

	// The date and time recorded.
	CreatedAt *time.Time `type:"timestamp"`

	// An Amazon Web Services account ID.
	Owner *string `min:"12" type:"string"`

	// The profile ARN.
	ProfileArn *string `type:"string"`

	// The profile description.
	ProfileDescription *string `min:"3" type:"string"`

	// The profile name.
	ProfileName *string `min:"3" type:"string"`

	// The profile version.
	ProfileVersion *string `min:"1" type:"string"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ProfileSummary) SetCreatedAt(v time.Time) *ProfileSummary {
	s.CreatedAt = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ProfileSummary) SetOwner(v string) *ProfileSummary {
	s.Owner = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *ProfileSummary) SetProfileArn(v string) *ProfileSummary {
	s.ProfileArn = &v
	return s
}

// SetProfileDescription sets the ProfileDescription field's value.
func (s *ProfileSummary) SetProfileDescription(v string) *ProfileSummary {
	s.ProfileDescription = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *ProfileSummary) SetProfileName(v string) *ProfileSummary {
	s.ProfileName = &v
	return s
}

// SetProfileVersion sets the ProfileVersion field's value.
func (s *ProfileSummary) SetProfileVersion(v string) *ProfileSummary {
	s.ProfileVersion = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ProfileSummary) SetUpdatedAt(v time.Time) *ProfileSummary {
	s.UpdatedAt = &v
	return s
}

// The profile template.
type ProfileTemplate struct {
	_ struct{} `type:"structure"`

	// The date and time recorded.
	CreatedAt *time.Time `type:"timestamp"`

	// The name of the profile template.
	TemplateName *string `min:"3" type:"string"`

	// Profile template questions.
	TemplateQuestions []*ProfileTemplateQuestion `type:"list"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileTemplate) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ProfileTemplate) SetCreatedAt(v time.Time) *ProfileTemplate {
	s.CreatedAt = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ProfileTemplate) SetTemplateName(v string) *ProfileTemplate {
	s.TemplateName = &v
	return s
}

// SetTemplateQuestions sets the TemplateQuestions field's value.
func (s *ProfileTemplate) SetTemplateQuestions(v []*ProfileTemplateQuestion) *ProfileTemplate {
	s.TemplateQuestions = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ProfileTemplate) SetUpdatedAt(v time.Time) *ProfileTemplate {
	s.UpdatedAt = &v
	return s
}

// A profile template choice.
type ProfileTemplateChoice struct {
	_ struct{} `type:"structure"`

	// The description of a choice.
	ChoiceDescription *string `min:"1" type:"string"`

	// The ID of a choice.
	ChoiceId *string `min:"1" type:"string"`

	// The title of a choice.
	ChoiceTitle *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileTemplateChoice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileTemplateChoice) GoString() string {
	return s.String()
}

// SetChoiceDescription sets the ChoiceDescription field's value.
func (s *ProfileTemplateChoice) SetChoiceDescription(v string) *ProfileTemplateChoice {
	s.ChoiceDescription = &v
	return s
}

// SetChoiceId sets the ChoiceId field's value.
func (s *ProfileTemplateChoice) SetChoiceId(v string) *ProfileTemplateChoice {
	s.ChoiceId = &v
	return s
}

// SetChoiceTitle sets the ChoiceTitle field's value.
func (s *ProfileTemplateChoice) SetChoiceTitle(v string) *ProfileTemplateChoice {
	s.ChoiceTitle = &v
	return s
}

// A profile template question.
type ProfileTemplateQuestion struct {
	_ struct{} `type:"structure"`

	// The maximum number of choices selected.
	MaxSelectedChoices *int64 `type:"integer"`

	// The minimum number of choices selected.
	MinSelectedChoices *int64 `type:"integer"`

	// The question choices.
	QuestionChoices []*ProfileTemplateChoice `type:"list"`

	// The description of the question.
	QuestionDescription *string `min:"1" type:"string"`

	// The ID of the question.
	QuestionId *string `min:"1" type:"string"`

	// The title of the question.
	QuestionTitle *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileTemplateQuestion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileTemplateQuestion) GoString() string {
	return s.String()
}

// SetMaxSelectedChoices sets the MaxSelectedChoices field's value.
func (s *ProfileTemplateQuestion) SetMaxSelectedChoices(v int64) *ProfileTemplateQuestion {
	s.MaxSelectedChoices = &v
	return s
}

// SetMinSelectedChoices sets the MinSelectedChoices field's value.
func (s *ProfileTemplateQuestion) SetMinSelectedChoices(v int64) *ProfileTemplateQuestion {
	s.MinSelectedChoices = &v
	return s
}

// SetQuestionChoices sets the QuestionChoices field's value.
func (s *ProfileTemplateQuestion) SetQuestionChoices(v []*ProfileTemplateChoice) *ProfileTemplateQuestion {
	s.QuestionChoices = v
	return s
}

// SetQuestionDescription sets the QuestionDescription field's value.
func (s *ProfileTemplateQuestion) SetQuestionDescription(v string) *ProfileTemplateQuestion {
	s.QuestionDescription = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *ProfileTemplateQuestion) SetQuestionId(v string) *ProfileTemplateQuestion {
	s.QuestionId = &v
	return s
}

// SetQuestionTitle sets the QuestionTitle field's value.
func (s *ProfileTemplateQuestion) SetQuestionTitle(v string) *ProfileTemplateQuestion {
	s.QuestionTitle = &v
	return s
}

// A question difference return object.
type QuestionDifference struct {
	_ struct{} `type:"structure"`

	// Indicates the type of change to the question.
	DifferenceStatus *string `type:"string" enum:"DifferenceStatus"`

	// The ID of the question.
	QuestionId *string `min:"1" type:"string"`

	// The title of the question.
	QuestionTitle *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QuestionDifference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QuestionDifference) GoString() string {
	return s.String()
}

// SetDifferenceStatus sets the DifferenceStatus field's value.
func (s *QuestionDifference) SetDifferenceStatus(v string) *QuestionDifference {
	s.DifferenceStatus = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *QuestionDifference) SetQuestionId(v string) *QuestionDifference {
	s.QuestionId = &v
	return s
}

// SetQuestionTitle sets the QuestionTitle field's value.
func (s *QuestionDifference) SetQuestionTitle(v string) *QuestionDifference {
	s.QuestionTitle = &v
	return s
}

// A metric for a particular question in the pillar.
type QuestionMetric struct {
	_ struct{} `type:"structure"`

	// The best practices, or choices, that have been identified as contributing
	// to risk in a question.
	BestPractices []*BestPractice `type:"list"`

	// The ID of the question.
	QuestionId *string `min:"1" type:"string"`

	// The risk for a given workload, lens review, pillar, or question.
	Risk *string `type:"string" enum:"Risk"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QuestionMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QuestionMetric) GoString() string {
	return s.String()
}

// SetBestPractices sets the BestPractices field's value.
func (s *QuestionMetric) SetBestPractices(v []*BestPractice) *QuestionMetric {
	s.BestPractices = v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *QuestionMetric) SetQuestionId(v string) *QuestionMetric {
	s.QuestionId = &v
	return s
}

// SetRisk sets the Risk field's value.
func (s *QuestionMetric) SetRisk(v string) *QuestionMetric {
	s.Risk = &v
	return s
}

// The requested resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"Message" type:"string"`

	// Identifier of the resource affected.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Type of the resource affected.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A review template.
type ReviewTemplate struct {
	_ struct{} `type:"structure"`

	// The review template description.
	Description *string `min:"3" type:"string"`

	// The lenses applied to the review template.
	Lenses []*string `type:"list"`

	// The notes associated with the workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	Notes *string `type:"string"`

	// An Amazon Web Services account ID.
	Owner *string `min:"12" type:"string"`

	// A count of how many total questions are answered and unanswered in the review
	// template.
	QuestionCounts map[string]*int64 `type:"map"`

	// The ID assigned to the template share invitation.
	ShareInvitationId *string `type:"string"`

	// The tags assigned to the review template.
	Tags map[string]*string `min:"1" type:"map"`

	// The review template ARN.
	TemplateArn *string `min:"50" type:"string"`

	// The name of the review template.
	TemplateName *string `min:"3" type:"string"`

	// The latest status of a review template.
	UpdateStatus *string `type:"string" enum:"ReviewTemplateUpdateStatus"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReviewTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReviewTemplate) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ReviewTemplate) SetDescription(v string) *ReviewTemplate {
	s.Description = &v
	return s
}

// SetLenses sets the Lenses field's value.
func (s *ReviewTemplate) SetLenses(v []*string) *ReviewTemplate {
	s.Lenses = v
	return s
}

// SetNotes sets the Notes field's value.
func (s *ReviewTemplate) SetNotes(v string) *ReviewTemplate {
	s.Notes = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ReviewTemplate) SetOwner(v string) *ReviewTemplate {
	s.Owner = &v
	return s
}

// SetQuestionCounts sets the QuestionCounts field's value.
func (s *ReviewTemplate) SetQuestionCounts(v map[string]*int64) *ReviewTemplate {
	s.QuestionCounts = v
	return s
}

// SetShareInvitationId sets the ShareInvitationId field's value.
func (s *ReviewTemplate) SetShareInvitationId(v string) *ReviewTemplate {
	s.ShareInvitationId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ReviewTemplate) SetTags(v map[string]*string) *ReviewTemplate {
	s.Tags = v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *ReviewTemplate) SetTemplateArn(v string) *ReviewTemplate {
	s.TemplateArn = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ReviewTemplate) SetTemplateName(v string) *ReviewTemplate {
	s.TemplateName = &v
	return s
}

// SetUpdateStatus sets the UpdateStatus field's value.
func (s *ReviewTemplate) SetUpdateStatus(v string) *ReviewTemplate {
	s.UpdateStatus = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ReviewTemplate) SetUpdatedAt(v time.Time) *ReviewTemplate {
	s.UpdatedAt = &v
	return s
}

// An answer of the question.
type ReviewTemplateAnswer struct {
	_ struct{} `type:"structure"`

	// The status of whether or not this question has been answered.
	AnswerStatus *string `type:"string" enum:"ReviewTemplateAnswerStatus"`

	// A list of selected choices to a question in your review template.
	ChoiceAnswers []*ChoiceAnswer `type:"list"`

	// List of choices available for a question.
	Choices []*Choice `type:"list"`

	// The helpful resource text to be displayed for a custom lens.
	//
	// This field does not apply to Amazon Web Services official lenses.
	HelpfulResourceDisplayText *string `min:"1" type:"string"`

	// The helpful resource URL.
	//
	// For Amazon Web Services official lenses, this is the helpful resource URL
	// for a question or choice.
	//
	// For custom lenses, this is the helpful resource URL for a question and is
	// only provided if HelpfulResourceDisplayText was specified for the question.
	HelpfulResourceUrl *string `min:"1" type:"string"`

	// The improvement plan URL for a question in an Amazon Web Services official
	// lenses.
	//
	// This value is only available if the question has been answered.
	//
	// This value does not apply to custom lenses.
	ImprovementPlanUrl *string `min:"1" type:"string"`

	// Defines whether this question is applicable to a lens review.
	IsApplicable *bool `type:"boolean"`

	// The notes associated with the workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	Notes *string `type:"string"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// The description of the question.
	QuestionDescription *string `min:"1" type:"string"`

	// The ID of the question.
	QuestionId *string `min:"1" type:"string"`

	// The title of the question.
	QuestionTitle *string `min:"1" type:"string"`

	// The reason why the question is not applicable to your review template.
	Reason *string `type:"string" enum:"AnswerReason"`

	// List of selected choice IDs in a question answer.
	//
	// The values entered replace the previously selected choices.
	SelectedChoices []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReviewTemplateAnswer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReviewTemplateAnswer) GoString() string {
	return s.String()
}

// SetAnswerStatus sets the AnswerStatus field's value.
func (s *ReviewTemplateAnswer) SetAnswerStatus(v string) *ReviewTemplateAnswer {
	s.AnswerStatus = &v
	return s
}

// SetChoiceAnswers sets the ChoiceAnswers field's value.
func (s *ReviewTemplateAnswer) SetChoiceAnswers(v []*ChoiceAnswer) *ReviewTemplateAnswer {
	s.ChoiceAnswers = v
	return s
}

// SetChoices sets the Choices field's value.
func (s *ReviewTemplateAnswer) SetChoices(v []*Choice) *ReviewTemplateAnswer {
	s.Choices = v
	return s
}

// SetHelpfulResourceDisplayText sets the HelpfulResourceDisplayText field's value.
func (s *ReviewTemplateAnswer) SetHelpfulResourceDisplayText(v string) *ReviewTemplateAnswer {
	s.HelpfulResourceDisplayText = &v
	return s
}

// SetHelpfulResourceUrl sets the HelpfulResourceUrl field's value.
func (s *ReviewTemplateAnswer) SetHelpfulResourceUrl(v string) *ReviewTemplateAnswer {
	s.HelpfulResourceUrl = &v
	return s
}

// SetImprovementPlanUrl sets the ImprovementPlanUrl field's value.
func (s *ReviewTemplateAnswer) SetImprovementPlanUrl(v string) *ReviewTemplateAnswer {
	s.ImprovementPlanUrl = &v
	return s
}

// SetIsApplicable sets the IsApplicable field's value.
func (s *ReviewTemplateAnswer) SetIsApplicable(v bool) *ReviewTemplateAnswer {
	s.IsApplicable = &v
	return s
}

// SetNotes sets the Notes field's value.
func (s *ReviewTemplateAnswer) SetNotes(v string) *ReviewTemplateAnswer {
	s.Notes = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *ReviewTemplateAnswer) SetPillarId(v string) *ReviewTemplateAnswer {
	s.PillarId = &v
	return s
}

// SetQuestionDescription sets the QuestionDescription field's value.
func (s *ReviewTemplateAnswer) SetQuestionDescription(v string) *ReviewTemplateAnswer {
	s.QuestionDescription = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *ReviewTemplateAnswer) SetQuestionId(v string) *ReviewTemplateAnswer {
	s.QuestionId = &v
	return s
}

// SetQuestionTitle sets the QuestionTitle field's value.
func (s *ReviewTemplateAnswer) SetQuestionTitle(v string) *ReviewTemplateAnswer {
	s.QuestionTitle = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ReviewTemplateAnswer) SetReason(v string) *ReviewTemplateAnswer {
	s.Reason = &v
	return s
}

// SetSelectedChoices sets the SelectedChoices field's value.
func (s *ReviewTemplateAnswer) SetSelectedChoices(v []*string) *ReviewTemplateAnswer {
	s.SelectedChoices = v
	return s
}

// The summary of review template answers.
type ReviewTemplateAnswerSummary struct {
	_ struct{} `type:"structure"`

	// The status of whether or not this question has been answered.
	AnswerStatus *string `type:"string" enum:"ReviewTemplateAnswerStatus"`

	// A list of selected choices to a question in the review template.
	ChoiceAnswerSummaries []*ChoiceAnswerSummary `type:"list"`

	// List of choices available for a question.
	Choices []*Choice `type:"list"`

	// Defines whether this question is applicable to a lens review.
	IsApplicable *bool `type:"boolean"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// The ID of the question.
	QuestionId *string `min:"1" type:"string"`

	// The title of the question.
	QuestionTitle *string `min:"1" type:"string"`

	// The type of question.
	QuestionType *string `type:"string" enum:"QuestionType"`

	// The reason why a choice is not-applicable to a question in the review template.
	Reason *string `type:"string" enum:"AnswerReason"`

	// List of selected choice IDs in a question answer.
	//
	// The values entered replace the previously selected choices.
	SelectedChoices []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReviewTemplateAnswerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReviewTemplateAnswerSummary) GoString() string {
	return s.String()
}

// SetAnswerStatus sets the AnswerStatus field's value.
func (s *ReviewTemplateAnswerSummary) SetAnswerStatus(v string) *ReviewTemplateAnswerSummary {
	s.AnswerStatus = &v
	return s
}

// SetChoiceAnswerSummaries sets the ChoiceAnswerSummaries field's value.
func (s *ReviewTemplateAnswerSummary) SetChoiceAnswerSummaries(v []*ChoiceAnswerSummary) *ReviewTemplateAnswerSummary {
	s.ChoiceAnswerSummaries = v
	return s
}

// SetChoices sets the Choices field's value.
func (s *ReviewTemplateAnswerSummary) SetChoices(v []*Choice) *ReviewTemplateAnswerSummary {
	s.Choices = v
	return s
}

// SetIsApplicable sets the IsApplicable field's value.
func (s *ReviewTemplateAnswerSummary) SetIsApplicable(v bool) *ReviewTemplateAnswerSummary {
	s.IsApplicable = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *ReviewTemplateAnswerSummary) SetPillarId(v string) *ReviewTemplateAnswerSummary {
	s.PillarId = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *ReviewTemplateAnswerSummary) SetQuestionId(v string) *ReviewTemplateAnswerSummary {
	s.QuestionId = &v
	return s
}

// SetQuestionTitle sets the QuestionTitle field's value.
func (s *ReviewTemplateAnswerSummary) SetQuestionTitle(v string) *ReviewTemplateAnswerSummary {
	s.QuestionTitle = &v
	return s
}

// SetQuestionType sets the QuestionType field's value.
func (s *ReviewTemplateAnswerSummary) SetQuestionType(v string) *ReviewTemplateAnswerSummary {
	s.QuestionType = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ReviewTemplateAnswerSummary) SetReason(v string) *ReviewTemplateAnswerSummary {
	s.Reason = &v
	return s
}

// SetSelectedChoices sets the SelectedChoices field's value.
func (s *ReviewTemplateAnswerSummary) SetSelectedChoices(v []*string) *ReviewTemplateAnswerSummary {
	s.SelectedChoices = v
	return s
}

// The lens review of a review template.
type ReviewTemplateLensReview struct {
	_ struct{} `type:"structure"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The lens ARN.
	LensArn *string `type:"string"`

	// The full name of the lens.
	LensName *string `min:"1" type:"string"`

	// The status of the lens.
	LensStatus *string `type:"string" enum:"LensStatus"`

	// The version of the lens.
	LensVersion *string `min:"1" type:"string"`

	// The token to use to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The notes associated with the workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	Notes *string `type:"string"`

	// Pillar review summaries of a lens review.
	PillarReviewSummaries []*ReviewTemplatePillarReviewSummary `type:"list"`

	// A count of how many questions are answered and unanswered in the lens review.
	QuestionCounts map[string]*int64 `type:"map"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReviewTemplateLensReview) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReviewTemplateLensReview) GoString() string {
	return s.String()
}

// SetLensAlias sets the LensAlias field's value.
func (s *ReviewTemplateLensReview) SetLensAlias(v string) *ReviewTemplateLensReview {
	s.LensAlias = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *ReviewTemplateLensReview) SetLensArn(v string) *ReviewTemplateLensReview {
	s.LensArn = &v
	return s
}

// SetLensName sets the LensName field's value.
func (s *ReviewTemplateLensReview) SetLensName(v string) *ReviewTemplateLensReview {
	s.LensName = &v
	return s
}

// SetLensStatus sets the LensStatus field's value.
func (s *ReviewTemplateLensReview) SetLensStatus(v string) *ReviewTemplateLensReview {
	s.LensStatus = &v
	return s
}

// SetLensVersion sets the LensVersion field's value.
func (s *ReviewTemplateLensReview) SetLensVersion(v string) *ReviewTemplateLensReview {
	s.LensVersion = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ReviewTemplateLensReview) SetNextToken(v string) *ReviewTemplateLensReview {
	s.NextToken = &v
	return s
}

// SetNotes sets the Notes field's value.
func (s *ReviewTemplateLensReview) SetNotes(v string) *ReviewTemplateLensReview {
	s.Notes = &v
	return s
}

// SetPillarReviewSummaries sets the PillarReviewSummaries field's value.
func (s *ReviewTemplateLensReview) SetPillarReviewSummaries(v []*ReviewTemplatePillarReviewSummary) *ReviewTemplateLensReview {
	s.PillarReviewSummaries = v
	return s
}

// SetQuestionCounts sets the QuestionCounts field's value.
func (s *ReviewTemplateLensReview) SetQuestionCounts(v map[string]*int64) *ReviewTemplateLensReview {
	s.QuestionCounts = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ReviewTemplateLensReview) SetUpdatedAt(v time.Time) *ReviewTemplateLensReview {
	s.UpdatedAt = &v
	return s
}

// Summary of a review template.
type ReviewTemplatePillarReviewSummary struct {
	_ struct{} `type:"structure"`

	// The notes associated with the workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	Notes *string `type:"string"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// The name of the pillar.
	PillarName *string `min:"1" type:"string"`

	// A count of how many questions are answered and unanswered in the requested
	// pillar of the lens review.
	QuestionCounts map[string]*int64 `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReviewTemplatePillarReviewSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReviewTemplatePillarReviewSummary) GoString() string {
	return s.String()
}

// SetNotes sets the Notes field's value.
func (s *ReviewTemplatePillarReviewSummary) SetNotes(v string) *ReviewTemplatePillarReviewSummary {
	s.Notes = &v
	return s
}

// SetPillarId sets the PillarId field's value.
func (s *ReviewTemplatePillarReviewSummary) SetPillarId(v string) *ReviewTemplatePillarReviewSummary {
	s.PillarId = &v
	return s
}

// SetPillarName sets the PillarName field's value.
func (s *ReviewTemplatePillarReviewSummary) SetPillarName(v string) *ReviewTemplatePillarReviewSummary {
	s.PillarName = &v
	return s
}

// SetQuestionCounts sets the QuestionCounts field's value.
func (s *ReviewTemplatePillarReviewSummary) SetQuestionCounts(v map[string]*int64) *ReviewTemplatePillarReviewSummary {
	s.QuestionCounts = v
	return s
}

// Summary of a review template.
type ReviewTemplateSummary struct {
	_ struct{} `type:"structure"`

	// Description of the review template.
	Description *string `min:"3" type:"string"`

	// Lenses associated with the review template.
	Lenses []*string `type:"list"`

	// An Amazon Web Services account ID.
	Owner *string `min:"12" type:"string"`

	// The review template ARN.
	TemplateArn *string `min:"50" type:"string"`

	// The name of the review template.
	TemplateName *string `min:"3" type:"string"`

	// The latest status of a review template.
	UpdateStatus *string `type:"string" enum:"ReviewTemplateUpdateStatus"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReviewTemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReviewTemplateSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ReviewTemplateSummary) SetDescription(v string) *ReviewTemplateSummary {
	s.Description = &v
	return s
}

// SetLenses sets the Lenses field's value.
func (s *ReviewTemplateSummary) SetLenses(v []*string) *ReviewTemplateSummary {
	s.Lenses = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ReviewTemplateSummary) SetOwner(v string) *ReviewTemplateSummary {
	s.Owner = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *ReviewTemplateSummary) SetTemplateArn(v string) *ReviewTemplateSummary {
	s.TemplateArn = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ReviewTemplateSummary) SetTemplateName(v string) *ReviewTemplateSummary {
	s.TemplateName = &v
	return s
}

// SetUpdateStatus sets the UpdateStatus field's value.
func (s *ReviewTemplateSummary) SetUpdateStatus(v string) *ReviewTemplateSummary {
	s.UpdateStatus = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ReviewTemplateSummary) SetUpdatedAt(v time.Time) *ReviewTemplateSummary {
	s.UpdatedAt = &v
	return s
}

// The selected pillar.
type SelectedPillar struct {
	_ struct{} `type:"structure"`

	// The ID used to identify a pillar, for example, security.
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string `min:"1" type:"string"`

	// Selected question IDs in the selected pillar.
	SelectedQuestionIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelectedPillar) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelectedPillar) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelectedPillar) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SelectedPillar"}
	if s.PillarId != nil && len(*s.PillarId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PillarId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPillarId sets the PillarId field's value.
func (s *SelectedPillar) SetPillarId(v string) *SelectedPillar {
	s.PillarId = &v
	return s
}

// SetSelectedQuestionIds sets the SelectedQuestionIds field's value.
func (s *SelectedPillar) SetSelectedQuestionIds(v []*string) *SelectedPillar {
	s.SelectedQuestionIds = v
	return s
}

// The user has reached their resource quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"Message" type:"string"`

	// Service Quotas requirement to identify originating quota.
	//
	// QuotaCode is a required field
	QuotaCode *string `type:"string" required:"true"`

	// Identifier of the resource affected.
	ResourceId *string `type:"string"`

	// Type of the resource affected.
	ResourceType *string `type:"string"`

	// Service Quotas requirement to identify originating service.
	//
	// ServiceCode is a required field
	ServiceCode *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The share invitation.
type ShareInvitation struct {
	_ struct{} `type:"structure"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The ARN for the lens.
	LensArn *string `type:"string"`

	// The profile ARN.
	ProfileArn *string `type:"string"`

	// The ID assigned to the share invitation.
	ShareInvitationId *string `type:"string"`

	// The resource type of the share invitation.
	ShareResourceType *string `type:"string" enum:"ShareResourceType"`

	// The review template ARN.
	TemplateArn *string `min:"50" type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShareInvitation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShareInvitation) GoString() string {
	return s.String()
}

// SetLensAlias sets the LensAlias field's value.
func (s *ShareInvitation) SetLensAlias(v string) *ShareInvitation {
	s.LensAlias = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *ShareInvitation) SetLensArn(v string) *ShareInvitation {
	s.LensArn = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *ShareInvitation) SetProfileArn(v string) *ShareInvitation {
	s.ProfileArn = &v
	return s
}

// SetShareInvitationId sets the ShareInvitationId field's value.
func (s *ShareInvitation) SetShareInvitationId(v string) *ShareInvitation {
	s.ShareInvitationId = &v
	return s
}

// SetShareResourceType sets the ShareResourceType field's value.
func (s *ShareInvitation) SetShareResourceType(v string) *ShareInvitation {
	s.ShareResourceType = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *ShareInvitation) SetTemplateArn(v string) *ShareInvitation {
	s.TemplateArn = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ShareInvitation) SetWorkloadId(v string) *ShareInvitation {
	s.WorkloadId = &v
	return s
}

// A share invitation summary return object.
type ShareInvitationSummary struct {
	_ struct{} `type:"structure"`

	// The ARN for the lens.
	LensArn *string `type:"string"`

	// The full name of the lens.
	LensName *string `min:"1" type:"string"`

	// Permission granted on a share request.
	PermissionType *string `type:"string" enum:"PermissionType"`

	// The profile ARN.
	ProfileArn *string `type:"string"`

	// The profile name.
	ProfileName *string `min:"3" type:"string"`

	// The ID assigned to the share invitation.
	ShareInvitationId *string `type:"string"`

	// The resource type of the share invitation.
	ShareResourceType *string `type:"string" enum:"ShareResourceType"`

	// An Amazon Web Services account ID.
	SharedBy *string `min:"12" type:"string"`

	// The Amazon Web Services account ID, organization ID, or organizational unit
	// (OU) ID with which the workload, lens, profile, or review template is shared.
	SharedWith *string `min:"12" type:"string"`

	// The review template ARN.
	TemplateArn *string `min:"50" type:"string"`

	// The name of the review template.
	TemplateName *string `min:"3" type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`

	// The name of the workload.
	//
	// The name must be unique within an account within an Amazon Web Services Region.
	// Spaces and capitalization are ignored when checking for uniqueness.
	WorkloadName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShareInvitationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShareInvitationSummary) GoString() string {
	return s.String()
}

// SetLensArn sets the LensArn field's value.
func (s *ShareInvitationSummary) SetLensArn(v string) *ShareInvitationSummary {
	s.LensArn = &v
	return s
}

// SetLensName sets the LensName field's value.
func (s *ShareInvitationSummary) SetLensName(v string) *ShareInvitationSummary {
	s.LensName = &v
	return s
}

// SetPermissionType sets the PermissionType field's value.
func (s *ShareInvitationSummary) SetPermissionType(v string) *ShareInvitationSummary {
	s.PermissionType = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *ShareInvitationSummary) SetProfileArn(v string) *ShareInvitationSummary {
	s.ProfileArn = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *ShareInvitationSummary) SetProfileName(v string) *ShareInvitationSummary {
	s.ProfileName = &v
	return s
}

// SetShareInvitationId sets the ShareInvitationId field's value.
func (s *ShareInvitationSummary) SetShareInvitationId(v string) *ShareInvitationSummary {
	s.ShareInvitationId = &v
	return s
}

// SetShareResourceType sets the ShareResourceType field's value.
func (s *ShareInvitationSummary) SetShareResourceType(v string) *ShareInvitationSummary {
	s.ShareResourceType = &v
	return s
}

// SetSharedBy sets the SharedBy field's value.
func (s *ShareInvitationSummary) SetSharedBy(v string) *ShareInvitationSummary {
	s.SharedBy = &v
	return s
}

// SetSharedWith sets the SharedWith field's value.
func (s *ShareInvitationSummary) SetSharedWith(v string) *ShareInvitationSummary {
	s.SharedWith = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *ShareInvitationSummary) SetTemplateArn(v string) *ShareInvitationSummary {
	s.TemplateArn = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ShareInvitationSummary) SetTemplateName(v string) *ShareInvitationSummary {
	s.TemplateName = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *ShareInvitationSummary) SetWorkloadId(v string) *ShareInvitationSummary {
	s.WorkloadId = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *ShareInvitationSummary) SetWorkloadName(v string) *ShareInvitationSummary {
	s.WorkloadName = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`

	// The ARN for the workload.
	//
	// WorkloadArn is a required field
	WorkloadArn *string `location:"uri" locationName:"WorkloadArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.WorkloadArn == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadArn"))
	}
	if s.WorkloadArn != nil && len(*s.WorkloadArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

// SetWorkloadArn sets the WorkloadArn field's value.
func (s *TagResourceInput) SetWorkloadArn(v string) *TagResourceInput {
	s.WorkloadArn = &v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Summary of a review template share.
type TemplateShareSummary struct {
	_ struct{} `type:"structure"`

	// The ID associated with the share.
	ShareId *string `type:"string"`

	// The Amazon Web Services account ID, organization ID, or organizational unit
	// (OU) ID with which the workload, lens, profile, or review template is shared.
	SharedWith *string `min:"12" type:"string"`

	// The status of the share request.
	Status *string `type:"string" enum:"ShareStatus"`

	// Review template share invitation status message.
	StatusMessage *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateShareSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateShareSummary) GoString() string {
	return s.String()
}

// SetShareId sets the ShareId field's value.
func (s *TemplateShareSummary) SetShareId(v string) *TemplateShareSummary {
	s.ShareId = &v
	return s
}

// SetSharedWith sets the SharedWith field's value.
func (s *TemplateShareSummary) SetSharedWith(v string) *TemplateShareSummary {
	s.SharedWith = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TemplateShareSummary) SetStatus(v string) *TemplateShareSummary {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *TemplateShareSummary) SetStatusMessage(v string) *TemplateShareSummary {
	s.StatusMessage = &v
	return s
}

// Request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"Message" type:"string"`

	// Service Quotas requirement to identify originating quota.
	QuotaCode *string `type:"string"`

	// Service Quotas requirement to identify originating service.
	ServiceCode *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A list of tag keys. Existing tags of the resource whose keys are members
	// of this list are removed from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`

	// The ARN for the workload.
	//
	// WorkloadArn is a required field
	WorkloadArn *string `location:"uri" locationName:"WorkloadArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}
	if s.WorkloadArn == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadArn"))
	}
	if s.WorkloadArn != nil && len(*s.WorkloadArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

// SetWorkloadArn sets the WorkloadArn field's value.
func (s *UntagResourceInput) SetWorkloadArn(v string) *UntagResourceInput {
	s.WorkloadArn = &v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Input to update answer.
type UpdateAnswerInput struct {
	_ struct{} `type:"structure"`

	// A list of choices to update on a question in your workload. The String key
	// corresponds to the choice ID to be updated.
	ChoiceUpdates map[string]*ChoiceUpdate `type:"map"`

	// Defines whether this question is applicable to a lens review.
	IsApplicable *bool `type:"boolean"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The notes associated with the workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	Notes *string `type:"string"`

	// The ID of the question.
	//
	// QuestionId is a required field
	QuestionId *string `location:"uri" locationName:"QuestionId" min:"1" type:"string" required:"true"`

	// The reason why a question is not applicable to your workload.
	Reason *string `type:"string" enum:"AnswerReason"`

	// List of selected choice IDs in a question answer.
	//
	// The values entered replace the previously selected choices.
	SelectedChoices []*string `type:"list"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnswerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnswerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAnswerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAnswerInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.QuestionId == nil {
		invalidParams.Add(request.NewErrParamRequired("QuestionId"))
	}
	if s.QuestionId != nil && len(*s.QuestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuestionId", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}
	if s.ChoiceUpdates != nil {
		for i, v := range s.ChoiceUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ChoiceUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChoiceUpdates sets the ChoiceUpdates field's value.
func (s *UpdateAnswerInput) SetChoiceUpdates(v map[string]*ChoiceUpdate) *UpdateAnswerInput {
	s.ChoiceUpdates = v
	return s
}

// SetIsApplicable sets the IsApplicable field's value.
func (s *UpdateAnswerInput) SetIsApplicable(v bool) *UpdateAnswerInput {
	s.IsApplicable = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *UpdateAnswerInput) SetLensAlias(v string) *UpdateAnswerInput {
	s.LensAlias = &v
	return s
}

// SetNotes sets the Notes field's value.
func (s *UpdateAnswerInput) SetNotes(v string) *UpdateAnswerInput {
	s.Notes = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *UpdateAnswerInput) SetQuestionId(v string) *UpdateAnswerInput {
	s.QuestionId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *UpdateAnswerInput) SetReason(v string) *UpdateAnswerInput {
	s.Reason = &v
	return s
}

// SetSelectedChoices sets the SelectedChoices field's value.
func (s *UpdateAnswerInput) SetSelectedChoices(v []*string) *UpdateAnswerInput {
	s.SelectedChoices = v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpdateAnswerInput) SetWorkloadId(v string) *UpdateAnswerInput {
	s.WorkloadId = &v
	return s
}

// Output of a update answer call.
type UpdateAnswerOutput struct {
	_ struct{} `type:"structure"`

	// An answer of the question.
	Answer *Answer `type:"structure"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The ARN for the lens.
	LensArn *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnswerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAnswerOutput) GoString() string {
	return s.String()
}

// SetAnswer sets the Answer field's value.
func (s *UpdateAnswerOutput) SetAnswer(v *Answer) *UpdateAnswerOutput {
	s.Answer = v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *UpdateAnswerOutput) SetLensAlias(v string) *UpdateAnswerOutput {
	s.LensAlias = &v
	return s
}

// SetLensArn sets the LensArn field's value.
func (s *UpdateAnswerOutput) SetLensArn(v string) *UpdateAnswerOutput {
	s.LensArn = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpdateAnswerOutput) SetWorkloadId(v string) *UpdateAnswerOutput {
	s.WorkloadId = &v
	return s
}

type UpdateGlobalSettingsInput struct {
	_ struct{} `type:"structure"`

	// The status of discovery support settings.
	DiscoveryIntegrationStatus *string `type:"string" enum:"DiscoveryIntegrationStatus"`

	// The status of Jira integration settings.
	JiraConfiguration *AccountJiraConfigurationInput_ `type:"structure"`

	// The status of organization sharing settings.
	OrganizationSharingStatus *string `type:"string" enum:"OrganizationSharingStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGlobalSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGlobalSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGlobalSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGlobalSettingsInput"}
	if s.JiraConfiguration != nil {
		if err := s.JiraConfiguration.Validate(); err != nil {
			invalidParams.AddNested("JiraConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiscoveryIntegrationStatus sets the DiscoveryIntegrationStatus field's value.
func (s *UpdateGlobalSettingsInput) SetDiscoveryIntegrationStatus(v string) *UpdateGlobalSettingsInput {
	s.DiscoveryIntegrationStatus = &v
	return s
}

// SetJiraConfiguration sets the JiraConfiguration field's value.
func (s *UpdateGlobalSettingsInput) SetJiraConfiguration(v *AccountJiraConfigurationInput_) *UpdateGlobalSettingsInput {
	s.JiraConfiguration = v
	return s
}

// SetOrganizationSharingStatus sets the OrganizationSharingStatus field's value.
func (s *UpdateGlobalSettingsInput) SetOrganizationSharingStatus(v string) *UpdateGlobalSettingsInput {
	s.OrganizationSharingStatus = &v
	return s
}

type UpdateGlobalSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGlobalSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGlobalSettingsOutput) GoString() string {
	return s.String()
}

type UpdateIntegrationInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// Which integrated service to update.
	//
	// IntegratingService is a required field
	IntegratingService *string `type:"string" required:"true" enum:"IntegratingService"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIntegrationInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.IntegratingService == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegratingService"))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateIntegrationInput) SetClientRequestToken(v string) *UpdateIntegrationInput {
	s.ClientRequestToken = &v
	return s
}

// SetIntegratingService sets the IntegratingService field's value.
func (s *UpdateIntegrationInput) SetIntegratingService(v string) *UpdateIntegrationInput {
	s.IntegratingService = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpdateIntegrationInput) SetWorkloadId(v string) *UpdateIntegrationInput {
	s.WorkloadId = &v
	return s
}

type UpdateIntegrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIntegrationOutput) GoString() string {
	return s.String()
}

// Input for update lens review.
type UpdateLensReviewInput struct {
	_ struct{} `type:"structure"`

	// Configuration of the Jira integration.
	JiraConfiguration *JiraSelectedQuestionConfiguration `type:"structure"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The notes associated with the workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	LensNotes *string `type:"string"`

	// List of pillar notes of a lens review in a workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	PillarNotes map[string]*string `type:"map"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLensReviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLensReviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLensReviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLensReviewInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}
	if s.JiraConfiguration != nil {
		if err := s.JiraConfiguration.Validate(); err != nil {
			invalidParams.AddNested("JiraConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJiraConfiguration sets the JiraConfiguration field's value.
func (s *UpdateLensReviewInput) SetJiraConfiguration(v *JiraSelectedQuestionConfiguration) *UpdateLensReviewInput {
	s.JiraConfiguration = v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *UpdateLensReviewInput) SetLensAlias(v string) *UpdateLensReviewInput {
	s.LensAlias = &v
	return s
}

// SetLensNotes sets the LensNotes field's value.
func (s *UpdateLensReviewInput) SetLensNotes(v string) *UpdateLensReviewInput {
	s.LensNotes = &v
	return s
}

// SetPillarNotes sets the PillarNotes field's value.
func (s *UpdateLensReviewInput) SetPillarNotes(v map[string]*string) *UpdateLensReviewInput {
	s.PillarNotes = v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpdateLensReviewInput) SetWorkloadId(v string) *UpdateLensReviewInput {
	s.WorkloadId = &v
	return s
}

// Output of a update lens review call.
type UpdateLensReviewOutput struct {
	_ struct{} `type:"structure"`

	// A lens review of a question.
	LensReview *LensReview `type:"structure"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLensReviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLensReviewOutput) GoString() string {
	return s.String()
}

// SetLensReview sets the LensReview field's value.
func (s *UpdateLensReviewOutput) SetLensReview(v *LensReview) *UpdateLensReviewOutput {
	s.LensReview = v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpdateLensReviewOutput) SetWorkloadId(v string) *UpdateLensReviewOutput {
	s.WorkloadId = &v
	return s
}

type UpdateProfileInput struct {
	_ struct{} `type:"structure"`

	// The profile ARN.
	//
	// ProfileArn is a required field
	ProfileArn *string `location:"uri" locationName:"ProfileArn" type:"string" required:"true"`

	// The profile description.
	ProfileDescription *string `min:"3" type:"string"`

	// Profile questions.
	ProfileQuestions []*ProfileQuestionUpdate `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProfileInput"}
	if s.ProfileArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileArn"))
	}
	if s.ProfileArn != nil && len(*s.ProfileArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileArn", 1))
	}
	if s.ProfileDescription != nil && len(*s.ProfileDescription) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileDescription", 3))
	}
	if s.ProfileQuestions != nil {
		for i, v := range s.ProfileQuestions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ProfileQuestions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileArn sets the ProfileArn field's value.
func (s *UpdateProfileInput) SetProfileArn(v string) *UpdateProfileInput {
	s.ProfileArn = &v
	return s
}

// SetProfileDescription sets the ProfileDescription field's value.
func (s *UpdateProfileInput) SetProfileDescription(v string) *UpdateProfileInput {
	s.ProfileDescription = &v
	return s
}

// SetProfileQuestions sets the ProfileQuestions field's value.
func (s *UpdateProfileInput) SetProfileQuestions(v []*ProfileQuestionUpdate) *UpdateProfileInput {
	s.ProfileQuestions = v
	return s
}

type UpdateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The profile.
	Profile *Profile `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileOutput) GoString() string {
	return s.String()
}

// SetProfile sets the Profile field's value.
func (s *UpdateProfileOutput) SetProfile(v *Profile) *UpdateProfileOutput {
	s.Profile = v
	return s
}

type UpdateReviewTemplateAnswerInput struct {
	_ struct{} `type:"structure"`

	// A list of choices to be updated.
	ChoiceUpdates map[string]*ChoiceUpdate `type:"map"`

	// Defines whether this question is applicable to a lens review.
	IsApplicable *bool `type:"boolean"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The notes associated with the workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	Notes *string `type:"string"`

	// The ID of the question.
	//
	// QuestionId is a required field
	QuestionId *string `location:"uri" locationName:"QuestionId" min:"1" type:"string" required:"true"`

	// The update reason.
	Reason *string `type:"string" enum:"AnswerReason"`

	// List of selected choice IDs in a question answer.
	//
	// The values entered replace the previously selected choices.
	SelectedChoices []*string `type:"list"`

	// The review template ARN.
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"50" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReviewTemplateAnswerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReviewTemplateAnswerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReviewTemplateAnswerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReviewTemplateAnswerInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.QuestionId == nil {
		invalidParams.Add(request.NewErrParamRequired("QuestionId"))
	}
	if s.QuestionId != nil && len(*s.QuestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuestionId", 1))
	}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 50))
	}
	if s.ChoiceUpdates != nil {
		for i, v := range s.ChoiceUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ChoiceUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChoiceUpdates sets the ChoiceUpdates field's value.
func (s *UpdateReviewTemplateAnswerInput) SetChoiceUpdates(v map[string]*ChoiceUpdate) *UpdateReviewTemplateAnswerInput {
	s.ChoiceUpdates = v
	return s
}

// SetIsApplicable sets the IsApplicable field's value.
func (s *UpdateReviewTemplateAnswerInput) SetIsApplicable(v bool) *UpdateReviewTemplateAnswerInput {
	s.IsApplicable = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *UpdateReviewTemplateAnswerInput) SetLensAlias(v string) *UpdateReviewTemplateAnswerInput {
	s.LensAlias = &v
	return s
}

// SetNotes sets the Notes field's value.
func (s *UpdateReviewTemplateAnswerInput) SetNotes(v string) *UpdateReviewTemplateAnswerInput {
	s.Notes = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *UpdateReviewTemplateAnswerInput) SetQuestionId(v string) *UpdateReviewTemplateAnswerInput {
	s.QuestionId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *UpdateReviewTemplateAnswerInput) SetReason(v string) *UpdateReviewTemplateAnswerInput {
	s.Reason = &v
	return s
}

// SetSelectedChoices sets the SelectedChoices field's value.
func (s *UpdateReviewTemplateAnswerInput) SetSelectedChoices(v []*string) *UpdateReviewTemplateAnswerInput {
	s.SelectedChoices = v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *UpdateReviewTemplateAnswerInput) SetTemplateArn(v string) *UpdateReviewTemplateAnswerInput {
	s.TemplateArn = &v
	return s
}

type UpdateReviewTemplateAnswerOutput struct {
	_ struct{} `type:"structure"`

	// An answer of the question.
	Answer *ReviewTemplateAnswer `type:"structure"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string `min:"1" type:"string"`

	// The review template ARN.
	TemplateArn *string `min:"50" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReviewTemplateAnswerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReviewTemplateAnswerOutput) GoString() string {
	return s.String()
}

// SetAnswer sets the Answer field's value.
func (s *UpdateReviewTemplateAnswerOutput) SetAnswer(v *ReviewTemplateAnswer) *UpdateReviewTemplateAnswerOutput {
	s.Answer = v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *UpdateReviewTemplateAnswerOutput) SetLensAlias(v string) *UpdateReviewTemplateAnswerOutput {
	s.LensAlias = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *UpdateReviewTemplateAnswerOutput) SetTemplateArn(v string) *UpdateReviewTemplateAnswerOutput {
	s.TemplateArn = &v
	return s
}

type UpdateReviewTemplateInput struct {
	_ struct{} `type:"structure"`

	// The review template description.
	Description *string `min:"3" type:"string"`

	// A list of lens aliases or ARNs to apply to the review template.
	LensesToAssociate []*string `min:"1" type:"list"`

	// A list of lens aliases or ARNs to unapply to the review template. The wellarchitected
	// lens cannot be unapplied.
	LensesToDisassociate []*string `min:"1" type:"list"`

	// The notes associated with the workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	Notes *string `type:"string"`

	// The review template ARN.
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"50" type:"string" required:"true"`

	// The review template name.
	TemplateName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReviewTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReviewTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReviewTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReviewTemplateInput"}
	if s.Description != nil && len(*s.Description) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 3))
	}
	if s.LensesToAssociate != nil && len(s.LensesToAssociate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensesToAssociate", 1))
	}
	if s.LensesToDisassociate != nil && len(s.LensesToDisassociate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensesToDisassociate", 1))
	}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 50))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateReviewTemplateInput) SetDescription(v string) *UpdateReviewTemplateInput {
	s.Description = &v
	return s
}

// SetLensesToAssociate sets the LensesToAssociate field's value.
func (s *UpdateReviewTemplateInput) SetLensesToAssociate(v []*string) *UpdateReviewTemplateInput {
	s.LensesToAssociate = v
	return s
}

// SetLensesToDisassociate sets the LensesToDisassociate field's value.
func (s *UpdateReviewTemplateInput) SetLensesToDisassociate(v []*string) *UpdateReviewTemplateInput {
	s.LensesToDisassociate = v
	return s
}

// SetNotes sets the Notes field's value.
func (s *UpdateReviewTemplateInput) SetNotes(v string) *UpdateReviewTemplateInput {
	s.Notes = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *UpdateReviewTemplateInput) SetTemplateArn(v string) *UpdateReviewTemplateInput {
	s.TemplateArn = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *UpdateReviewTemplateInput) SetTemplateName(v string) *UpdateReviewTemplateInput {
	s.TemplateName = &v
	return s
}

type UpdateReviewTemplateLensReviewInput struct {
	_ struct{} `type:"structure"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The notes associated with the workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	LensNotes *string `type:"string"`

	// List of pillar notes of a lens review in a workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	PillarNotes map[string]*string `type:"map"`

	// The review template ARN.
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"50" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReviewTemplateLensReviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReviewTemplateLensReviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReviewTemplateLensReviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReviewTemplateLensReviewInput"}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLensAlias sets the LensAlias field's value.
func (s *UpdateReviewTemplateLensReviewInput) SetLensAlias(v string) *UpdateReviewTemplateLensReviewInput {
	s.LensAlias = &v
	return s
}

// SetLensNotes sets the LensNotes field's value.
func (s *UpdateReviewTemplateLensReviewInput) SetLensNotes(v string) *UpdateReviewTemplateLensReviewInput {
	s.LensNotes = &v
	return s
}

// SetPillarNotes sets the PillarNotes field's value.
func (s *UpdateReviewTemplateLensReviewInput) SetPillarNotes(v map[string]*string) *UpdateReviewTemplateLensReviewInput {
	s.PillarNotes = v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *UpdateReviewTemplateLensReviewInput) SetTemplateArn(v string) *UpdateReviewTemplateLensReviewInput {
	s.TemplateArn = &v
	return s
}

type UpdateReviewTemplateLensReviewOutput struct {
	_ struct{} `type:"structure"`

	// A lens review of a question.
	LensReview *ReviewTemplateLensReview `type:"structure"`

	// The review template ARN.
	TemplateArn *string `min:"50" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReviewTemplateLensReviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReviewTemplateLensReviewOutput) GoString() string {
	return s.String()
}

// SetLensReview sets the LensReview field's value.
func (s *UpdateReviewTemplateLensReviewOutput) SetLensReview(v *ReviewTemplateLensReview) *UpdateReviewTemplateLensReviewOutput {
	s.LensReview = v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *UpdateReviewTemplateLensReviewOutput) SetTemplateArn(v string) *UpdateReviewTemplateLensReviewOutput {
	s.TemplateArn = &v
	return s
}

type UpdateReviewTemplateOutput struct {
	_ struct{} `type:"structure"`

	// A review template.
	ReviewTemplate *ReviewTemplate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReviewTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReviewTemplateOutput) GoString() string {
	return s.String()
}

// SetReviewTemplate sets the ReviewTemplate field's value.
func (s *UpdateReviewTemplateOutput) SetReviewTemplate(v *ReviewTemplate) *UpdateReviewTemplateOutput {
	s.ReviewTemplate = v
	return s
}

// Input for Update Share Invitation
type UpdateShareInvitationInput struct {
	_ struct{} `type:"structure"`

	// Share invitation action taken by contributor.
	//
	// ShareInvitationAction is a required field
	ShareInvitationAction *string `type:"string" required:"true" enum:"ShareInvitationAction"`

	// The ID assigned to the share invitation.
	//
	// ShareInvitationId is a required field
	ShareInvitationId *string `location:"uri" locationName:"ShareInvitationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateShareInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateShareInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateShareInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateShareInvitationInput"}
	if s.ShareInvitationAction == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareInvitationAction"))
	}
	if s.ShareInvitationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareInvitationId"))
	}
	if s.ShareInvitationId != nil && len(*s.ShareInvitationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShareInvitationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShareInvitationAction sets the ShareInvitationAction field's value.
func (s *UpdateShareInvitationInput) SetShareInvitationAction(v string) *UpdateShareInvitationInput {
	s.ShareInvitationAction = &v
	return s
}

// SetShareInvitationId sets the ShareInvitationId field's value.
func (s *UpdateShareInvitationInput) SetShareInvitationId(v string) *UpdateShareInvitationInput {
	s.ShareInvitationId = &v
	return s
}

type UpdateShareInvitationOutput struct {
	_ struct{} `type:"structure"`

	// The updated workload or custom lens share invitation.
	ShareInvitation *ShareInvitation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateShareInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateShareInvitationOutput) GoString() string {
	return s.String()
}

// SetShareInvitation sets the ShareInvitation field's value.
func (s *UpdateShareInvitationOutput) SetShareInvitation(v *ShareInvitation) *UpdateShareInvitationOutput {
	s.ShareInvitation = v
	return s
}

// Input to update a workload.
type UpdateWorkloadInput struct {
	_ struct{} `type:"structure"`

	// The list of Amazon Web Services account IDs associated with the workload.
	AccountIds []*string `type:"list"`

	// List of AppRegistry application ARNs to associate to the workload.
	Applications []*string `type:"list"`

	// The URL of the architectural design for the workload.
	ArchitecturalDesign *string `type:"string"`

	// The list of Amazon Web Services Regions associated with the workload, for
	// example, us-east-2, or ca-central-1.
	AwsRegions []*string `type:"list"`

	// The description for the workload.
	Description *string `min:"3" type:"string"`

	// Well-Architected discovery configuration settings to associate to the workload.
	DiscoveryConfig *WorkloadDiscoveryConfig `type:"structure"`

	// The environment for the workload.
	Environment *string `type:"string" enum:"WorkloadEnvironment"`

	// The improvement status for a workload.
	ImprovementStatus *string `type:"string" enum:"WorkloadImprovementStatus"`

	// The industry for the workload.
	Industry *string `type:"string"`

	// The industry type for the workload.
	//
	// If specified, must be one of the following:
	//
	//    * Agriculture
	//
	//    * Automobile
	//
	//    * Defense
	//
	//    * Design and Engineering
	//
	//    * Digital Advertising
	//
	//    * Education
	//
	//    * Environmental Protection
	//
	//    * Financial Services
	//
	//    * Gaming
	//
	//    * General Public Services
	//
	//    * Healthcare
	//
	//    * Hospitality
	//
	//    * InfoTech
	//
	//    * Justice and Public Safety
	//
	//    * Life Sciences
	//
	//    * Manufacturing
	//
	//    * Media & Entertainment
	//
	//    * Mining & Resources
	//
	//    * Oil & Gas
	//
	//    * Power & Utilities
	//
	//    * Professional Services
	//
	//    * Real Estate & Construction
	//
	//    * Retail & Wholesale
	//
	//    * Social Protection
	//
	//    * Telecommunications
	//
	//    * Travel, Transportation & Logistics
	//
	//    * Other
	IndustryType *string `type:"string"`

	// Flag indicating whether the workload owner has acknowledged that the Review
	// owner field is required.
	//
	// If a Review owner is not added to the workload within 60 days of acknowledgement,
	// access to the workload is restricted until an owner is added.
	IsReviewOwnerUpdateAcknowledged *bool `type:"boolean"`

	// Configuration of the Jira integration.
	JiraConfiguration *WorkloadJiraConfigurationInput_ `type:"structure"`

	// The list of non-Amazon Web Services Regions associated with the workload.
	NonAwsRegions []*string `type:"list"`

	// The notes associated with the workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	Notes *string `type:"string"`

	// The priorities of the pillars, which are used to order items in the improvement
	// plan. Each pillar is represented by its PillarReviewSummary$PillarId.
	PillarPriorities []*string `type:"list"`

	// The review owner of the workload. The name, email address, or identifier
	// for the primary group or individual that owns the workload review process.
	ReviewOwner *string `min:"3" type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`

	// The name of the workload.
	//
	// The name must be unique within an account within an Amazon Web Services Region.
	// Spaces and capitalization are ignored when checking for uniqueness.
	WorkloadName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkloadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkloadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkloadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkloadInput"}
	if s.Description != nil && len(*s.Description) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 3))
	}
	if s.ReviewOwner != nil && len(*s.ReviewOwner) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ReviewOwner", 3))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}
	if s.WorkloadName != nil && len(*s.WorkloadName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadName", 3))
	}
	if s.JiraConfiguration != nil {
		if err := s.JiraConfiguration.Validate(); err != nil {
			invalidParams.AddNested("JiraConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *UpdateWorkloadInput) SetAccountIds(v []*string) *UpdateWorkloadInput {
	s.AccountIds = v
	return s
}

// SetApplications sets the Applications field's value.
func (s *UpdateWorkloadInput) SetApplications(v []*string) *UpdateWorkloadInput {
	s.Applications = v
	return s
}

// SetArchitecturalDesign sets the ArchitecturalDesign field's value.
func (s *UpdateWorkloadInput) SetArchitecturalDesign(v string) *UpdateWorkloadInput {
	s.ArchitecturalDesign = &v
	return s
}

// SetAwsRegions sets the AwsRegions field's value.
func (s *UpdateWorkloadInput) SetAwsRegions(v []*string) *UpdateWorkloadInput {
	s.AwsRegions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateWorkloadInput) SetDescription(v string) *UpdateWorkloadInput {
	s.Description = &v
	return s
}

// SetDiscoveryConfig sets the DiscoveryConfig field's value.
func (s *UpdateWorkloadInput) SetDiscoveryConfig(v *WorkloadDiscoveryConfig) *UpdateWorkloadInput {
	s.DiscoveryConfig = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *UpdateWorkloadInput) SetEnvironment(v string) *UpdateWorkloadInput {
	s.Environment = &v
	return s
}

// SetImprovementStatus sets the ImprovementStatus field's value.
func (s *UpdateWorkloadInput) SetImprovementStatus(v string) *UpdateWorkloadInput {
	s.ImprovementStatus = &v
	return s
}

// SetIndustry sets the Industry field's value.
func (s *UpdateWorkloadInput) SetIndustry(v string) *UpdateWorkloadInput {
	s.Industry = &v
	return s
}

// SetIndustryType sets the IndustryType field's value.
func (s *UpdateWorkloadInput) SetIndustryType(v string) *UpdateWorkloadInput {
	s.IndustryType = &v
	return s
}

// SetIsReviewOwnerUpdateAcknowledged sets the IsReviewOwnerUpdateAcknowledged field's value.
func (s *UpdateWorkloadInput) SetIsReviewOwnerUpdateAcknowledged(v bool) *UpdateWorkloadInput {
	s.IsReviewOwnerUpdateAcknowledged = &v
	return s
}

// SetJiraConfiguration sets the JiraConfiguration field's value.
func (s *UpdateWorkloadInput) SetJiraConfiguration(v *WorkloadJiraConfigurationInput_) *UpdateWorkloadInput {
	s.JiraConfiguration = v
	return s
}

// SetNonAwsRegions sets the NonAwsRegions field's value.
func (s *UpdateWorkloadInput) SetNonAwsRegions(v []*string) *UpdateWorkloadInput {
	s.NonAwsRegions = v
	return s
}

// SetNotes sets the Notes field's value.
func (s *UpdateWorkloadInput) SetNotes(v string) *UpdateWorkloadInput {
	s.Notes = &v
	return s
}

// SetPillarPriorities sets the PillarPriorities field's value.
func (s *UpdateWorkloadInput) SetPillarPriorities(v []*string) *UpdateWorkloadInput {
	s.PillarPriorities = v
	return s
}

// SetReviewOwner sets the ReviewOwner field's value.
func (s *UpdateWorkloadInput) SetReviewOwner(v string) *UpdateWorkloadInput {
	s.ReviewOwner = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpdateWorkloadInput) SetWorkloadId(v string) *UpdateWorkloadInput {
	s.WorkloadId = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *UpdateWorkloadInput) SetWorkloadName(v string) *UpdateWorkloadInput {
	s.WorkloadName = &v
	return s
}

// Output of an update workload call.
type UpdateWorkloadOutput struct {
	_ struct{} `type:"structure"`

	// A workload return object.
	Workload *Workload `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkloadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkloadOutput) GoString() string {
	return s.String()
}

// SetWorkload sets the Workload field's value.
func (s *UpdateWorkloadOutput) SetWorkload(v *Workload) *UpdateWorkloadOutput {
	s.Workload = v
	return s
}

// Input for Update Workload Share
type UpdateWorkloadShareInput struct {
	_ struct{} `type:"structure"`

	// Permission granted on a share request.
	//
	// PermissionType is a required field
	PermissionType *string `type:"string" required:"true" enum:"PermissionType"`

	// The ID associated with the share.
	//
	// ShareId is a required field
	ShareId *string `location:"uri" locationName:"ShareId" type:"string" required:"true"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkloadShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkloadShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkloadShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkloadShareInput"}
	if s.PermissionType == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionType"))
	}
	if s.ShareId == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareId"))
	}
	if s.ShareId != nil && len(*s.ShareId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShareId", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPermissionType sets the PermissionType field's value.
func (s *UpdateWorkloadShareInput) SetPermissionType(v string) *UpdateWorkloadShareInput {
	s.PermissionType = &v
	return s
}

// SetShareId sets the ShareId field's value.
func (s *UpdateWorkloadShareInput) SetShareId(v string) *UpdateWorkloadShareInput {
	s.ShareId = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpdateWorkloadShareInput) SetWorkloadId(v string) *UpdateWorkloadShareInput {
	s.WorkloadId = &v
	return s
}

// Input for Update Workload Share
type UpdateWorkloadShareOutput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`

	// A workload share return object.
	WorkloadShare *WorkloadShare `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkloadShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkloadShareOutput) GoString() string {
	return s.String()
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpdateWorkloadShareOutput) SetWorkloadId(v string) *UpdateWorkloadShareOutput {
	s.WorkloadId = &v
	return s
}

// SetWorkloadShare sets the WorkloadShare field's value.
func (s *UpdateWorkloadShareOutput) SetWorkloadShare(v *WorkloadShare) *UpdateWorkloadShareOutput {
	s.WorkloadShare = v
	return s
}

type UpgradeLensReviewInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `min:"1" type:"string"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The name of the milestone in a workload.
	//
	// Milestone names must be unique within a workload.
	//
	// MilestoneName is a required field
	MilestoneName *string `min:"3" type:"string" required:"true"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeLensReviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeLensReviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpgradeLensReviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpgradeLensReviewInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.MilestoneName == nil {
		invalidParams.Add(request.NewErrParamRequired("MilestoneName"))
	}
	if s.MilestoneName != nil && len(*s.MilestoneName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("MilestoneName", 3))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpgradeLensReviewInput) SetClientRequestToken(v string) *UpgradeLensReviewInput {
	s.ClientRequestToken = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *UpgradeLensReviewInput) SetLensAlias(v string) *UpgradeLensReviewInput {
	s.LensAlias = &v
	return s
}

// SetMilestoneName sets the MilestoneName field's value.
func (s *UpgradeLensReviewInput) SetMilestoneName(v string) *UpgradeLensReviewInput {
	s.MilestoneName = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpgradeLensReviewInput) SetWorkloadId(v string) *UpgradeLensReviewInput {
	s.WorkloadId = &v
	return s
}

type UpgradeLensReviewOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeLensReviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeLensReviewOutput) GoString() string {
	return s.String()
}

type UpgradeProfileVersionInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The name of the milestone in a workload.
	//
	// Milestone names must be unique within a workload.
	MilestoneName *string `min:"3" type:"string"`

	// The profile ARN.
	//
	// ProfileArn is a required field
	ProfileArn *string `location:"uri" locationName:"ProfileArn" type:"string" required:"true"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	//
	// WorkloadId is a required field
	WorkloadId *string `location:"uri" locationName:"WorkloadId" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeProfileVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeProfileVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpgradeProfileVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpgradeProfileVersionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.MilestoneName != nil && len(*s.MilestoneName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("MilestoneName", 3))
	}
	if s.ProfileArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileArn"))
	}
	if s.ProfileArn != nil && len(*s.ProfileArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileArn", 1))
	}
	if s.WorkloadId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkloadId"))
	}
	if s.WorkloadId != nil && len(*s.WorkloadId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("WorkloadId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpgradeProfileVersionInput) SetClientRequestToken(v string) *UpgradeProfileVersionInput {
	s.ClientRequestToken = &v
	return s
}

// SetMilestoneName sets the MilestoneName field's value.
func (s *UpgradeProfileVersionInput) SetMilestoneName(v string) *UpgradeProfileVersionInput {
	s.MilestoneName = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *UpgradeProfileVersionInput) SetProfileArn(v string) *UpgradeProfileVersionInput {
	s.ProfileArn = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *UpgradeProfileVersionInput) SetWorkloadId(v string) *UpgradeProfileVersionInput {
	s.WorkloadId = &v
	return s
}

type UpgradeProfileVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeProfileVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeProfileVersionOutput) GoString() string {
	return s.String()
}

type UpgradeReviewTemplateLensReviewInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once).
	//
	// You should not reuse the same token for other requests. If you retry a request
	// with the same client request token and the same parameters after the original
	// request has completed successfully, the result of the original request is
	// returned.
	//
	// This token is listed as required, however, if you do not specify it, the
	// Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token
	// or the request will fail.
	ClientRequestToken *string `min:"1" type:"string"`

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such
	// as serverless, or the lens ARN, such as arn:aws:wellarchitected:us-east-1::lens/serverless.
	// Note that some operations (such as ExportLens and CreateLensShare) are not
	// permitted on Amazon Web Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef.
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// LensAlias is a required field
	LensAlias *string `location:"uri" locationName:"LensAlias" min:"1" type:"string" required:"true"`

	// The ARN of the review template.
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"50" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeReviewTemplateLensReviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeReviewTemplateLensReviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpgradeReviewTemplateLensReviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpgradeReviewTemplateLensReviewInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.LensAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("LensAlias"))
	}
	if s.LensAlias != nil && len(*s.LensAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LensAlias", 1))
	}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpgradeReviewTemplateLensReviewInput) SetClientRequestToken(v string) *UpgradeReviewTemplateLensReviewInput {
	s.ClientRequestToken = &v
	return s
}

// SetLensAlias sets the LensAlias field's value.
func (s *UpgradeReviewTemplateLensReviewInput) SetLensAlias(v string) *UpgradeReviewTemplateLensReviewInput {
	s.LensAlias = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *UpgradeReviewTemplateLensReviewInput) SetTemplateArn(v string) *UpgradeReviewTemplateLensReviewInput {
	s.TemplateArn = &v
	return s
}

type UpgradeReviewTemplateLensReviewOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeReviewTemplateLensReviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeReviewTemplateLensReviewOutput) GoString() string {
	return s.String()
}

// The user input is not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The fields that caused the error, if applicable.
	Fields []*ValidationExceptionField `type:"list"`

	// Description of the error.
	Message_ *string `locationName:"Message" type:"string"`

	// The reason why the request failed validation.
	Reason *string `type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Stores information about a field passed inside a request that resulted in
// an exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Description of the error.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The field name for which validation failed.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// The differences between the base and latest versions of the lens.
type VersionDifferences struct {
	_ struct{} `type:"structure"`

	// The differences between the base and latest versions of the lens.
	PillarDifferences []*PillarDifference `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VersionDifferences) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VersionDifferences) GoString() string {
	return s.String()
}

// SetPillarDifferences sets the PillarDifferences field's value.
func (s *VersionDifferences) SetPillarDifferences(v []*PillarDifference) *VersionDifferences {
	s.PillarDifferences = v
	return s
}

// A workload return object.
type Workload struct {
	_ struct{} `type:"structure"`

	// The list of Amazon Web Services account IDs associated with the workload.
	AccountIds []*string `type:"list"`

	// List of AppRegistry application ARNs associated to the workload.
	Applications []*string `type:"list"`

	// The URL of the architectural design for the workload.
	ArchitecturalDesign *string `type:"string"`

	// The list of Amazon Web Services Regions associated with the workload, for
	// example, us-east-2, or ca-central-1.
	AwsRegions []*string `type:"list"`

	// The description for the workload.
	Description *string `min:"3" type:"string"`

	// Discovery configuration associated to the workload.
	DiscoveryConfig *WorkloadDiscoveryConfig `type:"structure"`

	// The environment for the workload.
	Environment *string `type:"string" enum:"WorkloadEnvironment"`

	// The improvement status for a workload.
	ImprovementStatus *string `type:"string" enum:"WorkloadImprovementStatus"`

	// The industry for the workload.
	Industry *string `type:"string"`

	// The industry type for the workload.
	//
	// If specified, must be one of the following:
	//
	//    * Agriculture
	//
	//    * Automobile
	//
	//    * Defense
	//
	//    * Design and Engineering
	//
	//    * Digital Advertising
	//
	//    * Education
	//
	//    * Environmental Protection
	//
	//    * Financial Services
	//
	//    * Gaming
	//
	//    * General Public Services
	//
	//    * Healthcare
	//
	//    * Hospitality
	//
	//    * InfoTech
	//
	//    * Justice and Public Safety
	//
	//    * Life Sciences
	//
	//    * Manufacturing
	//
	//    * Media & Entertainment
	//
	//    * Mining & Resources
	//
	//    * Oil & Gas
	//
	//    * Power & Utilities
	//
	//    * Professional Services
	//
	//    * Real Estate & Construction
	//
	//    * Retail & Wholesale
	//
	//    * Social Protection
	//
	//    * Telecommunications
	//
	//    * Travel, Transportation & Logistics
	//
	//    * Other
	IndustryType *string `type:"string"`

	// Flag indicating whether the workload owner has acknowledged that the Review
	// owner field is required.
	//
	// If a Review owner is not added to the workload within 60 days of acknowledgement,
	// access to the workload is restricted until an owner is added.
	IsReviewOwnerUpdateAcknowledged *bool `type:"boolean"`

	// Jira configuration for a specific workload.
	JiraConfiguration *WorkloadJiraConfigurationOutput_ `type:"structure"`

	// The list of lenses associated with the workload. Each lens is identified
	// by its LensSummary$LensAlias.
	//
	// If a review template that specifies lenses is applied to the workload, those
	// lenses are applied to the workload in addition to these lenses.
	Lenses []*string `type:"list"`

	// The list of non-Amazon Web Services Regions associated with the workload.
	NonAwsRegions []*string `type:"list"`

	// The notes associated with the workload.
	//
	// For a review template, these are the notes that will be associated with the
	// workload when the template is applied.
	Notes *string `type:"string"`

	// An Amazon Web Services account ID.
	Owner *string `min:"12" type:"string"`

	// The priorities of the pillars, which are used to order items in the improvement
	// plan. Each pillar is represented by its PillarReviewSummary$PillarId.
	PillarPriorities []*string `type:"list"`

	// A map from risk names to the count of how many questions have that rating.
	PrioritizedRiskCounts map[string]*int64 `type:"map"`

	// Profile associated with a workload.
	Profiles []*WorkloadProfile `type:"list"`

	// The review owner of the workload. The name, email address, or identifier
	// for the primary group or individual that owns the workload review process.
	ReviewOwner *string `min:"3" type:"string"`

	// The date and time recorded.
	ReviewRestrictionDate *time.Time `type:"timestamp"`

	// A map from risk names to the count of how many questions have that rating.
	RiskCounts map[string]*int64 `type:"map"`

	// The ID assigned to the share invitation.
	ShareInvitationId *string `type:"string"`

	// The tags associated with the workload.
	Tags map[string]*string `min:"1" type:"map"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`

	// The ARN for the workload.
	WorkloadArn *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`

	// The name of the workload.
	//
	// The name must be unique within an account within an Amazon Web Services Region.
	// Spaces and capitalization are ignored when checking for uniqueness.
	WorkloadName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Workload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Workload) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *Workload) SetAccountIds(v []*string) *Workload {
	s.AccountIds = v
	return s
}

// SetApplications sets the Applications field's value.
func (s *Workload) SetApplications(v []*string) *Workload {
	s.Applications = v
	return s
}

// SetArchitecturalDesign sets the ArchitecturalDesign field's value.
func (s *Workload) SetArchitecturalDesign(v string) *Workload {
	s.ArchitecturalDesign = &v
	return s
}

// SetAwsRegions sets the AwsRegions field's value.
func (s *Workload) SetAwsRegions(v []*string) *Workload {
	s.AwsRegions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Workload) SetDescription(v string) *Workload {
	s.Description = &v
	return s
}

// SetDiscoveryConfig sets the DiscoveryConfig field's value.
func (s *Workload) SetDiscoveryConfig(v *WorkloadDiscoveryConfig) *Workload {
	s.DiscoveryConfig = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *Workload) SetEnvironment(v string) *Workload {
	s.Environment = &v
	return s
}

// SetImprovementStatus sets the ImprovementStatus field's value.
func (s *Workload) SetImprovementStatus(v string) *Workload {
	s.ImprovementStatus = &v
	return s
}

// SetIndustry sets the Industry field's value.
func (s *Workload) SetIndustry(v string) *Workload {
	s.Industry = &v
	return s
}

// SetIndustryType sets the IndustryType field's value.
func (s *Workload) SetIndustryType(v string) *Workload {
	s.IndustryType = &v
	return s
}

// SetIsReviewOwnerUpdateAcknowledged sets the IsReviewOwnerUpdateAcknowledged field's value.
func (s *Workload) SetIsReviewOwnerUpdateAcknowledged(v bool) *Workload {
	s.IsReviewOwnerUpdateAcknowledged = &v
	return s
}

// SetJiraConfiguration sets the JiraConfiguration field's value.
func (s *Workload) SetJiraConfiguration(v *WorkloadJiraConfigurationOutput_) *Workload {
	s.JiraConfiguration = v
	return s
}

// SetLenses sets the Lenses field's value.
func (s *Workload) SetLenses(v []*string) *Workload {
	s.Lenses = v
	return s
}

// SetNonAwsRegions sets the NonAwsRegions field's value.
func (s *Workload) SetNonAwsRegions(v []*string) *Workload {
	s.NonAwsRegions = v
	return s
}

// SetNotes sets the Notes field's value.
func (s *Workload) SetNotes(v string) *Workload {
	s.Notes = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *Workload) SetOwner(v string) *Workload {
	s.Owner = &v
	return s
}

// SetPillarPriorities sets the PillarPriorities field's value.
func (s *Workload) SetPillarPriorities(v []*string) *Workload {
	s.PillarPriorities = v
	return s
}

// SetPrioritizedRiskCounts sets the PrioritizedRiskCounts field's value.
func (s *Workload) SetPrioritizedRiskCounts(v map[string]*int64) *Workload {
	s.PrioritizedRiskCounts = v
	return s
}

// SetProfiles sets the Profiles field's value.
func (s *Workload) SetProfiles(v []*WorkloadProfile) *Workload {
	s.Profiles = v
	return s
}

// SetReviewOwner sets the ReviewOwner field's value.
func (s *Workload) SetReviewOwner(v string) *Workload {
	s.ReviewOwner = &v
	return s
}

// SetReviewRestrictionDate sets the ReviewRestrictionDate field's value.
func (s *Workload) SetReviewRestrictionDate(v time.Time) *Workload {
	s.ReviewRestrictionDate = &v
	return s
}

// SetRiskCounts sets the RiskCounts field's value.
func (s *Workload) SetRiskCounts(v map[string]*int64) *Workload {
	s.RiskCounts = v
	return s
}

// SetShareInvitationId sets the ShareInvitationId field's value.
func (s *Workload) SetShareInvitationId(v string) *Workload {
	s.ShareInvitationId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Workload) SetTags(v map[string]*string) *Workload {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Workload) SetUpdatedAt(v time.Time) *Workload {
	s.UpdatedAt = &v
	return s
}

// SetWorkloadArn sets the WorkloadArn field's value.
func (s *Workload) SetWorkloadArn(v string) *Workload {
	s.WorkloadArn = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *Workload) SetWorkloadId(v string) *Workload {
	s.WorkloadId = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *Workload) SetWorkloadName(v string) *Workload {
	s.WorkloadName = &v
	return s
}

// Discovery configuration associated to the workload.
type WorkloadDiscoveryConfig struct {
	_ struct{} `type:"structure"`

	// Discovery integration status in respect to Trusted Advisor for the workload.
	TrustedAdvisorIntegrationStatus *string `type:"string" enum:"TrustedAdvisorIntegrationStatus"`

	// The mode to use for identifying resources associated with the workload.
	//
	// You can specify WORKLOAD_METADATA, APP_REGISTRY, or both.
	WorkloadResourceDefinition []*string `type:"list" enum:"DefinitionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadDiscoveryConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadDiscoveryConfig) GoString() string {
	return s.String()
}

// SetTrustedAdvisorIntegrationStatus sets the TrustedAdvisorIntegrationStatus field's value.
func (s *WorkloadDiscoveryConfig) SetTrustedAdvisorIntegrationStatus(v string) *WorkloadDiscoveryConfig {
	s.TrustedAdvisorIntegrationStatus = &v
	return s
}

// SetWorkloadResourceDefinition sets the WorkloadResourceDefinition field's value.
func (s *WorkloadDiscoveryConfig) SetWorkloadResourceDefinition(v []*string) *WorkloadDiscoveryConfig {
	s.WorkloadResourceDefinition = v
	return s
}

// Workload-level: Input for the Jira configuration.
type WorkloadJiraConfigurationInput_ struct {
	_ struct{} `type:"structure"`

	// Workload-level: Jira issue management status.
	IssueManagementStatus *string `type:"string" enum:"WorkloadIssueManagementStatus"`

	// Workload-level: Jira issue management type.
	IssueManagementType *string `type:"string" enum:"IssueManagementType"`

	// Workload-level: Jira project key to sync workloads to.
	JiraProjectKey *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadJiraConfigurationInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadJiraConfigurationInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkloadJiraConfigurationInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkloadJiraConfigurationInput_"}
	if s.JiraProjectKey != nil && len(*s.JiraProjectKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JiraProjectKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIssueManagementStatus sets the IssueManagementStatus field's value.
func (s *WorkloadJiraConfigurationInput_) SetIssueManagementStatus(v string) *WorkloadJiraConfigurationInput_ {
	s.IssueManagementStatus = &v
	return s
}

// SetIssueManagementType sets the IssueManagementType field's value.
func (s *WorkloadJiraConfigurationInput_) SetIssueManagementType(v string) *WorkloadJiraConfigurationInput_ {
	s.IssueManagementType = &v
	return s
}

// SetJiraProjectKey sets the JiraProjectKey field's value.
func (s *WorkloadJiraConfigurationInput_) SetJiraProjectKey(v string) *WorkloadJiraConfigurationInput_ {
	s.JiraProjectKey = &v
	return s
}

// Workload-level: Output configuration of the Jira integration.
type WorkloadJiraConfigurationOutput_ struct {
	_ struct{} `type:"structure"`

	// Workload-level: Jira issue management status.
	IssueManagementStatus *string `type:"string" enum:"WorkloadIssueManagementStatus"`

	// Workload-level: Jira issue management type.
	IssueManagementType *string `type:"string" enum:"IssueManagementType"`

	// Workload-level: Jira project key to sync workloads to.
	JiraProjectKey *string `min:"1" type:"string"`

	// Workload-level: Status message on configuration of the Jira integration.
	StatusMessage *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadJiraConfigurationOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadJiraConfigurationOutput_) GoString() string {
	return s.String()
}

// SetIssueManagementStatus sets the IssueManagementStatus field's value.
func (s *WorkloadJiraConfigurationOutput_) SetIssueManagementStatus(v string) *WorkloadJiraConfigurationOutput_ {
	s.IssueManagementStatus = &v
	return s
}

// SetIssueManagementType sets the IssueManagementType field's value.
func (s *WorkloadJiraConfigurationOutput_) SetIssueManagementType(v string) *WorkloadJiraConfigurationOutput_ {
	s.IssueManagementType = &v
	return s
}

// SetJiraProjectKey sets the JiraProjectKey field's value.
func (s *WorkloadJiraConfigurationOutput_) SetJiraProjectKey(v string) *WorkloadJiraConfigurationOutput_ {
	s.JiraProjectKey = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *WorkloadJiraConfigurationOutput_) SetStatusMessage(v string) *WorkloadJiraConfigurationOutput_ {
	s.StatusMessage = &v
	return s
}

// The profile associated with a workload.
type WorkloadProfile struct {
	_ struct{} `type:"structure"`

	// The profile ARN.
	ProfileArn *string `type:"string"`

	// The profile version.
	ProfileVersion *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadProfile) GoString() string {
	return s.String()
}

// SetProfileArn sets the ProfileArn field's value.
func (s *WorkloadProfile) SetProfileArn(v string) *WorkloadProfile {
	s.ProfileArn = &v
	return s
}

// SetProfileVersion sets the ProfileVersion field's value.
func (s *WorkloadProfile) SetProfileVersion(v string) *WorkloadProfile {
	s.ProfileVersion = &v
	return s
}

// A workload share return object.
type WorkloadShare struct {
	_ struct{} `type:"structure"`

	// Permission granted on a share request.
	PermissionType *string `type:"string" enum:"PermissionType"`

	// The ID associated with the share.
	ShareId *string `type:"string"`

	// An Amazon Web Services account ID.
	SharedBy *string `min:"12" type:"string"`

	// The Amazon Web Services account ID, organization ID, or organizational unit
	// (OU) ID with which the workload, lens, profile, or review template is shared.
	SharedWith *string `min:"12" type:"string"`

	// The status of the share request.
	Status *string `type:"string" enum:"ShareStatus"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`

	// The name of the workload.
	//
	// The name must be unique within an account within an Amazon Web Services Region.
	// Spaces and capitalization are ignored when checking for uniqueness.
	WorkloadName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadShare) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadShare) GoString() string {
	return s.String()
}

// SetPermissionType sets the PermissionType field's value.
func (s *WorkloadShare) SetPermissionType(v string) *WorkloadShare {
	s.PermissionType = &v
	return s
}

// SetShareId sets the ShareId field's value.
func (s *WorkloadShare) SetShareId(v string) *WorkloadShare {
	s.ShareId = &v
	return s
}

// SetSharedBy sets the SharedBy field's value.
func (s *WorkloadShare) SetSharedBy(v string) *WorkloadShare {
	s.SharedBy = &v
	return s
}

// SetSharedWith sets the SharedWith field's value.
func (s *WorkloadShare) SetSharedWith(v string) *WorkloadShare {
	s.SharedWith = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorkloadShare) SetStatus(v string) *WorkloadShare {
	s.Status = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *WorkloadShare) SetWorkloadId(v string) *WorkloadShare {
	s.WorkloadId = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *WorkloadShare) SetWorkloadName(v string) *WorkloadShare {
	s.WorkloadName = &v
	return s
}

// A workload share summary return object.
type WorkloadShareSummary struct {
	_ struct{} `type:"structure"`

	// Permission granted on a share request.
	PermissionType *string `type:"string" enum:"PermissionType"`

	// The ID associated with the share.
	ShareId *string `type:"string"`

	// The Amazon Web Services account ID, organization ID, or organizational unit
	// (OU) ID with which the workload, lens, profile, or review template is shared.
	SharedWith *string `min:"12" type:"string"`

	// The status of the share request.
	Status *string `type:"string" enum:"ShareStatus"`

	// Optional message to compliment the Status field.
	StatusMessage *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadShareSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadShareSummary) GoString() string {
	return s.String()
}

// SetPermissionType sets the PermissionType field's value.
func (s *WorkloadShareSummary) SetPermissionType(v string) *WorkloadShareSummary {
	s.PermissionType = &v
	return s
}

// SetShareId sets the ShareId field's value.
func (s *WorkloadShareSummary) SetShareId(v string) *WorkloadShareSummary {
	s.ShareId = &v
	return s
}

// SetSharedWith sets the SharedWith field's value.
func (s *WorkloadShareSummary) SetSharedWith(v string) *WorkloadShareSummary {
	s.SharedWith = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorkloadShareSummary) SetStatus(v string) *WorkloadShareSummary {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *WorkloadShareSummary) SetStatusMessage(v string) *WorkloadShareSummary {
	s.StatusMessage = &v
	return s
}

// A workload summary return object.
type WorkloadSummary struct {
	_ struct{} `type:"structure"`

	// The improvement status for a workload.
	ImprovementStatus *string `type:"string" enum:"WorkloadImprovementStatus"`

	// The list of lenses associated with the workload. Each lens is identified
	// by its LensSummary$LensAlias.
	//
	// If a review template that specifies lenses is applied to the workload, those
	// lenses are applied to the workload in addition to these lenses.
	Lenses []*string `type:"list"`

	// An Amazon Web Services account ID.
	Owner *string `min:"12" type:"string"`

	// A map from risk names to the count of how many questions have that rating.
	PrioritizedRiskCounts map[string]*int64 `type:"map"`

	// Profile associated with a workload.
	Profiles []*WorkloadProfile `type:"list"`

	// A map from risk names to the count of how many questions have that rating.
	RiskCounts map[string]*int64 `type:"map"`

	// The date and time recorded.
	UpdatedAt *time.Time `type:"timestamp"`

	// The ARN for the workload.
	WorkloadArn *string `type:"string"`

	// The ID assigned to the workload. This ID is unique within an Amazon Web Services
	// Region.
	WorkloadId *string `min:"32" type:"string"`

	// The name of the workload.
	//
	// The name must be unique within an account within an Amazon Web Services Region.
	// Spaces and capitalization are ignored when checking for uniqueness.
	WorkloadName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkloadSummary) GoString() string {
	return s.String()
}

// SetImprovementStatus sets the ImprovementStatus field's value.
func (s *WorkloadSummary) SetImprovementStatus(v string) *WorkloadSummary {
	s.ImprovementStatus = &v
	return s
}

// SetLenses sets the Lenses field's value.
func (s *WorkloadSummary) SetLenses(v []*string) *WorkloadSummary {
	s.Lenses = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *WorkloadSummary) SetOwner(v string) *WorkloadSummary {
	s.Owner = &v
	return s
}

// SetPrioritizedRiskCounts sets the PrioritizedRiskCounts field's value.
func (s *WorkloadSummary) SetPrioritizedRiskCounts(v map[string]*int64) *WorkloadSummary {
	s.PrioritizedRiskCounts = v
	return s
}

// SetProfiles sets the Profiles field's value.
func (s *WorkloadSummary) SetProfiles(v []*WorkloadProfile) *WorkloadSummary {
	s.Profiles = v
	return s
}

// SetRiskCounts sets the RiskCounts field's value.
func (s *WorkloadSummary) SetRiskCounts(v map[string]*int64) *WorkloadSummary {
	s.RiskCounts = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *WorkloadSummary) SetUpdatedAt(v time.Time) *WorkloadSummary {
	s.UpdatedAt = &v
	return s
}

// SetWorkloadArn sets the WorkloadArn field's value.
func (s *WorkloadSummary) SetWorkloadArn(v string) *WorkloadSummary {
	s.WorkloadArn = &v
	return s
}

// SetWorkloadId sets the WorkloadId field's value.
func (s *WorkloadSummary) SetWorkloadId(v string) *WorkloadSummary {
	s.WorkloadId = &v
	return s
}

// SetWorkloadName sets the WorkloadName field's value.
func (s *WorkloadSummary) SetWorkloadName(v string) *WorkloadSummary {
	s.WorkloadName = &v
	return s
}

const (
	// AccountJiraIssueManagementStatusEnabled is a AccountJiraIssueManagementStatus enum value
	AccountJiraIssueManagementStatusEnabled = "ENABLED"

	// AccountJiraIssueManagementStatusDisabled is a AccountJiraIssueManagementStatus enum value
	AccountJiraIssueManagementStatusDisabled = "DISABLED"
)

// AccountJiraIssueManagementStatus_Values returns all elements of the AccountJiraIssueManagementStatus enum
func AccountJiraIssueManagementStatus_Values() []string {
	return []string{
		AccountJiraIssueManagementStatusEnabled,
		AccountJiraIssueManagementStatusDisabled,
	}
}

const (
	// AdditionalResourceTypeHelpfulResource is a AdditionalResourceType enum value
	AdditionalResourceTypeHelpfulResource = "HELPFUL_RESOURCE"

	// AdditionalResourceTypeImprovementPlan is a AdditionalResourceType enum value
	AdditionalResourceTypeImprovementPlan = "IMPROVEMENT_PLAN"
)

// AdditionalResourceType_Values returns all elements of the AdditionalResourceType enum
func AdditionalResourceType_Values() []string {
	return []string{
		AdditionalResourceTypeHelpfulResource,
		AdditionalResourceTypeImprovementPlan,
	}
}

const (
	// AnswerReasonOutOfScope is a AnswerReason enum value
	AnswerReasonOutOfScope = "OUT_OF_SCOPE"

	// AnswerReasonBusinessPriorities is a AnswerReason enum value
	AnswerReasonBusinessPriorities = "BUSINESS_PRIORITIES"

	// AnswerReasonArchitectureConstraints is a AnswerReason enum value
	AnswerReasonArchitectureConstraints = "ARCHITECTURE_CONSTRAINTS"

	// AnswerReasonOther is a AnswerReason enum value
	AnswerReasonOther = "OTHER"

	// AnswerReasonNone is a AnswerReason enum value
	AnswerReasonNone = "NONE"
)

// AnswerReason_Values returns all elements of the AnswerReason enum
func AnswerReason_Values() []string {
	return []string{
		AnswerReasonOutOfScope,
		AnswerReasonBusinessPriorities,
		AnswerReasonArchitectureConstraints,
		AnswerReasonOther,
		AnswerReasonNone,
	}
}

const (
	// CheckFailureReasonAssumeRoleError is a CheckFailureReason enum value
	CheckFailureReasonAssumeRoleError = "ASSUME_ROLE_ERROR"

	// CheckFailureReasonAccessDenied is a CheckFailureReason enum value
	CheckFailureReasonAccessDenied = "ACCESS_DENIED"

	// CheckFailureReasonUnknownError is a CheckFailureReason enum value
	CheckFailureReasonUnknownError = "UNKNOWN_ERROR"

	// CheckFailureReasonPremiumSupportRequired is a CheckFailureReason enum value
	CheckFailureReasonPremiumSupportRequired = "PREMIUM_SUPPORT_REQUIRED"
)

// CheckFailureReason_Values returns all elements of the CheckFailureReason enum
func CheckFailureReason_Values() []string {
	return []string{
		CheckFailureReasonAssumeRoleError,
		CheckFailureReasonAccessDenied,
		CheckFailureReasonUnknownError,
		CheckFailureReasonPremiumSupportRequired,
	}
}

const (
	// CheckProviderTrustedAdvisor is a CheckProvider enum value
	CheckProviderTrustedAdvisor = "TRUSTED_ADVISOR"
)

// CheckProvider_Values returns all elements of the CheckProvider enum
func CheckProvider_Values() []string {
	return []string{
		CheckProviderTrustedAdvisor,
	}
}

const (
	// CheckStatusOkay is a CheckStatus enum value
	CheckStatusOkay = "OKAY"

	// CheckStatusWarning is a CheckStatus enum value
	CheckStatusWarning = "WARNING"

	// CheckStatusError is a CheckStatus enum value
	CheckStatusError = "ERROR"

	// CheckStatusNotAvailable is a CheckStatus enum value
	CheckStatusNotAvailable = "NOT_AVAILABLE"

	// CheckStatusFetchFailed is a CheckStatus enum value
	CheckStatusFetchFailed = "FETCH_FAILED"
)

// CheckStatus_Values returns all elements of the CheckStatus enum
func CheckStatus_Values() []string {
	return []string{
		CheckStatusOkay,
		CheckStatusWarning,
		CheckStatusError,
		CheckStatusNotAvailable,
		CheckStatusFetchFailed,
	}
}

const (
	// ChoiceReasonOutOfScope is a ChoiceReason enum value
	ChoiceReasonOutOfScope = "OUT_OF_SCOPE"

	// ChoiceReasonBusinessPriorities is a ChoiceReason enum value
	ChoiceReasonBusinessPriorities = "BUSINESS_PRIORITIES"

	// ChoiceReasonArchitectureConstraints is a ChoiceReason enum value
	ChoiceReasonArchitectureConstraints = "ARCHITECTURE_CONSTRAINTS"

	// ChoiceReasonOther is a ChoiceReason enum value
	ChoiceReasonOther = "OTHER"

	// ChoiceReasonNone is a ChoiceReason enum value
	ChoiceReasonNone = "NONE"
)

// ChoiceReason_Values returns all elements of the ChoiceReason enum
func ChoiceReason_Values() []string {
	return []string{
		ChoiceReasonOutOfScope,
		ChoiceReasonBusinessPriorities,
		ChoiceReasonArchitectureConstraints,
		ChoiceReasonOther,
		ChoiceReasonNone,
	}
}

const (
	// ChoiceStatusSelected is a ChoiceStatus enum value
	ChoiceStatusSelected = "SELECTED"

	// ChoiceStatusNotApplicable is a ChoiceStatus enum value
	ChoiceStatusNotApplicable = "NOT_APPLICABLE"

	// ChoiceStatusUnselected is a ChoiceStatus enum value
	ChoiceStatusUnselected = "UNSELECTED"
)

// ChoiceStatus_Values returns all elements of the ChoiceStatus enum
func ChoiceStatus_Values() []string {
	return []string{
		ChoiceStatusSelected,
		ChoiceStatusNotApplicable,
		ChoiceStatusUnselected,
	}
}

const (
	// DefinitionTypeWorkloadMetadata is a DefinitionType enum value
	DefinitionTypeWorkloadMetadata = "WORKLOAD_METADATA"

	// DefinitionTypeAppRegistry is a DefinitionType enum value
	DefinitionTypeAppRegistry = "APP_REGISTRY"
)

// DefinitionType_Values returns all elements of the DefinitionType enum
func DefinitionType_Values() []string {
	return []string{
		DefinitionTypeWorkloadMetadata,
		DefinitionTypeAppRegistry,
	}
}

const (
	// DifferenceStatusUpdated is a DifferenceStatus enum value
	DifferenceStatusUpdated = "UPDATED"

	// DifferenceStatusNew is a DifferenceStatus enum value
	DifferenceStatusNew = "NEW"

	// DifferenceStatusDeleted is a DifferenceStatus enum value
	DifferenceStatusDeleted = "DELETED"
)

// DifferenceStatus_Values returns all elements of the DifferenceStatus enum
func DifferenceStatus_Values() []string {
	return []string{
		DifferenceStatusUpdated,
		DifferenceStatusNew,
		DifferenceStatusDeleted,
	}
}

const (
	// DiscoveryIntegrationStatusEnabled is a DiscoveryIntegrationStatus enum value
	DiscoveryIntegrationStatusEnabled = "ENABLED"

	// DiscoveryIntegrationStatusDisabled is a DiscoveryIntegrationStatus enum value
	DiscoveryIntegrationStatusDisabled = "DISABLED"
)

// DiscoveryIntegrationStatus_Values returns all elements of the DiscoveryIntegrationStatus enum
func DiscoveryIntegrationStatus_Values() []string {
	return []string{
		DiscoveryIntegrationStatusEnabled,
		DiscoveryIntegrationStatusDisabled,
	}
}

const (
	// ImportLensStatusInProgress is a ImportLensStatus enum value
	ImportLensStatusInProgress = "IN_PROGRESS"

	// ImportLensStatusComplete is a ImportLensStatus enum value
	ImportLensStatusComplete = "COMPLETE"

	// ImportLensStatusError is a ImportLensStatus enum value
	ImportLensStatusError = "ERROR"
)

// ImportLensStatus_Values returns all elements of the ImportLensStatus enum
func ImportLensStatus_Values() []string {
	return []string{
		ImportLensStatusInProgress,
		ImportLensStatusComplete,
		ImportLensStatusError,
	}
}

const (
	// IntegratingServiceJira is a IntegratingService enum value
	IntegratingServiceJira = "JIRA"
)

// IntegratingService_Values returns all elements of the IntegratingService enum
func IntegratingService_Values() []string {
	return []string{
		IntegratingServiceJira,
	}
}

const (
	// IntegrationStatusConfigured is a IntegrationStatus enum value
	IntegrationStatusConfigured = "CONFIGURED"

	// IntegrationStatusNotConfigured is a IntegrationStatus enum value
	IntegrationStatusNotConfigured = "NOT_CONFIGURED"
)

// IntegrationStatus_Values returns all elements of the IntegrationStatus enum
func IntegrationStatus_Values() []string {
	return []string{
		IntegrationStatusConfigured,
		IntegrationStatusNotConfigured,
	}
}

const (
	// IntegrationStatusInputNotConfigured is a IntegrationStatusInput_ enum value
	IntegrationStatusInputNotConfigured = "NOT_CONFIGURED"
)

// IntegrationStatusInput__Values returns all elements of the IntegrationStatusInput_ enum
func IntegrationStatusInput__Values() []string {
	return []string{
		IntegrationStatusInputNotConfigured,
	}
}

const (
	// IssueManagementTypeAuto is a IssueManagementType enum value
	IssueManagementTypeAuto = "AUTO"

	// IssueManagementTypeManual is a IssueManagementType enum value
	IssueManagementTypeManual = "MANUAL"
)

// IssueManagementType_Values returns all elements of the IssueManagementType enum
func IssueManagementType_Values() []string {
	return []string{
		IssueManagementTypeAuto,
		IssueManagementTypeManual,
	}
}

const (
	// LensStatusCurrent is a LensStatus enum value
	LensStatusCurrent = "CURRENT"

	// LensStatusNotCurrent is a LensStatus enum value
	LensStatusNotCurrent = "NOT_CURRENT"

	// LensStatusDeprecated is a LensStatus enum value
	LensStatusDeprecated = "DEPRECATED"

	// LensStatusDeleted is a LensStatus enum value
	LensStatusDeleted = "DELETED"

	// LensStatusUnshared is a LensStatus enum value
	LensStatusUnshared = "UNSHARED"
)

// LensStatus_Values returns all elements of the LensStatus enum
func LensStatus_Values() []string {
	return []string{
		LensStatusCurrent,
		LensStatusNotCurrent,
		LensStatusDeprecated,
		LensStatusDeleted,
		LensStatusUnshared,
	}
}

const (
	// LensStatusTypeAll is a LensStatusType enum value
	LensStatusTypeAll = "ALL"

	// LensStatusTypeDraft is a LensStatusType enum value
	LensStatusTypeDraft = "DRAFT"

	// LensStatusTypePublished is a LensStatusType enum value
	LensStatusTypePublished = "PUBLISHED"
)

// LensStatusType_Values returns all elements of the LensStatusType enum
func LensStatusType_Values() []string {
	return []string{
		LensStatusTypeAll,
		LensStatusTypeDraft,
		LensStatusTypePublished,
	}
}

const (
	// LensTypeAwsOfficial is a LensType enum value
	LensTypeAwsOfficial = "AWS_OFFICIAL"

	// LensTypeCustomShared is a LensType enum value
	LensTypeCustomShared = "CUSTOM_SHARED"

	// LensTypeCustomSelf is a LensType enum value
	LensTypeCustomSelf = "CUSTOM_SELF"
)

// LensType_Values returns all elements of the LensType enum
func LensType_Values() []string {
	return []string{
		LensTypeAwsOfficial,
		LensTypeCustomShared,
		LensTypeCustomSelf,
	}
}

const (
	// MetricTypeWorkload is a MetricType enum value
	MetricTypeWorkload = "WORKLOAD"
)

// MetricType_Values returns all elements of the MetricType enum
func MetricType_Values() []string {
	return []string{
		MetricTypeWorkload,
	}
}

const (
	// NotificationTypeLensVersionUpgraded is a NotificationType enum value
	NotificationTypeLensVersionUpgraded = "LENS_VERSION_UPGRADED"

	// NotificationTypeLensVersionDeprecated is a NotificationType enum value
	NotificationTypeLensVersionDeprecated = "LENS_VERSION_DEPRECATED"
)

// NotificationType_Values returns all elements of the NotificationType enum
func NotificationType_Values() []string {
	return []string{
		NotificationTypeLensVersionUpgraded,
		NotificationTypeLensVersionDeprecated,
	}
}

const (
	// OrganizationSharingStatusEnabled is a OrganizationSharingStatus enum value
	OrganizationSharingStatusEnabled = "ENABLED"

	// OrganizationSharingStatusDisabled is a OrganizationSharingStatus enum value
	OrganizationSharingStatusDisabled = "DISABLED"
)

// OrganizationSharingStatus_Values returns all elements of the OrganizationSharingStatus enum
func OrganizationSharingStatus_Values() []string {
	return []string{
		OrganizationSharingStatusEnabled,
		OrganizationSharingStatusDisabled,
	}
}

// Permission granted on a share request.
const (
	// PermissionTypeReadonly is a PermissionType enum value
	PermissionTypeReadonly = "READONLY"

	// PermissionTypeContributor is a PermissionType enum value
	PermissionTypeContributor = "CONTRIBUTOR"
)

// PermissionType_Values returns all elements of the PermissionType enum
func PermissionType_Values() []string {
	return []string{
		PermissionTypeReadonly,
		PermissionTypeContributor,
	}
}

const (
	// ProfileNotificationTypeProfileAnswersUpdated is a ProfileNotificationType enum value
	ProfileNotificationTypeProfileAnswersUpdated = "PROFILE_ANSWERS_UPDATED"

	// ProfileNotificationTypeProfileDeleted is a ProfileNotificationType enum value
	ProfileNotificationTypeProfileDeleted = "PROFILE_DELETED"
)

// ProfileNotificationType_Values returns all elements of the ProfileNotificationType enum
func ProfileNotificationType_Values() []string {
	return []string{
		ProfileNotificationTypeProfileAnswersUpdated,
		ProfileNotificationTypeProfileDeleted,
	}
}

const (
	// ProfileOwnerTypeSelf is a ProfileOwnerType enum value
	ProfileOwnerTypeSelf = "SELF"

	// ProfileOwnerTypeShared is a ProfileOwnerType enum value
	ProfileOwnerTypeShared = "SHARED"
)

// ProfileOwnerType_Values returns all elements of the ProfileOwnerType enum
func ProfileOwnerType_Values() []string {
	return []string{
		ProfileOwnerTypeSelf,
		ProfileOwnerTypeShared,
	}
}

const (
	// QuestionUnanswered is a Question enum value
	QuestionUnanswered = "UNANSWERED"

	// QuestionAnswered is a Question enum value
	QuestionAnswered = "ANSWERED"
)

// Question_Values returns all elements of the Question enum
func Question_Values() []string {
	return []string{
		QuestionUnanswered,
		QuestionAnswered,
	}
}

const (
	// QuestionPriorityPrioritized is a QuestionPriority enum value
	QuestionPriorityPrioritized = "PRIORITIZED"

	// QuestionPriorityNone is a QuestionPriority enum value
	QuestionPriorityNone = "NONE"
)

// QuestionPriority_Values returns all elements of the QuestionPriority enum
func QuestionPriority_Values() []string {
	return []string{
		QuestionPriorityPrioritized,
		QuestionPriorityNone,
	}
}

const (
	// QuestionTypePrioritized is a QuestionType enum value
	QuestionTypePrioritized = "PRIORITIZED"

	// QuestionTypeNonPrioritized is a QuestionType enum value
	QuestionTypeNonPrioritized = "NON_PRIORITIZED"
)

// QuestionType_Values returns all elements of the QuestionType enum
func QuestionType_Values() []string {
	return []string{
		QuestionTypePrioritized,
		QuestionTypeNonPrioritized,
	}
}

const (
	// ReportFormatPdf is a ReportFormat enum value
	ReportFormatPdf = "PDF"

	// ReportFormatJson is a ReportFormat enum value
	ReportFormatJson = "JSON"
)

// ReportFormat_Values returns all elements of the ReportFormat enum
func ReportFormat_Values() []string {
	return []string{
		ReportFormatPdf,
		ReportFormatJson,
	}
}

const (
	// ReviewTemplateAnswerStatusUnanswered is a ReviewTemplateAnswerStatus enum value
	ReviewTemplateAnswerStatusUnanswered = "UNANSWERED"

	// ReviewTemplateAnswerStatusAnswered is a ReviewTemplateAnswerStatus enum value
	ReviewTemplateAnswerStatusAnswered = "ANSWERED"
)

// ReviewTemplateAnswerStatus_Values returns all elements of the ReviewTemplateAnswerStatus enum
func ReviewTemplateAnswerStatus_Values() []string {
	return []string{
		ReviewTemplateAnswerStatusUnanswered,
		ReviewTemplateAnswerStatusAnswered,
	}
}

const (
	// ReviewTemplateUpdateStatusCurrent is a ReviewTemplateUpdateStatus enum value
	ReviewTemplateUpdateStatusCurrent = "CURRENT"

	// ReviewTemplateUpdateStatusLensNotCurrent is a ReviewTemplateUpdateStatus enum value
	ReviewTemplateUpdateStatusLensNotCurrent = "LENS_NOT_CURRENT"
)

// ReviewTemplateUpdateStatus_Values returns all elements of the ReviewTemplateUpdateStatus enum
func ReviewTemplateUpdateStatus_Values() []string {
	return []string{
		ReviewTemplateUpdateStatusCurrent,
		ReviewTemplateUpdateStatusLensNotCurrent,
	}
}

// The risk for a given workload, lens review, pillar, or question.
const (
	// RiskUnanswered is a Risk enum value
	RiskUnanswered = "UNANSWERED"

	// RiskHigh is a Risk enum value
	RiskHigh = "HIGH"

	// RiskMedium is a Risk enum value
	RiskMedium = "MEDIUM"

	// RiskNone is a Risk enum value
	RiskNone = "NONE"

	// RiskNotApplicable is a Risk enum value
	RiskNotApplicable = "NOT_APPLICABLE"
)

// Risk_Values returns all elements of the Risk enum
func Risk_Values() []string {
	return []string{
		RiskUnanswered,
		RiskHigh,
		RiskMedium,
		RiskNone,
		RiskNotApplicable,
	}
}

// Share invitation action taken by contributor.
const (
	// ShareInvitationActionAccept is a ShareInvitationAction enum value
	ShareInvitationActionAccept = "ACCEPT"

	// ShareInvitationActionReject is a ShareInvitationAction enum value
	ShareInvitationActionReject = "REJECT"
)

// ShareInvitationAction_Values returns all elements of the ShareInvitationAction enum
func ShareInvitationAction_Values() []string {
	return []string{
		ShareInvitationActionAccept,
		ShareInvitationActionReject,
	}
}

const (
	// ShareResourceTypeWorkload is a ShareResourceType enum value
	ShareResourceTypeWorkload = "WORKLOAD"

	// ShareResourceTypeLens is a ShareResourceType enum value
	ShareResourceTypeLens = "LENS"

	// ShareResourceTypeProfile is a ShareResourceType enum value
	ShareResourceTypeProfile = "PROFILE"

	// ShareResourceTypeTemplate is a ShareResourceType enum value
	ShareResourceTypeTemplate = "TEMPLATE"
)

// ShareResourceType_Values returns all elements of the ShareResourceType enum
func ShareResourceType_Values() []string {
	return []string{
		ShareResourceTypeWorkload,
		ShareResourceTypeLens,
		ShareResourceTypeProfile,
		ShareResourceTypeTemplate,
	}
}

// The status of the share request.
const (
	// ShareStatusAccepted is a ShareStatus enum value
	ShareStatusAccepted = "ACCEPTED"

	// ShareStatusRejected is a ShareStatus enum value
	ShareStatusRejected = "REJECTED"

	// ShareStatusPending is a ShareStatus enum value
	ShareStatusPending = "PENDING"

	// ShareStatusRevoked is a ShareStatus enum value
	ShareStatusRevoked = "REVOKED"

	// ShareStatusExpired is a ShareStatus enum value
	ShareStatusExpired = "EXPIRED"

	// ShareStatusAssociating is a ShareStatus enum value
	ShareStatusAssociating = "ASSOCIATING"

	// ShareStatusAssociated is a ShareStatus enum value
	ShareStatusAssociated = "ASSOCIATED"

	// ShareStatusFailed is a ShareStatus enum value
	ShareStatusFailed = "FAILED"
)

// ShareStatus_Values returns all elements of the ShareStatus enum
func ShareStatus_Values() []string {
	return []string{
		ShareStatusAccepted,
		ShareStatusRejected,
		ShareStatusPending,
		ShareStatusRevoked,
		ShareStatusExpired,
		ShareStatusAssociating,
		ShareStatusAssociated,
		ShareStatusFailed,
	}
}

const (
	// TrustedAdvisorIntegrationStatusEnabled is a TrustedAdvisorIntegrationStatus enum value
	TrustedAdvisorIntegrationStatusEnabled = "ENABLED"

	// TrustedAdvisorIntegrationStatusDisabled is a TrustedAdvisorIntegrationStatus enum value
	TrustedAdvisorIntegrationStatusDisabled = "DISABLED"
)

// TrustedAdvisorIntegrationStatus_Values returns all elements of the TrustedAdvisorIntegrationStatus enum
func TrustedAdvisorIntegrationStatus_Values() []string {
	return []string{
		TrustedAdvisorIntegrationStatusEnabled,
		TrustedAdvisorIntegrationStatusDisabled,
	}
}

// The reason why the request failed validation.
const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}

// The environment for the workload.
const (
	// WorkloadEnvironmentProduction is a WorkloadEnvironment enum value
	WorkloadEnvironmentProduction = "PRODUCTION"

	// WorkloadEnvironmentPreproduction is a WorkloadEnvironment enum value
	WorkloadEnvironmentPreproduction = "PREPRODUCTION"
)

// WorkloadEnvironment_Values returns all elements of the WorkloadEnvironment enum
func WorkloadEnvironment_Values() []string {
	return []string{
		WorkloadEnvironmentProduction,
		WorkloadEnvironmentPreproduction,
	}
}

// The improvement status for a workload.
const (
	// WorkloadImprovementStatusNotApplicable is a WorkloadImprovementStatus enum value
	WorkloadImprovementStatusNotApplicable = "NOT_APPLICABLE"

	// WorkloadImprovementStatusNotStarted is a WorkloadImprovementStatus enum value
	WorkloadImprovementStatusNotStarted = "NOT_STARTED"

	// WorkloadImprovementStatusInProgress is a WorkloadImprovementStatus enum value
	WorkloadImprovementStatusInProgress = "IN_PROGRESS"

	// WorkloadImprovementStatusComplete is a WorkloadImprovementStatus enum value
	WorkloadImprovementStatusComplete = "COMPLETE"

	// WorkloadImprovementStatusRiskAcknowledged is a WorkloadImprovementStatus enum value
	WorkloadImprovementStatusRiskAcknowledged = "RISK_ACKNOWLEDGED"
)

// WorkloadImprovementStatus_Values returns all elements of the WorkloadImprovementStatus enum
func WorkloadImprovementStatus_Values() []string {
	return []string{
		WorkloadImprovementStatusNotApplicable,
		WorkloadImprovementStatusNotStarted,
		WorkloadImprovementStatusInProgress,
		WorkloadImprovementStatusComplete,
		WorkloadImprovementStatusRiskAcknowledged,
	}
}

const (
	// WorkloadIssueManagementStatusEnabled is a WorkloadIssueManagementStatus enum value
	WorkloadIssueManagementStatusEnabled = "ENABLED"

	// WorkloadIssueManagementStatusDisabled is a WorkloadIssueManagementStatus enum value
	WorkloadIssueManagementStatusDisabled = "DISABLED"

	// WorkloadIssueManagementStatusInherit is a WorkloadIssueManagementStatus enum value
	WorkloadIssueManagementStatusInherit = "INHERIT"
)

// WorkloadIssueManagementStatus_Values returns all elements of the WorkloadIssueManagementStatus enum
func WorkloadIssueManagementStatus_Values() []string {
	return []string{
		WorkloadIssueManagementStatusEnabled,
		WorkloadIssueManagementStatusDisabled,
		WorkloadIssueManagementStatusInherit,
	}
}
