// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/resolve.proto

package registryv1alpha1

import (
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/module/v1alpha1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ResolvedReferenceType int32

const (
	ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_UNSPECIFIED ResolvedReferenceType = 0
	ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_COMMIT      ResolvedReferenceType = 1
	ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_BRANCH      ResolvedReferenceType = 2
	ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_TAG         ResolvedReferenceType = 3
	ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_DRAFT       ResolvedReferenceType = 5
)

// Enum value maps for ResolvedReferenceType.
var (
	ResolvedReferenceType_name = map[int32]string{
		0: "RESOLVED_REFERENCE_TYPE_UNSPECIFIED",
		1: "RESOLVED_REFERENCE_TYPE_COMMIT",
		2: "RESOLVED_REFERENCE_TYPE_BRANCH",
		3: "RESOLVED_REFERENCE_TYPE_TAG",
		5: "RESOLVED_REFERENCE_TYPE_DRAFT",
	}
	ResolvedReferenceType_value = map[string]int32{
		"RESOLVED_REFERENCE_TYPE_UNSPECIFIED": 0,
		"RESOLVED_REFERENCE_TYPE_COMMIT":      1,
		"RESOLVED_REFERENCE_TYPE_BRANCH":      2,
		"RESOLVED_REFERENCE_TYPE_TAG":         3,
		"RESOLVED_REFERENCE_TYPE_DRAFT":       5,
	}
)

func (x ResolvedReferenceType) Enum() *ResolvedReferenceType {
	p := new(ResolvedReferenceType)
	*p = x
	return p
}

func (x ResolvedReferenceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResolvedReferenceType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_enumTypes[0].Descriptor()
}

func (ResolvedReferenceType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_resolve_proto_enumTypes[0]
}

func (x ResolvedReferenceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type GetModulePinsRequest struct {
	state                        protoimpl.MessageState       `protogen:"opaque.v1"`
	xxx_hidden_ModuleReferences  *[]*v1alpha1.ModuleReference `protobuf:"bytes,1,rep,name=module_references,json=moduleReferences,proto3"`
	xxx_hidden_CurrentModulePins *[]*v1alpha1.ModulePin       `protobuf:"bytes,2,rep,name=current_module_pins,json=currentModulePins,proto3"`
	unknownFields                protoimpl.UnknownFields
	sizeCache                    protoimpl.SizeCache
}

func (x *GetModulePinsRequest) Reset() {
	*x = GetModulePinsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetModulePinsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModulePinsRequest) ProtoMessage() {}

func (x *GetModulePinsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetModulePinsRequest) GetModuleReferences() []*v1alpha1.ModuleReference {
	if x != nil {
		if x.xxx_hidden_ModuleReferences != nil {
			return *x.xxx_hidden_ModuleReferences
		}
	}
	return nil
}

func (x *GetModulePinsRequest) GetCurrentModulePins() []*v1alpha1.ModulePin {
	if x != nil {
		if x.xxx_hidden_CurrentModulePins != nil {
			return *x.xxx_hidden_CurrentModulePins
		}
	}
	return nil
}

func (x *GetModulePinsRequest) SetModuleReferences(v []*v1alpha1.ModuleReference) {
	x.xxx_hidden_ModuleReferences = &v
}

func (x *GetModulePinsRequest) SetCurrentModulePins(v []*v1alpha1.ModulePin) {
	x.xxx_hidden_CurrentModulePins = &v
}

type GetModulePinsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	ModuleReferences []*v1alpha1.ModuleReference
	// current_module_pins allows for partial dependency updates by letting clients
	// send a request with the pins for their current module and only the
	// identities of the dependencies they want to update in module_references.
	//
	// When resolving, if a client supplied module pin is:
	//   - in the transitive closure of pins resolved from the module_references,
	//     the client supplied module pin will be an extra candidate for tie
	//     breaking.
	//   - NOT in the in the transitive closure of pins resolved from the
	//     module_references, it will be returned as is.
	CurrentModulePins []*v1alpha1.ModulePin
}

func (b0 GetModulePinsRequest_builder) Build() *GetModulePinsRequest {
	m0 := &GetModulePinsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ModuleReferences = &b.ModuleReferences
	x.xxx_hidden_CurrentModulePins = &b.CurrentModulePins
	return m0
}

type GetModulePinsResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ModulePins *[]*v1alpha1.ModulePin `protobuf:"bytes,1,rep,name=module_pins,json=modulePins,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GetModulePinsResponse) Reset() {
	*x = GetModulePinsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetModulePinsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModulePinsResponse) ProtoMessage() {}

func (x *GetModulePinsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetModulePinsResponse) GetModulePins() []*v1alpha1.ModulePin {
	if x != nil {
		if x.xxx_hidden_ModulePins != nil {
			return *x.xxx_hidden_ModulePins
		}
	}
	return nil
}

func (x *GetModulePinsResponse) SetModulePins(v []*v1alpha1.ModulePin) {
	x.xxx_hidden_ModulePins = &v
}

type GetModulePinsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	ModulePins []*v1alpha1.ModulePin
}

func (b0 GetModulePinsResponse_builder) Build() *GetModulePinsResponse {
	m0 := &GetModulePinsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ModulePins = &b.ModulePins
	return m0
}

type GetLocalModulePinsRequest struct {
	state                            protoimpl.MessageState   `protogen:"opaque.v1"`
	xxx_hidden_LocalModuleReferences *[]*LocalModuleReference `protobuf:"bytes,1,rep,name=local_module_references,json=localModuleReferences,proto3"`
	unknownFields                    protoimpl.UnknownFields
	sizeCache                        protoimpl.SizeCache
}

func (x *GetLocalModulePinsRequest) Reset() {
	*x = GetLocalModulePinsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLocalModulePinsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLocalModulePinsRequest) ProtoMessage() {}

func (x *GetLocalModulePinsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetLocalModulePinsRequest) GetLocalModuleReferences() []*LocalModuleReference {
	if x != nil {
		if x.xxx_hidden_LocalModuleReferences != nil {
			return *x.xxx_hidden_LocalModuleReferences
		}
	}
	return nil
}

func (x *GetLocalModulePinsRequest) SetLocalModuleReferences(v []*LocalModuleReference) {
	x.xxx_hidden_LocalModuleReferences = &v
}

type GetLocalModulePinsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	LocalModuleReferences []*LocalModuleReference
}

func (b0 GetLocalModulePinsRequest_builder) Build() *GetLocalModulePinsRequest {
	m0 := &GetLocalModulePinsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_LocalModuleReferences = &b.LocalModuleReferences
	return m0
}

type LocalModuleResolveResult struct {
	state                            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Reference             *LocalModuleReference  `protobuf:"bytes,1,opt,name=reference,proto3"`
	xxx_hidden_Pin                   *LocalModulePin        `protobuf:"bytes,2,opt,name=pin,proto3"`
	xxx_hidden_ResolvedReferenceType ResolvedReferenceType  `protobuf:"varint,3,opt,name=resolved_reference_type,json=resolvedReferenceType,proto3,enum=buf.alpha.registry.v1alpha1.ResolvedReferenceType"`
	unknownFields                    protoimpl.UnknownFields
	sizeCache                        protoimpl.SizeCache
}

func (x *LocalModuleResolveResult) Reset() {
	*x = LocalModuleResolveResult{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocalModuleResolveResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalModuleResolveResult) ProtoMessage() {}

func (x *LocalModuleResolveResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *LocalModuleResolveResult) GetReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_Reference
	}
	return nil
}

func (x *LocalModuleResolveResult) GetPin() *LocalModulePin {
	if x != nil {
		return x.xxx_hidden_Pin
	}
	return nil
}

func (x *LocalModuleResolveResult) GetResolvedReferenceType() ResolvedReferenceType {
	if x != nil {
		return x.xxx_hidden_ResolvedReferenceType
	}
	return ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_UNSPECIFIED
}

func (x *LocalModuleResolveResult) SetReference(v *LocalModuleReference) {
	x.xxx_hidden_Reference = v
}

func (x *LocalModuleResolveResult) SetPin(v *LocalModulePin) {
	x.xxx_hidden_Pin = v
}

func (x *LocalModuleResolveResult) SetResolvedReferenceType(v ResolvedReferenceType) {
	x.xxx_hidden_ResolvedReferenceType = v
}

func (x *LocalModuleResolveResult) HasReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Reference != nil
}

func (x *LocalModuleResolveResult) HasPin() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Pin != nil
}

func (x *LocalModuleResolveResult) ClearReference() {
	x.xxx_hidden_Reference = nil
}

func (x *LocalModuleResolveResult) ClearPin() {
	x.xxx_hidden_Pin = nil
}

type LocalModuleResolveResult_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// A copy of the reference that was resolved.
	Reference *LocalModuleReference
	// The pin the reference resolved to.
	Pin *LocalModulePin
	// The type the reference resolved as.
	ResolvedReferenceType ResolvedReferenceType
}

func (b0 LocalModuleResolveResult_builder) Build() *LocalModuleResolveResult {
	m0 := &LocalModuleResolveResult{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Reference = b.Reference
	x.xxx_hidden_Pin = b.Pin
	x.xxx_hidden_ResolvedReferenceType = b.ResolvedReferenceType
	return m0
}

type GetLocalModulePinsResponse struct {
	state                                protoimpl.MessageState       `protogen:"opaque.v1"`
	xxx_hidden_LocalModuleResolveResults *[]*LocalModuleResolveResult `protobuf:"bytes,1,rep,name=local_module_resolve_results,json=localModuleResolveResults,proto3"`
	xxx_hidden_Dependencies              *[]*v1alpha1.ModulePin       `protobuf:"bytes,2,rep,name=dependencies,proto3"`
	unknownFields                        protoimpl.UnknownFields
	sizeCache                            protoimpl.SizeCache
}

func (x *GetLocalModulePinsResponse) Reset() {
	*x = GetLocalModulePinsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLocalModulePinsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLocalModulePinsResponse) ProtoMessage() {}

func (x *GetLocalModulePinsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetLocalModulePinsResponse) GetLocalModuleResolveResults() []*LocalModuleResolveResult {
	if x != nil {
		if x.xxx_hidden_LocalModuleResolveResults != nil {
			return *x.xxx_hidden_LocalModuleResolveResults
		}
	}
	return nil
}

func (x *GetLocalModulePinsResponse) GetDependencies() []*v1alpha1.ModulePin {
	if x != nil {
		if x.xxx_hidden_Dependencies != nil {
			return *x.xxx_hidden_Dependencies
		}
	}
	return nil
}

func (x *GetLocalModulePinsResponse) SetLocalModuleResolveResults(v []*LocalModuleResolveResult) {
	x.xxx_hidden_LocalModuleResolveResults = &v
}

func (x *GetLocalModulePinsResponse) SetDependencies(v []*v1alpha1.ModulePin) {
	x.xxx_hidden_Dependencies = &v
}

type GetLocalModulePinsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	LocalModuleResolveResults []*LocalModuleResolveResult
	// dependencies are the dependencies of the LocalModulePins.
	//
	// This includes the transitive deps.
	Dependencies []*v1alpha1.ModulePin
}

func (b0 GetLocalModulePinsResponse_builder) Build() *GetLocalModulePinsResponse {
	m0 := &GetLocalModulePinsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_LocalModuleResolveResults = &b.LocalModuleResolveResults
	x.xxx_hidden_Dependencies = &b.Dependencies
	return m0
}

type GetGoVersionRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetGoVersionRequest) Reset() {
	*x = GetGoVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGoVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGoVersionRequest) ProtoMessage() {}

func (x *GetGoVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetGoVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetGoVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetGoVersionRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetGoVersionRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetGoVersionRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetGoVersionRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetGoVersionRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *GetGoVersionRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

type GetGoVersionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin
	// The module reference to resolve.
	ModuleReference *LocalModuleReference
}

func (b0 GetGoVersionRequest_builder) Build() *GetGoVersionRequest {
	m0 := &GetGoVersionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_ModuleReference = b.ModuleReference
	return m0
}

type GetGoVersionResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetGoVersionResponse) Reset() {
	*x = GetGoVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGoVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGoVersionResponse) ProtoMessage() {}

func (x *GetGoVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetGoVersionResponse) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetGoVersionResponse) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GetGoVersionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// version is the resolved version to be used with the go module proxy.
	Version string
}

func (b0 GetGoVersionResponse_builder) Build() *GetGoVersionResponse {
	m0 := &GetGoVersionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	return m0
}

type GetMavenVersionRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetMavenVersionRequest) Reset() {
	*x = GetMavenVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMavenVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMavenVersionRequest) ProtoMessage() {}

func (x *GetMavenVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetMavenVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetMavenVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetMavenVersionRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetMavenVersionRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetMavenVersionRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetMavenVersionRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetMavenVersionRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *GetMavenVersionRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

type GetMavenVersionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin
	// The module reference to resolve.
	ModuleReference *LocalModuleReference
}

func (b0 GetMavenVersionRequest_builder) Build() *GetMavenVersionRequest {
	m0 := &GetMavenVersionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_ModuleReference = b.ModuleReference
	return m0
}

type GetMavenVersionResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetMavenVersionResponse) Reset() {
	*x = GetMavenVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMavenVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMavenVersionResponse) ProtoMessage() {}

func (x *GetMavenVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetMavenVersionResponse) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetMavenVersionResponse) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GetMavenVersionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// version is the resolved version to be used with the maven repository.
	Version string
}

func (b0 GetMavenVersionResponse_builder) Build() *GetMavenVersionResponse {
	m0 := &GetMavenVersionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	return m0
}

type GetNPMVersionRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetNPMVersionRequest) Reset() {
	*x = GetNPMVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNPMVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNPMVersionRequest) ProtoMessage() {}

func (x *GetNPMVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetNPMVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetNPMVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetNPMVersionRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetNPMVersionRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetNPMVersionRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetNPMVersionRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetNPMVersionRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *GetNPMVersionRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

type GetNPMVersionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin
	// The module reference to resolve.
	ModuleReference *LocalModuleReference
}

func (b0 GetNPMVersionRequest_builder) Build() *GetNPMVersionRequest {
	m0 := &GetNPMVersionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_ModuleReference = b.ModuleReference
	return m0
}

type GetNPMVersionResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetNPMVersionResponse) Reset() {
	*x = GetNPMVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNPMVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNPMVersionResponse) ProtoMessage() {}

func (x *GetNPMVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetNPMVersionResponse) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetNPMVersionResponse) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GetNPMVersionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// version is the resolved version to be used with the npm registry.
	Version string
}

func (b0 GetNPMVersionResponse_builder) Build() *GetNPMVersionResponse {
	m0 := &GetNPMVersionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	return m0
}

type GetSwiftVersionRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetSwiftVersionRequest) Reset() {
	*x = GetSwiftVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSwiftVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSwiftVersionRequest) ProtoMessage() {}

func (x *GetSwiftVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetSwiftVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetSwiftVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetSwiftVersionRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetSwiftVersionRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetSwiftVersionRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetSwiftVersionRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetSwiftVersionRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *GetSwiftVersionRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

type GetSwiftVersionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin
	// The module reference to resolve.
	ModuleReference *LocalModuleReference
}

func (b0 GetSwiftVersionRequest_builder) Build() *GetSwiftVersionRequest {
	m0 := &GetSwiftVersionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_ModuleReference = b.ModuleReference
	return m0
}

type GetSwiftVersionResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetSwiftVersionResponse) Reset() {
	*x = GetSwiftVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSwiftVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSwiftVersionResponse) ProtoMessage() {}

func (x *GetSwiftVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetSwiftVersionResponse) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetSwiftVersionResponse) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GetSwiftVersionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// version is the resolved version to be used with the swift registry.
	Version string
}

func (b0 GetSwiftVersionResponse_builder) Build() *GetSwiftVersionResponse {
	m0 := &GetSwiftVersionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	return m0
}

type GetPythonVersionRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetPythonVersionRequest) Reset() {
	*x = GetPythonVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPythonVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPythonVersionRequest) ProtoMessage() {}

func (x *GetPythonVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetPythonVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetPythonVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetPythonVersionRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetPythonVersionRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetPythonVersionRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetPythonVersionRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetPythonVersionRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *GetPythonVersionRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

type GetPythonVersionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin
	// The module reference to resolve.
	ModuleReference *LocalModuleReference
}

func (b0 GetPythonVersionRequest_builder) Build() *GetPythonVersionRequest {
	m0 := &GetPythonVersionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_ModuleReference = b.ModuleReference
	return m0
}

type GetPythonVersionResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetPythonVersionResponse) Reset() {
	*x = GetPythonVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPythonVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPythonVersionResponse) ProtoMessage() {}

func (x *GetPythonVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetPythonVersionResponse) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetPythonVersionResponse) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GetPythonVersionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// version is the resolved version to be used with the python repository.
	Version string
}

func (b0 GetPythonVersionResponse_builder) Build() *GetPythonVersionResponse {
	m0 := &GetPythonVersionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	return m0
}

type GetCargoVersionRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetCargoVersionRequest) Reset() {
	*x = GetCargoVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCargoVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCargoVersionRequest) ProtoMessage() {}

func (x *GetCargoVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetCargoVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetCargoVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetCargoVersionRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetCargoVersionRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetCargoVersionRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetCargoVersionRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetCargoVersionRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *GetCargoVersionRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

type GetCargoVersionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin
	// The module reference to resolve.
	ModuleReference *LocalModuleReference
}

func (b0 GetCargoVersionRequest_builder) Build() *GetCargoVersionRequest {
	m0 := &GetCargoVersionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_ModuleReference = b.ModuleReference
	return m0
}

type GetCargoVersionResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetCargoVersionResponse) Reset() {
	*x = GetCargoVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCargoVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCargoVersionResponse) ProtoMessage() {}

func (x *GetCargoVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetCargoVersionResponse) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetCargoVersionResponse) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GetCargoVersionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// version is the resolved version to be used with the cargo registry.
	Version string
}

func (b0 GetCargoVersionResponse_builder) Build() *GetCargoVersionResponse {
	m0 := &GetCargoVersionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	return m0
}

type GetNugetVersionRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetNugetVersionRequest) Reset() {
	*x = GetNugetVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNugetVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNugetVersionRequest) ProtoMessage() {}

func (x *GetNugetVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetNugetVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetNugetVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetNugetVersionRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetNugetVersionRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetNugetVersionRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetNugetVersionRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetNugetVersionRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *GetNugetVersionRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

type GetNugetVersionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin
	// The module reference to resolve.
	ModuleReference *LocalModuleReference
}

func (b0 GetNugetVersionRequest_builder) Build() *GetNugetVersionRequest {
	m0 := &GetNugetVersionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_ModuleReference = b.ModuleReference
	return m0
}

type GetNugetVersionResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetNugetVersionResponse) Reset() {
	*x = GetNugetVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNugetVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNugetVersionResponse) ProtoMessage() {}

func (x *GetNugetVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetNugetVersionResponse) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetNugetVersionResponse) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GetNugetVersionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// version is the resolved version to be used with the nuget registry.
	Version string
}

func (b0 GetNugetVersionResponse_builder) Build() *GetNugetVersionResponse {
	m0 := &GetNugetVersionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	return m0
}

type GetCmakeVersionRequest struct {
	state                      protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3"`
	xxx_hidden_ModuleReference *LocalModuleReference          `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetCmakeVersionRequest) Reset() {
	*x = GetCmakeVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCmakeVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCmakeVersionRequest) ProtoMessage() {}

func (x *GetCmakeVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetCmakeVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.xxx_hidden_PluginReference
	}
	return nil
}

func (x *GetCmakeVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.xxx_hidden_ModuleReference
	}
	return nil
}

func (x *GetCmakeVersionRequest) SetPluginReference(v *GetRemotePackageVersionPlugin) {
	x.xxx_hidden_PluginReference = v
}

func (x *GetCmakeVersionRequest) SetModuleReference(v *LocalModuleReference) {
	x.xxx_hidden_ModuleReference = v
}

func (x *GetCmakeVersionRequest) HasPluginReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PluginReference != nil
}

func (x *GetCmakeVersionRequest) HasModuleReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleReference != nil
}

func (x *GetCmakeVersionRequest) ClearPluginReference() {
	x.xxx_hidden_PluginReference = nil
}

func (x *GetCmakeVersionRequest) ClearModuleReference() {
	x.xxx_hidden_ModuleReference = nil
}

type GetCmakeVersionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin
	// The module reference to resolve.
	ModuleReference *LocalModuleReference
}

func (b0 GetCmakeVersionRequest_builder) Build() *GetCmakeVersionRequest {
	m0 := &GetCmakeVersionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginReference = b.PluginReference
	x.xxx_hidden_ModuleReference = b.ModuleReference
	return m0
}

type GetCmakeVersionResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Version string                 `protobuf:"bytes,1,opt,name=version,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetCmakeVersionResponse) Reset() {
	*x = GetCmakeVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCmakeVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCmakeVersionResponse) ProtoMessage() {}

func (x *GetCmakeVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetCmakeVersionResponse) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetCmakeVersionResponse) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

type GetCmakeVersionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// version is the resolved version to be used with the cmake registry.
	Version string
}

func (b0 GetCmakeVersionResponse_builder) Build() *GetCmakeVersionResponse {
	m0 := &GetCmakeVersionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Version = b.Version
	return m0
}

// GetRemotePackageVersionPlugin is a plugin reference.
// If the version is empty, this is a reference to the latest version.
type GetRemotePackageVersionPlugin struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Owner    string                 `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Name     string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_Version  string                 `protobuf:"bytes,3,opt,name=version,proto3"`
	xxx_hidden_Revision uint32                 `protobuf:"varint,4,opt,name=revision,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *GetRemotePackageVersionPlugin) Reset() {
	*x = GetRemotePackageVersionPlugin{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRemotePackageVersionPlugin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRemotePackageVersionPlugin) ProtoMessage() {}

func (x *GetRemotePackageVersionPlugin) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRemotePackageVersionPlugin) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *GetRemotePackageVersionPlugin) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *GetRemotePackageVersionPlugin) GetVersion() string {
	if x != nil {
		return x.xxx_hidden_Version
	}
	return ""
}

func (x *GetRemotePackageVersionPlugin) GetRevision() uint32 {
	if x != nil {
		return x.xxx_hidden_Revision
	}
	return 0
}

func (x *GetRemotePackageVersionPlugin) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *GetRemotePackageVersionPlugin) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *GetRemotePackageVersionPlugin) SetVersion(v string) {
	x.xxx_hidden_Version = v
}

func (x *GetRemotePackageVersionPlugin) SetRevision(v uint32) {
	x.xxx_hidden_Revision = v
}

type GetRemotePackageVersionPlugin_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The owner of the plugin.
	// example: bufbuild
	Owner string
	// The name of the plugin.
	// example: connect-go
	Name string
	// The version of the plugin.
	// If empty, this is a reference to the latest version.
	// example: v1.0.0
	Version string
	// The revision of the plugin version.
	// example: 1
	Revision uint32
}

func (b0 GetRemotePackageVersionPlugin_builder) Build() *GetRemotePackageVersionPlugin {
	m0 := &GetRemotePackageVersionPlugin{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Version = b.Version
	x.xxx_hidden_Revision = b.Revision
	return m0
}

var File_buf_alpha_registry_v1alpha1_resolve_proto protoreflect.FileDescriptor

var file_buf_alpha_registry_v1alpha1_resolve_proto_rawDesc = string([]byte{
	0x0a, 0x29, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x6c, 0x76, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a, 0x26, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x28, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc5, 0x01, 0x0a, 0x14, 0x47,
	0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x11, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x10, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x54, 0x0a, 0x13,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x70,
	0x69, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x52,
	0x11, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69,
	0x6e, 0x73, 0x22, 0x5e, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50,
	0x69, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x0b, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x70, 0x69, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x52, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69,
	0x6e, 0x73, 0x22, 0x86, 0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x69, 0x0a, 0x17, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x15, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x22, 0xa9, 0x02, 0x0a, 0x18,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c,
	0x76, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x4f, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x09,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x3d, 0x0a, 0x03, 0x70, 0x69, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x50, 0x69, 0x6e, 0x52, 0x03, 0x70, 0x69, 0x6e, 0x12, 0x6a, 0x0a, 0x17, 0x72, 0x65, 0x73, 0x6f,
	0x6c, 0x76, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x15, 0x72,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x52, 0x0b, 0x69, 0x73, 0x5f, 0x62,
	0x73, 0x72, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x22, 0xde, 0x01, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x4c,
	0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x76, 0x0a, 0x1c, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x19, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x48,
	0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x22, 0xda, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74,
	0x47, 0x6f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x65, 0x0a, 0x10, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x0f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x30, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x47, 0x6f, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xdd, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x4d,
	0x61, 0x76, 0x65, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x65, 0x0a, 0x10, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x0f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x33, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x4d, 0x61,
	0x76, 0x65, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xdb, 0x01, 0x0a,
	0x14, 0x47, 0x65, 0x74, 0x4e, 0x50, 0x4d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x65, 0x0a, 0x10, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x0f, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a, 0x10,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x31, 0x0a, 0x15, 0x47, 0x65,
	0x74, 0x4e, 0x50, 0x4d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xdd, 0x01,
	0x0a, 0x16, 0x47, 0x65, 0x74, 0x53, 0x77, 0x69, 0x66, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x65, 0x0a, 0x10, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x0f,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x5c, 0x0a, 0x10, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x33, 0x0a,
	0x17, 0x47, 0x65, 0x74, 0x53, 0x77, 0x69, 0x66, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0xde, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x65,
	0x0a, 0x10, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x52, 0x0f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x22, 0x34, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xdd, 0x01, 0x0a, 0x16, 0x47, 0x65,
	0x74, 0x43, 0x61, 0x72, 0x67, 0x6f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x65, 0x0a, 0x10, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x0f, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x33, 0x0a, 0x17, 0x47, 0x65, 0x74,
	0x43, 0x61, 0x72, 0x67, 0x6f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xdd,
	0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x4e, 0x75, 0x67, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x65, 0x0a, 0x10, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52,
	0x0f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x5c, 0x0a, 0x10, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x33,
	0x0a, 0x17, 0x47, 0x65, 0x74, 0x4e, 0x75, 0x67, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x22, 0xdd, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x43, 0x6d, 0x61, 0x6b, 0x65,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x65,
	0x0a, 0x10, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x52, 0x0f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x22, 0x33, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x43, 0x6d, 0x61, 0x6b, 0x65, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x7f, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a,
	0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2a, 0xf1, 0x01, 0x0a, 0x15, 0x52, 0x65,
	0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x23, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x5f,
	0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x22, 0x0a, 0x1e,
	0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e,
	0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x10, 0x01,
	0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x46,
	0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x42, 0x52, 0x41, 0x4e,
	0x43, 0x48, 0x10, 0x02, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44,
	0x5f, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x54, 0x41, 0x47, 0x10, 0x03, 0x12, 0x21, 0x0a, 0x1d, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45,
	0x44, 0x5f, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x44, 0x52, 0x41, 0x46, 0x54, 0x10, 0x05, 0x22, 0x04, 0x08, 0x04, 0x10, 0x04, 0x2a, 0x1d,
	0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e,
	0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x32, 0x9f, 0x09,
	0x0a, 0x0e, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x7b, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e,
	0x73, 0x12, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x78, 0x0a,
	0x0c, 0x47, 0x65, 0x74, 0x47, 0x6f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x47,
	0x6f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x47, 0x6f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x81, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x53,
	0x77, 0x69, 0x66, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x77, 0x69,
	0x66, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x77, 0x69, 0x66, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x81, 0x01, 0x0a, 0x0f,
	0x47, 0x65, 0x74, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12,
	0x7b, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x4e, 0x50, 0x4d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x4e, 0x50, 0x4d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x50, 0x4d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x84, 0x01, 0x0a,
	0x10, 0x47, 0x65, 0x74, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03,
	0x90, 0x02, 0x01, 0x12, 0x81, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x43, 0x61, 0x72, 0x67, 0x6f,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x61, 0x72, 0x67, 0x6f, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x61,
	0x72, 0x67, 0x6f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x81, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x4e,
	0x75, 0x67, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x75, 0x67,
	0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x4e, 0x75, 0x67, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x81, 0x01, 0x0a, 0x0f,
	0x47, 0x65, 0x74, 0x43, 0x6d, 0x61, 0x6b, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x43, 0x6d, 0x61, 0x6b, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6d, 0x61, 0x6b, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x32,
	0xa2, 0x01, 0x0a, 0x13, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x8a, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x4c,
	0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x73, 0x12, 0x36,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x03, 0x90, 0x02, 0x01, 0x42, 0x99, 0x02, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x42, 0x0c, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x62, 0x75,
	0x66, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x3b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x42, 0x41, 0x52, 0xaa, 0x02, 0x1b, 0x42, 0x75, 0x66, 0x2e,
	0x41, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x56,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xca, 0x02, 0x1b, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c,
	0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0xe2, 0x02, 0x27, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c, 0x70, 0x68,
	0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea,
	0x02, 0x1e, 0x42, 0x75, 0x66, 0x3a, 0x3a, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x3a, 0x3a, 0x52, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var file_buf_alpha_registry_v1alpha1_resolve_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_buf_alpha_registry_v1alpha1_resolve_proto_goTypes = []any{
	(ResolvedReferenceType)(0),            // 0: buf.alpha.registry.v1alpha1.ResolvedReferenceType
	(*GetModulePinsRequest)(nil),          // 1: buf.alpha.registry.v1alpha1.GetModulePinsRequest
	(*GetModulePinsResponse)(nil),         // 2: buf.alpha.registry.v1alpha1.GetModulePinsResponse
	(*GetLocalModulePinsRequest)(nil),     // 3: buf.alpha.registry.v1alpha1.GetLocalModulePinsRequest
	(*LocalModuleResolveResult)(nil),      // 4: buf.alpha.registry.v1alpha1.LocalModuleResolveResult
	(*GetLocalModulePinsResponse)(nil),    // 5: buf.alpha.registry.v1alpha1.GetLocalModulePinsResponse
	(*GetGoVersionRequest)(nil),           // 6: buf.alpha.registry.v1alpha1.GetGoVersionRequest
	(*GetGoVersionResponse)(nil),          // 7: buf.alpha.registry.v1alpha1.GetGoVersionResponse
	(*GetMavenVersionRequest)(nil),        // 8: buf.alpha.registry.v1alpha1.GetMavenVersionRequest
	(*GetMavenVersionResponse)(nil),       // 9: buf.alpha.registry.v1alpha1.GetMavenVersionResponse
	(*GetNPMVersionRequest)(nil),          // 10: buf.alpha.registry.v1alpha1.GetNPMVersionRequest
	(*GetNPMVersionResponse)(nil),         // 11: buf.alpha.registry.v1alpha1.GetNPMVersionResponse
	(*GetSwiftVersionRequest)(nil),        // 12: buf.alpha.registry.v1alpha1.GetSwiftVersionRequest
	(*GetSwiftVersionResponse)(nil),       // 13: buf.alpha.registry.v1alpha1.GetSwiftVersionResponse
	(*GetPythonVersionRequest)(nil),       // 14: buf.alpha.registry.v1alpha1.GetPythonVersionRequest
	(*GetPythonVersionResponse)(nil),      // 15: buf.alpha.registry.v1alpha1.GetPythonVersionResponse
	(*GetCargoVersionRequest)(nil),        // 16: buf.alpha.registry.v1alpha1.GetCargoVersionRequest
	(*GetCargoVersionResponse)(nil),       // 17: buf.alpha.registry.v1alpha1.GetCargoVersionResponse
	(*GetNugetVersionRequest)(nil),        // 18: buf.alpha.registry.v1alpha1.GetNugetVersionRequest
	(*GetNugetVersionResponse)(nil),       // 19: buf.alpha.registry.v1alpha1.GetNugetVersionResponse
	(*GetCmakeVersionRequest)(nil),        // 20: buf.alpha.registry.v1alpha1.GetCmakeVersionRequest
	(*GetCmakeVersionResponse)(nil),       // 21: buf.alpha.registry.v1alpha1.GetCmakeVersionResponse
	(*GetRemotePackageVersionPlugin)(nil), // 22: buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	(*v1alpha1.ModuleReference)(nil),      // 23: buf.alpha.module.v1alpha1.ModuleReference
	(*v1alpha1.ModulePin)(nil),            // 24: buf.alpha.module.v1alpha1.ModulePin
	(*LocalModuleReference)(nil),          // 25: buf.alpha.registry.v1alpha1.LocalModuleReference
	(*LocalModulePin)(nil),                // 26: buf.alpha.registry.v1alpha1.LocalModulePin
}
var file_buf_alpha_registry_v1alpha1_resolve_proto_depIdxs = []int32{
	23, // 0: buf.alpha.registry.v1alpha1.GetModulePinsRequest.module_references:type_name -> buf.alpha.module.v1alpha1.ModuleReference
	24, // 1: buf.alpha.registry.v1alpha1.GetModulePinsRequest.current_module_pins:type_name -> buf.alpha.module.v1alpha1.ModulePin
	24, // 2: buf.alpha.registry.v1alpha1.GetModulePinsResponse.module_pins:type_name -> buf.alpha.module.v1alpha1.ModulePin
	25, // 3: buf.alpha.registry.v1alpha1.GetLocalModulePinsRequest.local_module_references:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	25, // 4: buf.alpha.registry.v1alpha1.LocalModuleResolveResult.reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	26, // 5: buf.alpha.registry.v1alpha1.LocalModuleResolveResult.pin:type_name -> buf.alpha.registry.v1alpha1.LocalModulePin
	0,  // 6: buf.alpha.registry.v1alpha1.LocalModuleResolveResult.resolved_reference_type:type_name -> buf.alpha.registry.v1alpha1.ResolvedReferenceType
	4,  // 7: buf.alpha.registry.v1alpha1.GetLocalModulePinsResponse.local_module_resolve_results:type_name -> buf.alpha.registry.v1alpha1.LocalModuleResolveResult
	24, // 8: buf.alpha.registry.v1alpha1.GetLocalModulePinsResponse.dependencies:type_name -> buf.alpha.module.v1alpha1.ModulePin
	22, // 9: buf.alpha.registry.v1alpha1.GetGoVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 10: buf.alpha.registry.v1alpha1.GetGoVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 11: buf.alpha.registry.v1alpha1.GetMavenVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 12: buf.alpha.registry.v1alpha1.GetMavenVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 13: buf.alpha.registry.v1alpha1.GetNPMVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 14: buf.alpha.registry.v1alpha1.GetNPMVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 15: buf.alpha.registry.v1alpha1.GetSwiftVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 16: buf.alpha.registry.v1alpha1.GetSwiftVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 17: buf.alpha.registry.v1alpha1.GetPythonVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 18: buf.alpha.registry.v1alpha1.GetPythonVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 19: buf.alpha.registry.v1alpha1.GetCargoVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 20: buf.alpha.registry.v1alpha1.GetCargoVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 21: buf.alpha.registry.v1alpha1.GetNugetVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 22: buf.alpha.registry.v1alpha1.GetNugetVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 23: buf.alpha.registry.v1alpha1.GetCmakeVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 24: buf.alpha.registry.v1alpha1.GetCmakeVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	1,  // 25: buf.alpha.registry.v1alpha1.ResolveService.GetModulePins:input_type -> buf.alpha.registry.v1alpha1.GetModulePinsRequest
	6,  // 26: buf.alpha.registry.v1alpha1.ResolveService.GetGoVersion:input_type -> buf.alpha.registry.v1alpha1.GetGoVersionRequest
	12, // 27: buf.alpha.registry.v1alpha1.ResolveService.GetSwiftVersion:input_type -> buf.alpha.registry.v1alpha1.GetSwiftVersionRequest
	8,  // 28: buf.alpha.registry.v1alpha1.ResolveService.GetMavenVersion:input_type -> buf.alpha.registry.v1alpha1.GetMavenVersionRequest
	10, // 29: buf.alpha.registry.v1alpha1.ResolveService.GetNPMVersion:input_type -> buf.alpha.registry.v1alpha1.GetNPMVersionRequest
	14, // 30: buf.alpha.registry.v1alpha1.ResolveService.GetPythonVersion:input_type -> buf.alpha.registry.v1alpha1.GetPythonVersionRequest
	16, // 31: buf.alpha.registry.v1alpha1.ResolveService.GetCargoVersion:input_type -> buf.alpha.registry.v1alpha1.GetCargoVersionRequest
	18, // 32: buf.alpha.registry.v1alpha1.ResolveService.GetNugetVersion:input_type -> buf.alpha.registry.v1alpha1.GetNugetVersionRequest
	20, // 33: buf.alpha.registry.v1alpha1.ResolveService.GetCmakeVersion:input_type -> buf.alpha.registry.v1alpha1.GetCmakeVersionRequest
	3,  // 34: buf.alpha.registry.v1alpha1.LocalResolveService.GetLocalModulePins:input_type -> buf.alpha.registry.v1alpha1.GetLocalModulePinsRequest
	2,  // 35: buf.alpha.registry.v1alpha1.ResolveService.GetModulePins:output_type -> buf.alpha.registry.v1alpha1.GetModulePinsResponse
	7,  // 36: buf.alpha.registry.v1alpha1.ResolveService.GetGoVersion:output_type -> buf.alpha.registry.v1alpha1.GetGoVersionResponse
	13, // 37: buf.alpha.registry.v1alpha1.ResolveService.GetSwiftVersion:output_type -> buf.alpha.registry.v1alpha1.GetSwiftVersionResponse
	9,  // 38: buf.alpha.registry.v1alpha1.ResolveService.GetMavenVersion:output_type -> buf.alpha.registry.v1alpha1.GetMavenVersionResponse
	11, // 39: buf.alpha.registry.v1alpha1.ResolveService.GetNPMVersion:output_type -> buf.alpha.registry.v1alpha1.GetNPMVersionResponse
	15, // 40: buf.alpha.registry.v1alpha1.ResolveService.GetPythonVersion:output_type -> buf.alpha.registry.v1alpha1.GetPythonVersionResponse
	17, // 41: buf.alpha.registry.v1alpha1.ResolveService.GetCargoVersion:output_type -> buf.alpha.registry.v1alpha1.GetCargoVersionResponse
	19, // 42: buf.alpha.registry.v1alpha1.ResolveService.GetNugetVersion:output_type -> buf.alpha.registry.v1alpha1.GetNugetVersionResponse
	21, // 43: buf.alpha.registry.v1alpha1.ResolveService.GetCmakeVersion:output_type -> buf.alpha.registry.v1alpha1.GetCmakeVersionResponse
	5,  // 44: buf.alpha.registry.v1alpha1.LocalResolveService.GetLocalModulePins:output_type -> buf.alpha.registry.v1alpha1.GetLocalModulePinsResponse
	35, // [35:45] is the sub-list for method output_type
	25, // [25:35] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_resolve_proto_init() }
func file_buf_alpha_registry_v1alpha1_resolve_proto_init() {
	if File_buf_alpha_registry_v1alpha1_resolve_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_module_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_resolve_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_resolve_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_resolve_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_resolve_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_resolve_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_resolve_proto = out.File
	file_buf_alpha_registry_v1alpha1_resolve_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_resolve_proto_depIdxs = nil
}
