/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.objectweb.asm.ClassReader;
import org.pantsbuild.jarjar.StringReader;
import org.pantsbuild.jarjar.util.ClassPathEntry;
import org.pantsbuild.jarjar.util.ClassPathIterator;
import org.pantsbuild.jarjar.util.RuntimeIOException;

class StringDumper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String string, PrintWriter printWriter) throws IOException {
        DumpStringReader dumpStringReader = new DumpStringReader(printWriter);
        ClassPathIterator classPathIterator = new ClassPathIterator(string);
        try {
            while (classPathIterator.hasNext()) {
                ClassPathEntry classPathEntry = classPathIterator.next();
                InputStream inputStream = classPathEntry.openStream();
                try {
                    new ClassReader(inputStream).accept(dumpStringReader, 0);
                }
                catch (Exception exception) {
                    System.err.println("Error reading " + classPathEntry.getName() + ": " + exception.getMessage());
                }
                finally {
                    inputStream.close();
                }
                printWriter.flush();
            }
        }
        catch (RuntimeIOException runtimeIOException) {
            throw (IOException)runtimeIOException.getCause();
        }
        finally {
            classPathIterator.close();
        }
    }

    private static String escapeStringLiteral(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"");
        block9: for (char c : string.toCharArray()) {
            switch (c) {
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block9;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block9;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block9;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block9;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block9;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    private static class DumpStringReader
    extends StringReader {
        private final PrintWriter pw;
        private String className;

        public DumpStringReader(PrintWriter printWriter) {
            this.pw = printWriter;
        }

        @Override
        public void visitString(String string, String string2, int n) {
            if (string2.length() > 0) {
                if (!string.equals(this.className)) {
                    this.className = string;
                    this.pw.println(string.replace('/', '.'));
                }
                this.pw.print("\t");
                if (n >= 0) {
                    this.pw.print(n + ": ");
                }
                this.pw.print(StringDumper.escapeStringLiteral(string2));
                this.pw.println();
            }
        }
    }
}

