/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/networking/v1"
	networkingv1 "k8s.io/client-go/applyconfigurations/networking/v1"
	gentype "k8s.io/client-go/gentype"
	typednetworkingv1 "k8s.io/client-go/kubernetes/typed/networking/v1"
)

// fakeNetworkPolicies implements NetworkPolicyInterface
type fakeNetworkPolicies struct {
	*gentype.FakeClientWithListAndApply[*v1.NetworkPolicy, *v1.NetworkPolicyList, *networkingv1.NetworkPolicyApplyConfiguration]
	Fake *FakeNetworkingV1
}

func newFakeNetworkPolicies(fake *FakeNetworkingV1, namespace string) typednetworkingv1.NetworkPolicyInterface {
	return &fakeNetworkPolicies{
		gentype.NewFakeClientWithListAndApply[*v1.NetworkPolicy, *v1.NetworkPolicyList, *networkingv1.NetworkPolicyApplyConfiguration](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("networkpolicies"),
			v1.SchemeGroupVersion.WithKind("NetworkPolicy"),
			func() *v1.NetworkPolicy { return &v1.NetworkPolicy{} },
			func() *v1.NetworkPolicyList { return &v1.NetworkPolicyList{} },
			func(dst, src *v1.NetworkPolicyList) { dst.ListMeta = src.ListMeta },
			func(list *v1.NetworkPolicyList) []*v1.NetworkPolicy { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.NetworkPolicyList, items []*v1.NetworkPolicy) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
