/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.common;

import com.thaiopensource.util.Utf16;
import com.thaiopensource.xml.out.CharRepertoire;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;

public class XmlWriter {
    private final String lineSep;
    private final String indentString;
    private final Writer w;
    private final CharRepertoire cr;
    private final Stack<String> tagStack = new Stack();
    private boolean inStartTag = false;
    private boolean inText = false;
    private int level = 0;
    private final String[] topLevelAttributes;

    public XmlWriter(Writer writer, String string, CharRepertoire charRepertoire, String string2, int n, String[] stringArray) {
        this.w = writer;
        this.lineSep = string2;
        this.cr = charRepertoire;
        this.topLevelAttributes = stringArray;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 32;
        }
        this.indentString = new String(cArray);
        this.write("<?xml version=\"1.0\" encoding=\"");
        this.write(string);
        this.write("\"?>");
        this.newline();
    }

    public void startElement(String string) {
        if (this.inStartTag) {
            this.maybeWriteTopLevelAttributes();
            this.inStartTag = false;
            this.write(">");
            this.newline();
        }
        if (this.inText) {
            this.inText = false;
        } else {
            this.indent();
        }
        this.write('<');
        this.write(string);
        this.tagStack.push(string);
        this.inStartTag = true;
        ++this.level;
    }

    public void endElement() {
        if (this.inStartTag) {
            this.maybeWriteTopLevelAttributes();
            --this.level;
            this.inStartTag = false;
            this.tagStack.pop();
            this.write("/>");
        } else {
            --this.level;
            if (this.inText) {
                this.inText = false;
            } else {
                this.indent();
            }
            this.write("</");
            this.write(this.tagStack.pop());
            this.write(">");
        }
        this.newline();
    }

    public void attribute(String string, String string2) {
        if (!this.inStartTag) {
            throw new IllegalStateException("attribute outside of start-tag");
        }
        this.write(' ');
        this.write(string);
        this.write('=');
        this.write('\"');
        this.data(string2);
        this.write('\"');
    }

    public void text(String string) {
        if (string.length() == 0) {
            return;
        }
        if (this.inStartTag) {
            this.maybeWriteTopLevelAttributes();
            this.inStartTag = false;
            this.write(">");
        }
        this.data(string);
        this.inText = true;
    }

    public void comment(String string) {
        if (this.inStartTag) {
            this.maybeWriteTopLevelAttributes();
            this.inStartTag = false;
            this.write(">");
            this.newline();
        }
        if (!this.inText) {
            this.indent();
        }
        this.write("<!--");
        int n = 0;
        ++this.level;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(10, n)) < 0) {
                if (n > 0) {
                    this.newline();
                    this.indent();
                    this.write(string.substring(n));
                    --this.level;
                    this.newline();
                    this.indent();
                    break;
                }
                --this.level;
                if (string.length() == 0) break;
                this.write(' ');
                this.write(string);
                if (string.charAt(string.length() - 1) == ' ') break;
                this.write(' ');
                break;
            }
            this.newline();
            this.indent();
            this.write(string.substring(n, n2));
            n = n2 + 1;
        }
        this.write("-->");
        if (!this.inText) {
            this.newline();
        }
    }

    private void data(String string) {
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    this.write("&lt;");
                    continue block7;
                }
                case '>': {
                    this.write("&gt;");
                    continue block7;
                }
                case '&': {
                    this.write("&amp;");
                    continue block7;
                }
                case '\r': {
                    this.write("&#xD;");
                    continue block7;
                }
                case '\n': {
                    this.write(this.lineSep);
                    continue block7;
                }
                default: {
                    if (Utf16.isSurrogate(c)) {
                        char c2;
                        if (!Utf16.isSurrogate1(c) || i + 1 == n || !Utf16.isSurrogate2(string.charAt(i + 1))) {
                            throw new WrappedException(new CharConversionException("surrogate pair integrity failure"));
                        }
                        if (this.cr.contains(c, c2 = string.charAt(++i))) {
                            this.write(c);
                            this.write(c2);
                            continue block7;
                        }
                        this.charRef(Utf16.scalarValue(c, c2));
                        continue block7;
                    }
                    if (!this.cr.contains(c)) {
                        this.charRef(c);
                        continue block7;
                    }
                    this.write(c);
                }
            }
        }
    }

    private void charRef(int n) {
        this.write("&#x");
        this.write(Integer.toHexString(n));
        this.write(';');
    }

    private void indent() {
        for (int i = 0; i < this.level; ++i) {
            this.write(this.indentString);
        }
    }

    private void newline() {
        this.write(this.lineSep);
    }

    private void maybeWriteTopLevelAttributes() {
        if (this.level != 1) {
            return;
        }
        for (int i = 0; i < this.topLevelAttributes.length; i += 2) {
            this.attribute(this.topLevelAttributes[i], this.topLevelAttributes[i + 1]);
        }
    }

    private void write(String string) {
        try {
            this.w.write(string);
        }
        catch (IOException iOException) {
            throw new WrappedException(iOException);
        }
    }

    private void write(char c) {
        try {
            this.w.write(c);
        }
        catch (IOException iOException) {
            throw new WrappedException(iOException);
        }
    }

    public void close() {
        try {
            this.w.close();
        }
        catch (IOException iOException) {
            throw new WrappedException(iOException);
        }
    }

    public static class WrappedException
    extends RuntimeException {
        private final IOException cause;

        public Throwable getCause() {
            return this.cause;
        }

        public IOException getIOException() {
            return this.cause;
        }

        private WrappedException(IOException iOException) {
            this.cause = iOException;
        }
    }
}

