/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPExternalFileManager;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.LocalFileStorage;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.IDataSourceContainerUpdate;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.IInMemoryEditorInput;
import org.jkiss.dbeaver.ui.editors.ILazyEditorInput;
import org.jkiss.dbeaver.ui.editors.IRevertableEditor;
import org.jkiss.dbeaver.ui.editors.IncludedScriptFileEditorInput;
import org.jkiss.dbeaver.ui.editors.file.FileTypeHandlerDescriptor;
import org.jkiss.dbeaver.ui.editors.file.FileTypeHandlerRegistry;
import org.jkiss.dbeaver.ui.editors.internal.EditorsMessages;
import org.jkiss.dbeaver.utils.ResourceUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class EditorUtils {
    public static final String PROP_SQL_DATA_SOURCE_ID = "sql-editor-data-source-id";
    public static final String PROP_SQL_PROJECT_ID = "sql-editor-project-id";
    public static final String PROP_CONTEXT_DEFAULT_DATASOURCE = "default-datasource";
    public static final String PROP_CONTEXT_DEFAULT_CATALOG = "default-catalog";
    private static final String PROP_CONTEXT_DEFAULT_SCHEMA = "default-schema";
    private static final String PROP_SQL_DATA_SOURCE_CONTAINER = "sql-editor-data-source-container";
    private static final String PROP_EDITOR_CONTEXT = "database-editor-context";
    private static final String PROP_EXECUTION_CONTEXT = "sql-editor-execution-context";
    private static final String PROP_INPUT_FILE = "sql-editor-input-file";
    public static final String COLORS_AND_FONTS_PAGE_ID = "org.eclipse.ui.preferencePages.ColorsAndFonts";
    private static final Log log = Log.getLog(EditorUtils.class);

    @Nullable
    public static DBPProject getFileProject(@Nullable IEditorInput editorInput) {
        if (editorInput != null) {
            DBPDataSource dataSource;
            IDatabaseEditorInput dei;
            DBSObject dbo;
            if (editorInput instanceof ILazyEditorInput) {
                ILazyEditorInput lei = (ILazyEditorInput)editorInput;
                return lei.getProject();
            }
            if (editorInput instanceof IDatabaseEditorInput && (dbo = (dei = (IDatabaseEditorInput)editorInput).getDatabaseObject()) != null && (dataSource = dbo.getDataSource()) != null) {
                return dataSource.getContainer().getProject();
            }
            IFile curFile = EditorUtils.getFileFromInput(editorInput);
            if (curFile != null) {
                return DBPPlatformDesktop.getInstance().getWorkspace().getProject(curFile.getProject());
            }
        }
        return null;
    }

    @Nullable
    public static IFile getFileFromInput(IEditorInput editorInput) {
        IPathEditorInput pathInput;
        if (editorInput == null) {
            return null;
        }
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fei = (IFileEditorInput)editorInput;
            return fei.getFile();
        }
        if (editorInput instanceof IPathEditorInput) {
            IPathEditorInput pei = (IPathEditorInput)editorInput;
            IPath path = pei.getPath();
            return path == null ? null : ResourceUtils.convertPathToWorkspaceFile((IPath)path);
        }
        if (editorInput instanceof IInMemoryEditorInput) {
            IInMemoryEditorInput mei = (IInMemoryEditorInput)editorInput;
            IFile file = (IFile)mei.getProperty(PROP_INPUT_FILE);
            if (file != null) {
                return file;
            }
        } else if (editorInput instanceof IURIEditorInput) {
            return null;
        }
        if ((pathInput = (IPathEditorInput)editorInput.getAdapter(IPathEditorInput.class)) != null) {
            IPath path = pathInput.getPath();
            return path == null ? null : ResourceUtils.convertPathToWorkspaceFile((IPath)path);
        }
        try {
            Method getFileMethod = editorInput.getClass().getMethod("getFile", new Class[0]);
            if (IFile.class.isAssignableFrom(getFileMethod.getReturnType())) {
                return (IFile)getFileMethod.invoke((Object)editorInput, new Object[0]);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static IStorage getStorageFromInput(Object element) {
        IAdaptable adaptable;
        IStorage storage;
        if (element instanceof IStorageEditorInput) {
            IStorageEditorInput sei = (IStorageEditorInput)element;
            try {
                return sei.getStorage();
            }
            catch (CoreException e) {
                log.error((Object)e);
            }
        }
        if (element instanceof IAdaptable && (storage = (IStorage)(adaptable = (IAdaptable)element).getAdapter(IStorage.class)) != null) {
            return storage;
        }
        if (element instanceof IEditorInput) {
            IURIEditorInput uriei;
            URI uri;
            File localFile;
            IEditorInput ei = (IEditorInput)element;
            IFile file = EditorUtils.getFileFromInput(ei);
            if (file != null) {
                return file;
            }
            if (element instanceof IURIEditorInput && (localFile = new File(uri = (uriei = (IURIEditorInput)element).getURI())).exists()) {
                return new LocalFileStorage(localFile, StandardCharsets.UTF_8.name());
            }
        }
        return null;
    }

    public static File getLocalFileFromInput(Object element) {
        if (element instanceof IEditorInput) {
            IEditorInput ei = (IEditorInput)element;
            IFile file = EditorUtils.getFileFromInput(ei);
            if (file != null) {
                IPath location = file.getLocation();
                return location == null ? null : location.toFile();
            }
            if (element instanceof IURIEditorInput) {
                IURIEditorInput uriei = (IURIEditorInput)element;
                try {
                    File localFile = new File(uriei.getURI());
                    if (localFile.exists()) {
                        return localFile;
                    }
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        return null;
    }

    public static Path getPathFromInput(Object element) {
        IEditorInput ei;
        IFile file;
        if (element instanceof IEditorInput && (file = EditorUtils.getFileFromInput(ei = (IEditorInput)element)) != null) {
            IPath location = file.getLocation();
            return location == null ? null : location.toPath();
        }
        File localFile = EditorUtils.getLocalFileFromInput(element);
        return localFile == null ? null : localFile.toPath();
    }

    @Nullable
    public static Object getResourceProperty(@NotNull RCPProject project, @NotNull IResource resource, @NotNull String propName) {
        return project.getResourceProperty(project.getResourcePath(resource), propName);
    }

    public static void setResourceProperty(@NotNull RCPProject project, @NotNull IResource resource, @NotNull String propName, @Nullable Object value) {
        project.setResourceProperty(project.getResourcePath(resource), propName, value);
    }

    public static DatabaseEditorContext getEditorContext(IEditorInput editorInput) {
        if (editorInput instanceof IInMemoryEditorInput) {
            return (DatabaseEditorContext)((IInMemoryEditorInput)editorInput).getProperty(PROP_EDITOR_CONTEXT);
        }
        if (editorInput instanceof IncludedScriptFileEditorInput) {
            IncludedScriptFileEditorInput input = (IncludedScriptFileEditorInput)editorInput;
            return input.getDatabaseEditorContext();
        }
        return null;
    }

    public static DBCExecutionContext getInputExecutionContext(IEditorInput editorInput) {
        if (editorInput instanceof IInMemoryEditorInput) {
            return (DBCExecutionContext)((IInMemoryEditorInput)editorInput).getProperty(PROP_EXECUTION_CONTEXT);
        }
        return null;
    }

    public static DBPDataSourceContainer getInputDataSource(IEditorInput editorInput) {
        return EditorUtils.getInputDataSource(editorInput, true);
    }

    public static DBPDataSourceContainer getInputDataSource(IEditorInput editorInput, boolean forceRegistryLoad) {
        if (editorInput instanceof IDatabaseEditorInput) {
            IDatabaseEditorInput dei = (IDatabaseEditorInput)editorInput;
            DBSObject object = dei.getDatabaseObject();
            if (object != null && object.getDataSource() != null) {
                return object.getDataSource().getContainer();
            }
            if (editorInput instanceof DBPDataSourceContainerProvider) {
                DBPDataSourceContainerProvider containerProvider = (DBPDataSourceContainerProvider)editorInput;
                return containerProvider.getDataSourceContainer();
            }
            return null;
        }
        if (editorInput instanceof IInMemoryEditorInput) {
            IInMemoryEditorInput mei = (IInMemoryEditorInput)editorInput;
            return (DBPDataSourceContainer)mei.getProperty(PROP_SQL_DATA_SOURCE_CONTAINER);
        }
        IFile file = EditorUtils.getFileFromInput(editorInput);
        if (file != null) {
            return EditorUtils.getFileDataSource(file, forceRegistryLoad);
        }
        File localFile = EditorUtils.getLocalFileFromInput(editorInput);
        if (localFile != null) {
            DBPExternalFileManager efManager = DBPPlatformDesktop.getInstance().getExternalFileManager();
            String dataSourceId = (String)efManager.getFileProperty(localFile, PROP_SQL_DATA_SOURCE_ID);
            String projectName = (String)efManager.getFileProperty(localFile, PROP_SQL_PROJECT_ID);
            if (CommonUtils.isEmpty((String)dataSourceId) || CommonUtils.isEmpty((String)projectName)) {
                return null;
            }
            IProject project = DBPPlatformDesktop.getInstance().getWorkspace().getEclipseWorkspace().getRoot().getProject(projectName);
            if (project == null || !project.exists()) {
                log.error((Object)("Can't locate project '" + projectName + "' in workspace"));
                return null;
            }
            DBPProject projectMeta = DBPPlatformDesktop.getInstance().getWorkspace().getProject(project);
            return projectMeta == null || !forceRegistryLoad && !projectMeta.isRegistryLoaded() ? null : projectMeta.getDataSourceRegistry().getDataSource(dataSourceId);
        }
        return null;
    }

    public static String[] getInputContextDefaults(DBPDataSourceContainer dataSource, IEditorInput editorInput) {
        String defaultDatasource = null;
        String defaultCatalogName = null;
        String defaultSchema = null;
        if (editorInput instanceof IInMemoryEditorInput) {
            IInMemoryEditorInput mei = (IInMemoryEditorInput)editorInput;
            defaultDatasource = (String)mei.getProperty(PROP_CONTEXT_DEFAULT_DATASOURCE);
            defaultCatalogName = (String)mei.getProperty(PROP_CONTEXT_DEFAULT_CATALOG);
            defaultSchema = (String)mei.getProperty(PROP_CONTEXT_DEFAULT_SCHEMA);
        } else {
            IFile file = EditorUtils.getFileFromInput(editorInput);
            if (file != null) {
                RCPProject projectMeta = (RCPProject)DBPPlatformDesktop.getInstance().getWorkspace().getProject(file.getProject());
                if (projectMeta != null) {
                    defaultDatasource = (String)EditorUtils.getResourceProperty(projectMeta, (IResource)file, PROP_CONTEXT_DEFAULT_DATASOURCE);
                    defaultCatalogName = (String)EditorUtils.getResourceProperty(projectMeta, (IResource)file, PROP_CONTEXT_DEFAULT_CATALOG);
                    defaultSchema = (String)EditorUtils.getResourceProperty(projectMeta, (IResource)file, PROP_CONTEXT_DEFAULT_SCHEMA);
                }
            } else {
                File localFile = EditorUtils.getLocalFileFromInput(editorInput);
                if (localFile != null) {
                    DBPExternalFileManager efManager = DBPPlatformDesktop.getInstance().getExternalFileManager();
                    defaultDatasource = (String)efManager.getFileProperty(localFile, PROP_CONTEXT_DEFAULT_DATASOURCE);
                    defaultCatalogName = (String)efManager.getFileProperty(localFile, PROP_CONTEXT_DEFAULT_CATALOG);
                    defaultSchema = (String)efManager.getFileProperty(localFile, PROP_CONTEXT_DEFAULT_SCHEMA);
                }
            }
        }
        if (!CommonUtils.isEmpty((String)defaultDatasource) && !defaultDatasource.equals(dataSource.getId())) {
            return new String[2];
        }
        return new String[]{defaultCatalogName, defaultSchema};
    }

    @Nullable
    public static DBPDataSourceContainer getFileDataSource(IFile file) {
        return EditorUtils.getFileDataSource(file, true);
    }

    @Nullable
    public static DBPDataSourceContainer getFileDataSource(IFile file, boolean forceRegistryLoad) {
        if (!file.exists()) {
            return null;
        }
        RCPProject projectMeta = (RCPProject)DBPPlatformDesktop.getInstance().getWorkspace().getProject(file.getProject());
        if (projectMeta != null) {
            Object dataSourceId = EditorUtils.getResourceProperty(projectMeta, (IResource)file, PROP_CONTEXT_DEFAULT_DATASOURCE);
            if (dataSourceId != null && (forceRegistryLoad || projectMeta.isRegistryLoaded())) {
                DBPDataSourceContainer dataSource = projectMeta.getDataSourceRegistry().getDataSource(dataSourceId.toString());
                if (dataSource == null) {
                    log.debug((Object)("Datasource " + String.valueOf(dataSourceId) + " not found in project " + projectMeta.getName() + " (" + file.getFullPath().toString() + ")"));
                }
                return dataSource;
            }
            return null;
        }
        return null;
    }

    public static void setInputDataSource(@NotNull IEditorInput editorInput, @NotNull DatabaseEditorContext context) {
        IFile file;
        if (editorInput instanceof IInMemoryEditorInput) {
            DBPDataSourceContainer dataSourceContainer;
            ((IInMemoryEditorInput)editorInput).setProperty(PROP_EDITOR_CONTEXT, context);
            DBCExecutionContext executionContext = context.getExecutionContext();
            if (executionContext != null) {
                ((IInMemoryEditorInput)editorInput).setProperty(PROP_EXECUTION_CONTEXT, executionContext);
            }
            if ((dataSourceContainer = context.getDataSourceContainer()) != null) {
                ((IInMemoryEditorInput)editorInput).setProperty(PROP_SQL_DATA_SOURCE_CONTAINER, dataSourceContainer);
            }
            if (!EditorUtils.isDefaultContextSettings(context)) {
                String schemaName;
                String catalogName;
                if (dataSourceContainer != null) {
                    ((IInMemoryEditorInput)editorInput).setProperty(PROP_CONTEXT_DEFAULT_DATASOURCE, dataSourceContainer.getId());
                }
                if ((catalogName = EditorUtils.getDefaultCatalogName(context)) != null) {
                    ((IInMemoryEditorInput)editorInput).setProperty(PROP_CONTEXT_DEFAULT_CATALOG, EditorUtils.getDefaultCatalogName(context));
                }
                if ((schemaName = EditorUtils.getDefaultSchemaName(context)) != null) {
                    ((IInMemoryEditorInput)editorInput).setProperty(PROP_CONTEXT_DEFAULT_SCHEMA, schemaName);
                }
            }
            return;
        }
        if (editorInput instanceof IncludedScriptFileEditorInput) {
            IncludedScriptFileEditorInput input = (IncludedScriptFileEditorInput)editorInput;
            input.setDatabaseEditorContext(context);
        }
        if ((file = EditorUtils.getFileFromInput(editorInput)) != null) {
            EditorUtils.setFileDataSource(file, context);
        } else {
            File localFile = EditorUtils.getLocalFileFromInput(editorInput);
            if (localFile != null) {
                EditorUtils.setFileDataSource(localFile, context);
            } else {
                log.error((Object)("Can't set datasource for input " + String.valueOf(editorInput)));
            }
        }
    }

    public static void setInputInputFile(@NotNull IEditorInput editorInput, @NotNull IFile file) {
        if (editorInput instanceof IInMemoryEditorInput) {
            ((IInMemoryEditorInput)editorInput).setProperty(PROP_INPUT_FILE, file);
        }
    }

    public static void setFileDataSource(@NotNull File localFile, @NotNull DatabaseEditorContext context) {
        DBPExternalFileManager efManager = DBPPlatformDesktop.getInstance().getExternalFileManager();
        DBPDataSourceContainer dataSourceContainer = context.getDataSourceContainer();
        efManager.setFileProperty(localFile, PROP_SQL_PROJECT_ID, dataSourceContainer == null ? null : dataSourceContainer.getRegistry().getProject().getName());
        String dataSourceId = dataSourceContainer == null ? null : dataSourceContainer.getId();
        efManager.setFileProperty(localFile, PROP_SQL_DATA_SOURCE_ID, (Object)dataSourceId);
        if (!EditorUtils.isDefaultContextSettings(context)) {
            efManager.setFileProperty(localFile, PROP_CONTEXT_DEFAULT_DATASOURCE, (Object)dataSourceId);
            String catalogName = EditorUtils.getDefaultCatalogName(context);
            if (catalogName != null) {
                efManager.setFileProperty(localFile, PROP_CONTEXT_DEFAULT_CATALOG, (Object)EditorUtils.getDefaultCatalogName(context));
            }
            String schemaName = EditorUtils.getDefaultSchemaName(context);
            if (catalogName != null || schemaName != null) {
                efManager.setFileProperty(localFile, PROP_CONTEXT_DEFAULT_SCHEMA, (Object)EditorUtils.getDefaultCatalogName(context));
            }
        }
    }

    public static void setFileDataSource(@NotNull IFile file, @NotNull DatabaseEditorContext context) {
        RCPProject projectMeta = (RCPProject)DBPPlatformDesktop.getInstance().getWorkspace().getProject(file.getProject());
        if (projectMeta == null) {
            return;
        }
        DBPDataSourceContainer dataSourceContainer = context.getDataSourceContainer();
        String dataSourceId = dataSourceContainer == null ? null : dataSourceContainer.getId();
        String resourcePath = projectMeta.getResourcePath((IResource)file);
        projectMeta.setResourceProperty(resourcePath, PROP_CONTEXT_DEFAULT_DATASOURCE, (Object)dataSourceId);
        if (!EditorUtils.isDefaultContextSettings(context)) {
            String defaultSchemaName;
            String defaultCatalogName = EditorUtils.getDefaultCatalogName(context);
            if (!CommonUtils.isEmpty((String)defaultCatalogName)) {
                projectMeta.setResourceProperty(resourcePath, PROP_CONTEXT_DEFAULT_CATALOG, (Object)defaultCatalogName);
            }
            if (!CommonUtils.isEmpty((String)(defaultSchemaName = EditorUtils.getDefaultSchemaName(context)))) {
                projectMeta.setResourceProperty(resourcePath, PROP_CONTEXT_DEFAULT_SCHEMA, (Object)defaultSchemaName);
            }
        }
    }

    private static boolean isDefaultContextSettings(DatabaseEditorContext context) {
        return context.getExecutionContext() == null && context.getSelectedObject() == null;
    }

    private static String getDefaultCatalogName(DatabaseEditorContext context) {
        DBCExecutionContext executionContext = context.getExecutionContext();
        if (executionContext != null) {
            DBSCatalog defaultCatalog;
            DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
            if (contextDefaults != null && (defaultCatalog = contextDefaults.getDefaultCatalog()) != null) {
                return defaultCatalog.getName();
            }
        } else {
            DBSCatalog catalog = context.getSelectedObject() instanceof DBSCatalog ? (DBSCatalog)context.getSelectedObject() : (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)context.getSelectedObject());
            return catalog == null ? null : catalog.getName();
        }
        return null;
    }

    private static String getDefaultSchemaName(DatabaseEditorContext context) {
        DBCExecutionContext executionContext = context.getExecutionContext();
        if (executionContext != null) {
            DBSSchema defaultSchema;
            DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
            if (contextDefaults != null && (defaultSchema = contextDefaults.getDefaultSchema()) != null) {
                return defaultSchema.getName();
            }
        } else {
            DBSSchema schema = context.getSelectedObject() instanceof DBSSchema ? (DBSSchema)context.getSelectedObject() : (DBSSchema)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)context.getSelectedObject());
            return schema == null ? null : schema.getName();
        }
        return null;
    }

    public static IEditorPart openExternalFileEditor(File file, IWorkbenchWindow window) {
        try {
            IEditorDescriptor desc = EditorUtils.getFileEditorDescriptor(file, window);
            IFileStore fileStore = EFS.getStore((URI)file.toURI());
            FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
            return IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IEditorInput)input, (String)desc.getId());
        }
        catch (CoreException e) {
            log.error((Object)("Can't open editor from file '" + file.getAbsolutePath()), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static IEditorDescriptor getFileEditorDescriptor(@NotNull File file, @NotNull IWorkbenchWindow window) {
        IEditorDescriptor desc = window.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        if (desc == null) {
            desc = window.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName() + ".txt");
        }
        if (desc == null) {
            desc = window.getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor");
        }
        return desc;
    }

    public static boolean isInAutoSaveJob() {
        Job currentJob = Job.getJobManager().currentJob();
        if (currentJob == null) {
            return false;
        }
        return "Auto save all editors".equals(currentJob.getName());
    }

    public static void trackControlContext(IWorkbenchSite site, Control control, final String contextId) {
        final IContextService contextService = (IContextService)site.getService(IContextService.class);
        if (contextService != null) {
            final IContextActivation[] activation = new IContextActivation[1];
            FocusListener focusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                    if (activation[0] != null) {
                        contextService.deactivateContext(activation[0]);
                        activation[0] = null;
                    }
                    activation[0] = contextService.activateContext(contextId);
                }

                public void focusLost(FocusEvent e) {
                    if (activation[0] != null) {
                        contextService.deactivateContext(activation[0]);
                        activation[0] = null;
                    }
                }
            };
            control.addFocusListener(focusListener);
            control.addDisposeListener(e -> {
                if (activation[0] != null) {
                    contextService.deactivateContext(activation[0]);
                    iContextActivationArray[0] = null;
                }
            });
        }
    }

    public static void revertEditorChanges(IEditorPart editorPart) {
        DBCExecutionContext executionContext;
        if (editorPart instanceof IRevertableEditor) {
            ((IRevertableEditor)editorPart).doRevertToSaved();
        } else if (editorPart instanceof ITextEditor) {
            ((ITextEditor)editorPart).doRevertToSaved();
        }
        if (editorPart instanceof DBPContextProvider && editorPart instanceof IDataSourceContainerUpdate && (executionContext = ((DBPContextProvider)editorPart).getExecutionContext()) != null) {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)executionContext);
            try {
                if (txnManager != null && !txnManager.isAutoCommit()) {
                    RuntimeUtils.runTask(monitor -> {
                        try {
                            Throwable throwable = null;
                            Object var4_6 = null;
                            try (DBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Rollback editor transaction");){
                                txnManager.rollback(session, null);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (DBException e) {
                            throw new InvocationTargetException(e);
                        }
                    }, (String)"End editor transaction", (long)5000L);
                }
            }
            catch (DBCException e) {
                log.error((Object)e);
            }
        }
    }

    public static void appendProjectToolTip(@NotNull StringBuilder tip, @Nullable DBPProject project) {
        if (project == null || project.getWorkspace().getProjects().size() < 2) {
            return;
        }
        if (!tip.isEmpty() && tip.charAt(tip.length() - 1) != '\n') {
            tip.append('\n');
        }
        tip.append(EditorsMessages.database_editor_project).append(": ").append(project.getName());
    }

    public static List<Path> openExternalFiles(@NotNull String[] fileNames, @Nullable DBPDataSourceContainer currentContainer) {
        log.debug((Object)("Open external file(s) [" + Arrays.toString(fileNames) + "]"));
        ArrayList<Path> openedFiles = new ArrayList<Path>();
        Path[] filePaths = (Path[])Arrays.stream(fileNames).map(string -> Path.of(string, new String[0])).toArray(Path[]::new);
        EditorUtils.openFileEditors(filePaths, currentContainer, openedFiles);
        return openedFiles;
    }

    public static boolean openExternalFiles(@NotNull Path[] filePaths, @Nullable DBPDataSourceContainer currentContainer) {
        log.debug((Object)("Open external file(s) [" + Arrays.toString(filePaths) + "]"));
        ArrayList<Path> openedFiles = new ArrayList<Path>();
        return EditorUtils.openFileEditors(filePaths, currentContainer, openedFiles);
    }

    public static boolean openFileEditors(@NotNull Path[] fileNames, @Nullable DBPDataSourceContainer currentContainer, @NotNull List<Path> openedFiles) {
        LinkedHashMap<FileTypeHandlerDescriptor, List> filesByHandler = new LinkedHashMap<FileTypeHandlerDescriptor, List>();
        Path[] pathArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            Path path = pathArray[n2];
            if (Files.exists(path, new LinkOption[0])) {
                String fileExtension = IOUtils.getFileExtension((Path)path);
                FileTypeHandlerDescriptor handler = CommonUtils.isEmpty((String)fileExtension) ? null : FileTypeHandlerRegistry.getInstance().findHandler(fileExtension);
                filesByHandler.computeIfAbsent(handler, d -> new ArrayList()).add(path);
                openedFiles.add(path);
            } else {
                DBWorkbench.getPlatformUI().showError("Open file", "Can't open '" + String.valueOf(path) + "': file doesn't exist");
            }
            ++n2;
        }
        for (Map.Entry entry : filesByHandler.entrySet()) {
            FileTypeHandlerDescriptor handler = (FileTypeHandlerDescriptor)((Object)entry.getKey());
            List pathList = (List)entry.getValue();
            for (Path path : pathList) {
                if (IOUtils.isLocalPath((Path)path) || handler != null && handler.supportsRemoteFiles()) continue;
                return false;
            }
            if (handler == null) {
                for (Path path : pathList) {
                    IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
                    EditorUtils.openExternalFileEditor(path.toFile(), window);
                }
                continue;
            }
            try {
                handler.createHandler().openFiles(pathList, Map.of(), currentContainer);
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Open file error", "Can't open file '" + String.valueOf(pathList) + "'", (Throwable)e);
            }
        }
        return true;
    }

    public static void activatePartContexts(IWorkbenchPart part) {
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        if (contextService == null) {
            return;
        }
        try {
            contextService.deferUpdates(true);
            ActionUtils.fireCommandRefresh((String[])new String[]{"org.jkiss.dbeaver.core.txn.autocommit"});
        }
        finally {
            contextService.deferUpdates(false);
        }
    }

    public static void deactivatePartContexts(IWorkbenchPart part) {
    }

    public static void refreshPartContexts(IWorkbenchPart part) {
        EditorUtils.deactivatePartContexts(part);
        EditorUtils.activatePartContexts(part);
    }
}

