/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Object;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2OwnerType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.ext.db2.model.module.DB2Module;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DB2Variable
extends DB2Object<DBSObject> {
    private DB2Schema db2Schema;
    private Integer id;
    private String owner;
    private DB2OwnerType ownerType;
    private Timestamp createTime;
    private Timestamp lastRegenTime;
    private Boolean valid;
    private Boolean published;
    private String remarks;

    public DB2Variable(DBSObject owner, ResultSet dbResult) throws DBException {
        super(owner, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VARNAME"), true);
        this.id = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"VARID");
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
        this.ownerType = (DB2OwnerType)CommonUtils.valueOf(DB2OwnerType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNERTYPE"));
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.lastRegenTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_REGEN_TIME");
        this.valid = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"VALID", (String)DB2YesNo.Y.name());
        this.published = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"PUBLISHED", (String)DB2YesNo.Y.name());
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        if (owner instanceof DB2Module) {
            this.db2Schema = ((DB2Module)owner).getSchema();
        } else {
            String schemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"VARSCHEMA");
            this.db2Schema = ((DB2DataSource)owner).getSchema((DBRProgressMonitor)new VoidProgressMonitor(), schemaName);
        }
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public DB2Schema getSchema() {
        return this.db2Schema;
    }

    @Property(viewable=true, order=3)
    public Integer getId() {
        return this.id;
    }

    @Property(viewable=true, order=4, category="Owner")
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=true, order=5, category="Owner")
    public DB2OwnerType getOwnerType() {
        return this.ownerType;
    }

    @Property(viewable=true, order=6)
    public Boolean getValid() {
        return this.valid;
    }

    @Property(viewable=true, order=7)
    public Boolean getPublished() {
        return this.published;
    }

    @Property(viewable=false, order=8, category="Date & Time")
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=false, order=9, category="Date & Time")
    public Timestamp getLastRegenTime() {
        return this.lastRegenTime;
    }
}

