/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.toml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.dataformat.toml.PackageVersion;
import com.fasterxml.jackson.dataformat.toml.TomlFactory;
import com.fasterxml.jackson.dataformat.toml.TomlReadFeature;
import com.fasterxml.jackson.dataformat.toml.TomlWriteFeature;

public class TomlMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public TomlMapper() {
        this(new TomlFactory());
    }

    public TomlMapper(TomlFactory f) {
        super((JsonFactory)f);
        this.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        this.coercionConfigDefaults().setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsNull);
    }

    public static Builder builder() {
        return new Builder(new TomlMapper());
    }

    public static Builder builder(TomlFactory streamFactory) {
        return new Builder(new TomlMapper(streamFactory));
    }

    public TomlMapper copy() {
        this._checkInvalidCopy(TomlMapper.class);
        return new TomlMapper(this.tokenStreamFactory().copy());
    }

    public TomlMapper configure(TomlReadFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public TomlMapper enable(TomlReadFeature f) {
        ((TomlFactory)this._jsonFactory).enable(f);
        return this;
    }

    public TomlMapper disable(TomlReadFeature f) {
        ((TomlFactory)this._jsonFactory).disable(f);
        return this;
    }

    public TomlMapper configure(TomlWriteFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public TomlMapper enable(TomlWriteFeature f) {
        ((TomlFactory)this._jsonFactory).enable(f);
        return this;
    }

    public TomlMapper disable(TomlWriteFeature f) {
        ((TomlFactory)this._jsonFactory).disable(f);
        return this;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public TomlFactory tokenStreamFactory() {
        return (TomlFactory)this._jsonFactory;
    }

    public static class Builder
    extends MapperBuilder<TomlMapper, Builder> {
        Builder(TomlMapper mapper) {
            super((ObjectMapper)mapper);
        }

        public Builder enable(TomlReadFeature ... features) {
            for (TomlReadFeature feature : features) {
                ((TomlMapper)this._mapper).enable(feature);
            }
            return this;
        }

        public Builder disable(TomlReadFeature ... features) {
            for (TomlReadFeature feature : features) {
                ((TomlMapper)this._mapper).disable(feature);
            }
            return this;
        }

        public Builder configure(TomlReadFeature feature, boolean state) {
            ((TomlMapper)this._mapper).configure(feature, state);
            return this;
        }

        public Builder enable(TomlWriteFeature ... features) {
            for (TomlWriteFeature feature : features) {
                ((TomlMapper)this._mapper).enable(feature);
            }
            return this;
        }

        public Builder disable(TomlWriteFeature ... features) {
            for (TomlWriteFeature feature : features) {
                ((TomlMapper)this._mapper).disable(feature);
            }
            return this;
        }

        public Builder configure(TomlWriteFeature feature, boolean state) {
            ((TomlMapper)this._mapper).configure(feature, state);
            return this;
        }
    }
}

