/*
 * Copyright (c) 2005, 2006, 2012, 2014, 2023 NVIDIA Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef __NV_GPUS_H
#define __NV_GPUS_H

typedef struct _LEGACY_INFO {
    unsigned int  uiDevId;
    unsigned int  uiSubVendorId;
    unsigned int  uiSubDevId;
    unsigned int  branch;
    char*         AdapterString;
} LEGACY_INFO;

enum { GPU_FLAGS_NO_GSP = 1 << 0, GPU_FLAGS_VGPU_GUEST = 1 << 1, GPU_FLAGS_VGPU_NO_GSP = 1 << 2, GPU_FLAGS_PROPRIETARY_POSSIBLE = 1 << 3, };

typedef struct _GPU_FLAGS {
    unsigned short  devId;
    unsigned short  flags;
} GPU_FLAGS;

typedef struct _GPU_SUBDEVICE_FLAGS {
    unsigned short  devId;
    unsigned short  subVendorId;
    unsigned short  subDevId;
    unsigned short  flags;
} GPU_SUBDEVICE_FLAGS;

typedef struct _LEGACY_STRINGS {
    unsigned int    branch;
    char*           description;
} LEGACY_STRINGS;

/*
 * This table describes how we should refer to legacy branches.
 */
static const LEGACY_STRINGS LegacyStrings[] = {
    { 8, "470.xx" },
    { 7, "390.xx" },
    { 6, "367.xx" },
    { 5, "340.xx" },
    { 4, "304.xx" },
    { 3, "173.14.xx" },
    { 2, "96.43.xx" },
    { 1, "71.86.xx" }
};

// This is the list of the legacy GPUs
static const LEGACY_INFO LegacyList[] = {
//    PCI-ID  Subvend Subdev   Branch  Marketing name
    { 0x0020, 0x0000, 0x0000,  1,      "RIVA TNT" },
    { 0x0028, 0x0000, 0x0000,  1,      "RIVA TNT2/TNT2 Pro" },
    { 0x00A0, 0x0000, 0x0000,  1,      "Aladdin TNT2" },
    { 0x002C, 0x0000, 0x0000,  1,      "Vanta/Vanta LT" },
    { 0x0029, 0x0000, 0x0000,  1,      "RIVA TNT2 Ultra" },
    { 0x002D, 0x0000, 0x0000,  1,      "RIVA TNT2 Model 64/Model 64 Pro" },
    { 0x0100, 0x0000, 0x0000,  1,      "GeForce 256" },
    { 0x0101, 0x0000, 0x0000,  1,      "GeForce DDR" },
    { 0x0103, 0x0000, 0x0000,  1,      "Quadro" },
    { 0x0150, 0x0000, 0x0000,  1,      "GeForce2 GTS/GeForce2 Pro" },
    { 0x0151, 0x0000, 0x0000,  1,      "GeForce2 Ti" },
    { 0x0152, 0x0000, 0x0000,  1,      "GeForce2 Ultra" },
    { 0x0153, 0x0000, 0x0000,  1,      "Quadro2 Pro" },
    { 0x0110, 0x0000, 0x0000,  2,      "GeForce2 MX/MX 400" },
    { 0x0111, 0x0000, 0x0000,  2,      "GeForce2 MX 100/200" },
    { 0x0113, 0x0000, 0x0000,  2,      "Quadro2 MXR/EX/Go" },
    { 0x0170, 0x0000, 0x0000,  2,      "GeForce4 MX 460" },
    { 0x0171, 0x0000, 0x0000,  2,      "GeForce4 MX 440" },
    { 0x0172, 0x0000, 0x0000,  2,      "GeForce4 MX 420" },
    { 0x0173, 0x0000, 0x0000,  2,      "GeForce4 MX 440-SE" },
    { 0x0178, 0x0000, 0x0000,  2,      "Quadro4 550 XGL" },
    { 0x017A, 0x0000, 0x0000,  2,      "Quadro NVS 400" },
    { 0x0181, 0x0000, 0x0000,  2,      "GeForce4 MX 440 with AGP8X" },
    { 0x0182, 0x0000, 0x0000,  2,      "GeForce4 MX 440SE with AGP8X" },
    { 0x0183, 0x0000, 0x0000,  2,      "GeForce4 MX 420 with AGP8X" },
    { 0x0185, 0x0000, 0x0000,  2,      "GeForce4 MX 4000" },
    { 0x0188, 0x0000, 0x0000,  2,      "Quadro4 580 XGL" },
    { 0x018A, 0x0000, 0x0000,  2,      "Quadro NVS 280 SD" },
    { 0x018B, 0x0000, 0x0000,  2,      "Quadro4 380 XGL" },
    { 0x018C, 0x0000, 0x0000,  2,      "Quadro NVS 50 PCI" },
    { 0x0200, 0x0000, 0x0000,  2,      "GeForce3" },
    { 0x0201, 0x0000, 0x0000,  2,      "GeForce3 Ti 200" },
    { 0x0202, 0x0000, 0x0000,  2,      "GeForce3 Ti 500" },
    { 0x0203, 0x0000, 0x0000,  2,      "Quadro DCC" },
    { 0x0250, 0x0000, 0x0000,  2,      "GeForce4 Ti 4600" },
    { 0x0251, 0x0000, 0x0000,  2,      "GeForce4 Ti 4400" },
    { 0x0253, 0x0000, 0x0000,  2,      "GeForce4 Ti 4200" },
    { 0x0258, 0x0000, 0x0000,  2,      "Quadro4 900 XGL" },
    { 0x0259, 0x0000, 0x0000,  2,      "Quadro4 750 XGL" },
    { 0x025B, 0x0000, 0x0000,  2,      "Quadro4 700 XGL" },
    { 0x0280, 0x0000, 0x0000,  2,      "GeForce4 Ti 4800" },
    { 0x0281, 0x0000, 0x0000,  2,      "GeForce4 Ti 4200 with AGP8X" },
    { 0x0282, 0x0000, 0x0000,  2,      "GeForce4 Ti 4800 SE" },
    { 0x0288, 0x0000, 0x0000,  2,      "Quadro4 980 XGL" },
    { 0x0289, 0x0000, 0x0000,  2,      "Quadro4 780 XGL" },
    { 0x0112, 0x0000, 0x0000,  2,      "GeForce2 Go" },
    { 0x0174, 0x0000, 0x0000,  2,      "GeForce4 440 Go" },
    { 0x0175, 0x0000, 0x0000,  2,      "GeForce4 420 Go" },
    { 0x0176, 0x0000, 0x0000,  2,      "GeForce4 420 Go 32M" },
    { 0x0177, 0x0000, 0x0000,  2,      "GeForce4 460 Go" },
    { 0x0179, 0x0000, 0x0000,  2,      "GeForce4 440 Go 64M" },
    { 0x017D, 0x0000, 0x0000,  2,      "GeForce4 410 Go 16M" },
    { 0x017C, 0x0000, 0x0000,  2,      "Quadro4 500 GoGL" },
    { 0x0286, 0x0000, 0x0000,  2,      "GeForce4 4200 Go" },
    { 0x028C, 0x0000, 0x0000,  2,      "Quadro4 700 GoGL" },
    { 0x01A0, 0x0000, 0x0000,  2,      "GeForce2 Integrated GPU" },
    { 0x01F0, 0x0000, 0x0000,  2,      "GeForce4 MX Integrated GPU" },
    { 0x0301, 0x0000, 0x0000,  3,      "GeForce FX 5800 Ultra" },
    { 0x0302, 0x0000, 0x0000,  3,      "GeForce FX 5800" },
    { 0x0311, 0x0000, 0x0000,  3,      "GeForce FX 5600 Ultra" },
    { 0x0312, 0x0000, 0x0000,  3,      "GeForce FX 5600" },
    { 0x0314, 0x0000, 0x0000,  3,      "GeForce FX 5600XT" },
    { 0x0320, 0x0000, 0x0000,  3,      "GeForce FX 5200" },
    { 0x0321, 0x0000, 0x0000,  3,      "GeForce FX 5200 Ultra" },
    { 0x0322, 0x0000, 0x0000,  3,      "GeForce FX 5200" },
    { 0x0323, 0x0000, 0x0000,  3,      "GeForce FX 5200LE" },
    { 0x0326, 0x0000, 0x0000,  3,      "GeForce FX 5500" },
    { 0x0327, 0x0000, 0x0000,  3,      "GeForce FX 5100" },
    { 0x0330, 0x0000, 0x0000,  3,      "GeForce FX 5900 Ultra" },
    { 0x0331, 0x0000, 0x0000,  3,      "GeForce FX 5900" },
    { 0x0332, 0x0000, 0x0000,  3,      "GeForce FX 5900XT" },
    { 0x0333, 0x0000, 0x0000,  3,      "GeForce FX 5950 Ultra" },
    { 0x0334, 0x0000, 0x0000,  3,      "GeForce FX 5900ZT" },
    { 0x0341, 0x0000, 0x0000,  3,      "GeForce FX 5700 Ultra" },
    { 0x0342, 0x0000, 0x0000,  3,      "GeForce FX 5700" },
    { 0x0343, 0x0000, 0x0000,  3,      "GeForce FX 5700LE" },
    { 0x0344, 0x0000, 0x0000,  3,      "GeForce FX 5700VE" },
    { 0x00FC, 0x0000, 0x0000,  3,      "Quadro FX 330" },
    { 0x00FD, 0x0000, 0x0000,  3,      "Quadro FX 330" },
    { 0x00FE, 0x0000, 0x0000,  3,      "Quadro FX 1300" },
    { 0x032B, 0x0000, 0x0000,  3,      "Quadro FX 500/FX 600" },
    { 0x033F, 0x0000, 0x0000,  3,      "Quadro FX 700" },
    { 0x0309, 0x0000, 0x0000,  3,      "Quadro FX 1000" },
    { 0x034E, 0x0000, 0x0000,  3,      "Quadro FX 1100" },
    { 0x0308, 0x0000, 0x0000,  3,      "Quadro FX 2000" },
    { 0x0338, 0x0000, 0x0000,  3,      "Quadro FX 3000" },
    { 0x031A, 0x0000, 0x0000,  3,      "GeForce FX Go5600" },
    { 0x031B, 0x0000, 0x0000,  3,      "GeForce FX Go5650" },
    { 0x0324, 0x0000, 0x0000,  3,      "GeForce FX Go5200" },
    { 0x0325, 0x0000, 0x0000,  3,      "GeForce FX Go5250" },
    { 0x0328, 0x0000, 0x0000,  3,      "GeForce FX Go5200 32M/64M" },
    { 0x032C, 0x0000, 0x0000,  3,      "GeForce FX Go53xx" },
    { 0x032D, 0x0000, 0x0000,  3,      "GeForce FX Go5100" },
    { 0x0347, 0x0000, 0x0000,  3,      "GeForce FX Go5700" },
    { 0x0348, 0x0000, 0x0000,  3,      "GeForce FX Go5700" },
    { 0x034C, 0x0000, 0x0000,  3,      "Quadro FX Go1000" },
    { 0x00FA, 0x0000, 0x0000,  3,      "GeForce PCX 5750" },
    { 0x00FB, 0x0000, 0x0000,  3,      "GeForce PCX 5900" },
    { 0x00FC, 0x0000, 0x0000,  3,      "GeForce PCX 5300" },
    { 0x00FD, 0x0000, 0x0000,  3,      "Quadro NVS 280 PCI-E" },
    { 0x032A, 0x0000, 0x0000,  3,      "Quadro NVS 55/280 PCI" },
    { 0x031C, 0x0000, 0x0000,  3,      "Quadro FX Go700" },
    { 0x00F1, 0x0000, 0x0000,  4,      "GeForce 6600 GT" },
    { 0x00F2, 0x0000, 0x0000,  4,      "GeForce 6600" },
    { 0x00F3, 0x0000, 0x0000,  4,      "GeForce 6200" },
    { 0x00F4, 0x0000, 0x0000,  4,      "GeForce 6600 LE" },
    { 0x00F5, 0x0000, 0x0000,  4,      "GeForce 7800 GS" },
    { 0x00F6, 0x0000, 0x0000,  4,      "GeForce 6800 GS" },
    { 0x00F8, 0x0000, 0x0000,  4,      "Quadro FX 3400" },
    { 0x00F8, 0x0000, 0x0000,  4,      "Quadro FX 4000" },
    { 0x00F9, 0x0000, 0x0000,  4,      "GeForce 6800 Ultra" },
    { 0x02E0, 0x0000, 0x0000,  4,      "GeForce 7600 GT" },
    { 0x02E1, 0x0000, 0x0000,  4,      "GeForce 7600 GS" },
    { 0x02E2, 0x0000, 0x0000,  4,      "GeForce 7300 GT" },
    { 0x02E3, 0x0000, 0x0000,  4,      "GeForce 7900 GS" },
    { 0x02E4, 0x0000, 0x0000,  4,      "GeForce 7950 GT" },
    { 0x0240, 0x0000, 0x0000,  4,      "GeForce 6150" },
    { 0x0241, 0x0000, 0x0000,  4,      "GeForce 6150 LE" },
    { 0x0242, 0x0000, 0x0000,  4,      "GeForce 6100" },
    { 0x0245, 0x0000, 0x0000,  4,      "Quadro NVS 210S / GeForce 6150LE" },
    { 0x03D0, 0x0000, 0x0000,  4,      "GeForce 6150SE nForce 430" },
    { 0x03D1, 0x0000, 0x0000,  4,      "GeForce 6100 nForce 405" },
    { 0x03D2, 0x0000, 0x0000,  4,      "GeForce 6100 nForce 400" },
    { 0x03D5, 0x0000, 0x0000,  4,      "GeForce 6100 nForce 420" },
    { 0x03D6, 0x0000, 0x0000,  4,      "GeForce 7025 / nForce 630a" },
    { 0x053A, 0x0000, 0x0000,  4,      "GeForce 7050 PV / nForce 630a" },
    { 0x053B, 0x0000, 0x0000,  4,      "GeForce 7050 PV / nForce 630a" },
    { 0x053E, 0x0000, 0x0000,  4,      "GeForce 7025 / nForce 630a" },
    { 0x07E0, 0x0000, 0x0000,  4,      "GeForce 7150 / nForce 630i" },
    { 0x07E1, 0x0000, 0x0000,  4,      "GeForce 7100 / nForce 630i" },
    { 0x07E2, 0x0000, 0x0000,  4,      "GeForce 7050 / nForce 630i" },
    { 0x07E3, 0x0000, 0x0000,  4,      "GeForce 7050 / nForce 610i" },
    { 0x07E5, 0x0000, 0x0000,  4,      "GeForce 7050 / nForce 620i" },
    { 0x0090, 0x0000, 0x0000,  4,      "GeForce 7800 GTX" },
    { 0x0091, 0x0000, 0x0000,  4,      "GeForce 7800 GTX" },
    { 0x0092, 0x0000, 0x0000,  4,      "GeForce 7800 GT" },
    { 0x0093, 0x0000, 0x0000,  4,      "GeForce 7800 GS" },
    { 0x0095, 0x0000, 0x0000,  4,      "GeForce 7800 SLI" },
    { 0x009D, 0x0000, 0x0000,  4,      "Quadro FX 4500" },
    { 0x0290, 0x0000, 0x0000,  4,      "GeForce 7900 GTX" },
    { 0x0291, 0x0000, 0x0000,  4,      "GeForce 7900 GT/GTO" },
    { 0x0292, 0x0000, 0x0000,  4,      "GeForce 7900 GS" },
    { 0x0293, 0x0000, 0x0000,  4,      "GeForce 7950 GX2" },
    { 0x0294, 0x0000, 0x0000,  4,      "GeForce 7950 GX2" },
    { 0x0295, 0x0000, 0x0000,  4,      "GeForce 7950 GT" },
    { 0x029C, 0x0000, 0x0000,  4,      "Quadro FX 5500" },
    { 0x029D, 0x0000, 0x0000,  4,      "Quadro FX 3500" },
    { 0x029E, 0x0000, 0x0000,  4,      "Quadro FX 1500" },
    { 0x029F, 0x0000, 0x0000,  4,      "Quadro FX 4500 X2" },
    { 0x01D0, 0x0000, 0x0000,  4,      "GeForce 7350 LE" },
    { 0x01D1, 0x0000, 0x0000,  4,      "GeForce 7300 LE" },
    { 0x01D2, 0x0000, 0x0000,  4,      "GeForce 7550 LE" },
    { 0x01D3, 0x0000, 0x0000,  4,      "GeForce 7300 SE/7200 GS" },
    { 0x01DD, 0x0000, 0x0000,  4,      "GeForce 7500 LE" },
    { 0x01DE, 0x0000, 0x0000,  4,      "Quadro FX 350" },
    { 0x01DF, 0x0000, 0x0000,  4,      "GeForce 7300 GS" },
    { 0x038B, 0x0000, 0x0000,  4,      "GeForce 7650 GS" },
    { 0x0390, 0x0000, 0x0000,  4,      "GeForce 7650 GS" },
    { 0x0391, 0x0000, 0x0000,  4,      "GeForce 7600 GT" },
    { 0x0392, 0x0000, 0x0000,  4,      "GeForce 7600 GS" },
    { 0x0393, 0x0000, 0x0000,  4,      "GeForce 7300 GT" },
    { 0x0394, 0x0000, 0x0000,  4,      "GeForce 7600 LE" },
    { 0x0395, 0x0000, 0x0000,  4,      "GeForce 7300 GT" },
    { 0x039E, 0x0000, 0x0000,  4,      "Quadro FX 560" },
    { 0x0040, 0x0000, 0x0000,  4,      "GeForce 6800 Ultra" },
    { 0x0041, 0x0000, 0x0000,  4,      "GeForce 6800" },
    { 0x0042, 0x0000, 0x0000,  4,      "GeForce 6800 LE" },
    { 0x0043, 0x0000, 0x0000,  4,      "GeForce 6800 XE" },
    { 0x0044, 0x0000, 0x0000,  4,      "GeForce 6800 XT" },
    { 0x0045, 0x0000, 0x0000,  4,      "GeForce 6800 GT" },
    { 0x0047, 0x0000, 0x0000,  4,      "GeForce 6800 GS" },
    { 0x0048, 0x0000, 0x0000,  4,      "GeForce 6800 XT" },
    { 0x004E, 0x0000, 0x0000,  4,      "Quadro FX 4000" },
    { 0x00C0, 0x0000, 0x0000,  4,      "GeForce 6800 GS" },
    { 0x00C1, 0x0000, 0x0000,  4,      "GeForce 6800" },
    { 0x00C2, 0x0000, 0x0000,  4,      "GeForce 6800 LE" },
    { 0x00C3, 0x0000, 0x0000,  4,      "GeForce 6800 XT" },
    { 0x00CD, 0x0000, 0x0000,  4,      "Quadro FX 3450/4000 SDI" },
    { 0x00CE, 0x0000, 0x0000,  4,      "Quadro FX 1400" },
    { 0x0140, 0x0000, 0x0000,  4,      "GeForce 6600 GT" },
    { 0x0141, 0x0000, 0x0000,  4,      "GeForce 6600" },
    { 0x0142, 0x0000, 0x0000,  4,      "GeForce 6600 LE" },
    { 0x0143, 0x0000, 0x0000,  4,      "GeForce 6600 VE" },
    { 0x0145, 0x0000, 0x0000,  4,      "GeForce 6610 XL" },
    { 0x0147, 0x0000, 0x0000,  4,      "GeForce 6700 XL" },
    { 0x014A, 0x0000, 0x0000,  4,      "Quadro NVS 440" },
    { 0x014C, 0x0000, 0x0000,  4,      "Quadro FX 540M" },
    { 0x014D, 0x0000, 0x0000,  4,      "Quadro FX 550" },
    { 0x014E, 0x0000, 0x0000,  4,      "Quadro FX 540" },
    { 0x014F, 0x0000, 0x0000,  4,      "GeForce 6200" },
    { 0x0160, 0x0000, 0x0000,  4,      "GeForce 6500" },
    { 0x0161, 0x0000, 0x0000,  4,      "GeForce 6200 TurboCache(TM)" },
    { 0x0162, 0x0000, 0x0000,  4,      "GeForce 6200SE TurboCache(TM)" },
    { 0x0163, 0x0000, 0x0000,  4,      "GeForce 6200 LE" },
    { 0x0165, 0x0000, 0x0000,  4,      "Quadro NVS 285" },
    { 0x0169, 0x0000, 0x0000,  4,      "GeForce 6250" },
    { 0x016A, 0x0000, 0x0000,  4,      "GeForce 7100 GS" },
    { 0x0221, 0x0000, 0x0000,  4,      "GeForce 6200" },
    { 0x0222, 0x0000, 0x0000,  4,      "GeForce 6200 A-LE" },
    { 0x0046, 0x0000, 0x0000,  4,      "GeForce 6800 GT" },
    { 0x0211, 0x0000, 0x0000,  4,      "GeForce 6800" },
    { 0x0212, 0x0000, 0x0000,  4,      "GeForce 6800 LE" },
    { 0x0215, 0x0000, 0x0000,  4,      "GeForce 6800 GT" },
    { 0x0218, 0x0000, 0x0000,  4,      "GeForce 6800 XT" },
    { 0x0244, 0x0000, 0x0000,  4,      "GeForce Go 6150" },
    { 0x0247, 0x0000, 0x0000,  4,      "GeForce Go 6100" },
    { 0x0531, 0x0000, 0x0000,  4,      "GeForce 7150M / nForce 630M" },
    { 0x0533, 0x0000, 0x0000,  4,      "GeForce 7000M / nForce 610M" },
    { 0x0098, 0x0000, 0x0000,  4,      "GeForce Go 7800" },
    { 0x0099, 0x0000, 0x0000,  4,      "GeForce Go 7800 GTX" },
    { 0x0297, 0x0000, 0x0000,  4,      "GeForce Go 7950 GTX" },
    { 0x0298, 0x0000, 0x0000,  4,      "GeForce Go 7900 GS" },
    { 0x0299, 0x0000, 0x0000,  4,      "Quadro NVS 510M" },
    { 0x029A, 0x0000, 0x0000,  4,      "Quadro FX 2500M" },
    { 0x029B, 0x0000, 0x0000,  4,      "Quadro FX 1500M" },
    { 0x01D6, 0x0000, 0x0000,  4,      "GeForce Go 7200" },
    { 0x01D7, 0x0000, 0x0000,  4,      "GeForce Go 7300" },
    { 0x01D8, 0x0000, 0x0000,  4,      "GeForce Go 7400" },
    { 0x01DA, 0x0000, 0x0000,  4,      "Quadro NVS 110M" },
    { 0x01DB, 0x0000, 0x0000,  4,      "Quadro NVS 120M" },
    { 0x01DC, 0x0000, 0x0000,  4,      "Quadro FX 350M" },
    { 0x0397, 0x0000, 0x0000,  4,      "GeForce Go 7700" },
    { 0x0398, 0x0000, 0x0000,  4,      "GeForce Go 7600" },
    { 0x0399, 0x0000, 0x0000,  4,      "GeForce Go 7600 GT" },
    { 0x039C, 0x0000, 0x0000,  4,      "Quadro FX 560M" },
    { 0x00C8, 0x0000, 0x0000,  4,      "GeForce Go 6800" },
    { 0x00C9, 0x0000, 0x0000,  4,      "GeForce Go 6800 Ultra" },
    { 0x00CC, 0x0000, 0x0000,  4,      "Quadro FX Go1400" },
    { 0x0144, 0x0000, 0x0000,  4,      "GeForce Go 6600" },
    { 0x0146, 0x0000, 0x0000,  4,      "GeForce Go 6600 TE/6200 TE" },
    { 0x0148, 0x0000, 0x0000,  4,      "GeForce Go 6600" },
    { 0x0149, 0x0000, 0x0000,  4,      "GeForce Go 6600 GT" },
    { 0x0164, 0x0000, 0x0000,  4,      "GeForce Go 6200" },
    { 0x0166, 0x0000, 0x0000,  4,      "GeForce Go 6400" },
    { 0x0167, 0x0000, 0x0000,  4,      "GeForce Go 6200" },
    { 0x0168, 0x0000, 0x0000,  4,      "GeForce Go 6400" },
    { 0x0840, 0x0000, 0x0000,  5,      "GeForce 8200M" },
    { 0x0846, 0x0000, 0x0000,  5,      "GeForce 9200" },
    { 0x0847, 0x0000, 0x0000,  5,      "GeForce 9100" },
    { 0x0848, 0x0000, 0x0000,  5,      "GeForce 8300" },
    { 0x0849, 0x0000, 0x0000,  5,      "GeForce 8200" },
    { 0x084A, 0x0000, 0x0000,  5,      "nForce 730a" },
    { 0x084B, 0x0000, 0x0000,  5,      "GeForce 9200" },
    { 0x084C, 0x0000, 0x0000,  5,      "nForce 980a/780a SLI" },
    { 0x084D, 0x0000, 0x0000,  5,      "nForce 750a SLI" },
    { 0x084F, 0x0000, 0x0000,  5,      "GeForce 8100 / nForce 720a" },
    { 0x0860, 0x0000, 0x0000,  5,      "GeForce 9400" },
    { 0x0861, 0x0000, 0x0000,  5,      "GeForce 9400" },
    { 0x0862, 0x0000, 0x0000,  5,      "GeForce 9400M G" },
    { 0x0863, 0x0000, 0x0000,  5,      "GeForce 9400M" },
    { 0x0864, 0x0000, 0x0000,  5,      "GeForce 9300" },
    { 0x0865, 0x0000, 0x0000,  5,      "ION" },
    { 0x0866, 0x0000, 0x0000,  5,      "GeForce 9400M G" },
    { 0x0866, 0x106B, 0x00B1,  5,      "GeForce 9400M" },
    { 0x0867, 0x0000, 0x0000,  5,      "GeForce 9400" },
    { 0x0868, 0x0000, 0x0000,  5,      "nForce 760i SLI" },
    { 0x0869, 0x0000, 0x0000,  5,      "GeForce 9400" },
    { 0x086A, 0x0000, 0x0000,  5,      "GeForce 9400" },
    { 0x086C, 0x0000, 0x0000,  5,      "GeForce 9300 / nForce 730i" },
    { 0x086D, 0x0000, 0x0000,  5,      "GeForce 9200" },
    { 0x086E, 0x0000, 0x0000,  5,      "GeForce 9100M G" },
    { 0x086F, 0x0000, 0x0000,  5,      "GeForce 8200M G" },
    { 0x0870, 0x0000, 0x0000,  5,      "GeForce 9400M" },
    { 0x0871, 0x0000, 0x0000,  5,      "GeForce 9200" },
    { 0x0872, 0x0000, 0x0000,  5,      "GeForce G102M" },
    { 0x0872, 0x1043, 0x1C42,  5,      "GeForce G205M" },
    { 0x0873, 0x0000, 0x0000,  5,      "GeForce G102M" },
    { 0x0873, 0x1043, 0x1C52,  5,      "GeForce G205M" },
    { 0x0874, 0x0000, 0x0000,  5,      "ION" },
    { 0x0876, 0x0000, 0x0000,  5,      "ION" },
    { 0x087A, 0x0000, 0x0000,  5,      "GeForce 9400" },
    { 0x087D, 0x0000, 0x0000,  5,      "ION" },
    { 0x0A20, 0x0000, 0x0000,  5,      "GeForce GT 220" },
    { 0x0A22, 0x0000, 0x0000,  5,      "GeForce 315" },
    { 0x0A23, 0x0000, 0x0000,  5,      "GeForce 210" },
    { 0x0A38, 0x0000, 0x0000,  5,      "Quadro 400" },
    { 0x0A60, 0x0000, 0x0000,  5,      "GeForce G210" },
    { 0x0A62, 0x0000, 0x0000,  5,      "GeForce 205" },
    { 0x0A63, 0x0000, 0x0000,  5,      "GeForce 310" },
    { 0x0A64, 0x0000, 0x0000,  5,      "Second Generation ION" },
    { 0x0A65, 0x0000, 0x0000,  5,      "GeForce 210" },
    { 0x0A66, 0x0000, 0x0000,  5,      "GeForce 310" },
    { 0x0A67, 0x0000, 0x0000,  5,      "GeForce 315" },
    { 0x0A68, 0x0000, 0x0000,  5,      "GeForce G105M" },
    { 0x0A69, 0x0000, 0x0000,  5,      "GeForce G105M" },
    { 0x0A6A, 0x0000, 0x0000,  5,      "NVS 2100M" },
    { 0x0A6C, 0x0000, 0x0000,  5,      "NVS 3100M" },
    { 0x0A6E, 0x0000, 0x0000,  5,      "GeForce 305M" },
    { 0x0A6E, 0x17AA, 0x3607,  5,      "Second Generation ION" },
    { 0x0A6F, 0x0000, 0x0000,  5,      "Second Generation ION" },
    { 0x0A76, 0x0000, 0x0000,  5,      "Second Generation ION" },
    { 0x0A78, 0x0000, 0x0000,  5,      "Quadro FX 380 LP" },
    { 0x0CA0, 0x0000, 0x0000,  5,      "GeForce GT 330" },
    { 0x0CA2, 0x0000, 0x0000,  5,      "GeForce GT 320" },
    { 0x0CA3, 0x0000, 0x0000,  5,      "GeForce GT 240" },
    { 0x0CA4, 0x0000, 0x0000,  5,      "GeForce GT 340" },
    { 0x0CA5, 0x0000, 0x0000,  5,      "GeForce GT 220" },
    { 0x0CA7, 0x0000, 0x0000,  5,      "GeForce GT 330" },
    { 0x0CAC, 0x0000, 0x0000,  5,      "GeForce GT 220" },
    { 0x05E0, 0x0000, 0x0000,  5,      "GeForce GTX 295" },
    { 0x05E1, 0x0000, 0x0000,  5,      "GeForce GTX 280" },
    { 0x05E2, 0x0000, 0x0000,  5,      "GeForce GTX 260" },
    { 0x05E3, 0x0000, 0x0000,  5,      "GeForce GTX 285" },
    { 0x05E6, 0x0000, 0x0000,  5,      "GeForce GTX 275" },
    { 0x05E7, 0x0000, 0x0000,  5,      "Tesla C1060" },
    { 0x05E7, 0x10DE, 0x0595,  5,      "Tesla T10 Processor" },
    { 0x05E7, 0x10DE, 0x068F,  5,      "Tesla T10 Processor" },
    { 0x05E7, 0x10DE, 0x0697,  5,      "Tesla M1060" },
    { 0x05E7, 0x10DE, 0x0714,  5,      "Tesla M1060" },
    { 0x05E7, 0x10DE, 0x0743,  5,      "Tesla M1060" },
    { 0x05EA, 0x0000, 0x0000,  5,      "GeForce GTX 260" },
    { 0x05EB, 0x0000, 0x0000,  5,      "GeForce GTX 295" },
    { 0x05ED, 0x0000, 0x0000,  5,      "Quadroplex 2200 D2" },
    { 0x05F8, 0x0000, 0x0000,  5,      "Quadroplex 2200 S4" },
    { 0x05F9, 0x0000, 0x0000,  5,      "Quadro CX" },
    { 0x05FD, 0x0000, 0x0000,  5,      "Quadro FX 5800" },
    { 0x05FE, 0x0000, 0x0000,  5,      "Quadro FX 4800" },
    { 0x05FF, 0x0000, 0x0000,  5,      "Quadro FX 3800" },
    { 0x0191, 0x0000, 0x0000,  5,      "GeForce 8800 GTX" },
    { 0x0193, 0x0000, 0x0000,  5,      "GeForce 8800 GTS" },
    { 0x0194, 0x0000, 0x0000,  5,      "GeForce 8800 Ultra" },
    { 0x0197, 0x0000, 0x0000,  5,      "Tesla C870" },
    { 0x019D, 0x0000, 0x0000,  5,      "Quadro FX 5600" },
    { 0x019E, 0x0000, 0x0000,  5,      "Quadro FX 4600" },
    { 0x0400, 0x0000, 0x0000,  5,      "GeForce 8600 GTS" },
    { 0x0401, 0x0000, 0x0000,  5,      "GeForce 8600 GT" },
    { 0x0402, 0x0000, 0x0000,  5,      "GeForce 8600 GT" },
    { 0x0403, 0x0000, 0x0000,  5,      "GeForce 8600 GS" },
    { 0x0404, 0x0000, 0x0000,  5,      "GeForce 8400 GS" },
    { 0x0405, 0x0000, 0x0000,  5,      "GeForce 9500M GS" },
    { 0x0406, 0x0000, 0x0000,  5,      "GeForce 8300 GS" },
    { 0x040B, 0x0000, 0x0000,  5,      "Quadro NVS 320M" },
    { 0x040C, 0x0000, 0x0000,  5,      "Quadro FX 570M" },
    { 0x040D, 0x0000, 0x0000,  5,      "Quadro FX 1600M" },
    { 0x040E, 0x0000, 0x0000,  5,      "Quadro FX 570" },
    { 0x040F, 0x0000, 0x0000,  5,      "Quadro FX 1700" },
    { 0x0410, 0x0000, 0x0000,  5,      "GeForce GT 330" },
    { 0x0420, 0x0000, 0x0000,  5,      "GeForce 8400 SE" },
    { 0x0421, 0x0000, 0x0000,  5,      "GeForce 8500 GT" },
    { 0x0422, 0x0000, 0x0000,  5,      "GeForce 8400 GS" },
    { 0x0423, 0x0000, 0x0000,  5,      "GeForce 8300 GS" },
    { 0x0424, 0x0000, 0x0000,  5,      "GeForce 8400 GS" },
    { 0x042C, 0x0000, 0x0000,  5,      "GeForce 9400 GT" },
    { 0x042D, 0x0000, 0x0000,  5,      "Quadro FX 360M" },
    { 0x042E, 0x0000, 0x0000,  5,      "GeForce 9300M G" },
    { 0x042F, 0x0000, 0x0000,  5,      "Quadro NVS 290" },
    { 0x0600, 0x0000, 0x0000,  5,      "GeForce 8800 GTS 512" },
    { 0x0601, 0x0000, 0x0000,  5,      "GeForce 9800 GT" },
    { 0x0602, 0x0000, 0x0000,  5,      "GeForce 8800 GT" },
    { 0x0603, 0x0000, 0x0000,  5,      "GeForce GT 230" },
    { 0x0605, 0x0000, 0x0000,  5,      "GeForce 9800 GT" },
    { 0x0606, 0x0000, 0x0000,  5,      "GeForce 8800 GS" },
    { 0x0607, 0x0000, 0x0000,  5,      "GeForce GTS 240" },
    { 0x0611, 0x0000, 0x0000,  5,      "GeForce 8800 GT" },
    { 0x0618, 0x0000, 0x0000,  5,      "GeForce GTX 260M" },
    { 0x0619, 0x0000, 0x0000,  5,      "Quadro FX 4700 X2" },
    { 0x061A, 0x0000, 0x0000,  5,      "Quadro FX 3700" },
    { 0x061B, 0x0000, 0x0000,  5,      "Quadro VX 200" },
    { 0x06E0, 0x0000, 0x0000,  5,      "GeForce 9300 GE" },
    { 0x06E1, 0x0000, 0x0000,  5,      "GeForce 9300 GS" },
    { 0x06E2, 0x0000, 0x0000,  5,      "GeForce 8400" },
    { 0x06E3, 0x0000, 0x0000,  5,      "GeForce 8400 SE" },
    { 0x06E4, 0x0000, 0x0000,  5,      "GeForce 8400 GS" },
    { 0x06E7, 0x0000, 0x0000,  5,      "GeForce 9300 SE" },
    { 0x06FF, 0x0000, 0x0000,  5,      "HICx16 + Graphics" },
    { 0x06FF, 0x10DE, 0x0711,  5,      "HICx8 + Graphics" },
    { 0x0844, 0x0000, 0x0000,  5,      "GeForce 9100M G" },
    { 0x0845, 0x0000, 0x0000,  5,      "GeForce 8200M G" },
    { 0x087E, 0x0000, 0x0000,  5,      "ION LE" },
    { 0x087F, 0x0000, 0x0000,  5,      "ION LE" },
    { 0x08A0, 0x0000, 0x0000,  5,      "GeForce 320M" },
    { 0x08A2, 0x0000, 0x0000,  5,      "GeForce 320M" },
    { 0x08A3, 0x0000, 0x0000,  5,      "GeForce 320M" },
    { 0x08A4, 0x0000, 0x0000,  5,      "GeForce 320M" },
    { 0x08A5, 0x0000, 0x0000,  5,      "GeForce 320M" },
    { 0x0A26, 0x0000, 0x0000,  5,      "GeForce 405" },
    { 0x0A27, 0x0000, 0x0000,  5,      "GeForce 405" },
    { 0x0A28, 0x0000, 0x0000,  5,      "GeForce GT 230M" },
    { 0x0A29, 0x0000, 0x0000,  5,      "GeForce GT 330M" },
    { 0x0A2A, 0x0000, 0x0000,  5,      "GeForce GT 230M" },
    { 0x0A2B, 0x0000, 0x0000,  5,      "GeForce GT 330M" },
    { 0x0A2C, 0x0000, 0x0000,  5,      "NVS 5100M" },
    { 0x0A2D, 0x0000, 0x0000,  5,      "GeForce GT 320M" },
    { 0x0A32, 0x0000, 0x0000,  5,      "GeForce GT 415" },
    { 0x0A34, 0x0000, 0x0000,  5,      "GeForce GT 240M" },
    { 0x0A35, 0x0000, 0x0000,  5,      "GeForce GT 325M" },
    { 0x0A3C, 0x0000, 0x0000,  5,      "Quadro FX 880M" },
    { 0x0A70, 0x0000, 0x0000,  5,      "GeForce 310M" },
    { 0x0A70, 0x17AA, 0x3605,  5,      "Second Generation ION" },
    { 0x0A70, 0x17AA, 0x3617,  5,      "Second Generation ION" },
    { 0x0A71, 0x0000, 0x0000,  5,      "GeForce 305M" },
    { 0x0A72, 0x0000, 0x0000,  5,      "GeForce 310M" },
    { 0x0A73, 0x0000, 0x0000,  5,      "GeForce 305M" },
    { 0x0A73, 0x17AA, 0x3607,  5,      "Second Generation ION" },
    { 0x0A73, 0x17AA, 0x3610,  5,      "Second Generation ION" },
    { 0x0A74, 0x0000, 0x0000,  5,      "GeForce G210M" },
    { 0x0A74, 0x17AA, 0x903A,  5,      "GeForce G210" },
    { 0x0A75, 0x0000, 0x0000,  5,      "GeForce 310M" },
    { 0x0A75, 0x17AA, 0x3605,  5,      "Second Generation ION" },
    { 0x0A7A, 0x0000, 0x0000,  5,      "GeForce 315M" },
    { 0x0A7A, 0x1BFD, 0x0003,  5,      "GeForce 405" },
    { 0x0A7A, 0x17AA, 0x3950,  5,      "GeForce 405M" },
    { 0x0A7A, 0x17AA, 0x397D,  5,      "GeForce 405M" },
    { 0x0A7A, 0x1642, 0x3980,  5,      "GeForce 405" },
    { 0x0A7A, 0x1BFD, 0x8006,  5,      "GeForce 405" },
    { 0x0A7A, 0x1B0A, 0x90B4,  5,      "GeForce 405" },
    { 0x0A7A, 0x1462, 0xAA51,  5,      "GeForce 405" },
    { 0x0A7A, 0x1462, 0xAA58,  5,      "GeForce 405" },
    { 0x0A7A, 0x1462, 0xAC71,  5,      "GeForce 405" },
    { 0x0A7A, 0x1462, 0xAC82,  5,      "GeForce 405" },
    { 0x0A7C, 0x0000, 0x0000,  5,      "Quadro FX 380M" },
    { 0x0CA8, 0x0000, 0x0000,  5,      "GeForce GTS 260M" },
    { 0x0CA9, 0x0000, 0x0000,  5,      "GeForce GTS 250M" },
    { 0x0CAF, 0x0000, 0x0000,  5,      "GeForce GT 335M" },
    { 0x0CB0, 0x0000, 0x0000,  5,      "GeForce GTS 350M" },
    { 0x0CB1, 0x0000, 0x0000,  5,      "GeForce GTS 360M" },
    { 0x0CBC, 0x0000, 0x0000,  5,      "Quadro FX 1800M" },
    { 0x0407, 0x0000, 0x0000,  5,      "GeForce 8600M GT" },
    { 0x0408, 0x0000, 0x0000,  5,      "GeForce 9650M GS" },
    { 0x0409, 0x0000, 0x0000,  5,      "GeForce 8700M GT" },
    { 0x040A, 0x0000, 0x0000,  5,      "Quadro FX 370" },
    { 0x0425, 0x0000, 0x0000,  5,      "GeForce 8600M GS" },
    { 0x0426, 0x0000, 0x0000,  5,      "GeForce 8400M GT" },
    { 0x0427, 0x0000, 0x0000,  5,      "GeForce 8400M GS" },
    { 0x0428, 0x0000, 0x0000,  5,      "GeForce 8400M G" },
    { 0x0429, 0x0000, 0x0000,  5,      "Quadro NVS 140M" },
    { 0x042A, 0x0000, 0x0000,  5,      "Quadro NVS 130M" },
    { 0x042B, 0x0000, 0x0000,  5,      "Quadro NVS 135M" },
    { 0x0604, 0x0000, 0x0000,  5,      "GeForce 9800 GX2" },
    { 0x0608, 0x0000, 0x0000,  5,      "GeForce 9800M GTX" },
    { 0x0609, 0x0000, 0x0000,  5,      "GeForce 8800M GTS" },
    { 0x0609, 0x106B, 0x00A7,  5,      "GeForce 8800 GS" },
    { 0x060A, 0x0000, 0x0000,  5,      "GeForce GTX 280M" },
    { 0x060B, 0x0000, 0x0000,  5,      "GeForce 9800M GT" },
    { 0x060C, 0x0000, 0x0000,  5,      "GeForce 8800M GTX" },
    { 0x060D, 0x0000, 0x0000,  5,      "GeForce 8800 GS" },
    { 0x060F, 0x0000, 0x0000,  5,      "GeForce GTX 285M" },
    { 0x0610, 0x0000, 0x0000,  5,      "GeForce 9600 GSO" },
    { 0x0612, 0x0000, 0x0000,  5,      "GeForce 9800 GTX/9800 GTX+" },
    { 0x0613, 0x0000, 0x0000,  5,      "GeForce 9800 GTX+" },
    { 0x0614, 0x0000, 0x0000,  5,      "GeForce 9800 GT" },
    { 0x0615, 0x0000, 0x0000,  5,      "GeForce GTS 250" },
    { 0x0617, 0x0000, 0x0000,  5,      "GeForce 9800M GTX" },
    { 0x061C, 0x0000, 0x0000,  5,      "Quadro FX 3600M" },
    { 0x061D, 0x0000, 0x0000,  5,      "Quadro FX 2800M" },
    { 0x061E, 0x0000, 0x0000,  5,      "Quadro FX 3700M" },
    { 0x061F, 0x0000, 0x0000,  5,      "Quadro FX 3800M" },
    { 0x0621, 0x0000, 0x0000,  5,      "GeForce GT 230" },
    { 0x0622, 0x0000, 0x0000,  5,      "GeForce 9600 GT" },
    { 0x0623, 0x0000, 0x0000,  5,      "GeForce 9600 GS" },
    { 0x0625, 0x0000, 0x0000,  5,      "GeForce 9600 GSO 512" },
    { 0x0626, 0x0000, 0x0000,  5,      "GeForce GT 130" },
    { 0x0627, 0x0000, 0x0000,  5,      "GeForce GT 140" },
    { 0x0628, 0x0000, 0x0000,  5,      "GeForce 9800M GTS" },
    { 0x062A, 0x0000, 0x0000,  5,      "GeForce 9700M GTS" },
    { 0x062B, 0x0000, 0x0000,  5,      "GeForce 9800M GS" },
    { 0x062C, 0x0000, 0x0000,  5,      "GeForce 9800M GTS" },
    { 0x062D, 0x0000, 0x0000,  5,      "GeForce 9600 GT" },
    { 0x062E, 0x0000, 0x0000,  5,      "GeForce 9600 GT" },
    { 0x062E, 0x106B, 0x0605,  5,      "GeForce GT 130" },
    { 0x0630, 0x0000, 0x0000,  5,      "GeForce 9700 S" },
    { 0x0631, 0x0000, 0x0000,  5,      "GeForce GTS 160M" },
    { 0x0632, 0x0000, 0x0000,  5,      "GeForce GTS 150M" },
    { 0x0635, 0x0000, 0x0000,  5,      "GeForce 9600 GSO" },
    { 0x0637, 0x0000, 0x0000,  5,      "GeForce 9600 GT" },
    { 0x0638, 0x0000, 0x0000,  5,      "Quadro FX 1800" },
    { 0x063A, 0x0000, 0x0000,  5,      "Quadro FX 2700M" },
    { 0x0640, 0x0000, 0x0000,  5,      "GeForce 9500 GT" },
    { 0x0641, 0x0000, 0x0000,  5,      "GeForce 9400 GT" },
    { 0x0643, 0x0000, 0x0000,  5,      "GeForce 9500 GT" },
    { 0x0644, 0x0000, 0x0000,  5,      "GeForce 9500 GS" },
    { 0x0645, 0x0000, 0x0000,  5,      "GeForce 9500 GS" },
    { 0x0646, 0x0000, 0x0000,  5,      "GeForce GT 120" },
    { 0x0647, 0x0000, 0x0000,  5,      "GeForce 9600M GT" },
    { 0x0648, 0x0000, 0x0000,  5,      "GeForce 9600M GS" },
    { 0x0649, 0x0000, 0x0000,  5,      "GeForce 9600M GT" },
    { 0x0649, 0x1043, 0x202D,  5,      "GeForce GT 220M" },
    { 0x064A, 0x0000, 0x0000,  5,      "GeForce 9700M GT" },
    { 0x064B, 0x0000, 0x0000,  5,      "GeForce 9500M G" },
    { 0x064C, 0x0000, 0x0000,  5,      "GeForce 9650M GT" },
    { 0x0651, 0x0000, 0x0000,  5,      "GeForce G 110M" },
    { 0x0652, 0x0000, 0x0000,  5,      "GeForce GT 130M" },
    { 0x0652, 0x152D, 0x0850,  5,      "GeForce GT 240M LE" },
    { 0x0653, 0x0000, 0x0000,  5,      "GeForce GT 120M" },
    { 0x0654, 0x0000, 0x0000,  5,      "GeForce GT 220M" },
    { 0x0654, 0x1043, 0x14A2,  5,      "GeForce GT 320M" },
    { 0x0654, 0x1043, 0x14D2,  5,      "GeForce GT 320M" },
    { 0x0655, 0x106B, 0x0633,  5,      "GeForce GT 120" },
    { 0x0656, 0x106B, 0x0693,  5,      "GeForce GT 120" },
    { 0x0658, 0x0000, 0x0000,  5,      "Quadro FX 380" },
    { 0x0659, 0x0000, 0x0000,  5,      "Quadro FX 580" },
    { 0x065A, 0x0000, 0x0000,  5,      "Quadro FX 1700M" },
    { 0x065B, 0x0000, 0x0000,  5,      "GeForce 9400 GT" },
    { 0x065C, 0x0000, 0x0000,  5,      "Quadro FX 770M" },
    { 0x06E5, 0x0000, 0x0000,  5,      "GeForce 9300M GS" },
    { 0x06E6, 0x0000, 0x0000,  5,      "GeForce G100" },
    { 0x06EC, 0x0000, 0x0000,  5,      "GeForce G 105M" },
    { 0x06EF, 0x0000, 0x0000,  5,      "GeForce G 103M" },
    { 0x06F1, 0x0000, 0x0000,  5,      "GeForce G105M" },
    { 0x06EB, 0x0000, 0x0000,  5,      "Quadro NVS 160M" },
    { 0x06EA, 0x0000, 0x0000,  5,      "Quadro NVS 150M" },
    { 0x06E9, 0x0000, 0x0000,  5,      "GeForce 9300M GS" },
    { 0x06E8, 0x0000, 0x0000,  5,      "GeForce 9200M GS" },
    { 0x06E8, 0x103C, 0x360B,  5,      "GeForce 9200M GE" },
    { 0x06F8, 0x0000, 0x0000,  5,      "Quadro NVS 420" },
    { 0x06F9, 0x0000, 0x0000,  5,      "Quadro FX 370 LP" },
    { 0x06F9, 0x10DE, 0x060D,  5,      "Quadro FX 370 Low Profile" },
    { 0x06FA, 0x0000, 0x0000,  5,      "Quadro NVS 450" },
    { 0x06FB, 0x0000, 0x0000,  5,      "Quadro FX 370M" },
    { 0x06FD, 0x0000, 0x0000,  5,      "Quadro NVS 295" },
    { 0x10C0, 0x0000, 0x0000,  5,      "GeForce 9300 GS" },
    { 0x10C3, 0x0000, 0x0000,  5,      "GeForce 8400GS" },
    { 0x10C5, 0x0000, 0x0000,  5,      "GeForce 405" },
    { 0x10D8, 0x0000, 0x0000,  5,      "NVS 300" },
    { 0x0FEF, 0x0000, 0x0000,  6,      "GRID K340" },
    { 0x0FF2, 0x0000, 0x0000,  6,      "GRID K1" },
    { 0x11BF, 0x0000, 0x0000,  6,      "GRID K2" },
    { 0x06C0, 0x0000, 0x0000,  7,      "GeForce GTX 480" },
    { 0x06C4, 0x0000, 0x0000,  7,      "GeForce GTX 465" },
    { 0x06CA, 0x0000, 0x0000,  7,      "GeForce GTX 480M" },
    { 0x06CD, 0x0000, 0x0000,  7,      "GeForce GTX 470" },
    { 0x06D1, 0x0000, 0x0000,  7,      "Tesla C2050 / C2070" },
    { 0x06D1, 0x10DE, 0x0771,  7,      "Tesla C2050" },
    { 0x06D1, 0x10DE, 0x0772,  7,      "Tesla C2070" },
    { 0x06D2, 0x0000, 0x0000,  7,      "Tesla M2070" },
    { 0x06D2, 0x10DE, 0x088F,  7,      "Tesla X2070" },
    { 0x06D8, 0x0000, 0x0000,  7,      "Quadro 6000" },
    { 0x06D9, 0x0000, 0x0000,  7,      "Quadro 5000" },
    { 0x06DA, 0x0000, 0x0000,  7,      "Quadro 5000M" },
    { 0x06DC, 0x0000, 0x0000,  7,      "Quadro 6000" },
    { 0x06DD, 0x0000, 0x0000,  7,      "Quadro 4000" },
    { 0x06DE, 0x0000, 0x0000,  7,      "Tesla T20 Processor" },
    { 0x06DE, 0x10DE, 0x0773,  7,      "Tesla S2050" },
    { 0x06DE, 0x10DE, 0x082F,  7,      "Tesla M2050" },
    { 0x06DE, 0x10DE, 0x0840,  7,      "Tesla X2070" },
    { 0x06DE, 0x10DE, 0x0842,  7,      "Tesla M2050" },
    { 0x06DE, 0x10DE, 0x0846,  7,      "Tesla M2050" },
    { 0x06DE, 0x10DE, 0x0866,  7,      "Tesla M2050" },
    { 0x06DE, 0x10DE, 0x0907,  7,      "Tesla M2050" },
    { 0x06DE, 0x10DE, 0x091E,  7,      "Tesla M2050" },
    { 0x06DF, 0x0000, 0x0000,  7,      "Tesla M2070-Q" },
    { 0x0DC0, 0x0000, 0x0000,  7,      "GeForce GT 440" },
    { 0x0DC4, 0x0000, 0x0000,  7,      "GeForce GTS 450" },
    { 0x0DC5, 0x0000, 0x0000,  7,      "GeForce GTS 450" },
    { 0x0DC6, 0x0000, 0x0000,  7,      "GeForce GTS 450" },
    { 0x0DCD, 0x0000, 0x0000,  7,      "GeForce GT 555M" },
    { 0x0DCE, 0x0000, 0x0000,  7,      "GeForce GT 555M" },
    { 0x0DD1, 0x0000, 0x0000,  7,      "GeForce GTX 460M" },
    { 0x0DD2, 0x0000, 0x0000,  7,      "GeForce GT 445M" },
    { 0x0DD3, 0x0000, 0x0000,  7,      "GeForce GT 435M" },
    { 0x0DD6, 0x0000, 0x0000,  7,      "GeForce GT 550M" },
    { 0x0DD8, 0x0000, 0x0000,  7,      "Quadro 2000" },
    { 0x0DD8, 0x10DE, 0x0914,  7,      "Quadro 2000D" },
    { 0x0DDA, 0x0000, 0x0000,  7,      "Quadro 2000M" },
    { 0x0DE0, 0x0000, 0x0000,  7,      "GeForce GT 440" },
    { 0x0DE1, 0x0000, 0x0000,  7,      "GeForce GT 430" },
    { 0x0DE2, 0x0000, 0x0000,  7,      "GeForce GT 420" },
    { 0x0DE3, 0x0000, 0x0000,  7,      "GeForce GT 635M" },
    { 0x0DE4, 0x0000, 0x0000,  7,      "GeForce GT 520" },
    { 0x0DE5, 0x0000, 0x0000,  7,      "GeForce GT 530" },
    { 0x0DE7, 0x0000, 0x0000,  7,      "GeForce GT 610" },
    { 0x0DE8, 0x0000, 0x0000,  7,      "GeForce GT 620M" },
    { 0x0DE9, 0x0000, 0x0000,  7,      "GeForce GT 630M" },
    { 0x0DE9, 0x1025, 0x0692,  7,      "GeForce GT 620M" },
    { 0x0DE9, 0x1025, 0x0725,  7,      "GeForce GT 620M" },
    { 0x0DE9, 0x1025, 0x0728,  7,      "GeForce GT 620M" },
    { 0x0DE9, 0x1025, 0x072B,  7,      "GeForce GT 620M" },
    { 0x0DE9, 0x1025, 0x072E,  7,      "GeForce GT 620M" },
    { 0x0DE9, 0x1025, 0x0753,  7,      "GeForce GT 620M" },
    { 0x0DE9, 0x1025, 0x0754,  7,      "GeForce GT 620M" },
    { 0x0DE9, 0x1B0A, 0x2210,  7,      "GeForce GT 635M" },
    { 0x0DE9, 0x17AA, 0x3977,  7,      "GeForce GT 640M LE" },
    { 0x0DEA, 0x0000, 0x0000,  7,      "GeForce 610M" },
    { 0x0DEA, 0x17AA, 0x365A,  7,      "GeForce 615" },
    { 0x0DEA, 0x17AA, 0x365B,  7,      "GeForce 615" },
    { 0x0DEA, 0x17AA, 0x365E,  7,      "GeForce 615" },
    { 0x0DEA, 0x17AA, 0x3660,  7,      "GeForce 615" },
    { 0x0DEA, 0x17AA, 0x366C,  7,      "GeForce 615" },
    { 0x0DEB, 0x0000, 0x0000,  7,      "GeForce GT 555M" },
    { 0x0DEC, 0x0000, 0x0000,  7,      "GeForce GT 525M" },
    { 0x0DED, 0x0000, 0x0000,  7,      "GeForce GT 520M" },
    { 0x0DEE, 0x0000, 0x0000,  7,      "GeForce GT 415M" },
    { 0x0DEF, 0x0000, 0x0000,  7,      "NVS 5400M" },
    { 0x0DF0, 0x0000, 0x0000,  7,      "GeForce GT 425M" },
    { 0x0DF1, 0x0000, 0x0000,  7,      "GeForce GT 420M" },
    { 0x0DF2, 0x0000, 0x0000,  7,      "GeForce GT 435M" },
    { 0x0DF3, 0x0000, 0x0000,  7,      "GeForce GT 420M" },
    { 0x0DF4, 0x0000, 0x0000,  7,      "GeForce GT 540M" },
    { 0x0DF4, 0x152D, 0x0952,  7,      "GeForce GT 630M" },
    { 0x0DF4, 0x152D, 0x0953,  7,      "GeForce GT 630M" },
    { 0x0DF5, 0x0000, 0x0000,  7,      "GeForce GT 525M" },
    { 0x0DF6, 0x0000, 0x0000,  7,      "GeForce GT 550M" },
    { 0x0DF7, 0x0000, 0x0000,  7,      "GeForce GT 520M" },
    { 0x0DF8, 0x0000, 0x0000,  7,      "Quadro 600" },
    { 0x0DF9, 0x0000, 0x0000,  7,      "Quadro 500M" },
    { 0x0DFA, 0x0000, 0x0000,  7,      "Quadro 1000M" },
    { 0x0DFC, 0x0000, 0x0000,  7,      "NVS 5200M" },
    { 0x0E22, 0x0000, 0x0000,  7,      "GeForce GTX 460" },
    { 0x0E23, 0x0000, 0x0000,  7,      "GeForce GTX 460 SE" },
    { 0x0E24, 0x0000, 0x0000,  7,      "GeForce GTX 460" },
    { 0x0E30, 0x0000, 0x0000,  7,      "GeForce GTX 470M" },
    { 0x0E31, 0x0000, 0x0000,  7,      "GeForce GTX 485M" },
    { 0x0E3A, 0x0000, 0x0000,  7,      "Quadro 3000M" },
    { 0x0E3B, 0x0000, 0x0000,  7,      "Quadro 4000M" },
    { 0x0F00, 0x0000, 0x0000,  7,      "GeForce GT 630" },
    { 0x0F01, 0x0000, 0x0000,  7,      "GeForce GT 620" },
    { 0x0F02, 0x0000, 0x0000,  7,      "GeForce GT 730" },
    { 0x0F03, 0x0000, 0x0000,  7,      "GeForce GT 610" },
    { 0x0FC6, 0x0000, 0x0000,  8,      "GeForce GTX 650" },
    { 0x0FC8, 0x0000, 0x0000,  8,      "GeForce GT 740" },
    { 0x0FC9, 0x0000, 0x0000,  8,      "GeForce GT 730" },
    { 0x0FCD, 0x0000, 0x0000,  8,      "GeForce GT 755M" },
    { 0x0FCE, 0x0000, 0x0000,  8,      "GeForce GT 640M LE" },
    { 0x0FD1, 0x0000, 0x0000,  8,      "GeForce GT 650M" },
    { 0x0FD2, 0x0000, 0x0000,  8,      "GeForce GT 640M" },
    { 0x0FD2, 0x1028, 0x0595,  8,      "GeForce GT 640M LE" },
    { 0x0FD2, 0x1028, 0x05B2,  8,      "GeForce GT 640M LE" },
    { 0x0FD3, 0x0000, 0x0000,  8,      "GeForce GT 640M LE" },
    { 0x0FD4, 0x0000, 0x0000,  8,      "GeForce GTX 660M" },
    { 0x0FD5, 0x0000, 0x0000,  8,      "GeForce GT 650M" },
    { 0x0FD8, 0x0000, 0x0000,  8,      "GeForce GT 640M" },
    { 0x0FD9, 0x0000, 0x0000,  8,      "GeForce GT 645M" },
    { 0x0FDF, 0x0000, 0x0000,  8,      "GeForce GT 740M" },
    { 0x0FE0, 0x0000, 0x0000,  8,      "GeForce GTX 660M" },
    { 0x0FE1, 0x0000, 0x0000,  8,      "GeForce GT 730M" },
    { 0x0FE2, 0x0000, 0x0000,  8,      "GeForce GT 745M" },
    { 0x0FE3, 0x103C, 0x2B16,  8,      "GeForce GT 745A" },
    { 0x0FE3, 0x17AA, 0x3675,  8,      "GeForce GT 745A" },
    { 0x0FE3, 0x0000, 0x0000,  8,      "GeForce GT 745M" },
    { 0x0FE4, 0x0000, 0x0000,  8,      "GeForce GT 750M" },
    { 0x0FE9, 0x0000, 0x0000,  8,      "GeForce GT 750M" },
    { 0x0FEA, 0x0000, 0x0000,  8,      "GeForce GT 755M" },
    { 0x0FEC, 0x0000, 0x0000,  8,      "GeForce 710A" },
    { 0x0FED, 0x0000, 0x0000,  8,      "GeForce 820M" },
    { 0x0FEE, 0x0000, 0x0000,  8,      "GeForce 810M" },
    { 0x0FF6, 0x0000, 0x0000,  8,      "Quadro K1100M" },
    { 0x0FF8, 0x0000, 0x0000,  8,      "Quadro K500M" },
    { 0x0FF9, 0x0000, 0x0000,  8,      "Quadro K2000D" },
    { 0x0FFA, 0x0000, 0x0000,  8,      "Quadro K600" },
    { 0x0FFB, 0x0000, 0x0000,  8,      "Quadro K2000M" },
    { 0x0FFC, 0x0000, 0x0000,  8,      "Quadro K1000M" },
    { 0x0FFD, 0x0000, 0x0000,  8,      "NVS 510" },
    { 0x0FFE, 0x0000, 0x0000,  8,      "Quadro K2000" },
    { 0x0FFF, 0x0000, 0x0000,  8,      "Quadro 410" },
    { 0x1001, 0x0000, 0x0000,  8,      "GeForce GTX TITAN Z" },
    { 0x1004, 0x0000, 0x0000,  8,      "GeForce GTX 780" },
    { 0x1005, 0x0000, 0x0000,  8,      "GeForce GTX TITAN" },
    { 0x1007, 0x0000, 0x0000,  8,      "GeForce GTX 780" },
    { 0x1008, 0x0000, 0x0000,  8,      "GeForce GTX 780 Ti" },
    { 0x100A, 0x0000, 0x0000,  8,      "GeForce GTX 780 Ti" },
    { 0x100C, 0x0000, 0x0000,  8,      "GeForce GTX TITAN Black" },
    { 0x1021, 0x0000, 0x0000,  8,      "Tesla K20Xm" },
    { 0x1022, 0x0000, 0x0000,  8,      "Tesla K20c" },
    { 0x1023, 0x0000, 0x0000,  8,      "Tesla K40m" },
    { 0x1024, 0x0000, 0x0000,  8,      "Tesla K40c" },
    { 0x1026, 0x0000, 0x0000,  8,      "Tesla K20s" },
    { 0x1027, 0x0000, 0x0000,  8,      "Tesla K40st" },
    { 0x1028, 0x0000, 0x0000,  8,      "Tesla K20m" },
    { 0x1029, 0x0000, 0x0000,  8,      "Tesla K40s" },
    { 0x102A, 0x0000, 0x0000,  8,      "Tesla K40t" },
    { 0x102D, 0x0000, 0x0000,  8,      "Tesla K80" },
    { 0x103A, 0x0000, 0x0000,  8,      "Quadro K6000" },
    { 0x103C, 0x0000, 0x0000,  8,      "Quadro K5200" },
    { 0x1040, 0x0000, 0x0000,  7,      "GeForce GT 520" },
    { 0x1042, 0x0000, 0x0000,  7,      "GeForce 510" },
    { 0x1048, 0x0000, 0x0000,  7,      "GeForce 605" },
    { 0x1049, 0x0000, 0x0000,  7,      "GeForce GT 620" },
    { 0x104A, 0x0000, 0x0000,  7,      "GeForce GT 610" },
    { 0x104B, 0x0000, 0x0000,  7,      "GeForce GT 625 (OEM)" },
    { 0x104B, 0x174B, 0x0625,  7,      "GeForce GT 625" },
    { 0x104B, 0x1043, 0x844C,  7,      "GeForce GT 625" },
    { 0x104B, 0x1043, 0x846B,  7,      "GeForce GT 625" },
    { 0x104B, 0x174B, 0xA625,  7,      "GeForce GT 625" },
    { 0x104B, 0x1462, 0xB590,  7,      "GeForce GT 625" },
    { 0x104C, 0x0000, 0x0000,  7,      "GeForce GT 705" },
    { 0x1050, 0x0000, 0x0000,  7,      "GeForce GT 520M" },
    { 0x1051, 0x0000, 0x0000,  7,      "GeForce GT 520MX" },
    { 0x1052, 0x0000, 0x0000,  7,      "GeForce GT 520M" },
    { 0x1054, 0x0000, 0x0000,  7,      "GeForce 410M" },
    { 0x1055, 0x0000, 0x0000,  7,      "GeForce 410M" },
    { 0x1056, 0x0000, 0x0000,  7,      "NVS 4200M" },
    { 0x1057, 0x0000, 0x0000,  7,      "NVS 4200M" },
    { 0x1058, 0x0000, 0x0000,  7,      "GeForce 610M" },
    { 0x1058, 0x103C, 0x2AF1,  7,      "GeForce 610" },
    { 0x1058, 0x17AA, 0x3682,  7,      "GeForce 800A" },
    { 0x1058, 0x705A, 0x3682,  7,      "GeForce 800A" },
    { 0x1058, 0x17AA, 0x3692,  7,      "GeForce 705A" },
    { 0x1058, 0x17AA, 0x3695,  7,      "GeForce 800A" },
    { 0x1058, 0x17AA, 0x36A8,  7,      "GeForce 800A" },
    { 0x1058, 0x17AA, 0x36AC,  7,      "GeForce 800A" },
    { 0x1058, 0x17AA, 0x36AD,  7,      "GeForce 800A" },
    { 0x1059, 0x0000, 0x0000,  7,      "GeForce 610M" },
    { 0x105A, 0x0000, 0x0000,  7,      "GeForce 610M" },
    { 0x105B, 0x0000, 0x0000,  7,      "GeForce 705M" },
    { 0x105B, 0x103C, 0x2AFB,  7,      "GeForce 705A" },
    { 0x105B, 0x17AA, 0x30B1,  7,      "GeForce 800A" },
    { 0x105B, 0x17AA, 0x30F3,  7,      "GeForce 705A" },
    { 0x105B, 0x17AA, 0x36A1,  7,      "GeForce 800A" },
    { 0x107C, 0x0000, 0x0000,  7,      "NVS 315" },
    { 0x107D, 0x0000, 0x0000,  7,      "NVS 310" },
    { 0x1080, 0x0000, 0x0000,  7,      "GeForce GTX 580" },
    { 0x1081, 0x0000, 0x0000,  7,      "GeForce GTX 570" },
    { 0x1082, 0x0000, 0x0000,  7,      "GeForce GTX 560 Ti" },
    { 0x1084, 0x0000, 0x0000,  7,      "GeForce GTX 560" },
    { 0x1086, 0x0000, 0x0000,  7,      "GeForce GTX 570" },
    { 0x1087, 0x0000, 0x0000,  7,      "GeForce GTX 560 Ti" },
    { 0x1088, 0x0000, 0x0000,  7,      "GeForce GTX 590" },
    { 0x1089, 0x0000, 0x0000,  7,      "GeForce GTX 580" },
    { 0x108B, 0x0000, 0x0000,  7,      "GeForce GTX 580" },
    { 0x1091, 0x0000, 0x0000,  7,      "Tesla M2090" },
    { 0x1091, 0x10DE, 0x088E,  7,      "Tesla X2090" },
    { 0x1091, 0x10DE, 0x0891,  7,      "Tesla X2090" },
    { 0x1091, 0x10DE, 0x0974,  7,      "Tesla X2090" },
    { 0x1091, 0x10DE, 0x098D,  7,      "Tesla X2090" },
    { 0x1094, 0x0000, 0x0000,  7,      "Tesla M2075" },
    { 0x1096, 0x0000, 0x0000,  7,      "Tesla C2075" },
    { 0x1096, 0x10DE, 0x0911,  7,      "Tesla C2050" },
    { 0x109A, 0x0000, 0x0000,  7,      "Quadro 5010M" },
    { 0x109B, 0x0000, 0x0000,  7,      "Quadro 7000" },
    { 0x1140, 0x14C0, 0x0083,  7,      "GeForce 820M" },
    { 0x1140, 0x1BAB, 0x0106,  7,      "GeForce 820M" },
    { 0x1140, 0x1854, 0x0177,  7,      "GeForce 710M" },
    { 0x1140, 0x1854, 0x0180,  7,      "GeForce 710M" },
    { 0x1140, 0x1854, 0x0190,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1854, 0x0192,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1B0A, 0x01C0,  7,      "GeForce 820M" },
    { 0x1140, 0x1854, 0x0224,  7,      "GeForce 820M" },
    { 0x1140, 0x1028, 0x054D,  7,      "GeForce GT 630M" },
    { 0x1140, 0x1028, 0x054E,  7,      "GeForce GT 630M" },
    { 0x1140, 0x1028, 0x0554,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1028, 0x0557,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1028, 0x0562,  7,      "GeForce GT 625M" },
    { 0x1140, 0x1028, 0x0565,  7,      "GeForce GT 630M" },
    { 0x1140, 0x1028, 0x0568,  7,      "GeForce GT 630M" },
    { 0x1140, 0x1028, 0x0590,  7,      "GeForce GT 630M" },
    { 0x1140, 0x1028, 0x0592,  7,      "GeForce GT 625M" },
    { 0x1140, 0x1028, 0x0594,  7,      "GeForce GT 625M" },
    { 0x1140, 0x1028, 0x0595,  7,      "GeForce GT 625M" },
    { 0x1140, 0x1028, 0x05A2,  7,      "GeForce GT 625M" },
    { 0x1140, 0x1028, 0x05B1,  7,      "GeForce GT 625M" },
    { 0x1140, 0x1028, 0x05B3,  7,      "GeForce GT 625M" },
    { 0x1140, 0x1028, 0x05DA,  7,      "GeForce GT 630M" },
    { 0x1140, 0x1028, 0x05DE,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1028, 0x05E0,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1028, 0x05E8,  7,      "GeForce GT 630M" },
    { 0x1140, 0x1028, 0x05F4,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1025, 0x0600,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1025, 0x0606,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1028, 0x060F,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1028, 0x062F,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1025, 0x064A,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1025, 0x064C,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1028, 0x064E,  7,      "GeForce 820M" },
    { 0x1140, 0x1028, 0x0652,  7,      "GeForce 820M" },
    { 0x1140, 0x1028, 0x0653,  7,      "GeForce 820M" },
    { 0x1140, 0x1028, 0x0655,  7,      "GeForce 820M" },
    { 0x1140, 0x1028, 0x065E,  7,      "GeForce 820M" },
    { 0x1140, 0x1028, 0x0662,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x067A,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1025, 0x0680,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1025, 0x0686,  7,      "GeForce 710M" },
    { 0x1140, 0x1025, 0x0689,  7,      "GeForce 710M" },
    { 0x1140, 0x1025, 0x068B,  7,      "GeForce 710M" },
    { 0x1140, 0x1025, 0x068D,  7,      "GeForce 710M" },
    { 0x1140, 0x1028, 0x068D,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x068E,  7,      "GeForce 710M" },
    { 0x1140, 0x1025, 0x0691,  7,      "GeForce 710M" },
    { 0x1140, 0x1025, 0x0692,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1025, 0x0694,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1028, 0x06AD,  7,      "GeForce 820M" },
    { 0x1140, 0x1028, 0x06AE,  7,      "GeForce 820M" },
    { 0x1140, 0x1028, 0x06AF,  7,      "GeForce 820M" },
    { 0x1140, 0x1028, 0x06B0,  7,      "GeForce 820M" },
    { 0x1140, 0x1028, 0x06C0,  7,      "GeForce 820M" },
    { 0x1140, 0x1028, 0x06C1,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0702,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1025, 0x0719,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1025, 0x0725,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1025, 0x0728,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1025, 0x072B,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1025, 0x072E,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1025, 0x0732,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1025, 0x0763,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1025, 0x0773,  7,      "GeForce 710M" },
    { 0x1140, 0x1025, 0x0774,  7,      "GeForce 710M" },
    { 0x1140, 0x1025, 0x0776,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1025, 0x077A,  7,      "GeForce 710M" },
    { 0x1140, 0x1025, 0x077B,  7,      "GeForce 710M" },
    { 0x1140, 0x1025, 0x077C,  7,      "GeForce 710M" },
    { 0x1140, 0x1025, 0x077D,  7,      "GeForce 710M" },
    { 0x1140, 0x1025, 0x077E,  7,      "GeForce 710M" },
    { 0x1140, 0x1025, 0x077F,  7,      "GeForce 710M" },
    { 0x1140, 0x1025, 0x0781,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1025, 0x0798,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1019, 0x0799,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0799,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1025, 0x079B,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1025, 0x079C,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1025, 0x0807,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1025, 0x0821,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0823,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1025, 0x0830,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1025, 0x0833,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1025, 0x0837,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1025, 0x083E,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0841,  7,      "GeForce 710M" },
    { 0x1140, 0x1025, 0x0853,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0854,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0855,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0856,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0857,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0858,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0863,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0868,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0869,  7,      "GeForce 810M" },
    { 0x1140, 0x1025, 0x0873,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0878,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x087B,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x087F,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0881,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0885,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x088A,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x089B,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0921,  7,      "GeForce 820M" },
    { 0x1140, 0x152D, 0x0926,  7,      "GeForce 620M" },
    { 0x1140, 0x1025, 0x092E,  7,      "GeForce 810M" },
    { 0x1140, 0x1025, 0x092F,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0932,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x093A,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x093C,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x093F,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0941,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0945,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0954,  7,      "GeForce 820M" },
    { 0x1140, 0x1025, 0x0965,  7,      "GeForce 820M" },
    { 0x1140, 0x152D, 0x0982,  7,      "GeForce GT 630M" },
    { 0x1140, 0x152D, 0x0983,  7,      "GeForce GT 630M" },
    { 0x1140, 0x105B, 0x0DAC,  7,      "GeForce GT 720M" },
    { 0x1140, 0x105B, 0x0DAD,  7,      "GeForce GT 720M" },
    { 0x1140, 0x105B, 0x0EF3,  7,      "GeForce GT 720M" },
    { 0x1140, 0x152D, 0x1005,  7,      "GeForce GT 820M" },
    { 0x1140, 0x152D, 0x1012,  7,      "GeForce 710M" },
    { 0x1140, 0x1D05, 0x1013,  7,      "GeForce 810M" },
    { 0x1140, 0x152D, 0x1019,  7,      "GeForce 820M" },
    { 0x1140, 0x152D, 0x1030,  7,      "GeForce GT 630M" },
    { 0x1140, 0x152D, 0x1055,  7,      "GeForce 710M" },
    { 0x1140, 0x152D, 0x1067,  7,      "GeForce GT 720M" },
    { 0x1140, 0x152D, 0x1092,  7,      "GeForce 820M" },
    { 0x1140, 0x1462, 0x10B8,  7,      "GeForce GT 710M" },
    { 0x1140, 0x1043, 0x10DD,  7,      "NVS 5200M" },
    { 0x1140, 0x1462, 0x10E9,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1043, 0x10ED,  7,      "NVS 5200M" },
    { 0x1140, 0x1462, 0x1116,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x11FD,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1043, 0x124D,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1043, 0x126D,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1043, 0x131D,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1043, 0x13FD,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1043, 0x14C7,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1043, 0x1507,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1043, 0x15AD,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x15ED,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x160D,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x163D,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x165D,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x166D,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x16CD,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x16DD,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x170D,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x176D,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x178D,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x179D,  7,      "GeForce 820M" },
    { 0x1140, 0x10CF, 0x17F5,  7,      "GeForce GT 720M" },
    { 0x1140, 0x103C, 0x18EF,  7,      "GeForce GT 630M" },
    { 0x1140, 0x103C, 0x18F9,  7,      "GeForce GT 630M" },
    { 0x1140, 0x103C, 0x18FB,  7,      "GeForce GT 630M" },
    { 0x1140, 0x103C, 0x18FD,  7,      "GeForce GT 630M" },
    { 0x1140, 0x103C, 0x18FF,  7,      "GeForce GT 630M" },
    { 0x1140, 0x1B0A, 0x20DD,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1B0A, 0x20DF,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1B0A, 0x210E,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x2132,  7,      "GeForce GT 620M" },
    { 0x1140, 0x1043, 0x2136,  7,      "NVS 5200M" },
    { 0x1140, 0x103C, 0x218A,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x21BA,  7,      "GeForce GT 720M" },
    { 0x1140, 0x103C, 0x21BB,  7,      "GeForce 820M" },
    { 0x1140, 0x103C, 0x21BC,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x21FA,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x2200,  7,      "NVS 5200M" },
    { 0x1140, 0x1B0A, 0x2202,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1043, 0x220A,  7,      "GeForce GT 720M" },
    { 0x1140, 0x103C, 0x220E,  7,      "GeForce 820M" },
    { 0x1140, 0x103C, 0x2210,  7,      "GeForce 820M" },
    { 0x1140, 0x103C, 0x2212,  7,      "GeForce 820M" },
    { 0x1140, 0x17AA, 0x2213,  7,      "GeForce GT 720M" },
    { 0x1140, 0x103C, 0x2214,  7,      "GeForce 820M" },
    { 0x1140, 0x103C, 0x2218,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x221A,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x2220,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1043, 0x223A,  7,      "GeForce GT 710M" },
    { 0x1140, 0x1043, 0x224A,  7,      "GeForce GT 710M" },
    { 0x1140, 0x103C, 0x225B,  7,      "GeForce 820M" },
    { 0x1140, 0x103C, 0x225D,  7,      "GeForce 820M" },
    { 0x1140, 0x103C, 0x226D,  7,      "GeForce 820M" },
    { 0x1140, 0x103C, 0x226F,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x227A,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x228A,  7,      "GeForce 820M" },
    { 0x1140, 0x103C, 0x22D2,  7,      "GeForce 820M" },
    { 0x1140, 0x103C, 0x22D9,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x22FA,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x232A,  7,      "GeForce 820M" },
    { 0x1140, 0x103C, 0x2335,  7,      "GeForce 820M" },
    { 0x1140, 0x103C, 0x2337,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x233A,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x235A,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x236A,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x238A,  7,      "GeForce 820M" },
    { 0x1140, 0x103C, 0x2AEF,  7,      "GeForce GT 720A" },
    { 0x1140, 0x103C, 0x2AF9,  7,      "GeForce 710A" },
    { 0x1140, 0x17AA, 0x309C,  7,      "GeForce GT 720A" },
    { 0x1140, 0x17AA, 0x30B4,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x30B7,  7,      "GeForce 720A" },
    { 0x1140, 0x17AA, 0x30E4,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x361B,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x361C,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x361D,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x3656,  7,      "GeForce GT 620M" },
    { 0x1140, 0x17AA, 0x365A,  7,      "GeForce 705M" },
    { 0x1140, 0x17AA, 0x365E,  7,      "GeForce 800M" },
    { 0x1140, 0x17AA, 0x3661,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x366C,  7,      "GeForce 800M" },
    { 0x1140, 0x17AA, 0x3685,  7,      "GeForce 800M" },
    { 0x1140, 0x17AA, 0x3686,  7,      "GeForce 800M" },
    { 0x1140, 0x17AA, 0x3687,  7,      "GeForce 705A" },
    { 0x1140, 0x17AA, 0x3696,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x369B,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x369C,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x369D,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x369E,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x36A6,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x36A7,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x36A9,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x36AF,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x36B0,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x36B6,  7,      "GeForce 820A" },
    { 0x1140, 0x17AA, 0x3800,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x3801,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x3802,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x3803,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x3804,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x3806,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x3808,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x380D,  7,      "GeForce GT 820M" },
    { 0x1140, 0x17AA, 0x380E,  7,      "GeForce GT 820M" },
    { 0x1140, 0x17AA, 0x380F,  7,      "GeForce GT 820M" },
    { 0x1140, 0x17AA, 0x3811,  7,      "GeForce GT 820M" },
    { 0x1140, 0x17AA, 0x3812,  7,      "GeForce 820M" },
    { 0x1140, 0x17AA, 0x3813,  7,      "GeForce 820M" },
    { 0x1140, 0x17AA, 0x3816,  7,      "GeForce 820M" },
    { 0x1140, 0x17AA, 0x3817,  7,      "GeForce 820M" },
    { 0x1140, 0x17AA, 0x3818,  7,      "GeForce 820M" },
    { 0x1140, 0x17AA, 0x381A,  7,      "GeForce 820M" },
    { 0x1140, 0x17AA, 0x381C,  7,      "GeForce 820M" },
    { 0x1140, 0x17AA, 0x381D,  7,      "GeForce 820M" },
    { 0x1140, 0x17AA, 0x3901,  7,      "GeForce 610M" },
    { 0x1140, 0x17AA, 0x3902,  7,      "GeForce 710M" },
    { 0x1140, 0x17AA, 0x3903,  7,      "GeForce 710M" },
    { 0x1140, 0x17AA, 0x3904,  7,      "GeForce GT 625M" },
    { 0x1140, 0x17AA, 0x3905,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x3907,  7,      "GeForce 820M" },
    { 0x1140, 0x17AA, 0x3910,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x3912,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x3913,  7,      "GeForce 820M" },
    { 0x1140, 0x17AA, 0x3915,  7,      "GeForce 820M" },
    { 0x1140, 0x17AA, 0x3983,  7,      "GeForce 610M" },
    { 0x1140, 0x17AA, 0x5001,  7,      "GeForce 610M" },
    { 0x1140, 0x17AA, 0x5003,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x5005,  7,      "GeForce 705M" },
    { 0x1140, 0x17AA, 0x500D,  7,      "GeForce GT 620M" },
    { 0x1140, 0x17AA, 0x5014,  7,      "GeForce 710M" },
    { 0x1140, 0x17AA, 0x5017,  7,      "GeForce 710M" },
    { 0x1140, 0x17AA, 0x5019,  7,      "GeForce 710M" },
    { 0x1140, 0x17AA, 0x501A,  7,      "GeForce 710M" },
    { 0x1140, 0x17AA, 0x501F,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x5025,  7,      "GeForce 710M" },
    { 0x1140, 0x17AA, 0x5027,  7,      "GeForce 710M" },
    { 0x1140, 0x17AA, 0x502A,  7,      "GeForce 710M" },
    { 0x1140, 0x17AA, 0x502B,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x502D,  7,      "GeForce 710M" },
    { 0x1140, 0x17AA, 0x502E,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x502F,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x5030,  7,      "GeForce 705M" },
    { 0x1140, 0x17AA, 0x5031,  7,      "GeForce 705M" },
    { 0x1140, 0x1B6C, 0x5031,  7,      "GeForce GT 720M" },
    { 0x1140, 0x17AA, 0x5032,  7,      "GeForce 820M" },
    { 0x1140, 0x17AA, 0x5033,  7,      "GeForce 820M" },
    { 0x1140, 0x17AA, 0x503E,  7,      "GeForce 710M" },
    { 0x1140, 0x17AA, 0x503F,  7,      "GeForce 820M" },
    { 0x1140, 0x17AA, 0x5040,  7,      "GeForce 820M" },
    { 0x1140, 0x1B50, 0x5530,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x8595,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1043, 0x85EA,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1043, 0x85EB,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x85EC,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x85EE,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1043, 0x85F3,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x860E,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x861A,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x861B,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x8628,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x8643,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x864C,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x8652,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x8660,  7,      "GeForce 820M" },
    { 0x1140, 0x1043, 0x8661,  7,      "GeForce 820M" },
    { 0x1140, 0x1B0A, 0x90D7,  7,      "GeForce 820M" },
    { 0x1140, 0x1B0A, 0x90DD,  7,      "GeForce 820M" },
    { 0x1140, 0x1019, 0x999F,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1462, 0xAA33,  7,      "GeForce 720M" },
    { 0x1140, 0x1462, 0xAAA2,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1462, 0xAAA3,  7,      "GeForce 820M" },
    { 0x1140, 0x1462, 0xACB2,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1462, 0xACC1,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1462, 0xAE61,  7,      "GeForce 720M" },
    { 0x1140, 0x1462, 0xAE65,  7,      "GeForce GT 720M" },
    { 0x1140, 0x1462, 0xAE6A,  7,      "GeForce 820M" },
    { 0x1140, 0x1462, 0xAE71,  7,      "GeForce GT 720M" },
    { 0x1140, 0x144D, 0xB092,  7,      "GeForce GT 620M" },
    { 0x1140, 0x144D, 0xC0D5,  7,      "GeForce GT 630M" },
    { 0x1140, 0x144D, 0xC0D7,  7,      "GeForce GT 620M" },
    { 0x1140, 0x144D, 0xC0E2,  7,      "NVS 5200M" },
    { 0x1140, 0x144D, 0xC0E3,  7,      "NVS 5200M" },
    { 0x1140, 0x144D, 0xC0E4,  7,      "NVS 5200M" },
    { 0x1140, 0x144D, 0xC10D,  7,      "GeForce 820M" },
    { 0x1140, 0x144D, 0xC652,  7,      "GeForce GT 620M" },
    { 0x1140, 0x144D, 0xC709,  7,      "GeForce 710M" },
    { 0x1140, 0x144D, 0xC711,  7,      "GeForce 710M" },
    { 0x1140, 0x144D, 0xC736,  7,      "GeForce 710M" },
    { 0x1140, 0x144D, 0xC737,  7,      "GeForce 710M" },
    { 0x1140, 0x144D, 0xC745,  7,      "GeForce 820M" },
    { 0x1140, 0x144D, 0xC750,  7,      "GeForce 820M" },
    { 0x1140, 0x1179, 0xFA01,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA02,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA03,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA05,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA11,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA13,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA18,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA19,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA21,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA23,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA2A,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA32,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA33,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA36,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA38,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA42,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA43,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA45,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA47,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA49,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA58,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA59,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA88,  7,      "GeForce 710M" },
    { 0x1140, 0x1179, 0xFA89,  7,      "GeForce 710M" },
    { 0x1180, 0x0000, 0x0000,  8,      "GeForce GTX 680" },
    { 0x1183, 0x0000, 0x0000,  8,      "GeForce GTX 660 Ti" },
    { 0x1184, 0x0000, 0x0000,  8,      "GeForce GTX 770" },
    { 0x1185, 0x0000, 0x0000,  8,      "GeForce GTX 660" },
    { 0x1185, 0x10DE, 0x106F,  8,      "GeForce GTX 760" },
    { 0x1187, 0x0000, 0x0000,  8,      "GeForce GTX 760" },
    { 0x1188, 0x0000, 0x0000,  8,      "GeForce GTX 690" },
    { 0x1189, 0x0000, 0x0000,  8,      "GeForce GTX 670" },
    { 0x1189, 0x10DE, 0x1074,  8,      "GeForce GTX 760 Ti OEM" },
    { 0x118A, 0x0000, 0x0000,  8,      "GRID K520" },
    { 0x118E, 0x0000, 0x0000,  8,      "GeForce GTX 760 (192-bit)" },
    { 0x118F, 0x0000, 0x0000,  8,      "Tesla K10" },
    { 0x1193, 0x0000, 0x0000,  8,      "GeForce GTX 760 Ti OEM" },
    { 0x1194, 0x0000, 0x0000,  8,      "Tesla K8" },
    { 0x1195, 0x0000, 0x0000,  8,      "GeForce GTX 660" },
    { 0x1198, 0x0000, 0x0000,  8,      "GeForce GTX 880M" },
    { 0x1199, 0x0000, 0x0000,  8,      "GeForce GTX 870M" },
    { 0x1199, 0x1458, 0xD001,  8,      "GeForce GTX 760" },
    { 0x119A, 0x0000, 0x0000,  8,      "GeForce GTX 860M" },
    { 0x119D, 0x0000, 0x0000,  8,      "GeForce GTX 775M" },
    { 0x119E, 0x0000, 0x0000,  8,      "GeForce GTX 780M" },
    { 0x119F, 0x0000, 0x0000,  8,      "GeForce GTX 780M" },
    { 0x11A0, 0x0000, 0x0000,  8,      "GeForce GTX 680M" },
    { 0x11A1, 0x0000, 0x0000,  8,      "GeForce GTX 670MX" },
    { 0x11A2, 0x0000, 0x0000,  8,      "GeForce GTX 675MX" },
    { 0x11A3, 0x0000, 0x0000,  8,      "GeForce GTX 680MX" },
    { 0x11A7, 0x0000, 0x0000,  8,      "GeForce GTX 675MX" },
    { 0x11B4, 0x0000, 0x0000,  8,      "Quadro K4200" },
    { 0x11B6, 0x0000, 0x0000,  8,      "Quadro K3100M" },
    { 0x11B7, 0x0000, 0x0000,  8,      "Quadro K4100M" },
    { 0x11B8, 0x0000, 0x0000,  8,      "Quadro K5100M" },
    { 0x11BA, 0x0000, 0x0000,  8,      "Quadro K5000" },
    { 0x11BC, 0x0000, 0x0000,  8,      "Quadro K5000M" },
    { 0x11BD, 0x0000, 0x0000,  8,      "Quadro K4000M" },
    { 0x11BE, 0x0000, 0x0000,  8,      "Quadro K3000M" },
    { 0x11C0, 0x0000, 0x0000,  8,      "GeForce GTX 660" },
    { 0x11C2, 0x0000, 0x0000,  8,      "GeForce GTX 650 Ti BOOST" },
    { 0x11C3, 0x0000, 0x0000,  8,      "GeForce GTX 650 Ti" },
    { 0x11C4, 0x0000, 0x0000,  8,      "GeForce GTX 645" },
    { 0x11C5, 0x0000, 0x0000,  8,      "GeForce GT 740" },
    { 0x11C6, 0x0000, 0x0000,  8,      "GeForce GTX 650 Ti" },
    { 0x11C8, 0x0000, 0x0000,  8,      "GeForce GTX 650" },
    { 0x11CB, 0x0000, 0x0000,  8,      "GeForce GT 740" },
    { 0x11E0, 0x0000, 0x0000,  8,      "GeForce GTX 770M" },
    { 0x11E1, 0x0000, 0x0000,  8,      "GeForce GTX 765M" },
    { 0x11E2, 0x0000, 0x0000,  8,      "GeForce GTX 765M" },
    { 0x11E3, 0x0000, 0x0000,  8,      "GeForce GTX 760M" },
    { 0x11E3, 0x17AA, 0x3683,  8,      "GeForce GTX 760A" },
    { 0x11FA, 0x0000, 0x0000,  8,      "Quadro K4000" },
    { 0x11FC, 0x0000, 0x0000,  8,      "Quadro K2100M" },
    { 0x1200, 0x0000, 0x0000,  7,      "GeForce GTX 560 Ti" },
    { 0x1201, 0x0000, 0x0000,  7,      "GeForce GTX 560" },
    { 0x1203, 0x0000, 0x0000,  7,      "GeForce GTX 460 SE v2" },
    { 0x1205, 0x0000, 0x0000,  7,      "GeForce GTX 460 v2" },
    { 0x1206, 0x0000, 0x0000,  7,      "GeForce GTX 555" },
    { 0x1207, 0x0000, 0x0000,  7,      "GeForce GT 645" },
    { 0x1208, 0x0000, 0x0000,  7,      "GeForce GTX 560 SE" },
    { 0x1210, 0x0000, 0x0000,  7,      "GeForce GTX 570M" },
    { 0x1211, 0x0000, 0x0000,  7,      "GeForce GTX 580M" },
    { 0x1212, 0x0000, 0x0000,  7,      "GeForce GTX 675M" },
    { 0x1213, 0x0000, 0x0000,  7,      "GeForce GTX 670M" },
    { 0x1241, 0x0000, 0x0000,  7,      "GeForce GT 545" },
    { 0x1243, 0x0000, 0x0000,  7,      "GeForce GT 545" },
    { 0x1244, 0x0000, 0x0000,  7,      "GeForce GTX 550 Ti" },
    { 0x1245, 0x0000, 0x0000,  7,      "GeForce GTS 450" },
    { 0x1246, 0x0000, 0x0000,  7,      "GeForce GT 550M" },
    { 0x1247, 0x0000, 0x0000,  7,      "GeForce GT 555M" },
    { 0x1247, 0x1043, 0x212A,  7,      "GeForce GT 635M" },
    { 0x1247, 0x1043, 0x212B,  7,      "GeForce GT 635M" },
    { 0x1247, 0x1043, 0x212C,  7,      "GeForce GT 635M" },
    { 0x1248, 0x0000, 0x0000,  7,      "GeForce GT 555M" },
    { 0x1249, 0x0000, 0x0000,  7,      "GeForce GTS 450" },
    { 0x124B, 0x0000, 0x0000,  7,      "GeForce GT 640" },
    { 0x124D, 0x0000, 0x0000,  7,      "GeForce GT 555M" },
    { 0x124D, 0x1462, 0x10CC,  7,      "GeForce GT 635M" },
    { 0x1251, 0x0000, 0x0000,  7,      "GeForce GTX 560M" },
    { 0x1280, 0x0000, 0x0000,  8,      "GeForce GT 635" },
    { 0x1281, 0x0000, 0x0000,  8,      "GeForce GT 710" },
    { 0x1282, 0x0000, 0x0000,  8,      "GeForce GT 640" },
    { 0x1284, 0x0000, 0x0000,  8,      "GeForce GT 630" },
    { 0x1286, 0x0000, 0x0000,  8,      "GeForce GT 720" },
    { 0x1287, 0x0000, 0x0000,  8,      "GeForce GT 730" },
    { 0x1288, 0x0000, 0x0000,  8,      "GeForce GT 720" },
    { 0x1289, 0x0000, 0x0000,  8,      "GeForce GT 710" },
    { 0x128B, 0x0000, 0x0000,  8,      "GeForce GT 710" },
    { 0x1290, 0x0000, 0x0000,  8,      "GeForce GT 730M" },
    { 0x1290, 0x103C, 0x2AFA,  8,      "GeForce GT 730A" },
    { 0x1291, 0x0000, 0x0000,  8,      "GeForce GT 735M" },
    { 0x1292, 0x0000, 0x0000,  8,      "GeForce GT 740M" },
    { 0x1292, 0x17AA, 0x3675,  8,      "GeForce GT 740A" },
    { 0x1292, 0x17AA, 0x367C,  8,      "GeForce GT 740A" },
    { 0x1292, 0x17AA, 0x3684,  8,      "GeForce GT 740A" },
    { 0x1293, 0x0000, 0x0000,  8,      "GeForce GT 730M" },
    { 0x1295, 0x0000, 0x0000,  8,      "GeForce 710M" },
    { 0x1295, 0x103C, 0x2B0D,  8,      "GeForce 710A" },
    { 0x1295, 0x103C, 0x2B0F,  8,      "GeForce 710A" },
    { 0x1295, 0x103C, 0x2B20,  8,      "GeForce 810A" },
    { 0x1295, 0x103C, 0x2B21,  8,      "GeForce 810A" },
    { 0x1295, 0x17AA, 0x367A,  8,      "GeForce 805A" },
    { 0x1295, 0x17AA, 0x367C,  8,      "GeForce 710A" },
    { 0x1296, 0x0000, 0x0000,  8,      "GeForce 825M" },
    { 0x1298, 0x0000, 0x0000,  8,      "GeForce GT 720M" },
    { 0x1299, 0x0000, 0x0000,  8,      "GeForce 920M" },
    { 0x1299, 0x1B0A, 0x01C6,  8,      "GeForce GT 730" },
    { 0x1299, 0x17AA, 0x30BB,  8,      "GeForce 920A" },
    { 0x1299, 0x17AA, 0x30DA,  8,      "GeForce 920A" },
    { 0x1299, 0x17AA, 0x30DC,  8,      "GeForce 920A" },
    { 0x1299, 0x17AA, 0x30DD,  8,      "GeForce 920A" },
    { 0x1299, 0x17AA, 0x30DF,  8,      "GeForce 920A" },
    { 0x1299, 0x17AA, 0x3117,  8,      "GeForce 920A" },
    { 0x1299, 0x17AA, 0x361B,  8,      "GeForce 920A" },
    { 0x1299, 0x17AA, 0x362D,  8,      "GeForce 920A" },
    { 0x1299, 0x17AA, 0x362E,  8,      "GeForce 920A" },
    { 0x1299, 0x17AA, 0x3630,  8,      "GeForce 920A" },
    { 0x1299, 0x17AA, 0x3637,  8,      "GeForce 920A" },
    { 0x1299, 0x17AA, 0x369B,  8,      "GeForce 920A" },
    { 0x1299, 0x17AA, 0x36A7,  8,      "GeForce 920A" },
    { 0x1299, 0x17AA, 0x36AF,  8,      "GeForce 920A" },
    { 0x1299, 0x17AA, 0x36F0,  8,      "GeForce 920A" },
    { 0x129A, 0x0000, 0x0000,  8,      "GeForce 910M" },
    { 0x12B9, 0x0000, 0x0000,  8,      "Quadro K610M" },
    { 0x12BA, 0x0000, 0x0000,  8,      "Quadro K510M" }
};

// This is the list of feature flags for current GPUs
// Only two-part IDs for GPUs with non-zero flags are tracked
static const GPU_FLAGS GpuFlagList[] = {
//    PCI-ID  Flags
    { 0x1340, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1341, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1344, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1346, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1347, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1348, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1349, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x134b, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x134d, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x134e, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x134f, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x137a, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x137b, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1380, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1381, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1382, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1390, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1391, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1392, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1393, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1398, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1399, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x139a, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x139b, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x139c, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x139d, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13b0, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13b1, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13b2, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13b3, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13b4, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13b6, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13b9, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13ba, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13bb, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13bc, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13c0, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13c2, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13d7, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13d8, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13d9, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13da, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13f0, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13f1, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13f2, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13f3, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13f8, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13f9, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13fa, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13fb, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1401, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1402, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1406, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1407, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1427, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1430, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1431, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1436, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x15f0, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x15f7, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x15f8, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x15f9, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1617, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1618, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1619, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x161a, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1667, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x174d, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x174e, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x179c, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x17c2, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x17c8, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x17f0, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x17f1, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x17fd, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1b00, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1b02, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1b06, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1b30, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1b38, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1b80, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1b81, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1b82, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1b83, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1b84, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1b87, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1ba0, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1ba1, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1ba2, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1bb0, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1bb1, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1bb3, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1bb4, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1bb5, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1bb6, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1bb7, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1bb8, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1bb9, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1bbb, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1bc7, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1be0, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1be1, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c02, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c03, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c04, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c06, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c07, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c09, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c20, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c21, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c22, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c23, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c30, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c31, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c60, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c61, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c62, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c81, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c82, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c83, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c8c, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c8d, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c8f, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c90, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c91, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c92, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c94, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1c96, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1cb1, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1cb2, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1cb3, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1cb6, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1cba, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1cbb, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1cbc, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1cbd, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1cfa, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1cfb, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1d01, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1d02, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1d10, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1d11, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1d12, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1d13, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1d16, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1d33, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1d34, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1d52, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1d81, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db7, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db8, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1dba, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df0, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df2, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, GPU_FLAGS_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e02, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e04, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e07, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e09, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e36, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e81, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e82, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e84, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e87, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e89, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e90, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e91, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e93, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb1, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb5, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb6, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1ec2, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1ec7, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1ed0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1ed1, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1ed3, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1ef5, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f02, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f03, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f06, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f07, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f08, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f0a, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f0b, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f10, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f11, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f12, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f14, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f15, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f36, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f42, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f47, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f50, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f51, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f54, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f55, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f76, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f82, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f83, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f91, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f95, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f96, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f97, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f98, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f99, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f9c, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f9d, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1f9f, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1fa0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1fb0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1fb1, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1fb2, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1fb6, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1fb7, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1fb8, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1fb9, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1fba, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1fbb, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1fbc, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1fdd, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1ff0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1ff2, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1ff9, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b2, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b3, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b5, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b6, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b7, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20bd, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f1, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f3, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f5, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f6, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20fd, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2182, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2184, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2187, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2188, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2189, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2191, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2192, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x21c4, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x21d1, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2203, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2204, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2206, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2207, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2208, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x220a, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x220d, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2216, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2232, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2321, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2322, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2324, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2330, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2331, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2339, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233a, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2414, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2420, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2438, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2460, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2482, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2484, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2486, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2487, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2488, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2489, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x248a, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x249c, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x249d, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x24a0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x24b0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x24b1, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x24b6, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x24b7, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x24b8, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x24b9, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x24ba, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x24bb, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x24c7, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x24c9, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x24dc, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x24dd, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x24e0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x24fa, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2503, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2504, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2507, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2508, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2520, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2521, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2523, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2531, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2544, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2560, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2563, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2571, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2582, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2584, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25a0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25a2, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25a5, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25a6, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25a7, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25a9, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25aa, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25ab, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25ac, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25ad, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b2, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b8, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b9, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25ba, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25bb, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25bc, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25bd, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25e0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25e2, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25e5, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25ec, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25ed, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25f9, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25fa, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25fb, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2684, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2685, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2689, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2702, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2704, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2705, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2709, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2717, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2730, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2757, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2770, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2782, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2783, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2786, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2788, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27a0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b1, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b2, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27ba, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27bb, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27e0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27fb, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2803, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2805, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2808, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2820, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2822, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2838, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2860, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2882, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x28a0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x28a1, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x28a3, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x28b0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x28b8, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x28b9, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x28ba, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x28bb, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x28e0, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x28e1, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x28e3, GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x28f8, GPU_FLAGS_PROPRIETARY_POSSIBLE },
};
// Feature flag overrides for specific GPUs with four-part IDs:
// This list should be checked before the two-part list; a match
// on a four-part ID takes precedence over a match on the same
// two-part ID.
static const GPU_SUBDEVICE_FLAGS GpuSubDeviceFlagList[] = {
//    PCI-ID  Subvndr Subdev  Flags
    { 0x13bd, 0x10de, 0x11cc, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13bd, 0x10de, 0x11cd, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13bd, 0x10de, 0x11ce, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13bd, 0x10de, 0x11cf, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13bd, 0x10de, 0x11d0, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13bd, 0x10de, 0x11d1, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13bd, 0x10de, 0x11d2, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13bd, 0x10de, 0x11d3, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13bd, 0x10de, 0x11d4, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13bd, 0x10de, 0x11d5, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13bd, 0x10de, 0x11d6, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13bd, 0x10de, 0x1286, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13bd, 0x10de, 0x12ee, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x13bd, 0x10de, 0x1339, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x1259, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x125a, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x125b, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x125c, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x125d, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x125e, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x125f, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x1260, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x1261, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x1262, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x1263, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x128e, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x12f6, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x1341, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x1378, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x138e, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db1, 0x10de, 0x138f, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x1290, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x1291, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x1292, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x1293, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x1294, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x1295, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x1296, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x1297, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x1298, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x1299, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x129a, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x129b, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x12f9, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x1344, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x137a, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x1398, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db3, 0x10de, 0x1399, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x124e, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x124f, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x1250, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x1251, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x1252, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x1253, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x1254, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x1255, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x1256, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x1257, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x1258, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x128f, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x12f5, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x1340, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x1379, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x1393, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db4, 0x10de, 0x1394, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x12cb, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x12cc, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x12cd, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x12ce, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x12cf, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x12d0, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x12d1, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x12d2, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x12d3, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x12d4, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x12d5, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x12d6, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x12d7, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x12d8, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x12f8, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x1343, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x1376, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x1390, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x1391, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db5, 0x10de, 0x1392, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x12bd, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x12be, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x12bf, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x12c0, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x12c1, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x12c2, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x12c3, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x12c4, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x12c5, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x12c6, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x12c7, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x12c8, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x12c9, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x12ca, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x12f7, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x1342, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x1377, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x1395, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x1396, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x1397, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x13cd, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x13ce, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1db6, 0x10de, 0x13cf, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13e1, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13e3, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13e5, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13e6, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13e7, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13e8, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13e9, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13ea, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13eb, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13ec, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13ed, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13ee, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13ef, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13f0, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13f1, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13f2, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13f3, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1df6, 0x10de, 0x13f4, GPU_FLAGS_NO_GSP | GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1325, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1326, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1327, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1328, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1329, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x132a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x132b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x132c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x132d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x132e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x132f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1330, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1331, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1332, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1333, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1334, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1335, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1336, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13b9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13ba, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13bb, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13bc, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13bd, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13be, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13bf, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13c0, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13c1, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13c2, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13c3, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13c4, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13c5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13c6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13c7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13c8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13c9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13ca, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13cb, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x13cc, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1437, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1438, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1439, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x143a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x143b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x143c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x143d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x143e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x143f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1440, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1441, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1442, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1443, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1444, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1445, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1446, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1447, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1448, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x1449, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x144a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x144b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e30, 0x10de, 0x144c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e37, 0x10de, 0x1347, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e37, 0x10de, 0x1348, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e37, 0x10de, 0x1349, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e37, 0x10de, 0x136a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e37, 0x10de, 0x136b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e37, 0x10de, 0x136c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e37, 0x10de, 0x13a4, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e37, 0x10de, 0x13a5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e37, 0x10de, 0x13a6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e37, 0x10de, 0x13a7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e37, 0x10de, 0x13a8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e37, 0x10de, 0x13a9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e37, 0x10de, 0x180d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e37, 0x10de, 0x1820, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x13f7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x13f8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x13f9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x13fa, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x13fb, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x13fc, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x13fd, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x13fe, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x13ff, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1400, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1401, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1402, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1403, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1404, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1405, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1406, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1407, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1408, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1409, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x140a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x140b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x140c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x140d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x140e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x140f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1410, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1411, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1412, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1413, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1414, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1415, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1416, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1417, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1418, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1419, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x141a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x141b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x141c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x141d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x141e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x141f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1420, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1421, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1422, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1423, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1424, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1425, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1426, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1427, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1428, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1429, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x142a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x142b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x142c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x142d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x142e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x142f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1430, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1431, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1e78, 0x10de, 0x1436, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x1309, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x130a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x130b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x130c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x130d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x130e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x130f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x1310, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x1311, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x1312, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x1313, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x1314, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x1315, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x1345, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x1367, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x1368, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x1369, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x1375, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x139a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x1eb8, 0x10de, 0x139b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b0, 0x10de, 0x146f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b0, 0x10de, 0x1470, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b0, 0x10de, 0x1471, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b0, 0x10de, 0x1472, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b0, 0x10de, 0x1473, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b0, 0x10de, 0x1474, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b0, 0x10de, 0x1475, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b0, 0x10de, 0x1476, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b0, 0x10de, 0x1477, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b0, 0x10de, 0x1478, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b0, 0x10de, 0x1479, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b0, 0x10de, 0x160c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b0, 0x10de, 0x1840, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b2, 0x10de, 0x1523, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b2, 0x10de, 0x1524, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b2, 0x10de, 0x1525, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b2, 0x10de, 0x1526, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b2, 0x10de, 0x1527, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b2, 0x10de, 0x1528, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b2, 0x10de, 0x1529, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b2, 0x10de, 0x152a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b2, 0x10de, 0x152b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b2, 0x10de, 0x152c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b2, 0x10de, 0x152d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b2, 0x10de, 0x152e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b2, 0x10de, 0x160d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b2, 0x10de, 0x1841, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b5, 0x10de, 0x1591, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b5, 0x10de, 0x1592, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b5, 0x10de, 0x1593, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b5, 0x10de, 0x1594, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b5, 0x10de, 0x1595, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b5, 0x10de, 0x1596, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b5, 0x10de, 0x1597, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b5, 0x10de, 0x1598, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b5, 0x10de, 0x1599, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b5, 0x10de, 0x159a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b5, 0x10de, 0x159b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b5, 0x10de, 0x159c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b5, 0x10de, 0x160f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b5, 0x10de, 0x183e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b7, 0x10de, 0x1589, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b7, 0x10de, 0x158a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b7, 0x10de, 0x158b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b7, 0x10de, 0x158c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b7, 0x10de, 0x158d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b7, 0x10de, 0x158e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b7, 0x10de, 0x158f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b7, 0x10de, 0x1590, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b7, 0x10de, 0x1610, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20b7, 0x10de, 0x183c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f1, 0x10de, 0x1493, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f1, 0x10de, 0x1494, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f1, 0x10de, 0x1495, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f1, 0x10de, 0x1496, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f1, 0x10de, 0x1497, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f1, 0x10de, 0x1498, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f1, 0x10de, 0x1499, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f1, 0x10de, 0x149a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f1, 0x10de, 0x149b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f1, 0x10de, 0x149c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f1, 0x10de, 0x149d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f1, 0x10de, 0x160e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f1, 0x10de, 0x183d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f3, 0x10de, 0x17b2, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f3, 0x10de, 0x17b3, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f3, 0x10de, 0x17b4, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f3, 0x10de, 0x17b5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f3, 0x10de, 0x17b6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f3, 0x10de, 0x17b7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f3, 0x10de, 0x17b8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f3, 0x10de, 0x17b9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f3, 0x10de, 0x17ba, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f3, 0x10de, 0x17bb, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f3, 0x10de, 0x17bc, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f3, 0x10de, 0x17bd, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f3, 0x10de, 0x17be, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f3, 0x10de, 0x1842, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f5, 0x10de, 0x17bf, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f5, 0x10de, 0x17c0, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f5, 0x10de, 0x17c1, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f5, 0x10de, 0x17c2, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f5, 0x10de, 0x17c3, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f5, 0x10de, 0x17c4, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f5, 0x10de, 0x17c5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f5, 0x10de, 0x17c6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f5, 0x10de, 0x17c7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f5, 0x10de, 0x17c8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f5, 0x10de, 0x17c9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f5, 0x10de, 0x17ca, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f5, 0x10de, 0x17cb, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f5, 0x10de, 0x183f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f6, 0x10de, 0x17cc, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f6, 0x10de, 0x17cd, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f6, 0x10de, 0x17ce, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f6, 0x10de, 0x17cf, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f6, 0x10de, 0x17d0, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f6, 0x10de, 0x17d1, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f6, 0x10de, 0x17d2, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f6, 0x10de, 0x17d3, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f6, 0x10de, 0x17d4, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f6, 0x10de, 0x17d5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f6, 0x10de, 0x17d6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f6, 0x10de, 0x17d7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x20f6, 0x10de, 0x1843, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x14fa, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x14fb, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x14fc, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x14fd, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x14fe, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x14ff, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1500, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1501, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1502, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1503, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1504, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1505, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1506, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1507, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1508, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1509, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x150a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x150b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x150c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x150d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x150e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x150f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1510, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1511, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1512, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1513, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1514, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1515, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1516, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1517, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1518, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x1519, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2230, 0x10de, 0x151a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1562, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1563, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1564, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1565, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1566, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1567, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1568, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1569, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x156a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x156b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x156c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x156d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x156e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x156f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1570, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1571, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1572, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1573, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1574, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1575, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1576, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1577, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1578, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x1579, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x157a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x157b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2231, 0x10de, 0x157c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x165c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x165d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x165e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x165f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1660, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1661, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1662, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1663, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1664, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1665, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1666, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1667, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1668, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1669, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x166a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x166b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x166c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x166d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x166e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x166f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1670, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1671, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1672, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1673, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1674, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1675, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2233, 0x10de, 0x1676, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14d5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14d6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14d7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14d8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14d9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14da, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14db, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14dc, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14dd, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14de, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14df, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14e0, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14e1, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14e2, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14e3, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14e4, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14e5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14e6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14e7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14e8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14e9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14ea, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14eb, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14ec, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14ed, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14ee, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14f3, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14f4, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14f5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14f6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14f7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14f8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x14f9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x1684, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x1685, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x1686, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x1687, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x1688, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2235, 0x10de, 0x16e7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14b6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14b7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14b8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14b9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14ba, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14bb, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14bc, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14bd, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14be, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14bf, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14c0, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14c1, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14c2, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14c3, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14c4, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14c5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14c6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14c7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14c8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14c9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14ca, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14cb, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14d0, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14d1, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14d2, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14d3, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x14d4, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x167e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x167f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x1680, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2236, 0x10de, 0x16e8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x155a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x155b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x155c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x155d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x155e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x155f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x1560, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x1561, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x162a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x162b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x162c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x162d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x162e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x162f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x1630, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x1631, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x1632, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x1633, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x1634, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x1635, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x1636, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x1637, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x1638, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x1639, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x163a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x163b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x1810, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2237, 0x10de, 0x1811, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16a3, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16a4, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16a5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16a6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16a7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16a8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16a9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16aa, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16ab, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16ac, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16ad, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16ae, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16af, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16b0, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16b1, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16b2, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16b3, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16b4, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16b5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16b6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16b7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16b8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16b9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2238, 0x10de, 0x16e6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x20f5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x20f6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x20f7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x20f8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x20f9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x20fa, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x20fb, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x20fc, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x20fd, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x20fe, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x20ff, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x2100, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x2101, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x2102, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x2103, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x2104, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x2105, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x2106, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x230e, 0x10de, 0x2107, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2321, 0x10de, 0x1853, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2321, 0x10de, 0x1854, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2321, 0x10de, 0x1855, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2321, 0x10de, 0x1856, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2321, 0x10de, 0x1857, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2321, 0x10de, 0x1858, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2321, 0x10de, 0x1859, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2321, 0x10de, 0x185a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2321, 0x10de, 0x185b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2321, 0x10de, 0x185c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2321, 0x10de, 0x185d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2321, 0x10de, 0x185e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2321, 0x10de, 0x185f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2321, 0x10de, 0x1860, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2322, 0x10de, 0x17e2, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2322, 0x10de, 0x17e3, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2322, 0x10de, 0x17e4, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2322, 0x10de, 0x17e5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2322, 0x10de, 0x17e6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2322, 0x10de, 0x17e7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2322, 0x10de, 0x17e8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2322, 0x10de, 0x17e9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2322, 0x10de, 0x17ea, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2322, 0x10de, 0x17eb, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2322, 0x10de, 0x17ec, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2322, 0x10de, 0x17ed, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2322, 0x10de, 0x17ee, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2322, 0x10de, 0x17ef, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2322, 0x10de, 0x1845, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2324, 0x10de, 0x18d5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2324, 0x10de, 0x18d6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2324, 0x10de, 0x18d7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2324, 0x10de, 0x18d8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2324, 0x10de, 0x18d9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2324, 0x10de, 0x18da, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2324, 0x10de, 0x18db, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2324, 0x10de, 0x18dc, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2324, 0x10de, 0x18dd, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2324, 0x10de, 0x18de, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2324, 0x10de, 0x18df, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2324, 0x10de, 0x18e0, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2324, 0x10de, 0x18e1, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2324, 0x10de, 0x18e2, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2324, 0x10de, 0x18e3, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, 0x10de, 0x2028, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, 0x10de, 0x2029, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, 0x10de, 0x202a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, 0x10de, 0x202b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, 0x10de, 0x202c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, 0x10de, 0x202d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, 0x10de, 0x202e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, 0x10de, 0x202f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, 0x10de, 0x2030, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, 0x10de, 0x2031, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, 0x10de, 0x2032, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, 0x10de, 0x2033, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, 0x10de, 0x2034, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, 0x10de, 0x2035, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, 0x10de, 0x2047, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2329, 0x10de, 0x2048, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, 0x10de, 0x2108, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, 0x10de, 0x2109, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, 0x10de, 0x210a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, 0x10de, 0x210b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, 0x10de, 0x210c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, 0x10de, 0x210d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, 0x10de, 0x210e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, 0x10de, 0x210f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, 0x10de, 0x2110, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, 0x10de, 0x2111, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, 0x10de, 0x2112, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, 0x10de, 0x2113, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, 0x10de, 0x2114, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, 0x10de, 0x2115, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, 0x10de, 0x2116, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x232c, 0x10de, 0x2117, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2330, 0x10de, 0x187a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2330, 0x10de, 0x187b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2330, 0x10de, 0x187c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2330, 0x10de, 0x187d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2330, 0x10de, 0x187e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2330, 0x10de, 0x187f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2330, 0x10de, 0x1880, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2330, 0x10de, 0x1881, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2330, 0x10de, 0x1882, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2330, 0x10de, 0x1883, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2330, 0x10de, 0x1884, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2330, 0x10de, 0x1885, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2330, 0x10de, 0x1886, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2330, 0x10de, 0x1887, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2330, 0x10de, 0x1888, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2331, 0x10de, 0x16d3, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2331, 0x10de, 0x16d4, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2331, 0x10de, 0x16d5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2331, 0x10de, 0x16d6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2331, 0x10de, 0x16d7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2331, 0x10de, 0x16d8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2331, 0x10de, 0x16d9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2331, 0x10de, 0x16da, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2331, 0x10de, 0x16db, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2331, 0x10de, 0x16dc, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2331, 0x10de, 0x16dd, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2331, 0x10de, 0x16de, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2331, 0x10de, 0x1798, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2331, 0x10de, 0x17f0, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2331, 0x10de, 0x1844, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, 0x10de, 0x206e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, 0x10de, 0x206f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, 0x10de, 0x2070, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, 0x10de, 0x2071, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, 0x10de, 0x2072, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, 0x10de, 0x2073, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, 0x10de, 0x2074, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, 0x10de, 0x2075, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, 0x10de, 0x2076, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, 0x10de, 0x2077, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, 0x10de, 0x2078, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, 0x10de, 0x2079, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, 0x10de, 0x207a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, 0x10de, 0x207b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, 0x10de, 0x207e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2335, 0x10de, 0x207f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2337, 0x10de, 0x18f2, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2337, 0x10de, 0x18f3, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2337, 0x10de, 0x18f4, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2337, 0x10de, 0x18f5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2337, 0x10de, 0x18f6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2337, 0x10de, 0x18f7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2337, 0x10de, 0x18f8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2337, 0x10de, 0x18f9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2337, 0x10de, 0x18fa, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2337, 0x10de, 0x18fb, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2337, 0x10de, 0x18fc, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2337, 0x10de, 0x18fd, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2339, 0x10de, 0x18e4, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2339, 0x10de, 0x18e5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2339, 0x10de, 0x18e6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2339, 0x10de, 0x18e7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2339, 0x10de, 0x18e8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2339, 0x10de, 0x18e9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2339, 0x10de, 0x18ea, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2339, 0x10de, 0x18eb, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2339, 0x10de, 0x18ec, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2339, 0x10de, 0x18ed, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2339, 0x10de, 0x18ee, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2339, 0x10de, 0x18ef, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2339, 0x10de, 0x18f0, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2339, 0x10de, 0x18f1, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233a, 0x10de, 0x1861, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233a, 0x10de, 0x1862, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233a, 0x10de, 0x1863, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233a, 0x10de, 0x1864, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233a, 0x10de, 0x1865, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233a, 0x10de, 0x1866, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233a, 0x10de, 0x1867, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233a, 0x10de, 0x1868, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233a, 0x10de, 0x1869, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233a, 0x10de, 0x186a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233a, 0x10de, 0x186b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233a, 0x10de, 0x186c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233a, 0x10de, 0x186d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233a, 0x10de, 0x186e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, 0x10de, 0x2081, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, 0x10de, 0x2082, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, 0x10de, 0x2083, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, 0x10de, 0x2084, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, 0x10de, 0x2085, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, 0x10de, 0x2086, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, 0x10de, 0x2087, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, 0x10de, 0x2088, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, 0x10de, 0x2089, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, 0x10de, 0x208a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, 0x10de, 0x208b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, 0x10de, 0x208c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, 0x10de, 0x208d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, 0x10de, 0x208e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, 0x10de, 0x208f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x233b, 0x10de, 0x2090, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2342, 0x10de, 0x18c2, GPU_FLAGS_VGPU_GUEST },
    { 0x2342, 0x10de, 0x18c3, GPU_FLAGS_VGPU_GUEST },
    { 0x2342, 0x10de, 0x18c4, GPU_FLAGS_VGPU_GUEST },
    { 0x2342, 0x10de, 0x18c5, GPU_FLAGS_VGPU_GUEST },
    { 0x2342, 0x10de, 0x18c6, GPU_FLAGS_VGPU_GUEST },
    { 0x2342, 0x10de, 0x18c7, GPU_FLAGS_VGPU_GUEST },
    { 0x2342, 0x10de, 0x18c8, GPU_FLAGS_VGPU_GUEST },
    { 0x2342, 0x10de, 0x18c9, GPU_FLAGS_VGPU_GUEST },
    { 0x2348, 0x10de, 0x20c2, GPU_FLAGS_VGPU_GUEST },
    { 0x2348, 0x10de, 0x20c3, GPU_FLAGS_VGPU_GUEST },
    { 0x2348, 0x10de, 0x20c4, GPU_FLAGS_VGPU_GUEST },
    { 0x2348, 0x10de, 0x20c5, GPU_FLAGS_VGPU_GUEST },
    { 0x2348, 0x10de, 0x20c6, GPU_FLAGS_VGPU_GUEST },
    { 0x2348, 0x10de, 0x20c7, GPU_FLAGS_VGPU_GUEST },
    { 0x2348, 0x10de, 0x20c8, GPU_FLAGS_VGPU_GUEST },
    { 0x2348, 0x10de, 0x20c9, GPU_FLAGS_VGPU_GUEST },
    { 0x25b6, 0x10de, 0x159d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x159e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x159f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1600, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1601, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1602, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1603, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1604, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1605, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1606, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1607, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1608, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1609, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x160a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x160b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1646, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1647, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1648, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1649, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x164a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x164b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x164c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x164d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x164e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x164f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1650, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1651, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1652, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1653, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1654, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1655, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1656, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x25b6, 0x10de, 0x1657, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_VGPU_NO_GSP | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1708, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1709, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x170a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x170b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x170c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x170d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x170e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x170f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1710, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1711, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1712, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1713, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1714, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1715, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1716, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1717, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1718, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1719, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x171a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x171b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x171c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x171d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x171e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x171f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1720, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1721, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1722, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1723, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1724, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1725, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1726, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1727, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1728, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x1729, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x172a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x172b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x172c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x172d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b1, 0x10de, 0x172e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1821, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1822, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1823, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1824, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1825, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1826, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1827, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1828, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1829, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x182a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x182b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x182c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x182d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x182e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x182f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1830, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1831, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1832, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1833, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1834, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1835, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1836, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1837, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b2, 0x10de, 0x1838, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1958, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1959, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x195a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x195b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x195c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x195d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x195e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x195f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1960, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1961, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1962, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1963, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1964, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1965, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1966, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1967, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1968, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1969, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x196a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x196b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x196c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x196d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x196e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x196f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1970, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1971, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1972, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1973, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1974, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1975, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1976, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1977, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1978, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x1979, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x197a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x197b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x197c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x197d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b3, 0x10de, 0x197e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x176d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x176e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x176f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1770, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1771, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1772, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1773, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1774, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1775, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1776, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1777, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1778, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1779, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x177a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x177b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x177c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x177d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x177e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x177f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1780, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1781, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1782, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1783, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1784, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1785, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1786, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1787, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1788, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1789, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x178a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x178b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x178c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x178d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x178e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x178f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1790, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1791, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1792, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1793, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x1818, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b5, 0x10de, 0x181a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x174e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x174f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1750, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1751, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1752, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1753, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1754, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1755, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1756, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1757, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1758, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1759, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x175a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x175b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x175c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x175d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x175e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x175f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1760, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1761, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1762, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1763, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1764, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1765, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1766, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1767, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1768, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x1769, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x176a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x176b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x176c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x181c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b8, 0x10de, 0x181e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x1889, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x188a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x188b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x188c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x188d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x188e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x188f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x1890, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x1891, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x1892, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x1893, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x1894, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x1895, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x1896, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x1897, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x1898, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x1899, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x189a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x189b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x189c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x189d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x189e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x189f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18a0, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18a1, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18a2, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18a3, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18a4, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18a5, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18a6, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18a7, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18a8, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18a9, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18aa, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18ab, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18ac, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18ad, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18ae, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18af, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18b0, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26b9, 0x10de, 0x18b1, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1909, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x190a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x190b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x190c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x190d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x190e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x190f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1910, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1911, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1912, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1913, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1914, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1915, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1916, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1917, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1918, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1919, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x191a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x191b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x191c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x191d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x191e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x191f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1920, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1921, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1922, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1923, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1924, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1925, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1926, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1927, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1928, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1929, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x192a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x192b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x192c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x192d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x192e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x192f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1930, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x26ba, 0x10de, 0x1931, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1938, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1939, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x193a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x193b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x193c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x193d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x193e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x193f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1940, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1941, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1942, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1943, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1944, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1945, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1946, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1947, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1948, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1949, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x194a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x194b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x194c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x194d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x194e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x194f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1950, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1951, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1952, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1953, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1954, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1955, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b6, 0x10de, 0x1956, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x172f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1730, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1731, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1732, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1733, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1734, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1735, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1736, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1737, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1738, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1739, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x173a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x173b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x173c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x173d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x173e, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x173f, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1740, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1741, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1742, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1743, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1744, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1745, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1746, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1747, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1748, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x1749, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x174a, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x174b, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x174c, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x27b8, 0x10de, 0x174d, GPU_FLAGS_VGPU_GUEST | GPU_FLAGS_PROPRIETARY_POSSIBLE },
    { 0x2941, 0x10de, 0x20cb, GPU_FLAGS_VGPU_GUEST },
    { 0x2941, 0x10de, 0x20cc, GPU_FLAGS_VGPU_GUEST },
    { 0x2941, 0x10de, 0x20cd, GPU_FLAGS_VGPU_GUEST },
    { 0x2941, 0x10de, 0x20ce, GPU_FLAGS_VGPU_GUEST },
    { 0x2941, 0x10de, 0x20cf, GPU_FLAGS_VGPU_GUEST },
    { 0x2941, 0x10de, 0x20d0, GPU_FLAGS_VGPU_GUEST },
    { 0x2941, 0x10de, 0x20d1, GPU_FLAGS_VGPU_GUEST },
    { 0x2941, 0x10de, 0x20d2, GPU_FLAGS_VGPU_GUEST },
};

#endif /* __NV_GPUS_H */
