// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains the type of server-side encryption used.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct Encryption {
    /// <p>The server-side encryption algorithm used when storing job results in Amazon S3 (for example, AES256, <code>aws:kms</code>).</p>
    pub encryption_type: crate::types::ServerSideEncryption,
    /// <p>If the encryption type is <code>aws:kms</code>, this optional value specifies the ID of the symmetric encryption customer managed key to use for encryption of job results. Amazon S3 only supports symmetric encryption KMS keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Asymmetric keys in KMS</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
    pub kms_key_id: ::std::option::Option<::std::string::String>,
    /// <p>If the encryption type is <code>aws:kms</code>, this optional value can be used to specify the encryption context for the restore results.</p>
    pub kms_context: ::std::option::Option<::std::string::String>,
}
impl Encryption {
    /// <p>The server-side encryption algorithm used when storing job results in Amazon S3 (for example, AES256, <code>aws:kms</code>).</p>
    pub fn encryption_type(&self) -> &crate::types::ServerSideEncryption {
        &self.encryption_type
    }
    /// <p>If the encryption type is <code>aws:kms</code>, this optional value specifies the ID of the symmetric encryption customer managed key to use for encryption of job results. Amazon S3 only supports symmetric encryption KMS keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Asymmetric keys in KMS</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
    pub fn kms_key_id(&self) -> ::std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>If the encryption type is <code>aws:kms</code>, this optional value can be used to specify the encryption context for the restore results.</p>
    pub fn kms_context(&self) -> ::std::option::Option<&str> {
        self.kms_context.as_deref()
    }
}
impl ::std::fmt::Debug for Encryption {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("Encryption");
        formatter.field("encryption_type", &self.encryption_type);
        formatter.field("kms_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("kms_context", &self.kms_context);
        formatter.finish()
    }
}
impl Encryption {
    /// Creates a new builder-style object to manufacture [`Encryption`](crate::types::Encryption).
    pub fn builder() -> crate::types::builders::EncryptionBuilder {
        crate::types::builders::EncryptionBuilder::default()
    }
}

/// A builder for [`Encryption`](crate::types::Encryption).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct EncryptionBuilder {
    pub(crate) encryption_type: ::std::option::Option<crate::types::ServerSideEncryption>,
    pub(crate) kms_key_id: ::std::option::Option<::std::string::String>,
    pub(crate) kms_context: ::std::option::Option<::std::string::String>,
}
impl EncryptionBuilder {
    /// <p>The server-side encryption algorithm used when storing job results in Amazon S3 (for example, AES256, <code>aws:kms</code>).</p>
    /// This field is required.
    pub fn encryption_type(mut self, input: crate::types::ServerSideEncryption) -> Self {
        self.encryption_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The server-side encryption algorithm used when storing job results in Amazon S3 (for example, AES256, <code>aws:kms</code>).</p>
    pub fn set_encryption_type(mut self, input: ::std::option::Option<crate::types::ServerSideEncryption>) -> Self {
        self.encryption_type = input;
        self
    }
    /// <p>The server-side encryption algorithm used when storing job results in Amazon S3 (for example, AES256, <code>aws:kms</code>).</p>
    pub fn get_encryption_type(&self) -> &::std::option::Option<crate::types::ServerSideEncryption> {
        &self.encryption_type
    }
    /// <p>If the encryption type is <code>aws:kms</code>, this optional value specifies the ID of the symmetric encryption customer managed key to use for encryption of job results. Amazon S3 only supports symmetric encryption KMS keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Asymmetric keys in KMS</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
    pub fn kms_key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.kms_key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>If the encryption type is <code>aws:kms</code>, this optional value specifies the ID of the symmetric encryption customer managed key to use for encryption of job results. Amazon S3 only supports symmetric encryption KMS keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Asymmetric keys in KMS</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
    pub fn set_kms_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.kms_key_id = input;
        self
    }
    /// <p>If the encryption type is <code>aws:kms</code>, this optional value specifies the ID of the symmetric encryption customer managed key to use for encryption of job results. Amazon S3 only supports symmetric encryption KMS keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Asymmetric keys in KMS</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
    pub fn get_kms_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.kms_key_id
    }
    /// <p>If the encryption type is <code>aws:kms</code>, this optional value can be used to specify the encryption context for the restore results.</p>
    pub fn kms_context(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.kms_context = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>If the encryption type is <code>aws:kms</code>, this optional value can be used to specify the encryption context for the restore results.</p>
    pub fn set_kms_context(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.kms_context = input;
        self
    }
    /// <p>If the encryption type is <code>aws:kms</code>, this optional value can be used to specify the encryption context for the restore results.</p>
    pub fn get_kms_context(&self) -> &::std::option::Option<::std::string::String> {
        &self.kms_context
    }
    /// Consumes the builder and constructs a [`Encryption`](crate::types::Encryption).
    /// This method will fail if any of the following fields are not set:
    /// - [`encryption_type`](crate::types::builders::EncryptionBuilder::encryption_type)
    pub fn build(self) -> ::std::result::Result<crate::types::Encryption, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::Encryption {
            encryption_type: self.encryption_type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "encryption_type",
                    "encryption_type was not specified but it is required when building Encryption",
                )
            })?,
            kms_key_id: self.kms_key_id,
            kms_context: self.kms_context,
        })
    }
}
impl ::std::fmt::Debug for EncryptionBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionBuilder");
        formatter.field("encryption_type", &self.encryption_type);
        formatter.field("kms_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("kms_context", &self.kms_context);
        formatter.finish()
    }
}
