package main

import (
	"fmt"

	"github.com/power-devops/perfstat"
	"golang.org/x/sys/unix"
)

func main() {
	fmt.Printf("System Architecture (should be 2 - POWERPC) = %v\n", unix.Getsystemcfg(perfstat.SC_ARCH))
	fmt.Printf("Processor Implementation                    = %v\n", unix.Getsystemcfg(perfstat.SC_IMPL))
	fmt.Printf("                                            = %v\n", perfstat.GetCPUImplementation())
	fmt.Printf("    POWER9 or newer?                        = %v\n", perfstat.POWER9OrNewer())
	fmt.Printf("    POWER8 or newer?                        = %v\n", perfstat.POWER8OrNewer())
	fmt.Printf("    POWER7 or newer?                        = %v\n", perfstat.POWER7OrNewer())
	fmt.Printf("    POWER9?                                 = %v\n", perfstat.POWER9())
	fmt.Printf("    POWER8?                                 = %v\n", perfstat.POWER8())
	fmt.Printf("    POWER7?                                 = %v\n", perfstat.POWER7())
	fmt.Printf("Processor Version                           = %v\n", unix.Getsystemcfg(perfstat.SC_VERS))
	fmt.Printf("    Mode                                    = %v\n", perfstat.CPUMode())
	fmt.Printf("Processor bits                              = %v\n", unix.Getsystemcfg(perfstat.SC_WIDTH))
	fmt.Printf("    is 64 bit cpu?                          = %v\n", perfstat.Is64Bit())
	fmt.Printf("Number of processors                        = %v\n", unix.Getsystemcfg(perfstat.SC_NCPUS))
	fmt.Printf("    is SMP?                                 = %v\n", perfstat.IsSMP())
	fmt.Printf("L1 cache attributes                         = %v\n", unix.Getsystemcfg(perfstat.SC_L1C_ATTR))
	fmt.Printf("L1 instruction cache size                   = %v\n", unix.Getsystemcfg(perfstat.SC_L1C_ISZ))
	fmt.Printf("L1 data cache size                          = %v\n", unix.Getsystemcfg(perfstat.SC_L1C_DSZ))
	fmt.Printf("L1 instruction cache associativity          = %v\n", unix.Getsystemcfg(perfstat.SC_L1C_ICA))
	fmt.Printf("L1 data cache associativity                 = %v\n", unix.Getsystemcfg(perfstat.SC_L1C_DCA))
	fmt.Printf("L1 instruction cache data block size        = %v\n", unix.Getsystemcfg(perfstat.SC_L1C_IBS))
	fmt.Printf("L1 data cache data block size               = %v\n", unix.Getsystemcfg(perfstat.SC_L1C_DBS))
	fmt.Printf("L1 instruction cache line size              = %v\n", unix.Getsystemcfg(perfstat.SC_L1C_ILS))
	fmt.Printf("L1 data cache line size                     = %v\n", unix.Getsystemcfg(perfstat.SC_L1C_DLS))
	fmt.Printf("L2 cache size                               = %v\n", unix.Getsystemcfg(perfstat.SC_L2C_SZ))
	fmt.Printf("L2 cache associativity                      = %v\n", unix.Getsystemcfg(perfstat.SC_L2C_AS))
	fmt.Printf("TLB attributes                              = %v\n", unix.Getsystemcfg(perfstat.SC_TLB_ATTR))
	fmt.Printf("Number of entries in instruction TLB        = %v\n", unix.Getsystemcfg(perfstat.SC_ITLB_SZ))
	fmt.Printf("Number of entries in data TLB               = %v\n", unix.Getsystemcfg(perfstat.SC_DTLB_SZ))
	fmt.Printf("Instruction TLB associativity               = %v\n", unix.Getsystemcfg(perfstat.SC_ITLB_ATT))
	fmt.Printf("Data TLB associativity                      = %v\n", unix.Getsystemcfg(perfstat.SC_DTLB_ATT))
	fmt.Printf("Kernel attributes                           = %v\n", unix.Getsystemcfg(perfstat.SC_KRN_ATTR))
	fmt.Printf("    Kernel bits                             = %v\n", perfstat.KernelBits())
	fmt.Printf("    is LPAR?                                = %v\n", perfstat.IsLPAR())
	fmt.Printf("    DLPAR capable                           = %v\n", perfstat.DLparCapable())
	fmt.Printf("    DLPAR CPU Add capable                   = %v\n", perfstat.CpuAddCapable())
	fmt.Printf("    DLPAR CPU Remove capable                = %v\n", perfstat.CpuRemoveCapable())
	fmt.Printf("    DLPAR Memory Add capable                = %v\n", perfstat.MemoryAddCapable())
	fmt.Printf("    DLPAR Memory Remove capable             = %v\n", perfstat.MemoryRemoveCapable())
	fmt.Printf("    is NUMA?                                = %v\n", perfstat.IsNUMA())
	fmt.Printf("    Kernel keys enabled                     = %v\n", perfstat.KernelKeys())
	fmt.Printf("    Kernel recovery mode                    = %v\n", perfstat.RecoveryMode())
	fmt.Printf("    Enahnced Affinity enabled               = %v\n", perfstat.EnhancedAffinity())
	fmt.Printf("    VTPM enabled                            = %v\n", perfstat.VTpmEnabled())
	fmt.Printf("    is VIOS?                                = %v\n", perfstat.IsVIOS())
	fmt.Printf("    MLS enabled                             = %v\n", perfstat.MLSEnabled())
	fmt.Printf("Physical memory (bytes)                     = %v\n", unix.Getsystemcfg(perfstat.SC_PHYSMEM))
	fmt.Printf("SLB attributes                              = %v\n", unix.Getsystemcfg(perfstat.SC_SLB_ATTR))
	fmt.Printf("SLB size                                    = %v\n", unix.Getsystemcfg(perfstat.SC_SLB_SZ))
	fmt.Printf("Original number of CPUs                     = %v\n", unix.Getsystemcfg(perfstat.SC_ORIG_NCPUS))
	fmt.Printf("Maximum number of CPUs                      = %v\n", unix.Getsystemcfg(perfstat.SC_MAX_NCPUS))
	fmt.Printf("Maximum real memory address                 = %v\n", unix.Getsystemcfg(perfstat.SC_MAX_REALADDR))
	fmt.Printf("Boot-time entitled capacity                 = %v\n", unix.Getsystemcfg(perfstat.SC_ORIG_ENT_CAP))
	fmt.Printf("Entitled Capacity                           = %v\n", unix.Getsystemcfg(perfstat.SC_ENT_CAP))
	fmt.Printf("Capacity increment                          = %v\n", unix.Getsystemcfg(perfstat.SC_CAPINC))
	fmt.Printf("Priority weight                             = %v\n", unix.Getsystemcfg(perfstat.SC_VCAPW))
	fmt.Printf("SPLPAR state                                = %v\n", unix.Getsystemcfg(perfstat.SC_SPLP_STAT))
	fmt.Printf("    SPLPAR capable                          = %v\n", perfstat.SPLparCapable())
	fmt.Printf("    SPLPAR enabled                          = %v\n", perfstat.SPLparEnabled())
	fmt.Printf("    Dedicated LPAR                          = %v\n", perfstat.DedicatedLpar())
	fmt.Printf("    Capped?                                 = %v\n", perfstat.SPLparCapped())
	fmt.Printf("    Donating?                               = %v\n", perfstat.SPLparDonating())
	fmt.Printf("SMT state                                   = %v\n", unix.Getsystemcfg(perfstat.SC_SMT_STAT))
	fmt.Printf("    SMT capable                             = %v\n", perfstat.SmtCapable())
	fmt.Printf("    SMT enabled                             = %v\n", perfstat.SmtEnabled())
	fmt.Printf("SMT threads per CPU                         = %v\n", unix.Getsystemcfg(perfstat.SC_SMT_TC))
	fmt.Printf("Kernel error checking level                 = %v\n", unix.Getsystemcfg(perfstat.SC_EC_LVL))
	fmt.Printf("AME state                                   = %v\n", unix.Getsystemcfg(perfstat.SC_AME_STAT))
	fmt.Printf("    AME enabled                             = %v\n", perfstat.AmeEnabled())
	fmt.Printf("Physical processor implementation           = %v\n", unix.Getsystemcfg(perfstat.SC_PHYS_IMP))
	fmt.Printf("Physical processor version                  = %v\n", unix.Getsystemcfg(perfstat.SC_PHYS_VER))
	fmt.Printf("Transactional Memory version (0 - disabled) = %v\n", unix.Getsystemcfg(perfstat.SC_TM_VER))
	fmt.Printf("    transactional memory capable            = %v\n", perfstat.HasTransactionalMemory())
	fmt.Printf("NX GZIP capable                             = %v\n", unix.Getsystemcfg(perfstat.SC_NX_CAP))
	fmt.Printf("    NX GZIP capable                         = %v\n", perfstat.HasNxGzip())
	fmt.Printf("Platform keystore state                     = %v\n", unix.Getsystemcfg(perfstat.SC_PKS_STATE))
	fmt.Printf("    PKS capable                             = %v\n", perfstat.PksCapable())
	fmt.Printf("    PKS enabled                             = %v\n", perfstat.PksEnabled())
}
