# Licensed to Elasticsearch B.V. under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Elasticsearch B.V. licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# This code was automatically generated from the Elasticsearch Specification
# See https://github.com/elastic/elasticsearch-specification
# See Elasticsearch::ES_SPECIFICATION_COMMIT for commit hash.
module Elasticsearch
  module API
    module Cluster
      module Actions
        # Explain the shard allocations.
        # Get explanations for shard allocations in the cluster.
        # This API accepts the current_node, index, primary and shard parameters in the request body or in query parameters, but not in both at the same time.
        # For unassigned shards, it provides an explanation for why the shard is unassigned.
        # For assigned shards, it provides an explanation for why the shard is remaining on its current node and has not moved or rebalanced to another node.
        # This API can be very useful when attempting to diagnose why a shard is unassigned or why a shard continues to remain on its current node when you might expect otherwise.
        # Refer to the linked documentation for examples of how to troubleshoot allocation issues using this API.
        #
        # @option arguments [String] :index The name of the index that you would like an explanation for.
        # @option arguments [Integer] :shard An identifier for the shard that you would like an explanation for.
        # @option arguments [Boolean] :primary If true, returns an explanation for the primary shard for the specified shard ID.
        # @option arguments [String] :current_node Explain a shard only if it is currently located on the specified node name or node ID.
        # @option arguments [Boolean] :include_disk_info If true, returns information about disk usage and shard sizes.
        # @option arguments [Boolean] :include_yes_decisions If true, returns YES decisions in explanation.
        # @option arguments [Time] :master_timeout Period to wait for a connection to the master node. Server default: 30s.
        # @option arguments [Boolean] :error_trace When set to `true` Elasticsearch will include the full stack trace of errors
        #  when they occur.
        # @option arguments [String, Array<String>] :filter_path Comma-separated list of filters in dot notation which reduce the response
        #  returned by Elasticsearch.
        # @option arguments [Boolean] :human When set to `true` will return statistics in a format suitable for humans.
        #  For example `"exists_time": "1h"` for humans and
        #  `"exists_time_in_millis": 3600000` for computers. When disabled the human
        #  readable values will be omitted. This makes sense for responses being consumed
        #  only by machines.
        # @option arguments [Boolean] :pretty If set to `true` the returned JSON will be "pretty-formatted". Only use
        #  this option for debugging only.
        # @option arguments [Hash] :headers Custom HTTP headers
        # @option arguments [Hash] :body request body
        #
        # @see https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-allocation-explain
        #
        def allocation_explain(arguments = {})
          request_opts = { endpoint: arguments[:endpoint] || 'cluster.allocation_explain' }

          arguments = arguments.clone
          headers = arguments.delete(:headers) || {}

          body = arguments.delete(:body)

          method = if body
                     Elasticsearch::API::HTTP_POST
                   else
                     Elasticsearch::API::HTTP_GET
                   end

          path   = '_cluster/allocation/explain'
          params = Utils.process_params(arguments)

          Elasticsearch::API::Response.new(
            perform_request(method, path, params, body, headers, request_opts)
          )
        end
      end
    end
  end
end
