include!(concat!(env!("OUT_DIR"), "/category.rs")); // generated by build.rs

const MASK: usize = BLOCK_SIZE - 1;
const SHIFT: usize = MASK.count_ones() as usize;

/// Look up the general category for a character.
///
/// ### Example
///
/// ```
/// use unicode_general_category::{get_general_category, GeneralCategory};
///
/// assert_eq!(get_general_category('A'), GeneralCategory::UppercaseLetter);
/// ```
pub fn get_general_category(chr: char) -> GeneralCategory {
    let u = chr as u32;

    if u <= LAST_CODEPOINT {
        return CATEGORY_BLOCKS
            [CATEGORY_BLOCK_OFFSETS[u as usize >> SHIFT] as usize + (u as usize & MASK)];
    } else {
        return PrivateUse;
    }
}
