/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.encoders.Hex;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.key.SubkeyIdentifier;

public class SignatureVerification {
    private final PGPSignature signature;
    private final SubkeyIdentifier signingKey;

    public SignatureVerification(PGPSignature signature, @Nullable SubkeyIdentifier signingKey) {
        this.signature = signature;
        this.signingKey = signingKey;
    }

    public PGPSignature getSignature() {
        return this.signature;
    }

    @Nullable
    public SubkeyIdentifier getSigningKey() {
        return this.signingKey;
    }

    public String toString() {
        return "Signature: " + (this.signature != null ? Hex.toHexString(this.signature.getDigestPrefix()) : "null") + "; Key: " + (this.signingKey != null ? this.signingKey.toString() : "null") + ";";
    }

    public static class Failure {
        private final SignatureVerification signatureVerification;
        private final SignatureValidationException validationException;

        public Failure(SignatureVerification verification, SignatureValidationException validationException) {
            this.signatureVerification = verification;
            this.validationException = validationException;
        }

        public SignatureVerification getSignatureVerification() {
            return this.signatureVerification;
        }

        public SignatureValidationException getValidationException() {
            return this.validationException;
        }

        public String toString() {
            return this.signatureVerification.toString() + " Failure: " + this.getValidationException().getMessage();
        }
    }
}

