// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) TypeSpec Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

#pragma once

#include "configuration_client_models.hpp"
#include "configuration_client_options.hpp"

#include <azure/core/context.hpp>
#include <azure/core/nullable.hpp>
#include <azure/core/paged_response.hpp>

#include <memory>
#include <string>
#include <vector>

namespace Azure { namespace Data { namespace AppConfiguration {
  class ConfigurationClient;

  class GetKeysPagedResponse final : public Core::PagedResponse<GetKeysPagedResponse> {
    friend class ConfigurationClient;
    friend class Core::PagedResponse<GetKeysPagedResponse>;

  private:
    std::shared_ptr<ConfigurationClient> m_client;
    std::string m_accept;
    GetKeysOptions m_options;

    void OnNextPage(Core::Context const& context);

  public:
    Nullable<std::vector<Key>> Items;
    std::string SyncToken;
    GetKeysResponseContentType ContentType;
  };

  class GetKeyValuesPagedResponse final : public Core::PagedResponse<GetKeyValuesPagedResponse> {
    friend class ConfigurationClient;
    friend class Core::PagedResponse<GetKeyValuesPagedResponse>;

  private:
    std::shared_ptr<ConfigurationClient> m_client;
    std::string m_accept;
    GetKeyValuesOptions m_options;

    void OnNextPage(Core::Context const& context);

  public:
    Nullable<std::vector<KeyValue>> Items;
    Nullable<std::string> Etag;
    std::string SyncToken;
    std::string ETag;
    GetKeyValuesResponseContentType ContentType;
  };

  class GetSnapshotsPagedResponse final : public Core::PagedResponse<GetSnapshotsPagedResponse> {
    friend class ConfigurationClient;
    friend class Core::PagedResponse<GetSnapshotsPagedResponse>;

  private:
    std::shared_ptr<ConfigurationClient> m_client;
    std::string m_accept;
    GetSnapshotsOptions m_options;

    void OnNextPage(Core::Context const& context);

  public:
    Nullable<std::vector<Snapshot>> Items;
    std::string SyncToken;
    GetSnapshotsResponseContentType ContentType;
  };

  class GetLabelsPagedResponse final : public Core::PagedResponse<GetLabelsPagedResponse> {
    friend class ConfigurationClient;
    friend class Core::PagedResponse<GetLabelsPagedResponse>;

  private:
    std::shared_ptr<ConfigurationClient> m_client;
    std::string m_accept;
    GetLabelsOptions m_options;

    void OnNextPage(Core::Context const& context);

  public:
    Nullable<std::vector<Label>> Items;
    std::string SyncToken;
    GetLabelsResponseContentType ContentType;
  };

  class GetRevisionsPagedResponse final : public Core::PagedResponse<GetRevisionsPagedResponse> {
    friend class ConfigurationClient;
    friend class Core::PagedResponse<GetRevisionsPagedResponse>;

  private:
    std::shared_ptr<ConfigurationClient> m_client;
    std::string m_accept;
    GetRevisionsOptions m_options;

    void OnNextPage(Core::Context const& context);

  public:
    Nullable<std::vector<KeyValue>> Items;
    Nullable<std::string> Etag;
    std::string SyncToken;
    std::string ETag;
    GetRevisionsResponseContentType ContentType;
  };
}}} // namespace Azure::Data::AppConfiguration
