// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) TypeSpec Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

#pragma once

#include "key_vault_client_options.hpp"
#include "keys_models.hpp"

#include <azure/core/datetime.hpp>
#include <azure/core/internal/extendable_enumeration.hpp>
#include <azure/core/nullable.hpp>
#include <azure/core/paged_response.hpp>

#include <cstdint>
#include <map>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace Azure { namespace Security { namespace KeyVault { namespace Keys { namespace _detail {
  class KeyVaultClient;

  /**
   * @brief The key list result.
   *
   */
  class GetKeyVersionsPagedResponse final
      : public Core::PagedResponse<GetKeyVersionsPagedResponse> {
    friend class KeyVaultClient;
    friend class Core::PagedResponse<GetKeyVersionsPagedResponse>;

  private:
    std::shared_ptr<KeyVaultClient> m_client;
    std::string m_keyName;
    KeyVaultClientGetKeyVersionsOptions m_options;

    void OnNextPage(const Core::Context& context);

  public:
    /// A response message containing a list of keys in the key vault along with a link to the next
    /// page of keys.
    Nullable<std::vector<Models::KeyItem>> Value;
  };

  /**
   * @brief The key list result.
   *
   */
  class GetKeysPagedResponse final : public Core::PagedResponse<GetKeysPagedResponse> {
    friend class KeyVaultClient;
    friend class Core::PagedResponse<GetKeysPagedResponse>;

  private:
    std::shared_ptr<KeyVaultClient> m_client;
    KeyVaultClientGetKeysOptions m_options;

    void OnNextPage(const Core::Context& context);

  public:
    /// A response message containing a list of keys in the key vault along with a link to the next
    /// page of keys.
    Nullable<std::vector<Models::KeyItem>> Value;
  };

  /**
   * @brief A list of keys that have been deleted in this vault.
   *
   */
  class GetDeletedKeysPagedResponse final
      : public Core::PagedResponse<GetDeletedKeysPagedResponse> {
    friend class KeyVaultClient;
    friend class Core::PagedResponse<GetDeletedKeysPagedResponse>;

  private:
    std::shared_ptr<KeyVaultClient> m_client;
    KeyVaultClientGetDeletedKeysOptions m_options;

    void OnNextPage(const Core::Context& context);

  public:
    /// A response message containing a list of deleted keys in the key vault along with a link to
    /// the next page of deleted keys.
    Nullable<std::vector<Models::DeletedKeyItem>> Value;
  };
}}}}} // namespace Azure::Security::KeyVault::Keys::_detail
