// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.

/**
 * @file
 * @brief Parameters for sign a key.
 *
 */

#pragma once

#include <cstdint>
#include <string>
#include <vector>

namespace Azure {
  namespace Security {
    namespace KeyVault {
      namespace Keys {
        namespace Cryptography {
  namespace _detail {

    /**
     * @brief Parameters for sign a key.
     *
     */
    struct KeySignParameters final
    {
      std::string Algorithm;
      std::vector<uint8_t> Digest;

      KeySignParameters() = delete;

      KeySignParameters(std::string algorithm, std::vector<uint8_t> digest)
          : Algorithm(std::move(algorithm)), Digest(std::move(digest))
      {
      }
    };
}}}}}} // namespace Azure::Security::KeyVault::Keys::Cryptography::_detail
